'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');
var Radium = require('radium');
var browserifyStyle = require('../../utils/style/browserify');
var mergeStyles = require('../../utils/style/mergeStyles');
var wrapLayout = require('../../utils/layout/wrapper');

var Image = (function (_React$Component) {
  _inherits(Image, _React$Component);

  function Image(props) {
    _classCallCheck(this, Image);

    _get(Object.getPrototypeOf(Image.prototype), 'constructor', this).call(this, props);
    // default image state
    this.image = null;
    this.state = {
      pending: false,
      loaded: false,
      currentUri: null
    };

    // autobinding
    this.onLoad = this.onLoad.bind(this);
    this.onError = this.onError.bind(this);
  }

  // cancel an existing image being loaded

  _createClass(Image, [{
    key: '_cancelLoadImage',
    value: function _cancelLoadImage() {
      if (this.image) {
        this.image.onload = null;
        this.image.onerror = null;
        this.image = null;
      }
    }
  }, {
    key: '_loadImage',
    value: function _loadImage(uri) {
      // if there is a previous image, then detach the event handlers to avoid double occurence
      this._cancelLoadImage();
      // create a new image source
      this.image = new window.Image();
      // attach the event listeners
      this.image.onload = this.onLoad;
      this.image.onerror = this.onError;
      this.image.src = uri;
    }
  }, {
    key: '_uriChanged',
    value: function _uriChanged(props) {
      // if source is null, pass
      if (props === null) return this._cancelLoadImage();
      // checks if uri changed and return if not
      var uri = props.source.uri;
      var onLoadStart = props.onLoadStart;
      var onProgress = props.onProgress;

      if (uri == this.state.currentUri) return;
      // trigger the loadImage function for the new image
      this._loadImage(uri);
      // triggers the onLoadStart
      if (onLoadStart) onLoadStart();
      // TODO: is there a on progress event?
      if (onProgress) onProgress({ nativeEvent: { loaded: 0, total: 1 } });
      // sets the new uri into the state
      this.setState({
        currentUri: uri,
        loading: true,
        pending: true
      });
    }
  }, {
    key: 'onLoad',
    value: function onLoad(e) {
      // loading has been successfull!
      var _props = this.props;
      var onLoad = _props.onLoad;
      var onLoadEnd = _props.onLoadEnd;

      // calls onLoad and onLoadEnd
      if (onLoad) onLoad();
      if (onLoadEnd) onLoadEnd();
      // sets the state
      this.setState({
        pending: false,
        loaded: true
      });
    }
  }, {
    key: 'onError',
    value: function onError(e) {
      // loading has failed!
      var _props2 = this.props;
      var onError = _props2.onError;
      var onLoadEnd = _props2.onLoadEnd;

      // calls event handlers
      if (onError) onError();
      if (onLoadEnd) onLoadEnd();
      // sets the state
      this.setState({
        pending: false,
        loaded: false
      });
    }

    // on componentDidMount e componentWillReceiveProps, call the uriChanged, and on componentDidUnmount detach
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._uriChanged(this.props);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(props) {
      this._uriChanged(props);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this._cancelLoadImage();
    }

    // actual image rendering
  }, {
    key: 'render',
    value: function render() {
      // deconstruct supported properties
      var _props3 = this.props;
      var uri = _props3.source.uri;
      var defaultSource = _props3.defaultSource;
      var resizeMode = _props3.resizeMode;
      var capInsets = _props3.capInsets;
      var style = _props3.style;
      var children = _props3.children;
      var onLoad = _props3.onLoad;
      var onLoadStart = _props3.onLoadStart;
      var onLoadEnd = _props3.onLoadEnd;
      var onProgress = _props3.onProgress;
      var onError = _props3.onError;

      var props = _objectWithoutProperties(_props3, ['source', 'defaultSource', 'resizeMode', 'capInsets', 'style', 'children', 'onLoad', 'onLoadStart', 'onLoadEnd', 'onProgress', 'onError']);

      // default classNames
      var classNames = ['image'];

      // try to pick resizeMode from the style definition
      var mergedStyle = mergeStyles(style);
      if (!resizeMode && mergedStyle.resizeMode) {
        var resizeMode = mergedStyle.resizeMode;
      }

      // get the props to be merged into style
      if (resizeMode) classNames.push('resize-mode-' + resizeMode);

      // switch between default background image and current one if it's loaded
      // TODO: this will trigger double image loading, one for the event triggers and one for the bg image
      //      maybe we should consider using some sort of "toDataUrl" of the image to avoid reloading,
      //      but this will consume a lot of resources, and maybe we should have an internal flag for that to happen.
      var defaultBackgroundImage = typeof defaultSource === 'undefined' ? 'none' : defaultSource.uri;
      var backgroundImage = typeof uri === 'undefined' || !this.state.loaded ? defaultBackgroundImage : 'url(' + uri + ')';

      // TODO: handle tintColor via canvas image manipulation if setted

      // WIP
      // if image is loaded and capInsets is set
      var insetEls = null;
      if (this.state.loaded && capInsets) {
        insetEls = [React.createElement('div', { key: 'tl', className: 'cap-insets-tl', style: { backgroundImage: backgroundImage, width: capInsets.left, height: capInsets.top } }), React.createElement('div', { key: 'tr', className: 'cap-insets-tr', style: { backgroundImage: backgroundImage, width: capInsets.right, height: capInsets.top } }), React.createElement('div', { key: 'bl', className: 'cap-insets-bl', style: { backgroundImage: backgroundImage, width: capInsets.left, height: capInsets.bottom } }), React.createElement('div', { key: 'br', className: 'cap-insets-br', style: { backgroundImage: backgroundImage, width: capInsets.right, height: capInsets.bottom } })];
      }

      return React.createElement(
        'div',
        _extends({}, props, { className: classNames.join(' '), style: browserifyStyle({ backgroundImage: backgroundImage }, style) }),
        insetEls,
        children
      );
    }
  }]);

  return Image;
})(React.Component);

Image = wrapLayout(Radium(Image));

Image.resizeMode = {
  cover: 'cover',
  contain: 'contain',
  stretch: 'stretch',
  none: 'none'
};

module.exports = Image;