'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');
var Radium = require('radium');
var browserifyStyle = require('../../utils/style/browserify');
var View = require('../View');

var ScrollView = (function (_React$Component) {
  _inherits(ScrollView, _React$Component);

  function ScrollView(props) {
    _classCallCheck(this, ScrollView);

    _get(Object.getPrototypeOf(ScrollView.prototype), 'constructor', this).call(this, props);

    // autobinding
    this.onScroll = this.onScroll.bind(this);
    this.handleOnScroll = this.handleOnScroll.bind(this);
  }

  _createClass(ScrollView, [{
    key: 'onScroll',
    value: function onScroll() {
      // if there is a timeout, stop
      if (this.scrollTimeout) return;
      // deconstruct
      var _props = this.props;
      var onScroll = _props.onScroll;
      var _props$scrollEventThrottle = _props.scrollEventThrottle;
      var scrollEventThrottle = _props$scrollEventThrottle === undefined ? 0 : _props$scrollEventThrottle;

      // else, setup it
      this.scrollTimeout = setTimeout(this.handleOnScroll, scrollEventThrottle);
    }
  }, {
    key: 'handleOnScroll',
    value: function handleOnScroll() {
      // reset the timeout
      this.scrollTimeout = null;
      // deconstruct
      var _props2 = this.props;
      var onScroll = _props2.onScroll;
      var _props2$scrollEventThrottle = _props2.scrollEventThrottle;
      var scrollEventThrottle = _props2$scrollEventThrottle === undefined ? 0 : _props2$scrollEventThrottle;

      // if there is on scroll, call it
      if (onScroll) onScroll();
    }
  }, {
    key: 'render',
    value: function render() {
      // set of classNames
      var classNames = ['scroll-view'];

      // descructuring utility data
      var _props3 = this.props;
      var horizontal = _props3.horizontal;
      var contentContainerStyle = _props3.contentContainerStyle;
      var style = _props3.style;
      var children = _props3.children;
      var onScroll = _props3.onScroll;

      var props = _objectWithoutProperties(_props3, ['horizontal', 'contentContainerStyle', 'style', 'children', 'onScroll']);

      // apply style to correct scroll direction
      classNames.push(horizontal ? 'horizontal' : 'vertical');

      // return the component, use a View as a wrapper
      return React.createElement(
        'div',
        { onScroll: this.onScroll, className: classNames.join(' '), style: browserifyStyle(style) },
        React.createElement(
          View,
          { style: browserifyStyle(contentContainerStyle) },
          children
        )
      );
    }
  }]);

  return ScrollView;
})(React.Component);

module.exports = Radium(ScrollView);