'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');
var Radium = require('radium');
var browserifyStyle = require('../../utils/style/browserify');
var wrapLayout = require('../../utils/layout/wrapper');

var TextInput = (function (_React$Component) {
  _inherits(TextInput, _React$Component);

  function TextInput() {
    _classCallCheck(this, TextInput);

    _get(Object.getPrototypeOf(TextInput.prototype), 'constructor', this).apply(this, arguments);
  }

  _createClass(TextInput, [{
    key: 'onChange',

    // onChange and onChangeText support
    value: function onChange(e) {
      if (this.props.onChangeText) this.props.onChangeText(e.target.value);
      if (this.props.onChange) this.props.onChange({ nativeEvent: { text: e.target.value } });
    }

    // onFocus support
  }, {
    key: 'onFocus',
    value: function onFocus(e) {
      // deconstruct
      var _props = this.props;
      var onFocus = _props.onFocus;
      var selectTextOnFocus = _props.selectTextOnFocus;
      var clearTextOnFocus = _props.clearTextOnFocus;

      // if select or clear, perform it.
      if (clearTextOnFocus) this.refs.main.value = '';
      if (selectTextOnFocus) this.refs.main.select();
      // call event listener
      if (onFocus) onFocus(e);
    }

    // onBlur support
  }, {
    key: 'onBlur',
    value: function onBlur(e) {
      if (this.props.onBlur) this.props.onBlur(e);
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      // if wanted, do autofocus
      if (this.props.autoFocus) this.refs.main.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var _this = this;

      // by default, use a input[text]
      var tagName = 'input';
      var type = 'text';

      // copy over the same props to the new props for the input
      var _props2 = this.props;
      var defaultValue = _props2.defaultValue;
      var value = _props2.value;
      var placeholder = _props2.placeholder;
      var multiline = _props2.multiline;
      var secureTextEntry = _props2.secureTextEntry;
      var clearTextOnFocus = _props2.clearTextOnFocus;
      var selectTextOnFocus = _props2.selectTextOnFocus;
      var _props2$editable = _props2.editable;
      var editable = _props2$editable === undefined ? true : _props2$editable;
      var autoFocus = _props2.autoFocus;
      var textAlign = _props2.textAlign;
      var style = _props2.style;
      var children = _props2.children;
      var onChange = _props2.onChange;
      var onBlur = _props2.onBlur;
      var onFocus = _props2.onFocus;
      var onChangeText = _props2.onChangeText;

      var props = _objectWithoutProperties(_props2, ['defaultValue', 'value', 'placeholder', 'multiline', 'secureTextEntry', 'clearTextOnFocus', 'selectTextOnFocus', 'editable', 'autoFocus', 'textAlign', 'style', 'children', 'onChange', 'onBlur', 'onFocus', 'onChangeText']);

      // init the classNames
      var classNames = ['text-input'];

      // handle the textAlign
      if (textAlign) classNames.push('text-align-' + textAlign);

      // If multiline, convert to a textarea
      if (multiline) tagName = 'textarea';

      // if needs password-like, convert to password field.
      // TODO: multiline password-like inputs?
      if (secureTextEntry && !multiline) {
        type = 'password';
        tagName = 'input';
      }

      // return the input
      return React.createElement(tagName, {
        ref: 'main',
        className: classNames.join(' '),

        type: type,
        value: value,
        defaultValue: defaultValue,
        placeholder: placeholder,
        readOnly: !editable,
        style: browserifyStyle(style),

        onChange: function onChange(e) {
          return _this.onChange(e);
        },
        onFocus: function onFocus(e) {
          return _this.onFocus(e);
        },
        onBlur: function onBlur(e) {
          return _this.onBlur(e);
        }
      }, null);
    }
  }]);

  return TextInput;
})(React.Component);

module.exports = wrapLayout(Radium(TextInput));