'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');
var TouchableWithoutFeedback = require('../TouchableWithoutFeedback');
var View = require('../View');
var Touchable = require('../../utils/events/Touchable');

var _require = require('react-dom');

var findDOMNode = _require.findDOMNode;

var TouchableOpacity = (function (_React$Component) {
  _inherits(TouchableOpacity, _React$Component);

  function TouchableOpacity(props) {
    _classCallCheck(this, TouchableOpacity);

    _get(Object.getPrototypeOf(TouchableOpacity.prototype), 'constructor', this).call(this, props);
    this.state = {
      opacity: 1
    };

    // autobinding
    this.onMouseDown = this.onMouseDown.bind(this);
    this.onMouseUp = this.onMouseUp.bind(this);
  }

  // bind event handlers

  _createClass(TouchableOpacity, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      // create touchable instance
      if (!this.touchable) {
        this.touchable = new Touchable(findDOMNode(this.refs.main));
      }
      // binds events
      this.touchable.on('pressstart', this.onMouseDown);
      this.touchable.on('pressend', this.onMouseUp);
      this.touchable.on('presscancel', this.onMouseUp);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      // if no touchable instance exists, return
      if (!this.touchable) return;
      // unbind touchable events
      this.touchable.off('pressstart', this.onMouseDown);
      this.touchable.off('pressend', this.onMouseUp);
      this.touchable.off('presscancel', this.onMouseUp);
      this.touchable.destroy();
    }
  }, {
    key: 'onMouseUp',
    value: function onMouseUp() {
      this.setState({ opacity: 1 });
    }
  }, {
    key: 'onMouseDown',
    value: function onMouseDown() {
      // deconstruct active opacity
      var _props$activeOpacity = this.props.activeOpacity;
      var activeOpacity = _props$activeOpacity === undefined ? 0.2 : _props$activeOpacity;

      // set the state
      this.setState({ opacity: activeOpacity });
    }
  }, {
    key: 'render',
    value: function render() {
      // deconstruct style and other
      var _props = this.props;
      var style = _props.style;
      var activeOpacity = _props.activeOpacity;

      var props = _objectWithoutProperties(_props, ['style', 'activeOpacity']);

      return React.createElement(
        TouchableWithoutFeedback,
        _extends({ ref: 'main' }, props),
        React.createElement(
          View,
          { style: (Array.isArray(style) ? style : [style]).concat([{ opacity: this.state.opacity }]) },
          this.props.children
        )
      );
    }
  }]);

  return TouchableOpacity;
})(React.Component);

module.exports = TouchableOpacity;