'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');

var _require = require('react-dom');

var findDOMNode = _require.findDOMNode;

var Radium = require('radium');
var browserifyStyle = require('../../utils/style/browserify');
var Touchable = require('../../utils/events/Touchable');
var wrapLayout = require('../../utils/layout/wrapper');

var TouchableWithoutFeedback = (function (_React$Component) {
  _inherits(TouchableWithoutFeedback, _React$Component);

  function TouchableWithoutFeedback(props) {
    _classCallCheck(this, TouchableWithoutFeedback);

    _get(Object.getPrototypeOf(TouchableWithoutFeedback.prototype), 'constructor', this).call(this, props);
    // autobinding
    this.onMouseDown = this.onMouseDown.bind(this);
    this.onMouseUp = this.onMouseUp.bind(this);
    this.reset = this.reset.bind(this);
  }

  _createClass(TouchableWithoutFeedback, [{
    key: 'onMouseDown',
    value: function onMouseDown(e) {
      var _this = this;

      // handle onPressIn
      var _props = this.props;
      var _props$delayPressIn = _props.delayPressIn;
      var delayPressIn = _props$delayPressIn === undefined ? 0 : _props$delayPressIn;
      var _props$onPressIn = _props.onPressIn;
      var onPressIn = _props$onPressIn === undefined ? false : _props$onPressIn;
      var _props$delayLongPress = _props.delayLongPress;
      var delayLongPress = _props$delayLongPress === undefined ? 500 : _props$delayLongPress;
      var _props$onLongPress = _props.onLongPress;
      var onLongPress = _props$onLongPress === undefined ? false : _props$onLongPress;

      // there is no press in event, so do nothing
      if (!onPressIn) return;
      // call the event after a delay
      this.delayPressIn = setTimeout(function () {
        onPressIn(e);
        // setup the delay for a long press
        _this.delayLongPress = setTimeout(function () {
          return onLongPress(e);
        }, delayLongPress);
      }, delayPressIn);
    }
  }, {
    key: 'onMouseUp',
    value: function onMouseUp(e) {
      // handle onPressOut
      var _props2 = this.props;
      var _props2$delayPressOut = _props2.delayPressOut;
      var delayPressOut = _props2$delayPressOut === undefined ? 0 : _props2$delayPressOut;
      var _props2$onPressOut = _props2.onPressOut;
      var onPressOut = _props2$onPressOut === undefined ? false : _props2$onPressOut;
      var onPress = _props2.onPress;

      // call the event after a delay
      setTimeout(function () {
        // handle onPressOut first
        if (onPressOut) onPressOut(e);
        // handle the onPress event passed as a prop
        if (onPress) onPress(e);
      }, delayPressOut);
      this.reset();
    }
  }, {
    key: 'reset',
    value: function reset() {
      // if there was a delay for press in, clear it
      if (this.delayPressIn) {
        clearTimeout(this.delayPressIn);
        this.delayPressIn = null;
      }
      // if there was a delay for a long press, clear it
      if (this.delayLongPress) {
        clearTimeout(this.delayLongPress);
        this.delayLongPress = null;
      }
    }

    // bind event handlers
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      // create touchable instance
      if (!this.touchable) {
        this.touchable = new Touchable(findDOMNode(this.refs.main));
      }
      // binds events
      this.touchable.on('pressstart', this.onMouseDown);
      this.touchable.on('pressend', this.onMouseUp);
      this.touchable.on('presscancel', this.reset);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      // if no touchable instance exists, return
      if (!this.touchable) return;
      // unbind touchable events
      this.touchable.off('pressstart', this.onMouseDown);
      this.touchable.off('pressend', this.onMouseUp);
      this.touchable.off('presscancel', this.reset);
      this.touchable.destroy();
    }
  }, {
    key: 'render',
    value: function render() {
      // deconstruct from the props
      var children = this.props.children;

      // child style
      if (children) {
        var _ref = children.props || {};

        var style = _ref.style;
      }

      // returns the component
      return React.cloneElement(children, {
        ref: 'main',
        style: [styles.main].concat(Array.isArray(style) ? style : [style])
      });
    }
  }]);

  return TouchableWithoutFeedback;
})(React.Component);

var styles = {
  main: {
    cursor: 'pointer',
    userSelect: 'none'
  }
};

module.exports = wrapLayout(Radium(TouchableWithoutFeedback));