'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('eventemitter3');

var _require = require('./eventListener');

var attachListener = _require.attachListener;
var removeListener = _require.removeListener;
var normalizeTouchEvent = _require.normalizeTouchEvent;

// Minimal timeout used to delay a bit the events and make events emulation work
var EPS = 100;

// max distance before the touch event is considered a scroll
var MAX_DISTANCE = 10;

// Touch states
var NO_EVENT = 0;
var TOUCH_STARTING = 1;
var TOUCH_STARTED = 2;

// collect scrollables, in our case this means all the parent scroll views
function collectParentScrollables(node) {
	var scrollables = [];
	var scrollState = { top: 0, left: 0 };
	// loop up to root parent and collect scrollables dom elements
	while (node) {
		// classname contains scroll-view, so this is a scrollable view.
		if ((node.className || '').indexOf('scroll-view') > -1) {
			// push into the scrollables list
			scrollables.push({
				node: node,
				top: node.scrollTop,
				left: node.scrollLeft
			});
			// push into scroll state
			scrollState = {
				top: scrollState.top + node.scrollTop,
				left: scrollState.left + node.scrollLeft
			};
		}
		// go to parent
		node = node.parentNode;
	}
	// returns the collected data
	return { scrollables: scrollables, scrollState: scrollState };
}

// returns true if view has scrolled
function detectScroll(scrollablesBefore, scrollablesAfter) {
	return !(scrollablesBefore.scrollState.left === scrollablesAfter.scrollState.left && scrollablesBefore.scrollState.top === scrollablesAfter.scrollState.top);
}

// returns the distance between two x, y objects
function distanceBetween(a, b) {
	return Math.pow(Math.pow(a.x - b.x, 2) - Math.pow(a.y - b.y, 2), 0.5);
}

var Touchable = (function (_EventEmitter) {
	_inherits(Touchable, _EventEmitter);

	function Touchable(node) {
		_classCallCheck(this, Touchable);

		_get(Object.getPrototypeOf(Touchable.prototype), 'constructor', this).call(this);

		// store elements and instances
		this.node = node;
		this.state = NO_EVENT;
		this.pointer = null;
		this.lastPointer = null;
		this.scrollables = null;

		// autobind methods
		this.onMouseDown = this.onMouseDown.bind(this);
		this.onMouseMove = this.onMouseMove.bind(this);
		this.onMouseOut = this.onMouseOut.bind(this);
		this.onMouseUp = this.onMouseUp.bind(this);

		// attach dom event listeners
		attachListener(this.node, 'pointerdown', this.onMouseDown);
		attachListener(window, 'pointermove', this.onMouseMove);
		attachListener(window, 'pointerout', this.onMouseOut);
		attachListener(window, 'pointerup', this.onMouseUp);
	}

	// export the class

	_createClass(Touchable, [{
		key: 'destroy',
		value: function destroy() {
			// reset state
			this.state = NO_EVENT;
			this.pointer = null;
			this.scrollables = null;
			this.lastPointer = null;

			// detach dom event listeners
			removeListener(this.node, 'pointerdown', this.onMouseDown);
			removeListener(window, 'pointermove', this.onMouseMove);
			removeListener(window, 'pointerout', this.onMouseOut);
			removeListener(window, 'pointerup', this.onMouseUp);
		}
	}, {
		key: 'onMouseDown',
		value: function onMouseDown(e) {
			var e = normalizeTouchEvent(e);
			// to mouse down, you should first be in no_event
			if (this.state !== NO_EVENT) return;
			// store pointer position
			this.pointer = { x: e.clientX, y: e.clientY };
			this.lastPointer = { x: e.clientX, y: e.clientY };
			this.scrollables = collectParentScrollables(this.node);
			// trigger the touchstart event
			this.state = TOUCH_STARTED;
			this.emit('pressstart');
		}
	}, {
		key: 'onMouseMove',
		value: function onMouseMove(e) {
			var e = normalizeTouchEvent(e);
			// touch has to be started first
			if (this.state !== TOUCH_STARTED) return;
			// update last position
			this.updateLastPointerFromEvent(e);
			// cancel if moving
			this.cancelIfMoving();
		}
	}, {
		key: 'onMouseOut',
		value: function onMouseOut(e) {
			var e = normalizeTouchEvent(e);
			// touch has to be started first
			if (this.state !== TOUCH_STARTED) return;
			// update last position
			this.updateLastPointerFromEvent(e);
			// cancel if moving
			this.emitTouchCancel();
		}
	}, {
		key: 'onMouseUp',
		value: function onMouseUp(e) {
			// touch has to be started first
			if (this.state !== TOUCH_STARTED) return;
			// update last position
			this.updateLastPointerFromEvent(e);
			// cancel if moving
			if (this.cancelIfMoving()) return;
			// trigger touch end
			this.state = NO_EVENT;
			this.emit('pressend');
		}
	}, {
		key: 'updateLastPointerFromEvent',
		value: function updateLastPointerFromEvent(e) {
			// normalize event

			var _normalizeTouchEvent = normalizeTouchEvent(e);

			var _normalizeTouchEvent$clientX = _normalizeTouchEvent.clientX;
			var clientX = _normalizeTouchEvent$clientX === undefined ? null : _normalizeTouchEvent$clientX;
			var _normalizeTouchEvent$clientY = _normalizeTouchEvent.clientY;
			var clientY = _normalizeTouchEvent$clientY === undefined ? null : _normalizeTouchEvent$clientY;

			// update last pointer position if possible
			if (!(clientX === null || clientY === null)) this.lastPointer = { x: clientX, y: clientY };
		}
	}, {
		key: 'cancelIfMoving',
		value: function cancelIfMoving() {
			// does the mouse moved too much? reset and return
			if (distanceBetween(this.pointer, this.lastPointer) > MAX_DISTANCE) return this.emitTouchCancel();
			// collect new scrollable state, since some ms passed
			var newScrollables = collectParentScrollables(this.node);
			// is a scroll appened? reset and return.
			if (detectScroll(this.scrollables, newScrollables)) return this.emitTouchCancel();
			// return false if not cancelled
			return false;
		}
	}, {
		key: 'emitTouchCancel',
		value: function emitTouchCancel() {
			// emit touch cancel
			this.state = NO_EVENT;
			this.emit('presscancel');
			return true;
		}
	}]);

	return Touchable;
})(EventEmitter);

module.exports = Touchable;