// this manager emits and event whenever something changed it's size
// so this way you can look up for onLayout changes
'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('eventemitter3');

var LayoutManager = (function (_EventEmitter) {
	_inherits(LayoutManager, _EventEmitter);

	function LayoutManager() {
		_classCallCheck(this, LayoutManager);

		_get(Object.getPrototypeOf(LayoutManager.prototype), 'constructor', this).call(this);

		// autobinding
		this.deferUpdate = this.deferUpdate.bind(this);
		this.update = this.update.bind(this);
	}

	_createClass(LayoutManager, [{
		key: 'attach',
		value: function attach(fn) {
			this.on('redraw', fn);
		}
	}, {
		key: 'detach',
		value: function detach(fn) {
			this.off('redraw', fn);
		}

		// performs an update now.
	}, {
		key: 'update',
		value: function update() {
			this.emit('redraw');
		}

		// deferred update, so multiple updates can batch up
	}, {
		key: 'deferUpdate',
		value: function deferUpdate() {
			if (this.timeout) clearTimeout(this.timeout);
			this.timeout = setTimeout(this.update, 10);
		}
	}]);

	return LayoutManager;
})(EventEmitter);

var manager = new LayoutManager();

// bind the layout manager to the window resize, so we can update the layout on window resize
window.addEventListener('resize', manager.deferUpdate);

module.exports = manager;