'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');

var _require = require('react-dom');

var findDOMNode = _require.findDOMNode;

var LayoutManager = require('./manager');

// get element x, y
function getCumulativeOffset(obj) {
	var left, top;
	left = top = 0;
	if (obj.offsetParent) {
		do {
			left += obj.offsetLeft;
			top += obj.offsetTop;
		} while (obj = obj.offsetParent);
	}
	return {
		x: left,
		y: top
	};
};

// this functions returns the x, y, width and height of a given dom node
function getElementLayout(element) {
	var rect = getCumulativeOffset(element);
	return {
		x: rect.x,
		y: rect.y,
		width: element.offsetWidth,
		height: element.offsetHeight
	};
}

module.exports = function (Component) {
	var LayoutHandler = (function (_React$Component) {
		_inherits(LayoutHandler, _React$Component);

		function LayoutHandler(props) {
			_classCallCheck(this, LayoutHandler);

			_get(Object.getPrototypeOf(LayoutHandler.prototype), 'constructor', this).call(this, props);
			// propopulate state
			this.state = {};

			// autobinding
			this._handleRedraw = this._handleRedraw.bind(this);
		}

		// subscription to the layout handler

		_createClass(LayoutHandler, [{
			key: 'componentWillMount',
			value: function componentWillMount() {
				LayoutManager.attach(this._handleRedraw);
			}
		}, {
			key: 'componentWillUnmount',
			value: function componentWillUnmount() {
				LayoutManager.detach(this._handleRedraw);
			}

			// inform the layout handler of an update
		}, {
			key: 'componentDidUpdate',
			value: function componentDidUpdate() {
				LayoutManager.deferUpdate();
			}
		}, {
			key: '_handleRedraw',
			value: function _handleRedraw() {
				// get new layout
				var l = getElementLayout(findDOMNode(this.refs.main));
				// if something has changed
				if (this.state.x !== l.x || this.state.y !== l.y || this.state.width !== l.width || this.state.height !== l.height) {
					// trigger the onLayout event
					if (this.props.onLayout) this.props.onLayout({ nativeEvent: { layout: l } });
					// update the current state with new sizes
					this.setState(l);
				}
			}
		}, {
			key: 'render',
			value: function render() {
				// deconstruct
				var _props = this.props;
				var children = _props.children;
				var onLayout = _props.onLayout;

				var props = _objectWithoutProperties(_props, ['children', 'onLayout']);

				// return the component wrapped
				return React.createElement(
					Component,
					_extends({ ref: 'main' }, props),
					children
				);
			}
		}]);

		return LayoutHandler;
	})(React.Component);

	return LayoutHandler;
};