/**
 * Copyright (c) 2016-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */
'use strict';
/*eslint no-bitwise: "off"*/
/*eslint no-console-disallow: "off"*/

// TODO: future features
// put in a module.exports
// filtering / search
// pivot around frames in the middle of a stack by callers / callees
// graphing?

function stringInterner(){// eslint-disable-line no-unused-vars
var strings=[];
var ids={};
return{
intern:function internString(s){
var find=ids[s];
if(find===undefined){
var id=strings.length;
ids[s]=id;
strings.push(s);
return id;
}else{
return find;
}
},
get:function getString(id){
return strings[id];
}};

}

function stackData(stackIdMap,maxDepth){// eslint-disable-line no-unused-vars
return{
maxDepth:maxDepth,
get:function getStack(id){
return stackIdMap[id];
}};

}

function stackRegistry(){// eslint-disable-line no-unused-vars
return{
root:{id:0},
nodeCount:1,
insert:function insertNode(parent,frameId){
var node=parent[frameId];
if(node===undefined){
node={id:this.nodeCount};
this.nodeCount++;
parent[frameId]=node;
}
return node;
},
flatten:function flattenStacks(){
var stackFrameCount=0;
function countStacks(tree,depth){
var leaf=true;
for(var frameId in tree){
if(frameId!=='id'){
leaf=countStacks(tree[frameId],depth+1);
}
}
if(leaf){
stackFrameCount+=depth;
}
return false;
}
countStacks(this.root,0);
console.log('size needed to store stacks: '+(stackFrameCount*4).toString()+'B');
var stackIdMap=new Array(this.nodeCount);
var stackArray=new Int32Array(stackFrameCount);
var maxStackDepth=0;
stackFrameCount=0;
function flattenStacksImpl(tree,stack){
var childStack=void 0;
maxStackDepth=Math.max(maxStackDepth,stack.length);
for(var frameId in tree){
if(frameId!=='id'){
stack.push(Number(frameId));
childStack=flattenStacksImpl(tree[frameId],stack);
stack.pop();
}
}

var id=tree.id;
if(id<0||id>=stackIdMap.length||stackIdMap[id]!==undefined){
throw'invalid stack id!';
}

if(childStack!==undefined){
// each child must have our stack as a prefix, so just use that
stackIdMap[id]=childStack.subarray(0,stack.length);
}else{
var newStack=stackArray.subarray(stackFrameCount,stackFrameCount+stack.length);
stackFrameCount+=stack.length;
for(var i=0;i<stack.length;i++){
newStack[i]=stack[i];
}
stackIdMap[id]=newStack;
}
return stackIdMap[id];
}
flattenStacksImpl(this.root,[]);

return new stackData(stackIdMap,maxStackDepth);
}};

}

function aggrow(numRows){// eslint-disable-line no-unused-vars
// expander ID definitions
var FIELD_EXPANDER_ID_MIN=0x0000;
var FIELD_EXPANDER_ID_MAX=0x7fff;
var STACK_EXPANDER_ID_MIN=0x8000;
var STACK_EXPANDER_ID_MAX=0xffff;

// used for row.expander which reference state.activeExpanders (with frame index masked in)
var INVALID_ACTIVE_EXPANDER=-1;
var ACTIVE_EXPANDER_MASK=0xffff;
var ACTIVE_EXPANDER_FRAME_SHIFT=16;

// aggregator ID definitions
var AGGREGATOR_ID_MAX=0xffff;

// active aggragators can have sort order changed in the reference
var ACTIVE_AGGREGATOR_MASK=0xffff;
var ACTIVE_AGGREGATOR_ASC_BIT=0x10000;

// tree node state definitions
var NODE_EXPANDED_BIT=0x0001;// this row is expanded
var NODE_REAGGREGATE_BIT=0x0002;// children need aggregates
var NODE_REORDER_BIT=0x0004;// children need to be sorted
var NODE_REPOSITION_BIT=0x0008;// children need position
var NODE_INDENT_SHIFT=16;

function calleeFrameIdGetter(stack,depth){
return stack[depth];
}

function callerFrameIdGetter(stack,depth){
return stack[stack.length-depth-1];
}

function createStackComparers(stackGetter,frameIdGetter,maxStackDepth){
var comparers=new Array(maxStackDepth);var _loop=function _loop(
depth){
var captureDepth=depth;// NB: to capture depth per loop iteration
comparers[depth]=function calleeStackComparer(rowA,rowB){
var a=stackGetter(rowA);
var b=stackGetter(rowB);
// NB: we put the stacks that are too short at the top,
// so they can be grouped into the '<exclusive>' bucket
if(a.length<=captureDepth&&b.length<=captureDepth){
return 0;
}else if(a.length<=captureDepth){
return-1;
}else if(b.length<=captureDepth){
return 1;
}
return frameIdGetter(a,captureDepth)-frameIdGetter(b,captureDepth);
};};for(var depth=0;depth<maxStackDepth;depth++){_loop(depth);
}
return comparers;
}

function createTreeNode(parent,label,indices,expander){
var indent=parent===null?0:(parent.state>>>NODE_INDENT_SHIFT)+1;
var state=NODE_REPOSITION_BIT|
NODE_REAGGREGATE_BIT|
NODE_REORDER_BIT|
indent<<NODE_INDENT_SHIFT;
return{
parent:parent,// null if root
children:null,// array of children nodes
label:label,// string to show in UI
indices:indices,// row indices under this node
aggregates:null,// result of aggregate on indices
expander:expander,// index into state.activeExpanders
top:0,// y position of top row (in rows)
height:1,// number of rows including children
state:state};

}

function noSortOrder(a,b){
return 0;
}

var indices=new Int32Array(numRows);
for(var i=0;i<numRows;i++){
indices[i]=i;
}

var state={
fieldExpanders:[],// tree expanders that expand on simple values
stackExpanders:[],// tree expanders that expand stacks
activeExpanders:[],// index into field or stack expanders, hierarchy of tree
aggregators:[],// all available aggregators, might not be used
activeAggregators:[],// index into aggregators, to actually compute
sorter:noSortOrder,// compare function that uses sortOrder to sort row.children
root:createTreeNode(null,'<root>',indices,INVALID_ACTIVE_EXPANDER)};


function evaluateAggregate(row){
var activeAggregators=state.activeAggregators;
var aggregates=new Array(activeAggregators.length);
for(var j=0;j<activeAggregators.length;j++){
var aggregator=state.aggregators[activeAggregators[j]];
aggregates[j]=aggregator.aggregator(row.indices);
}
row.aggregates=aggregates;
row.state|=NODE_REAGGREGATE_BIT;
}

function evaluateAggregates(row){
if((row.state&NODE_EXPANDED_BIT)!==0){
var children=row.children;
for(var _i=0;_i<children.length;_i++){
evaluateAggregate(children[_i]);
}
row.state|=NODE_REORDER_BIT;
}
row.state^=NODE_REAGGREGATE_BIT;
}

function evaluateOrder(row){
if((row.state&NODE_EXPANDED_BIT)!==0){
var children=row.children;
for(var _i2=0;_i2<children.length;_i2++){
var child=children[_i2];
child.state|=NODE_REORDER_BIT;
}
children.sort(state.sorter);
row.state|=NODE_REPOSITION_BIT;
}
row.state^=NODE_REORDER_BIT;
}

function evaluatePosition(row){
if((row.state&NODE_EXPANDED_BIT)!==0){
var children=row.children;
var childTop=row.top+1;
for(var _i3=0;_i3<children.length;_i3++){
var child=children[_i3];
if(child.top!==childTop){
child.top=childTop;
child.state|=NODE_REPOSITION_BIT;
}
childTop+=child.height;
}
}
row.state^=NODE_REPOSITION_BIT;
}

function getRowsImpl(row,top,height,result){
if((row.state&NODE_REAGGREGATE_BIT)!==0){
evaluateAggregates(row);
}
if((row.state&NODE_REORDER_BIT)!==0){
evaluateOrder(row);
}
if((row.state&NODE_REPOSITION_BIT)!==0){
evaluatePosition(row);
}

if(row.top>=top&&row.top<top+height){
if(result[row.top-top]!=null){
throw'getRows put more than one row at position '+row.top+' into result';
}
result[row.top-top]=row;
}
if((row.state&NODE_EXPANDED_BIT)!==0){
var children=row.children;
for(var _i4=0;_i4<children.length;_i4++){
var child=children[_i4];
if(child.top<top+height&&top<child.top+child.height){
getRowsImpl(child,top,height,result);
}
}
}
}

function updateHeight(row,heightChange){
while(row!==null){
row.height+=heightChange;
row.state|=NODE_REPOSITION_BIT;
row=row.parent;
}
}

function addChildrenWithFieldExpander(row,expander,nextActiveIndex){
var rowIndices=row.indices;
var comparer=expander.comparer;
rowIndices.sort(comparer);
var begin=0;
var end=1;
row.children=[];
while(end<rowIndices.length){
if(comparer(rowIndices[begin],rowIndices[end])!==0){
row.children.push(createTreeNode(
row,
expander.name+': '+expander.formatter(rowIndices[begin]),
rowIndices.subarray(begin,end),
nextActiveIndex));
begin=end;
}
end++;
}
row.children.push(createTreeNode(
row,
expander.name+': '+expander.formatter(rowIndices[begin]),
rowIndices.subarray(begin,end),
nextActiveIndex));
}

function addChildrenWithStackExpander(row,expander,activeIndex,depth,nextActiveIndex){
var rowIndices=row.indices;
var stackGetter=expander.stackGetter;
var frameIdGetter=expander.frameIdGetter;
var frameGetter=expander.frameGetter;
var comparer=expander.comparers[depth];
var expandNextFrame=activeIndex|depth+1<<ACTIVE_EXPANDER_FRAME_SHIFT;
rowIndices.sort(comparer);
var columnName='';
if(depth===0){
columnName=expander.name+': ';
}

// put all the too-short stacks under <exclusive>
var begin=0;
var beginStack=null;
row.children=[];
while(begin<rowIndices.length){
beginStack=stackGetter(rowIndices[begin]);
if(beginStack.length>depth){
break;
}
begin++;
}
if(begin>0){
row.children.push(createTreeNode(
row,
columnName+'<exclusive>',
rowIndices.subarray(0,begin),
nextActiveIndex));
}
// aggregate the rest under frames
if(begin<rowIndices.length){
var end=begin+1;
while(end<rowIndices.length){
var endStack=stackGetter(rowIndices[end]);
if(frameIdGetter(beginStack,depth)!==frameIdGetter(endStack,depth)){
row.children.push(createTreeNode(
row,
columnName+frameGetter(frameIdGetter(beginStack,depth)),
rowIndices.subarray(begin,end),
expandNextFrame));
begin=end;
beginStack=endStack;
}
end++;
}
row.children.push(createTreeNode(
row,
columnName+frameGetter(frameIdGetter(beginStack,depth)),
rowIndices.subarray(begin,end),
expandNextFrame));
}
}

function contractRow(row){
if((row.state&NODE_EXPANDED_BIT)===0){
throw'can not contract row, already contracted';
}
row.state^=NODE_EXPANDED_BIT;
var heightChange=1-row.height;
updateHeight(row,heightChange);
}

function pruneExpanders(row,oldExpander,newExpander){
row.state|=NODE_REPOSITION_BIT;
if(row.expander===oldExpander){
row.state|=NODE_REAGGREGATE_BIT|NODE_REORDER_BIT|NODE_REPOSITION_BIT;
if((row.state&NODE_EXPANDED_BIT)!==0){
contractRow(row);
}
row.children=null;
row.expander=newExpander;
}else{
row.state|=NODE_REPOSITION_BIT;
var children=row.children;
if(children!=null){
for(var _i5=0;_i5<children.length;_i5++){
var child=children[_i5];
pruneExpanders(child,oldExpander,newExpander);
}
}
}
}

return{
addFieldExpander:function addFieldExpander(name,formatter,comparer){
if(FIELD_EXPANDER_ID_MIN+state.fieldExpanders.length>=FIELD_EXPANDER_ID_MAX){
throw'too many field expanders!';
}
state.fieldExpanders.push({
name:name,// name for column
formatter:formatter,// row index -> display string
comparer:comparer});

return FIELD_EXPANDER_ID_MIN+state.fieldExpanders.length-1;
},
addCalleeStackExpander:function addCalleeStackExpander(name,maxStackDepth,stackGetter,frameGetter){
if(STACK_EXPANDER_ID_MIN+state.fieldExpanders.length>=STACK_EXPANDER_ID_MAX){
throw'too many stack expanders!';
}
state.stackExpanders.push({
name:name,// name for column
stackGetter:stackGetter,// row index -> stack array
comparers:createStackComparers(stackGetter,calleeFrameIdGetter,maxStackDepth),// depth -> comparer
frameIdGetter:calleeFrameIdGetter,// (stack, depth) -> string id
frameGetter:frameGetter});

return STACK_EXPANDER_ID_MIN+state.stackExpanders.length-1;
},
addCallerStackExpander:function addCallerStackExpander(name,maxStackDepth,stackGetter,frameGetter){
if(STACK_EXPANDER_ID_MIN+state.fieldExpanders.length>=STACK_EXPANDER_ID_MAX){
throw'too many stack expanders!';
}
state.stackExpanders.push({
name:name,
stackGetter:stackGetter,
comparers:createStackComparers(stackGetter,callerFrameIdGetter,maxStackDepth),
frameIdGetter:callerFrameIdGetter,
frameGetter:frameGetter});

return STACK_EXPANDER_ID_MIN+state.stackExpanders.length-1;
},
getExpanders:function getExpanders(){
var expanders=[];
for(var _i6=0;_i6<state.fieldExpanders.length;_i6++){
expanders.push(FIELD_EXPANDER_ID_MIN+_i6);
}
for(var _i7=0;_i7<state.stackExpanders.length;_i7++){
expanders.push(STACK_EXPANDER_ID_MIN+_i7);
}
return expanders;
},
getExpanderName:function getExpanderName(id){
if(id>=FIELD_EXPANDER_ID_MIN&&id<=FIELD_EXPANDER_ID_MAX){
return state.fieldExpanders[id-FIELD_EXPANDER_ID_MIN].name;
}else if(id>=STACK_EXPANDER_ID_MIN&&id<=STACK_EXPANDER_ID_MAX){
return state.stackExpanders[id-STACK_EXPANDER_ID_MIN].name;
}
throw'Unknown expander ID '+id.toString();
},
setActiveExpanders:function setActiveExpanders(ids){
for(var _i8=0;_i8<ids.length;_i8++){
var id=ids[_i8];
if(id>=FIELD_EXPANDER_ID_MIN&&id<=FIELD_EXPANDER_ID_MAX){
if(id-FIELD_EXPANDER_ID_MIN>=state.fieldExpanders.length){
throw'field expander for id '+id.toString()+' does not exist!';
}
}else if(id>=STACK_EXPANDER_ID_MIN&&id<=STACK_EXPANDER_ID_MAX){
if(id-STACK_EXPANDER_ID_MIN>=state.stackExpanders.length){
throw'stack expander for id '+id.toString()+' does not exist!';
}
}
}
for(var _i9=0;_i9<ids.length;_i9++){
if(state.activeExpanders.length<=_i9){
pruneExpanders(state.root,INVALID_ACTIVE_EXPANDER,_i9);
break;
}else if(ids[_i9]!==state.activeExpanders[_i9]){
pruneExpanders(state.root,_i9,_i9);
break;
}
}
// TODO: if ids is prefix of activeExpanders, we need to make an expander invalid
state.activeExpanders=ids.slice();
},
getActiveExpanders:function getActiveExpanders(){
return state.activeExpanders.slice();
},
addAggregator:function addAggregator(name,aggregator,formatter,sorter){
if(state.aggregators.length>=AGGREGATOR_ID_MAX){
throw'too many aggregators!';
}
state.aggregators.push({
name:name,// name for column
aggregator:aggregator,// index array -> aggregate value
formatter:formatter,// aggregate value -> display string
sorter:sorter});

return state.aggregators.length-1;
},
getAggregators:function getAggregators(){
var aggregators=[];
for(var _i10=0;_i10<state.aggregators.length;_i10++){
aggregators.push(_i10);
}
return aggregators;
},
getAggregatorName:function getAggregatorName(id){
return state.aggregators[id&ACTIVE_AGGREGATOR_MASK].name;
},
setActiveAggregators:function setActiveAggregators(ids){
for(var _i11=0;_i11<ids.length;_i11++){
var id=ids[_i11]&ACTIVE_AGGREGATOR_MASK;
if(id<0||id>state.aggregators.length){
throw'aggregator id '+id.toString()+' not valid';
}
}
state.activeAggregators=ids.slice();
// NB: evaluate root here because dirty bit is for children
// so someone has to start with root, and it might as well be right away
evaluateAggregate(state.root);
var sorter=noSortOrder;var _loop2=function _loop2(
_i12){
var ascending=(ids[_i12]&ACTIVE_AGGREGATOR_ASC_BIT)!==0;
var id=ids[_i12]&ACTIVE_AGGREGATOR_MASK;
var comparer=state.aggregators[id].sorter;
var captureSorter=sorter;
var captureIndex=_i12;
sorter=function sorter(a,b){
var c=comparer(a.aggregates[captureIndex],b.aggregates[captureIndex]);
if(c===0){
return captureSorter(a,b);
}
return ascending?-c:c;
};};for(var _i12=ids.length-1;_i12>=0;_i12--){_loop2(_i12);
}
state.sorter=sorter;
state.root.state|=NODE_REORDER_BIT;
},
getActiveAggregators:function getActiveAggregators(){
return state.activeAggregators.slice();
},
getRows:function getRows(top,height){
var result=new Array(height);
for(var _i13=0;_i13<height;_i13++){
result[_i13]=null;
}
getRowsImpl(state.root,top,height,result);
return result;
},
getRowLabel:function getRowLabel(row){
return row.label;
},
getRowIndent:function getRowIndent(row){
return row.state>>>NODE_INDENT_SHIFT;
},
getRowAggregate:function getRowAggregate(row,index){
var aggregator=state.aggregators[state.activeAggregators[index]];
return aggregator.formatter(row.aggregates[index]);
},
getHeight:function getHeight(){
return state.root.height;
},
canExpand:function canExpand(row){
return(row.state&NODE_EXPANDED_BIT)===0&&row.expander!==INVALID_ACTIVE_EXPANDER;
},
canContract:function canContract(row){
return(row.state&NODE_EXPANDED_BIT)!==0;
},
expand:function expand(row){
if((row.state&NODE_EXPANDED_BIT)!==0){
throw'can not expand row, already expanded';
}
if(row.height!==1){
throw'unexpanded row has height '+row.height.toString()+' != 1';
}
if(row.children===null){// first expand, generate children
var activeIndex=row.expander&ACTIVE_EXPANDER_MASK;
var nextActiveIndex=activeIndex+1;// NB: if next is stack, frame is 0
if(nextActiveIndex>=state.activeExpanders.length){
nextActiveIndex=INVALID_ACTIVE_EXPANDER;
}
if(activeIndex>=state.activeExpanders.length){
throw'invalid active expander index '+activeIndex.toString();
}
var exId=state.activeExpanders[activeIndex];
if(exId>=FIELD_EXPANDER_ID_MIN&&
exId<FIELD_EXPANDER_ID_MIN+state.fieldExpanders.length){
var expander=state.fieldExpanders[exId-FIELD_EXPANDER_ID_MIN];
addChildrenWithFieldExpander(row,expander,nextActiveIndex);
}else if(exId>=STACK_EXPANDER_ID_MIN&&
exId<STACK_EXPANDER_ID_MIN+state.stackExpanders.length){
var depth=row.expander>>>ACTIVE_EXPANDER_FRAME_SHIFT;
var _expander=state.stackExpanders[exId-STACK_EXPANDER_ID_MIN];
addChildrenWithStackExpander(row,_expander,activeIndex,depth,nextActiveIndex);
}else{
throw'state.activeIndex '+activeIndex.toString()+
' has invalid expander'+exId.toString();
}
}
row.state|=NODE_EXPANDED_BIT|
NODE_REAGGREGATE_BIT|NODE_REORDER_BIT|NODE_REPOSITION_BIT;
var heightChange=0;
for(var _i14=0;_i14<row.children.length;_i14++){
heightChange+=row.children[_i14].height;
}
updateHeight(row,heightChange);
// if children only contains one node, then expand it as well
if(row.children.length===1&&this.canExpand(row.children[0])){
this.expand(row.children[0]);
}
},
contract:function contract(row){
contractRow(row);
}};

}
//# sourceMappingURL=data:application/json;base64,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
// @generated
