/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule Platform
 * @flow
 */

'use strict';

var Platform = {
  OS: 'android',
  get Version() {
    const AndroidConstants = require('NativeModules').AndroidConstants;
    return AndroidConstants && AndroidConstants.Version;
  },
  select: (obj: Object) => obj.android,
};

module.exports = Platform;
