'use strict';

jest.autoMockOff();

const xcode = require('xcode');
const path = require('path');
const PbxFile = require('xcode/lib/pbxFile');
const addProjectToLibraries = require('../../ios/addProjectToLibraries');
const last = require('lodash').last;

const project = xcode.project(
  path.join(__dirname, '../../__fixtures__/project.pbxproj')
);

describe('ios::addProjectToLibraries', () => {
  beforeEach(() => {
    project.parseSync();
  });

  it('should append file to Libraries group', () => {
    const file = new PbxFile('fakePath');
    const libraries = project.pbxGroupByName('Libraries');

    addProjectToLibraries(libraries, file);

    const child = last(libraries.children);

    expect((['value', 'comment']), child).toBeTruthy();
    expect(child.comment).toBe(file.basename);
  });
});
