/**
 * Given Xcode project and path, iterate over all build configurations
 * and execute func with HEADER_SEARCH_PATHS from current section
 *
 * We cannot use builtin addToHeaderSearchPaths method since react-native init does not
 * use $(TARGET_NAME) for PRODUCT_NAME, but sets it manually so that method will skip
 * that target.
 *
 * To workaround that issue and make it more bullet-proof for different names,
 * we iterate over all configurations and look if React is already there. If it is,
 * we assume we want to modify that section either
 *
 * Important: That function mutates `buildSettings` and it's not pure thus you should
 * not rely on its return value
 */
module.exports = function headerSearchPathIter(project, func) {
  const config = project.pbxXCBuildConfigurationSection();

  Object
    .keys(config)
    .filter(ref => ref.indexOf('_comment') === -1)
    .forEach(ref => {
      const buildSettings = config[ref].buildSettings;
      const shouldVisitBuildSettings = (
          Array.isArray(buildSettings.HEADER_SEARCH_PATHS) ?
            buildSettings.HEADER_SEARCH_PATHS :
            []
        )
        .filter(path => path.indexOf('react-native/React/**') >= 0)
        .length > 0;

      if (shouldVisitBuildSettings) {
        buildSettings.HEADER_SEARCH_PATHS = func(buildSettings.HEADER_SEARCH_PATHS);
      }
    });
};
