'use strict';

exports.__esModule = true;
exports.JSONAddNode = undefined;

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _AddOptions = require('./AddOptions');

var _typeCasting = require('./utils/typeCasting');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var JSONAddNode = exports.JSONAddNode = function (_React$Component) {
  (0, _inherits3['default'])(JSONAddNode, _React$Component);

  function JSONAddNode(props) {
    (0, _classCallCheck3['default'])(this, JSONAddNode);

    var _this = (0, _possibleConstructorReturn3['default'])(this, _React$Component.call(this, props));

    _this.showAddType = function () {
      _this.setState({
        showAddOptions: true
      });
    };

    _this.handleNodeKeyInput = function (e) {
      _this.setState({
        newNodeKey: e.target.value
      });
    };

    _this.handleNodeValueInput = function (e) {
      _this.setState({
        newNodeValue: e.target.value
      });
    };

    _this.handleAddNode = function () {
      var newNode = {};
      var newNodeValue = (0, _typeCasting.valueAsType)(_this.state.newNodeValue, _this.state.newNodeType);
      newNode['' + _this.state.newNodeKey] = newNodeValue;
      _this.props.addNode(_this.state.newNodeKey, newNodeValue, _this.props.keyPath);
      _this.setState({
        showAddOptions: false
      });
    };

    _this.handleNodeTypeUpdate = function (e) {
      _this.setState({
        newNodeType: e.target.value
      });
    };

    _this.state = {
      showAddOptions: false,
      newNodeType: 'String',
      newNodeKey: '',
      newNodeValue: ''
    };
    return _this;
  }

  JSONAddNode.prototype.render = function render() {
    return _react2['default'].createElement(
      'div',
      null,
      this.state.showAddOptions ? _react2['default'].createElement(_AddOptions.AddOptions, {
        addNode: this.handleAddNode,
        nodeType: this.state.newNodeType,
        updateNodeType: this.handleNodeTypeUpdate,
        newNodeKey: this.state.newNodeKey,
        newNodeValue: this.state.newNodeValue,
        updateNodeKey: this.handleNodeKeyInput,
        updateNodeValue: this.handleNodeValueInput
      }) : _react2['default'].createElement(
        'span',
        { onClick: this.showAddType },
        ' + Add Node'
      )
    );
  };

  return JSONAddNode;
}(_react2['default'].Component);

JSONAddNode.propTypes = {
  keyPath: _react.PropTypes.arrayOf(_react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number])).isRequired,
  addNode: _react.PropTypes.func
};

exports['default'] = JSONAddNode;