'use strict';

exports.__esModule = true;
exports.JSONEditableValueNode = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ValueInput = require('./ValueInput');

var _ValueType = require('./ValueType');

var _typeCasting = require('./utils/typeCasting');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var JSONEditableValueNode = exports.JSONEditableValueNode = function (_React$Component) {
  (0, _inherits3['default'])(JSONEditableValueNode, _React$Component);

  function JSONEditableValueNode(props) {
    var _this$props;

    (0, _classCallCheck3['default'])(this, JSONEditableValueNode);

    var _this = (0, _possibleConstructorReturn3['default'])(this, _React$Component.call(this, props));

    _this.makeEditableKey = function () {
      _this.setState({
        editableKey: true
      });
    };

    _this.makeEditableValue = function () {
      _this.setState({
        editableValue: true
      });
    };

    _this.clickUpdateValue = function () {
      var newValue = (0, _typeCasting.valueAsType)(_this.state.newNodeValue, _this.state.nodeType);
      _this.setState({
        editableKey: false,
        editableValue: false
      });
      _this.props.updateValue(newValue, _this.props.keyPath);
      _this.props.updateNodeKey(_this.state.keyValue, _this.props.keyPath);
    };

    _this.updateLocalKey = function (newKey) {
      _this.setState({
        keyValue: newKey
      });
    };

    _this.handleNodeTypeUpdate = function (e) {
      _this.setState({
        nodeType: e.target.value
      });
    };

    _this.handleNodeValueInput = function (e) {
      _this.setState({
        newNodeValue: e.target.value
      });
    };

    _this.state = {
      editableKey: false,
      editableValue: false,
      newNodeValue: _this.props.valueGetter(_this.props.value),
      nodeType: _this.props.nodeType,
      keyValue: (_this$props = _this.props).labelRenderer.apply(_this$props, _this.props.keyPath)
    };
    return _this;
  }

  JSONEditableValueNode.prototype.render = function render() {
    var _this2 = this;

    var _props = this.props;
    var nodeType = _props.nodeType;
    var styling = _props.styling;
    var labelRenderer = _props.labelRenderer;
    var keyPath = _props.keyPath;
    var valueRenderer = _props.valueRenderer;
    var value = _props.value;
    var valueGetter = _props.valueGetter;
    var removeNode = _props.removeNode;


    var editableKey = this.state.editableKey ? _react2['default'].createElement('input', (0, _extends3['default'])({}, styling(['label', 'valueLabel'], nodeType, keyPath), {
      value: this.state.keyValue,
      onChange: function onChange(e) {
        return _this2.updateLocalKey(e.target.value, keyPath);
      }
    })) : _react2['default'].createElement(
      'label',
      (0, _extends3['default'])({}, styling(['label', 'valueLabel'], nodeType, keyPath), {
        onClick: this.makeEditableKey
      }),
      labelRenderer.apply(undefined, keyPath)
    );

    var editableValue = this.state.editableValue ? _react2['default'].createElement(_ValueInput.ValueInput, {
      nodeType: this.state.nodeType,
      updateNodeValue: this.handleNodeValueInput,
      newNodeValue: this.state.newNodeValue
    }) : _react2['default'].createElement(
      'span',
      (0, _extends3['default'])({}, this.props.styling('valueText', nodeType, keyPath), {
        onClick: this.makeEditableValue
      }),
      valueRenderer(valueGetter(value), value)
    );

    var typeSelector = this.state.editableValue ? _react2['default'].createElement(_ValueType.ValueType, {
      nodeType: this.state.nodeType,
      updateNodeType: this.handleNodeTypeUpdate
    }) : null;

    var actionButton = this.state.editableKey || this.state.editableValue ? _react2['default'].createElement(
      'span',
      { onClick: this.clickUpdateValue },
      '[update value]'
    ) : _react2['default'].createElement(
      'span',
      { onClick: function onClick() {
          return removeNode(keyPath);
        } },
      '[x]'
    );

    return _react2['default'].createElement(
      'div',
      null,
      _react2['default'].createElement(
        'li',
        this.props.styling('value', nodeType, keyPath),
        editableKey,
        ':',
        editableValue,
        typeSelector,
        actionButton
      )
    );
  };

  return JSONEditableValueNode;
}(_react2['default'].Component);

JSONEditableValueNode.propTypes = {
  nodeType: _react.PropTypes.string.isRequired,
  styling: _react.PropTypes.func.isRequired,
  labelRenderer: _react.PropTypes.func.isRequired,
  keyPath: _react.PropTypes.arrayOf(_react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number])).isRequired,
  valueRenderer: _react.PropTypes.func.isRequired,
  value: _react.PropTypes.any,
  valueGetter: _react.PropTypes.func,
  makeEditable: _react.PropTypes.func,
  editableNode: _react.PropTypes.arrayOf(_react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number])),
  updateValue: _react.PropTypes.func,
  updateNodeKey: _react.PropTypes.func,
  removeNode: _react.PropTypes.func
};

JSONEditableValueNode.defaultProps = {
  valueGetter: function valueGetter(value) {
    return value;
  },
  editableNode: ''
};

exports['default'] = JSONEditableValueNode;