'use strict';

exports.__esModule = true;
exports.JSONEditor = undefined;

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _JSONNode = require('./JSONNode');

var _JSONNode2 = _interopRequireDefault(_JSONNode);

var _createStylingFromTheme = require('./createStylingFromTheme');

var _createStylingFromTheme2 = _interopRequireDefault(_createStylingFromTheme);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var identity = function identity(value) {
  return value;
}; // ES6 + inline style port of JSONViewer https://bitbucket.org/davevedder/react-json-viewer/
// all credits and original code to the author
// Dave Vedder <veddermatic@gmail.com> http://www.eskimospy.com/
// port by Daniele Zannotti http://www.github.com/dzannotti <dzannotti@me.com>

function checkLegacyTheming(theme, props) {
  var deprecatedStylingMethodsMap = {
    getArrowStyle: 'arrow',
    getListStyle: 'nestedNodeChildren',
    getItemStringStyle: 'nestedNodeItemString',
    getLabelStyle: 'label',
    getValueStyle: 'valueText'
  };

  var deprecatedStylingMethods = (0, _keys2['default'])(deprecatedStylingMethodsMap).filter(function (name) {
    return props[name];
  });

  if (deprecatedStylingMethods.length > 0) {
    if (typeof theme === 'string') {
      theme = {
        extend: theme
      };
    } else {
      theme = (0, _extends3['default'])({}, theme);
    }

    deprecatedStylingMethods.forEach(function (name) {
      console.error( // eslint-disable-line no-console
      'Styling method "' + name + '" is deprecated, use "theme" property instead');

      theme[deprecatedStylingMethodsMap[name]] = function (_ref) {
        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        var style = _ref.style;
        return {
          style: (0, _extends3['default'])({}, style, props[name].apply(props, args))
        };
      };
    });
  }

  return theme;
}

var JSONEditor = exports.JSONEditor = function (_React$Component) {
  (0, _inherits3['default'])(JSONEditor, _React$Component);

  function JSONEditor(props) {
    (0, _classCallCheck3['default'])(this, JSONEditor);

    var _this = (0, _possibleConstructorReturn3['default'])(this, _React$Component.call(this, props));

    _this.makeEditable = function (keyPath) {
      _this.setState({
        editableNode: keyPath.toString()
      });
    };

    _this.state = {
      editableNode: ''
    };
    return _this;
  }

  JSONEditor.prototype.render = function render() {
    var _props = this.props;
    var value = _props.data;
    var expandRoot = _props.expandRoot;
    var expandAll = _props.expandAll;
    var keyPath = _props.keyPath;
    var postprocessValue = _props.postprocessValue;
    var hideRoot = _props.hideRoot;
    var theme = _props.theme;
    var isLightTheme = _props.isLightTheme;
    var updateValue = _props.updateValue;
    var updateNodeKey = _props.updateNodeKey;
    var removeNode = _props.removeNode;
    var addNode = _props.addNode;
    var rest = (0, _objectWithoutProperties3['default'])(_props, ['data', 'expandRoot', 'expandAll', 'keyPath', 'postprocessValue', 'hideRoot', 'theme', 'isLightTheme', 'updateValue', 'updateNodeKey', 'removeNode', 'addNode']);


    if (typeof expandRoot !== 'undefined') {
      console.error( // eslint-disable-line no-console
      'The expandRoot property is deprecated, use "shouldExpandNode: () => false" instead');
    }

    if (typeof expandAll !== 'undefined') {
      console.error( // eslint-disable-line no-console
      'The expandAll property is deprecated, use "shouldExpandNode: () => true" instead');
    }

    var styling = (0, _createStylingFromTheme2['default'])(checkLegacyTheming(theme, rest), null, isLightTheme);

    return _react2['default'].createElement(
      'ul',
      styling('tree'),
      _react2['default'].createElement(
        'pre',
        null,
        (0, _stringify2['default'])(this.state)
      ),
      _react2['default'].createElement(_JSONNode2['default'], (0, _extends3['default'])({}, (0, _extends3['default'])({ postprocessValue: postprocessValue, hideRoot: hideRoot, styling: styling }, rest), {
        initialExpanded: typeof expandRoot === 'undefined' ? true : expandRoot,
        allExpanded: typeof expandAll === 'undefined' ? false : expandAll,
        keyPath: hideRoot ? [] : keyPath,
        value: postprocessValue(value),
        updateValue: updateValue,
        updateNodeKey: updateNodeKey,
        removeNode: removeNode,
        addNode: addNode,
        editableNode: this.state.editableNode,
        makeEditable: this.makeEditable,
        valueOnClick: this.valueOnClick
      }))
    );
  };

  return JSONEditor;
}(_react2['default'].Component);

JSONEditor.propTypes = {
  data: _react.PropTypes.oneOfType([_react.PropTypes.array, _react.PropTypes.object]).isRequired,
  hideRoot: _react.PropTypes.bool,
  theme: _react.PropTypes.oneOfType([_react.PropTypes.object, _react.PropTypes.string]),
  isLightTheme: _react.PropTypes.bool,
  expandRoot: _react.PropTypes.bool,
  expandAll: _react.PropTypes.bool,
  keyPath: _react.PropTypes.arrayOf(_react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number])),
  postprocessValue: _react.PropTypes.func,
  updateValue: _react.PropTypes.func,
  updateNodeKey: _react.PropTypes.func,
  removeNode: _react.PropTypes.func,
  addNode: _react.PropTypes.func
};

JSONEditor.defaultProps = {
  shouldExpandNode: function shouldExpandNode(keyName, data, level) {
    return level === 0;
  }, // expands root by default,
  hideRoot: true,
  keyPath: ['root'],
  getItemString: function getItemString(type, data, itemType, itemString) {
    return _react2['default'].createElement(
      'span',
      null,
      itemType,
      ' ',
      itemString
    );
  },
  labelRenderer: identity,
  valueRenderer: identity,
  postprocessValue: identity,
  isCustomNode: function isCustomNode() {
    return false;
  },
  collectionLimit: 50,
  isLightTheme: true
};

exports['default'] = JSONEditor;