'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ObjectDescription = require('./ObjectDescription');

var _ObjectDescription2 = _interopRequireDefault(_ObjectDescription);

var _ObjectPreview = require('./ObjectPreview');

var _ObjectPreview2 = _interopRequireDefault(_ObjectPreview);

// Constants

// Styles

var _objectStyles = require('./objectStyles');

var _objectStyles2 = _interopRequireDefault(_objectStyles);

var DEFAULT_ROOT_PATH = 'root';
var styles = {
  base: {
    fontFamily: 'Menlo, monospace',
    fontSize: '11px',
    lineHeight: '14px',
    cursor: 'default'
  },
  propertyNodesContainer: {
    paddingLeft: '12px'
  },
  unselectable: {
    WebkitTouchCallout: 'none',
    WebkitUserSelect: 'none',
    KhtmlUserSelect: 'none',
    MozUserSelect: 'none',
    msUserSelect: 'none',
    OUserSelect: 'none',
    userSelect: 'none'
  },
  expandControl: {
    color: '#6e6e6e',
    fontSize: '10px',
    marginRight: '3px',
    whiteSpace: 'pre'
  },
  property: {
    paddingTop: '2px'
  }
};

var ObjectInspector = (function (_Component) {
  _inherits(ObjectInspector, _Component);

  _createClass(ObjectInspector, null, [{
    key: 'defaultProps',
    // path is dot separated property names to reach the current node
    value: {
      name: void 0,
      data: undefined,
      initialExpandedPaths: undefined,
      depth: 0,
      path: DEFAULT_ROOT_PATH
    },
    enumerable: true
  }]);

  function ObjectInspector(props) {
    var _this = this;

    _classCallCheck(this, ObjectInspector);

    _get(Object.getPrototypeOf(ObjectInspector.prototype), 'constructor', this).call(this, props);

    if (props.depth === 0) {
      this.state = { expandedPaths: {} };
      this.state.expandedPaths[props.path] = false;

      // initialize expandedPaths with initialExpandedPaths
      if (typeof props.initialExpandedPaths !== 'undefined') {
        props.initialExpandedPaths.map(function (expandedPath) {
          if (typeof expandedPath === 'string') {
            (function () {
              var wildcardPathToPaths = function wildcardPathToPaths(curObject, curPath, i) {
                var WILDCARD = "*";
                if (i === names.length) {
                  paths.push(curPath);
                  return;
                }
                var name = names[i];
                if (i === 0) {
                  if (name === props.name || name === DEFAULT_ROOT_PATH || name === WILDCARD) {
                    wildcardPathToPaths(curObject, 'root', i + 1);
                  }
                } else {
                  if (name === WILDCARD) {
                    for (var propertyName in curObject) {
                      if (curObject.hasOwnProperty(propertyName)) {
                        var propertyValue = curObject[propertyName];
                        if (ObjectInspector.isExpandable(propertyValue)) {
                          wildcardPathToPaths(propertyValue, curPath + '.' + propertyName, i + 1);
                        } else {
                          continue;
                        }
                      }
                    }
                  } else {
                    var propertyValue = curObject[name];
                    if (ObjectInspector.isExpandable(propertyValue)) {
                      wildcardPathToPaths(propertyValue, curPath + '.' + name, i + 1);
                    }
                  }
                }
              };

              var names = expandedPath.split('.'); // wildcard names
              var paths = [];

              wildcardPathToPaths(props.data, '', 0);

              paths.map(function (path) {
                _this.state.expandedPaths[path] = true;
              });
            })();
          }
        });
      }
    }
  }

  _createClass(ObjectInspector, [{
    key: 'getExpanded',
    value: function getExpanded(path) {
      var expandedPaths = this.state.expandedPaths;
      if (typeof expandedPaths[path] !== 'undefined') {
        return expandedPaths[path];
      }
      return false;
    }
  }, {
    key: 'setExpanded',
    value: function setExpanded(path, expanded) {
      var expandedPaths = this.state.expandedPaths;
      expandedPaths[path] = expanded;
      this.setState({ expandedPaths: expandedPaths });
    }
  }, {
    key: 'handleClick',
    value: function handleClick() {
      // console.log(this.props.data);
      if (ObjectInspector.isExpandable(this.props.data)) {
        if (this.props.depth > 0) {
          this.props.setExpanded(this.props.path, !this.props.getExpanded(this.props.path));
        } else {
          this.setExpanded(this.props.path, !this.getExpanded(this.props.path));
        }
      }
    }
  }, {
    key: 'componentWillMount',
    value: function componentWillMount() {
      if (typeof _react2['default'].initializeTouchEvents === 'function') {
        _react2['default'].initializeTouchEvents(true);
      }
    }
  }, {
    key: 'render',
    value: function render() {

      var data = this.props.data;
      var name = this.props.name;

      var setExpanded = this.props.depth === 0 ? this.setExpanded.bind(this) : this.props.setExpanded;
      var getExpanded = this.props.depth === 0 ? this.getExpanded.bind(this) : this.props.getExpanded;
      var expanded = getExpanded(this.props.path);

      var expandGlyph = ObjectInspector.isExpandable(data) ? expanded ? '▼' : '▶' : this.props.depth === 0 ? '' // unnamed root node
      : ' ';

      var propertyNodesContainer = undefined;
      if (expanded) {
        var propertyNodes = [];

        for (var propertyName in data) {
          var propertyValue = data[propertyName];
          if (data.hasOwnProperty(propertyName)) {
            propertyNodes.push(_react2['default'].createElement(ObjectInspector, { getExpanded: getExpanded,
              setExpanded: setExpanded,
              path: this.props.path + '.' + propertyName,
              depth: this.props.depth + 1,
              key: propertyName,
              name: propertyName,
              data: propertyValue }));
          }
        }
        propertyNodesContainer = _react2['default'].createElement(
          'div',
          { style: styles.propertyNodesContainer },
          propertyNodes
        );
      }

      return _react2['default'].createElement(
        'div',
        { style: styles.base },
        _react2['default'].createElement(
          'span',
          { style: styles.property, onClick: this.handleClick.bind(this) },
          _react2['default'].createElement(
            'span',
            { style: _extends({}, styles.expandControl, styles.unselectable) },
            expandGlyph
          ),
          (function () {
            if (typeof name !== 'undefined') {
              return _react2['default'].createElement(
                'span',
                null,
                _react2['default'].createElement(
                  'span',
                  { style: _objectStyles2['default'].name },
                  name
                ),
                _react2['default'].createElement(
                  'span',
                  null,
                  ': '
                ),
                _react2['default'].createElement(_ObjectDescription2['default'], { object: data })
              );
            } else {
              return _react2['default'].createElement(_ObjectPreview2['default'], { object: data });
            }
          })()
        ),
        propertyNodesContainer
      );
    }
  }], [{
    key: 'isExpandable',
    value: function isExpandable(data) {
      return typeof data === 'object' && data !== null && Object.keys(data).length > 0;
    }
  }]);

  return ObjectInspector;
})(_react.Component);

exports['default'] = ObjectInspector;
module.exports = exports['default'];
// initial paths of the nodes that are visible