import SimpleWrapper from './SimpleWrapper.jsx';
import React from 'react';
import Util from './Util.js';

/**
 * @original ons-progress-bar
 * @category visual
 * @tutorial react/Reference/progress
 * @description
 * [en] The component is used to display a linear progress bar. It can either display a progress bar that shows the user how much of a task has been completed. In the case where the percentage is not known it can be used to display an animated progress bar so the user can see that an operation is in progress.  [/en]
 * [jp][/jp]
 * @example
 *<ProgressBar value={55} secondaryValue={87} />
 *<ProgressBar indeterminate />
 */
class ProgressBar extends SimpleWrapper {
  _getDomNodeName() {
    return 'ons-progress-bar';
  }

  render() {
    var {...others} = this.props;

    Util.convert(others, 'indeterminate');
    Util.convert(others, 'secondaryValue', {newName: 'secondary-value'});

    return React.createElement(this._getDomNodeName(), others, this.props.children);
  }

}

ProgressBar.propTypes = {
  /**
   * @name modifier
   * @type string
   * @required false
   * @description
   *  [en]The appearance of the progress indicator.[/en]
   *  [jp] [/jp]
   */
  modifier: React.PropTypes.string,

  /**
   * @name value
   * @type number
   * @description
   *  [en]
   *  Current progress. Should be a value between 0 and 100.
   *  [/en]
   *  [jp] [/jp]
   */
  value: React.PropTypes.number,

  /**
   * @name secondaryValue
   * @type bool
   * @description
   *  [en]
   *  Current secondary progress. Should be a value between 0 and 100.
   *  [/en]
   *  [jp] [/jp]
   */
  secondaryValue: React.PropTypes.number,

  /**
   * @name intermediate
   * @type bool
   * @description
   *  [en] If this property is set, an infinite looping animation will be shown. [/en]
   *  [jp] [/jp]
   */
  indeterminate: React.PropTypes.bool
};

export default ProgressBar;
