/* react-onsenui v1.13.0 - 2022-07-25 */

(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('onsenui'), require('prop-types'), require('onsenui/esm/elements/ons-action-sheet'), require('react'), require('react-dom'), require('onsenui/esm/elements/ons-action-sheet-button'), require('onsenui/esm/elements/ons-alert-dialog'), require('onsenui/esm/elements/ons-alert-dialog-button'), require('onsenui/esm/elements/ons-back-button'), require('onsenui/esm/elements/ons-bottom-toolbar'), require('onsenui/esm/elements/ons-button'), require('onsenui/esm/elements/ons-card'), require('onsenui/esm/elements/ons-carousel'), require('onsenui/esm/elements/ons-carousel-item'), require('onsenui/esm/elements/ons-checkbox'), require('onsenui/esm/elements/ons-col'), require('onsenui/esm/elements/ons-dialog'), require('onsenui/esm/elements/ons-fab'), require('onsenui/esm/elements/ons-gesture-detector'), require('onsenui/esm/elements/ons-icon'), require('onsenui/esm/elements/ons-input'), require('onsenui/esm/elements/ons-lazy-repeat'), require('onsenui/esm/elements/ons-list'), require('onsenui/esm/elements/ons-list-header'), require('onsenui/esm/elements/ons-list-item'), require('onsenui/esm/elements/ons-list-title'), require('onsenui/esm/elements/ons-navigator'), require('onsenui/esm/elements/ons-modal'), require('onsenui/esm/elements/ons-page'), require('onsenui/esm/elements/ons-popover'), require('onsenui/esm/elements/ons-progress-bar'), require('onsenui/esm/elements/ons-progress-circular'), require('onsenui/esm/elements/ons-pull-hook'), require('onsenui/esm/elements/ons-radio'), require('onsenui/esm/elements/ons-range'), require('onsenui/esm/elements/ons-ripple'), require('onsenui/esm/elements/ons-row'), require('onsenui/esm/elements/ons-search-input'), require('onsenui/esm/elements/ons-segment'), require('onsenui/esm/elements/ons-select'), require('onsenui/esm/elements/ons-speed-dial'), require('onsenui/esm/elements/ons-speed-dial-item'), require('onsenui/esm/elements/ons-splitter'), require('onsenui/esm/elements/ons-splitter-content'), require('onsenui/esm/elements/ons-splitter-side'), require('onsenui/esm/elements/ons-switch'), require('onsenui/esm/elements/ons-tab'), require('onsenui/esm/elements/ons-tabbar'), require('onsenui/esm/elements/ons-toast'), require('onsenui/esm/elements/ons-toolbar'), require('onsenui/esm/elements/ons-toolbar-button')) :
  typeof define === 'function' && define.amd ? define(['exports', 'onsenui', 'prop-types', 'onsenui/esm/elements/ons-action-sheet', 'react', 'react-dom', 'onsenui/esm/elements/ons-action-sheet-button', 'onsenui/esm/elements/ons-alert-dialog', 'onsenui/esm/elements/ons-alert-dialog-button', 'onsenui/esm/elements/ons-back-button', 'onsenui/esm/elements/ons-bottom-toolbar', 'onsenui/esm/elements/ons-button', 'onsenui/esm/elements/ons-card', 'onsenui/esm/elements/ons-carousel', 'onsenui/esm/elements/ons-carousel-item', 'onsenui/esm/elements/ons-checkbox', 'onsenui/esm/elements/ons-col', 'onsenui/esm/elements/ons-dialog', 'onsenui/esm/elements/ons-fab', 'onsenui/esm/elements/ons-gesture-detector', 'onsenui/esm/elements/ons-icon', 'onsenui/esm/elements/ons-input', 'onsenui/esm/elements/ons-lazy-repeat', 'onsenui/esm/elements/ons-list', 'onsenui/esm/elements/ons-list-header', 'onsenui/esm/elements/ons-list-item', 'onsenui/esm/elements/ons-list-title', 'onsenui/esm/elements/ons-navigator', 'onsenui/esm/elements/ons-modal', 'onsenui/esm/elements/ons-page', 'onsenui/esm/elements/ons-popover', 'onsenui/esm/elements/ons-progress-bar', 'onsenui/esm/elements/ons-progress-circular', 'onsenui/esm/elements/ons-pull-hook', 'onsenui/esm/elements/ons-radio', 'onsenui/esm/elements/ons-range', 'onsenui/esm/elements/ons-ripple', 'onsenui/esm/elements/ons-row', 'onsenui/esm/elements/ons-search-input', 'onsenui/esm/elements/ons-segment', 'onsenui/esm/elements/ons-select', 'onsenui/esm/elements/ons-speed-dial', 'onsenui/esm/elements/ons-speed-dial-item', 'onsenui/esm/elements/ons-splitter', 'onsenui/esm/elements/ons-splitter-content', 'onsenui/esm/elements/ons-splitter-side', 'onsenui/esm/elements/ons-switch', 'onsenui/esm/elements/ons-tab', 'onsenui/esm/elements/ons-tabbar', 'onsenui/esm/elements/ons-toast', 'onsenui/esm/elements/ons-toolbar', 'onsenui/esm/elements/ons-toolbar-button'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.Ons = {}, global.ons, global.PropTypes, global.ons.elements.ActionSheet, global.React, global.ReactDOM));
})(this, (function (exports, onsenui, PropTypes, onsActionSheet, React, ReactDOM) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var PropTypes__default = /*#__PURE__*/_interopDefaultLegacy(PropTypes);
  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
  var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };
    return _extends.apply(this, arguments);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    Object.defineProperty(subClass, "prototype", {
      writable: false
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }

    return _assertThisInitialized(self);
  }

  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
          result;

      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;

        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }

      return _possibleConstructorReturn(this, result);
    };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

    if (_i == null) return;
    var _arr = [];
    var _n = true;
    var _d = false;

    var _s, _e;

    try {
      for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var _excluded$c = ["style", "children"];

  var kebabize = function kebabize(camelString) {
    return camelString.replace(/([a-zA-Z])([A-Z])/g, '$1-$2').toLowerCase();
  };

  var addDeprecated = function addDeprecated(props, deprecated) {
    var propsCopy = _objectSpread2({}, props);

    var nameMap = _objectSpread2({
      className: 'class'
    }, deprecated);

    for (var _i = 0, _Object$entries = Object.entries(nameMap); _i < _Object$entries.length; _i++) {
      var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
          oldName = _Object$entries$_i[0],
          newName = _Object$entries$_i[1];

      if (propsCopy[newName] === undefined && propsCopy[oldName] !== undefined) {
        propsCopy[newName] = propsCopy[oldName];
        delete propsCopy[oldName];
      }
    }

    return propsCopy;
  };

  function useCustomElementListener(ref, prop, handler) {
    var event = prop.slice(2).toLowerCase();
    React.useEffect(function () {
      var current = ref.current;
      current.addEventListener(event, handler);
      return function cleanup() {
        current.removeEventListener(event, handler);
      };
    }, [ref, handler]);
  }

  function useCustomElement(props) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var ref = arguments.length > 2 ? arguments[2] : undefined;
    var notAttributes = options.notAttributes || [];
    var deprecated = options.deprecated || {};
    var properties = {};

    var _loop = function _loop() {
      var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i2], 2),
          prop = _Object$entries2$_i[0],
          value = _Object$entries2$_i[1];

      var jsName = kebabize(prop);

      if (notAttributes.includes(prop)) {
        React.useEffect(function () {
          ref.current[prop] = value;
        });
      } else if (/^on[A-Z]/.test(prop)) {
        useCustomElementListener(ref, prop, value);
      } else if (typeof value === 'boolean') {
        properties[jsName] = value ? '' : null;
      } else if (_typeof(value) === 'object' && value !== null) {
        properties[jsName] = JSON.stringify(value);
      } else {
        properties[jsName] = value;
      }
    };

    for (var _i2 = 0, _Object$entries2 = Object.entries(addDeprecated(props, deprecated)); _i2 < _Object$entries2.length; _i2++) {
      _loop();
    }

    return {
      properties: properties
    };
  }

  function onsCustomElement(WrappedComponent, options) {
    return /*#__PURE__*/React__default["default"].forwardRef(function (props, _ref) {
      var ref = _ref || React.useRef();

      var style = props.style,
          children = props.children,
          rest = _objectWithoutProperties(props, _excluded$c);

      var _useCustomElement = useCustomElement(rest, options, ref),
          properties = _useCustomElement.properties;

      return /*#__PURE__*/React__default["default"].createElement(WrappedComponent, _extends({
        ref: ref,
        style: style
      }, properties), children);
    });
  }

  var _excluded$b = ["visible"];

  var Portal = /*#__PURE__*/function (_React$Component) {
    _inherits(Portal, _React$Component);

    var _super = _createSuper(Portal);

    function Portal(props) {
      var _this;

      _classCallCheck(this, Portal);

      _this = _super.call(this, props);
      _this.container = document.createElement('div');
      return _this;
    }

    _createClass(Portal, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        document.body.appendChild(this.container);
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        document.body.removeChild(this.container);
      }
    }, {
      key: "render",
      value: function render() {
        return /*#__PURE__*/ReactDOM__default["default"].createPortal(this.props.children, this.container);
      }
    }]);

    return Portal;
  }(React__default["default"].Component);

  var baseDialog = function baseDialog(DialogComponent) {
    return /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
      // visible prop should be applied last since it depends on animation and
      // maskColor props being set first
      var visible = props.visible,
          rest = _objectWithoutProperties(props, _excluded$b);

      return /*#__PURE__*/React__default["default"].createElement(Portal, null, /*#__PURE__*/React__default["default"].createElement(DialogComponent, _extends({}, rest, {
        visible: visible,
        ref: ref
      }), props.children));
    });
  };

  var propTypes$7 = {
    /**
     * @name title
     * @type string
     * @required false
     * @description
     *  [en]
     *  Optional title of the action sheet. A new element will be created containing this string.
     *  [/en]
     *  [ja][/ja]
     */
    title: PropTypes__default["default"].string,

    /**
     * @name onDialogCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called only if cancelable is true. It will be called after tapping the background or by pressing the back button on Android devices.
     *  [/en]
     *  [ja][/ja]
     */
    onDialogCancel: PropTypes__default["default"].func,

    /**
     * @name visible
     * @type bool
     * @description
     *  [en]
     *  Indicates whether the dialog is open and shown.
     *  [/en]
     *  [ja][/ja]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name cancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is cancelable or not.
     *  A cancelable dialog will call onCancel  when tapping the background or or  pressing the back button on Android devices
     *  [/en]
     *  [ja][/ja]
     */
    cancelable: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name onCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `onDialogCancel` instead.
     *  [/en]
     *  [ja][/ja]
     */
    onCancel: PropTypes__default["default"].func,

    /**
     * @name isOpen
     * @type bool
     * @description
     *  [en]
     *  DEPRECATED! Use `visible` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isOpen: PropTypes__default["default"].bool,

    /**
     * @name isCancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `cancelable` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isCancelable: PropTypes__default["default"].bool,

    /**
     * @name isDisabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `disabled` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isDisabled: PropTypes__default["default"].bool,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]
     *  The animation used when showing and hiding the dialog. Can be either `"none"` or `"default"`.
     *  [/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the dialog.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name maskColor
     * @type string
     * @required false
     * @description
     *  [en]Color of the background mask. Default is "rgba(0, 0, 0, 0.2)"[/en]
     *  [ja][/ja]
     */
    maskColor: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onPreShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just before the action sheet is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPreShow: PropTypes__default["default"].func,

    /**
     * @name onPostShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just after the action sheet is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPostShow: PropTypes__default["default"].func,

    /**
     * @name onPreHide
     * @type function
     * @required false
     * @description
     *  [en]Called just before the action sheet is hidden.[/en]
     *  [ja][/ja]
     */
    onPreHide: PropTypes__default["default"].func,

    /**
     * @name onPostHide
     * @type function
     * @required false
     * @description
     *  [en]Called just after the action sheet is hidden.[/en]
     *  [ja][/ja]
     */
    onPostHide: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };
  var deprecated$a = {
    onCancel: 'onDialogCancel',
    isOpen: 'visible',
    isDisabled: 'disabled',
    isCancelable: 'cancelable'
  };
  var notAttributes$d = ['onDeviceBackButton'];
  /**
   * @original ons-action-sheet
   * @category dialog
   * @tutorial react/Reference/action-sheet
   * @description
   * [en]
   *  Action/bottom sheet that is displayed on top of current screen.
   *  The action sheet is useful for displaying a list of options and asking the user to make a decision. An ActionSheetButton component is provided for this purpose, although it can contain any type of content.
   *  It will automatically be displayed as Material Design (bottom sheet) when running on an Android device.
   * [/en]
   * [ja][/ja]
   */

  var ActionSheet = onsCustomElement(baseDialog('ons-action-sheet'), {
    propTypes: propTypes$7,
    deprecated: deprecated$a,
    notAttributes: notAttributes$d
  });
  ActionSheet.propTypes = propTypes$7;

  var propTypes$6 = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the action sheet button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name icon
     * @type string
     * @description
     *  [en]Creates an `Icon` component with this string. Only visible on Android.[/en]
     *  [ja][/ja]
     */
    icon: PropTypes__default["default"].string,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en]This function will be called when the button is clicked.[/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func
  };
  /**
   * @original ons-action-sheet-button
   * @category dialog
   * @tutorial react/Reference/action-sheet
   * @description
   * [en]Component that represent each button of the action sheet.[/en]
   * [ja][/ja]
   */

  var ActionSheetButton = onsCustomElement('ons-action-sheet-button', {
    propTypes: propTypes$6
  });
  ActionSheetButton.propTypes = propTypes$6;

  var deprecated$9 = {
    onCancel: 'onDialogCancel',
    isOpen: 'visible',
    isDisabled: 'disabled',
    isCancelable: 'cancelable'
  };
  var notAttributes$c = ['onDeviceBackButton'];
  /**
   * @original ons-alert-dialog
   * @category dialog
   * @tutorial react/Reference/alert-dialog
   * @description
   * [en]
   *   Alert dialog that is displayed on top of the current screen. Useful for displaying questions, warnings or error messages to the user. The title, content and buttons can be easily customized and it will automatically switch style based on the platform.
   * [/en]
   * [ja][/ja]
   * @example
     <AlertDialog isOpen={this.state.isOpen} onCancel={this.handleCancel.bind(this)} cancelable>
       <div className="alert-dialog-title">Warning!</div>
       <div className="alert-dialog-content">
         An error has occurred!
       </div>
       <div className="alert-dialog-footer">
         <Button onClick={this.handleCancel.bind(this)} className="alert-dialog-button">
           Cancel
         </Button>
         <Button onClick={this.handleCancel.bind(this)} className="alert-dialog-button">
           Ok
         </Button>
       </div>
     </AlertDialog>
   */

  var AlertDialog = onsCustomElement(baseDialog('ons-alert-dialog'), {
    deprecated: deprecated$9,
    notAttributes: notAttributes$c
  });
  AlertDialog.propTypes = {
    /**
     * @name visible
     * @type bool
     * @description
     *  [en]
     *  Indicates whether the dialog is open and shown.
     *  [/en]
     *  [ja][/ja]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name cancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is cancelable or not.
     *  A cancelable dialog will call `onDialogCancel` when tapping the background or pressing the back button on Android devices.
     *  [/en]
     *  [ja][/ja]
     */
    cancelable: PropTypes__default["default"].bool,

    /**
     * @name onDialogCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called only if `cancelable` is true. It will be called after tapping the background or by pressing the back button on Android devices.
     *  [/en]
     *  [ja][/ja]
     */
    onDialogCancel: PropTypes__default["default"].func,

    /**
     * @name onCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `onDialogCancel` instead.
     *  [/en]
     *  [ja][/ja]
     */
    onCancel: PropTypes__default["default"].func,

    /**
     * @name isOpen
     * @type bool
     * @description
     *  [en]
     *  DEPRECATED! Use `visible` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isOpen: PropTypes__default["default"].bool,

    /**
     * @name isCancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `cancelable` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isCancelable: PropTypes__default["default"].bool,

    /**
     * @name isDisabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `disabled` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isDisabled: PropTypes__default["default"].bool,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]
     *  The animation used when showing and hiding the dialog. Can be either `"none"` or `"default"`.
     *  [/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the dialog.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name maskColor
     * @type string
     * @required false
     * @description
     *  [en]Color of the background mask. Default is "rgba(0, 0, 0, 0.2)"[/en]
     *  [ja][/ja]
     */
    maskColor: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onPreShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just before the alert dialog is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPreShow: PropTypes__default["default"].func,

    /**
     * @name onPostShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just after the alert dialog is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPostShow: PropTypes__default["default"].func,

    /**
     * @name onPreHide
     * @type function
     * @required false
     * @description
     *  [en]Called just before the alert dialog is hidden.[/en]
     *  [ja][/ja]
     */
    onPreHide: PropTypes__default["default"].func,

    /**
     * @name onPostHide
     * @type function
     * @required false
     * @description
     *  [en]Called just after the alert dialog is hidden.[/en]
     *  [ja][/ja]
     */
    onPostHide: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  /**
   * @original ons-alert-dialog-button
   * @category dialog
   * @tutorial react/Reference/dialog
   * @description
   * [en]Component that represent each button of the alert dialog.[/en]
   * [ja][/ja]
   */

  var AlertDialogButton = onsCustomElement('ons-alert-dialog-button');
  AlertDialogButton.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the alert dialog button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the button is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en]This function will be called when the button is clicked.[/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func
  };

  var notAttributes$b = ['options'];
  /**
   * @original ons-back-button
   * @category navigation
   * @tutorial react/Reference/back-button
   * @description
   * [en]
   *   Back button component for Toolbar. It enables to automatically to pop the top page of the navigator. When only presented with one page, the button is hidden automatically.
   *
   *   The default behavior can be overridden using the `onClick` prop.
   * [/en]
   * [ja][/ja]
   * @example
   * <Toolbar modifier={this.props.modifier} >
        <div className="left"><BackButton modifier={this.props.modifier}>Back</BackButton></div>
        <div className="center">{this.props.title}</div>
     </Toolbar>
   */

  var BackButton = onsCustomElement('ons-back-button', {
    notAttributes: notAttributes$b
  });
  BackButton.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the back button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en]This function will be called when the button is clicked. To prevent the default click behaviour, call `event.preventDefault()`.[/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func,

    /**
     * @name options
     * @type object
     * @description
     *  [en]Specifies the animation, animationOptions, and callback.[/en]
     *  [ja][/ja]
     */
    options: PropTypes__default["default"].shape({
      animation: PropTypes__default["default"].string,
      animationOptions: PropTypes__default["default"].object,
      callback: PropTypes__default["default"].func
    })
  };

  var propTypes$5 = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]Specify modifier name to specify custom styles. Optional.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string
  };
  /**
   * @original ons-bottom-toolbar
   * @category page
   * @description
   * [en]Toolbar component that is positioned at the bottom of the page.[/en]
   * [ja][/ja]
   * @example
   * <BottomToolbar modifier="material"> Content </BottomToolbar>
   */

  var BottomToolbar = onsCustomElement('ons-bottom-toolbar', {
    propTypes: propTypes$5
  });
  BottomToolbar.propTypes = propTypes$5;

  var propTypes$4 = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the button is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name ripple
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the button has a ripple effect.
     *  [/en]
     *  [ja][/ja]
     */
    ripple: PropTypes__default["default"].bool,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en] This function will be called when the button is clicked. [/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func
  };
  /**
   * @original ons-button
   * @category form
   * @tutorial react/Reference/button
   * @description
   * [en] Button component. If you want to place a button in a toolbar, use `ToolbarButton` or `BackButton` instead. Will automatically display as a Material Design button with a ripple effect on Android.
   [/en]
   * [ja][/ja]
   * @example
   * <Button modifier="large--cta">
   *   Tap Me
   * </Button>
   */

  var Button = onsCustomElement('ons-button', {
    propTypes: propTypes$4
  });
  Button.propTypes = propTypes$4;

  /**
   * @original ons-card
   * @category visual
   * @tutorial react/Reference/visual
   * @description
   * [en]Card component that can be used to display content.[/en]
   * [ja][/ja]
   * @example
   *
  <Card>
    <p>Some content</p>
  </Card>
   */

  var Card = onsCustomElement('ons-card');
  Card.propTypes = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles. Optional.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string
  };

  var _excluded$a = ["itemWidth", "itemHeight"];
  var deprecated$8 = {
    index: 'activeIndex'
  };
  var Element$9 = onsCustomElement('ons-carousel', {
    deprecated: deprecated$8
  });
  /**
   * @original ons-carousel
   * @category carousel
   * @tutorial react/Reference/carousel
   * @description
   * [en] Carousel component. A carousel can be used to display several items in the same space.
   *     The component supports displaying content both horizontally and vertically. The user can scroll through the items by dragging and it can also be controller programmatically.
   [/en]
   * [ja][/ja]
   * @example
   *    <Carousel
            onPostChange={() => console.log('onPostChange')}
            onOverscroll={() => console.log('onOverscroll')}
            onRefresh={() => console.log('onRefresh')}
            ref={(carousel) => { this.carousel = carousel; }}
            swipeable
            overscrollable
            autoScroll
            fullscreen
            autoScrollRatio={0.2}
        >
            <CarouselItem style={{backgroundColor: 'gray'}}>
              <div className='item-label'>GRAY</div>
            </CarouselItem>
            <CarouselItem style={{backgroundColor: '#085078'}}>
              <div className='item-label'>BLUE</div>
            </CarouselItem>
          </Carousel>

   */

  var Carousel = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    var itemWidth = props.itemWidth,
        itemHeight = props.itemHeight,
        rest = _objectWithoutProperties(props, _excluded$a); // string values for itemWidth and itemHeight are deprecated but handle them
    // safely anyway to avoid breaking user code


    var stringify = function stringify(x) {
      return typeof x === 'number' ? "".concat(x, "px") : x;
    };

    var realItemWidth = stringify(itemWidth);
    var realItemHeight = stringify(itemHeight);
    return /*#__PURE__*/React__default["default"].createElement(Element$9, _extends({
      itemWidth: realItemWidth,
      itemHeight: realItemHeight,
      ref: ref
    }, rest), props.children);
  });
  Carousel.propTypes = {
    /**
     * @name direction
     * @type string
     * @required false
     * @description
     *  [en]The direction of the carousel. Can be either "horizontal" or "vertical". Default is "horizontal".[/en]
     *  [ja][/ja]
     */
    direction: PropTypes__default["default"].oneOf(['horizontal', 'vertical']),

    /**
     * @name fullscreen
     * @type bool
     * @description
     *  [en]If true, the carousel will cover the whole screen.[/en]
     *  [ja][/ja]
     */
    fullscreen: PropTypes__default["default"].bool,

    /**
     * @name overscrollable
     * @type bool
     * @description
     *  [en]If true, the carousel will be scrollable over the edge. It will bounce back when released.[/en]
     *  [ja][/ja]
     */
    overscrollable: PropTypes__default["default"].bool,

    /**
     * @name centered
     * @type bool
     * @description
     *  [en]If true, the carousel then the selected item will be in the center of the carousel instead of the beginning. Useful only when the items are smaller than the carousel.[/en]
     *  [ja][/ja]
     */
    centered: PropTypes__default["default"].bool,

    /**
     * @name itemWidth
     * @type string
     * @description
     *  [en]ons-carousel-item's width. Only works when the direction is set to "horizontal". Can be in pixels or a percentage.[/en]
     *  [ja][/ja]
     */
    itemWidth: PropTypes__default["default"].string,

    /**
     * @name itemHeight
     * @type string
     * @description
     *  [en]ons-carousel-item's height. Only works when the direction is set to "vertical". Can be in pixels or a percentage.[/en]
     *  [ja][/ja]
     */
    itemHeight: PropTypes__default["default"].string,

    /**
     * @name autoScroll
     * @type bool
     * @description
     *  [en]If true, the carousel will be automatically scrolled to the closest item border when released.[/en]
     *  [ja][/ja]
     */
    autoScroll: PropTypes__default["default"].bool,

    /**
     * @name autoScrollRatio
     * @type number
     * @description
     *  [en]A number between 0.0 and 1.0 that specifies how much the user must drag the carousel in order for it to auto scroll to the next item.[/en]
     *  [ja][/ja]
     */
    autoScrollRatio: PropTypes__default["default"].number,

    /**
     * @name swipeable
     * @type bool
     * @description
     *  [en]If true, the carousel can be scrolled by drag or swipe.[/en]
     *  [ja][/ja]
     */
    swipeable: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]If true, the carousel will be disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name activeIndex
     * @type number
     * @description
     *  [en]Specify the index of the ons-carousel-item to show. Default is 0.[/en]
     *  [ja][/ja]
     */
    activeIndex: PropTypes__default["default"].number,

    /**
     * @name index
     * @type number
     * @description
     *  [en]DEPRECATED! Use `activeIndex` instead.[/en]
     *  [ja][/ja]
     */
    index: PropTypes__default["default"].number,

    /**
     * @name autoRefresh
     * @type bool
     * @description
     *  [en]When this attribute is set the carousel will automatically refresh when the number of child nodes change.[/en]
     *  [ja][/ja]
     */
    autoRefresh: PropTypes__default["default"].bool,

    /**
     * @name onPreChange
     * @type function
     * @description
     *  [en]Called just before the current carousel item changes.[/en]
     *  [ja][/ja]
     */
    onPreChange: PropTypes__default["default"].func,

    /**
     * @name onPostChange
     * @type function
     * @description
     *  [en]Called just after the current carousel item has changed.[/en]
     *  [ja][/ja]
     */
    onPostChange: PropTypes__default["default"].func,

    /**
     * @name onRefresh
     * @type function
     * @description
     *  [en]Called when the carousel has been refreshed. [/en]
     *  [ja][/ja]
     */
    onRefresh: PropTypes__default["default"].func,

    /**
     * @name onOverscroll
     * @type function
     * @description
     *  [en]Called when the carousel has been overscrolled. [/en]
     *  [ja][/ja]
     */
    onOverscroll: PropTypes__default["default"].func,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]If this prop is set to "none" the transitions will not be animated.[/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onSwipe
     * @type function
     * @description
     *  [en]Hook called whenever the user slides the carousel. It gets a decimal index and an animationOptions object as arguments.[/en]
     *  [ja][/ja]
     */
    onSwipe: PropTypes__default["default"].func
  };

  /**
   * @original ons-carousel-item
   * @category carousel
   * @tutorial react/Reference/carousel
   * @description
   * [en] Carousel item component. Used as a child of the `<ons-carousel>` element.
   [/en]
   * [ja][/ja]
   * @example
  *  <Carousel swipeable overscrollable autoScroll fullscreen >
       <CarouselItem style={{backgroundColor: 'gray'}}>
         <div className='item-label'>GRAY</div>
       </CarouselItem>
       <CarouselItem style={{backgroundColor: '#085078'}}>
         <div className='item-label'>BLUE</div>
       </CarouselItem>
     </Carousel>
   */

  var CarouselItem = onsCustomElement('ons-carousel-item');
  CarouselItem.propTypes = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles. Optional.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string
  };

  var _excluded$9 = ["innerRef"];
  // value of `defaultProp` when the component mounts only.
  //
  // For example, Input has a defaulttValue prop that should set the inner input's
  // value when the component mounted and do nothing afterwards.

  var oneTimeProp = function oneTimeProp(WrappedComponent, defaultProp, prop) {
    var OneTimeProp = /*#__PURE__*/function (_React$Component) {
      _inherits(OneTimeProp, _React$Component);

      var _super = _createSuper(OneTimeProp);

      function OneTimeProp(props) {
        var _this;

        _classCallCheck(this, OneTimeProp);

        _this = _super.call(this, props);
        _this.ref = /*#__PURE__*/React__default["default"].createRef();
        return _this;
      }

      _createClass(OneTimeProp, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          var value = this.props[defaultProp];

          if (value) {
            this.ref.current[prop] = value;
          }
        }
      }, {
        key: "render",
        value: function render() {
          var _this$props = this.props,
              innerRef = _this$props.innerRef,
              rest = _objectWithoutProperties(_this$props, _excluded$9);

          delete rest[defaultProp];

          if (innerRef && innerRef !== this.ref) {
            this.ref = innerRef;
          }

          return /*#__PURE__*/React__default["default"].createElement(WrappedComponent, _extends({
            ref: this.ref
          }, rest), this.props.children);
        }
      }]);

      return OneTimeProp;
    }(React__default["default"].Component);

    return /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
      return /*#__PURE__*/React__default["default"].createElement(OneTimeProp, _extends({
        innerRef: ref
      }, props), props.children);
    });
  };

  var INPUT_PROPS = {
    autoCapitalize: 'autocapitalize',
    autoComplete: 'autocomplete',
    autoCorrect: 'autocorrect',
    autoFocus: 'autofocus',
    inputMode: 'inputmode',
    maxLength: 'maxlength',
    minLength: 'minlength',
    readOnly: 'readonly',
    spellCheck: 'spellcheck'
  };

  var nameMap$6 = _objectSpread2({}, INPUT_PROPS);

  var withDefaultChecked$2 = function withDefaultChecked(component) {
    return oneTimeProp(component, 'defaultChecked', 'checked');
  };
  /**
   * @original ons-checkbox
   * @category form
   * @tutorial react/Reference/checkbox
   * @description
   * [en]
   *  A checkbox element. The component will automatically render as a Material Design checkbox on Android devices.
   *
   *  Most attributes that can be used for a normal `<input type="checkbox">` element can also be used on the `<Checkbox>` component.
   * [/en]
   * [ja][/ja]
   * @example
   * <Checkbox
   *   onChange={event => { this.setState({checked: event.target.checked})} }
   *   modifier='material' />
   */


  var Checkbox = withDefaultChecked$2(onsCustomElement('ons-checkbox', {
    deprecated: nameMap$6
  }));
  Checkbox.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the checkbox.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the checkbox is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en]Called when the inner checkbox fires a `change` event.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name onInput
     * @type function
     * @description
     *  [en]Called when the inner checkbox fires an `input` event.[/en]
     *  [ja][/ja]
     */
    onInput: PropTypes__default["default"].func,

    /**
     * @name value
     * @type string
     * @description
     *  [en] Value of the checkbox.[/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].instanceOf(Date)]),

    /**
     * @name checked
     * @type boolean
     * @description
     *  [en]Controls the state of the checkbox (controlled).[/en]
     *  [ja][/ja]
     */
    checked: PropTypes__default["default"].bool,

    /**
     * @name defaultChecked
     * @type boolean
     * @description
     *  [en]Defined the state of the checkbox at first render for uncontrolled inputs.[/en]
     *  [ja][/ja]
     */
    defaultChecked: PropTypes__default["default"].bool,

    /**
     * @name inputId
     * @type string
     * @description
     *  [en]Specify the "id" attribute of the inner `<input>` element. This is useful when using <label for="..."> elements.[/en]
     *  [ja][/ja]
     */
    inputId: PropTypes__default["default"].string
  };

  /**
   * @original ons-col
   * @category grid
   * @description
   * [en]
   * Represents a column in the grid system. Use with `<ons-row>` to layout components.
   * [/en]
   * [ja][/ja]
   * <Row>
   *   <Col width={50}>
    *   <ons-icon icon="fa-twitter"></ons-icon>
   *   </Col>
   *   <Col>Text</Col>
   * </Row>
   */

  var Col = onsCustomElement('ons-col');
  Col.propTypes = {
    /**
    * @name verticalAlign
    * @type {String}
    * @description
    *   [en]Short hand attribute for aligning vertically. Valid values are top, bottom, and center.[/en]
    *   [ja][/ja]
    */
    verticalAlign: PropTypes__default["default"].oneOf(['top', 'bottom', 'center']),

    /**
    * @name width
    * @type {String}
    * @description
    *   [en]The width of the column. Valid values are css width values ("10%", 50).[/en]
    *   [ja][/ja]
    */
    width: PropTypes__default["default"].oneOfType([PropTypes__default["default"].number, PropTypes__default["default"].string])
  };

  var deprecated$7 = {
    onCancel: 'onDialogCancel',
    isOpen: 'visible',
    isDisabled: 'disabled',
    isCancelable: 'cancelable'
  };
  var notAttributes$a = ['onDeviceBackButton'];
  /**
   * @original ons-dialog
   * @category dialog
   * @tutorial react/Reference/dialog
   * @description
   * [en]  Dialog that is displayed on top of current screen. As opposed to the AlertDialog element, this component can contain any kind of content.  The dialog is useful for displaying menus, additional information or to ask the user to make a decision.  It will automatically be displayed as Material Design when running on an Android device.
   [/en]
   * [ja][/ja]
   * @example
     <Dialog onCancel={this.onCancel}
       isOpen={this.props.isOpen}
       style={{height: 250}}  cancelable>
       <Page>
         Page Content
       </Page>
      </Dialog>

   */

  var Dialog = onsCustomElement(baseDialog('ons-dialog'), {
    deprecated: deprecated$7,
    notAttributes: notAttributes$a
  });
  Dialog.propTypes = {
    /**
     * @name visible
     * @type bool
     * @description
     *  [en]
     *  Indicates whether the dialog is open and shown.
     *  [/en]
     *  [ja][/ja]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name cancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is cancelable or not.
     *  A cancelable dialog will call `onDialogCancel` when tapping the background or pressing the back button on Android devices.
     *  [/en]
     *  [ja][/ja]
     */
    cancelable: PropTypes__default["default"].bool,

    /**
     * @name onDialogCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called only if `cancelable` is true. It will be called after tapping the background or by pressing the back button on Android devices.
     *  [/en]
     *  [ja][/ja]
     */
    onDialogCancel: PropTypes__default["default"].func,

    /**
     * @name onCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `onDialogCancel` instead.
     *  [/en]
     *  [ja][/ja]
     */
    onCancel: PropTypes__default["default"].func,

    /**
     * @name isOpen
     * @type bool
     * @description
     *  [en]
     *  DEPRECATED! Use `visible` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isOpen: PropTypes__default["default"].bool,

    /**
     * @name isCancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `cancelable` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isCancelable: PropTypes__default["default"].bool,

    /**
     * @name isDisabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `disabled` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isDisabled: PropTypes__default["default"].bool,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]
     *  The animation used when showing and hiding the dialog. Can be either `"none"` or `"default"`.
     *  [/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the dialog.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name maskColor
     * @type string
     * @required false
     * @description
     *  [en]Color of the background mask. Default is "rgba(0, 0, 0, 0.2)"[/en]
     *  [ja][/ja]
     */
    maskColor: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onPreShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just before the alert dialog is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPreShow: PropTypes__default["default"].func,

    /**
     * @name onPostShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just after the alert dialog is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPostShow: PropTypes__default["default"].func,

    /**
     * @name onPreHide
     * @type function
     * @required false
     * @description
     *  [en]Called just before the alert dialog is hidden.[/en]
     *  [ja][/ja]
     */
    onPreHide: PropTypes__default["default"].func,

    /**
     * @name onPostHide
     * @type function
     * @required false
     * @description
     *  [en]Called just after the alert dialog is hidden.[/en]
     *  [ja][/ja]
     */
    onPostHide: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  /**
   * @original ons-fab
   * @category form
   * @tutorial react/Reference/fab
   * @description
   * [en] The Floating action button is a circular button defined in the [Material Design specification](https://www.google.com/design/spec/components/buttons-floating-action-button.html). They are often used to promote the primary action of the app.
   *     It can be displayed either as an inline element or in one of the corners. Normally it will be positioned in the lower right corner of the screen.
   [/en]
   * [ja][/ja]
   * @example
   * <SpeedDial disabled={false} direction='right' onClick={() => console.log('test1')} position='left bottom'>
       <Fab>
         <Icon icon='fa-twitter' size={26} fixedWidth={false} style={{verticalAlign: 'middle'}} />
       </Fab>
       <SpeedDialItem onClick={() => console.log('speed A')}> A </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed B')}> B </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed C')}> C </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed D')}> D </SpeedDialItem>
     </SpeedDial>
    */

  var Fab = onsCustomElement('ons-fab');
  Fab.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name ripple
     * @type bool
     * @description
     *  [en]If true,  the button will have a ripple effect when tapped.[/en]
     *  [ja][/ja]
     */
    ripple: PropTypes__default["default"].bool,

    /**
     * @name position
     * @type string
     * @required false
     * @description
     *  [en]The position of the button. Should be a string like `"bottom right"` or `"top left"`. If this attribute is not defined it will be displayed as an inline element.[/en]
     *  [ja][/ja]
     */
    position: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en] If true, the button will be disabled. [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en] This function will be called ones the button is clicked. [/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func
  };

  var propTypes$3 = {
    /**
     * @name onDrag
     * @type function
     * @description
     *  [en]Called when the user drags in any direction.[/en]
     *  [ja][/ja]
     */
    onDrag: PropTypes__default["default"].func,

    /**
     * @name onDragLeft
     * @type function
     * @description
     *  [en]Called when the user drags left.[/en]
     *  [ja][/ja]
     */
    onDragLeft: PropTypes__default["default"].func,

    /**
     * @name onDragRight
     * @type function
     * @description
     *  [en]Called when the user drags right.[/en]
     *  [ja][/ja]
     */
    onDragRight: PropTypes__default["default"].func,

    /**
     * @name onDragUp
     * @type function
     * @description
     *  [en]Called when the user drags up.[/en]
     *  [ja][/ja]
     */
    onDragUp: PropTypes__default["default"].func,

    /**
     * @name onDragDown
     * @type function
     * @description
     *  [en]Called when the user drags down.[/en]
     *  [ja][/ja]
     */
    onDragDown: PropTypes__default["default"].func,

    /**
     * @name onHold
     * @type function
     * @description
     *  [en]Called when the user holds.[/en]
     *  [ja][/ja]
     */
    onHold: PropTypes__default["default"].func,

    /**
     * @name onRelease
     * @type function
     * @description
     *  [en]Called when the user releases.[/en]
     *  [ja][/ja]
     */
    onRelease: PropTypes__default["default"].func,

    /**
     * @name onSwipe
     * @type function
     * @description
     *  [en]Called when the user swipes in any direction.[/en]
     *  [ja][/ja]
     */
    onSwipe: PropTypes__default["default"].func,

    /**
     * @name onSwipeLeft
     * @type function
     * @description
     *  [en]Called when the user swipes left.[/en]
     *  [ja][/ja]
     */
    onSwipeLeft: PropTypes__default["default"].func,

    /**
     * @name onSwipeRight
     * @type function
     * @description
     *  [en]Called when the user swipes right.[/en]
     *  [ja][/ja]
     */
    onSwipeRight: PropTypes__default["default"].func,

    /**
     * @name onSwipeUp
     * @type function
     * @description
     *  [en]Called when the user swipes up.[/en]
     *  [ja][/ja]
     */
    onSwipeUp: PropTypes__default["default"].func,

    /**
     * @name onSwipeDown
     * @type function
     * @description
     *  [en]Called when the user swipes down.[/en]
     *  [ja][/ja]
     */
    onSwipeDown: PropTypes__default["default"].func,

    /**
     * @name onTap
     * @type function
     * @description
     *  [en]Called when the user taps.[/en]
     *  [ja][/ja]
     */
    onTap: PropTypes__default["default"].func,

    /**
     * @name onDoubleTap
     * @type function
     * @description
     *  [en]Called when the user double taps.[/en]
     *  [ja][/ja]
     */
    onDoubleTap: PropTypes__default["default"].func,

    /**
     * @name onPinch
     * @type function
     * @description
     *  [en]Called when the user pinches in or out.[/en]
     *  [ja][/ja]
     */
    onPinch: PropTypes__default["default"].func,

    /**
     * @name onPinchIn
     * @type function
     * @description
     *  [en]Called when the user pinches in.[/en]
     *  [ja][/ja]
     */
    onPinchIn: PropTypes__default["default"].func,

    /**
     * @name onPinchOut
     * @type function
     * @description
     *  [en]Called when the user pinches out.[/en]
     *  [ja][/ja]
     */
    onPinchOut: PropTypes__default["default"].func,

    /**
     * @name onTouch
     * @type function
     * @description
     *  [en]Called when the user touches.[/en]
     *  [ja][/ja]
     */
    onTouch: PropTypes__default["default"].func,

    /**
     * @name onTransform
     * @type function
     * @description
     *  [en]Called when the user transforms.[/en]
     *  [ja][/ja]
     */
    onTransform: PropTypes__default["default"].func,

    /**
     * @name onRotate
     * @type function
     * @description
     *  [en]Called when the user rotates.[/en]
     *  [ja][/ja]
     */
    onRotate: PropTypes__default["default"].func
  };
  /**
   * @original ons-gesture-detector
   * @category gesture
   * @tutorial react/Reference/gesture-detector
   * @description
   * [en]Component to detect finger gestures within a wrapped element.
   [/en]
   * [ja][/ja]
   * @example
   * <GestureDetector
   *   onTap={() => console.log('tap')}
   *   onSwipeleft={() => console.log('swipe left')}
   * >
   *   <div style={{backgroundColor: 'pink', width: '100px', height: '100px'}}>
   *     Swipe Here
   *   </div>
   * </GestureDetector>
   *
   */

  var GestureDetector = onsCustomElement('ons-gesture-detector', {
    propTypes: propTypes$3
  });
  GestureDetector.propTypes = propTypes$3;

  var _excluded$8 = ["icon", "size"];

  var parseIcon = function parseIcon(icon) {
    if (icon) {
      if (typeof icon === 'string') {
        return icon;
      } else {
        var keys = Object.keys(icon).filter(function (a) {
          return a !== 'default';
        });
        var innerString = keys.map(function (key) {
          return key + ':' + icon[key] + '';
        });
        return icon["default"] + ', ' + innerString.join(',');
      }
    }
  };

  var parseSize = function parseSize(size) {
    if (size) {
      if (typeof size === 'number') {
        return "".concat(size, "px");
      } else {
        var keys = Object.keys(size).filter(function (a) {
          return a !== 'default';
        });
        var innerString = keys.map(function (key) {
          return key + ':' + size[key] + 'px';
        });
        return size["default"] + 'px, ' + innerString.join(',');
      }
    }
  };

  var Element$8 = onsCustomElement('ons-icon');
  /**
   * @original ons-icon
   * @category visual
   * @tutorial react/Reference/icon
   * @description
   * [en]
   * Displays an icon. The following icon suites are available:
   *   *  [Font Awesome](https://fortawesome.github.io/Font-Awesome/)
   *   *  [Ionicons](http://ionicons.com/)
   *   *  [Material Design Iconic Font](http://zavoloklom.github.io/material-design-iconic-font/)
   * [/en]
   * [ja][/ja]
   * @example
    <Icon
      size={{default: 32, material: 40}}
      icon={{default: 'ion-navicon', material: 'md-menu'}}
    />
  */

  var Icon = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    var icon = props.icon,
        size = props.size,
        rest = _objectWithoutProperties(props, _excluded$8);

    return /*#__PURE__*/React__default["default"].createElement(Element$8, _extends({
      icon: parseIcon(icon),
      size: parseSize(size)
    }, rest, {
      ref: ref
    }), props.children);
  });
  Icon.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the icon.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name icon
     * @type 'object or string'
     * @description
     *  [en] can be either a string or an object. If it is an string, it is set to an specific icon like 'ions-navicon'. If it is an object, it represents a dictionary of the icons depending on the modifier e.g.   `{{default: 'ion-navicon', material: 'md-menu'}}` [/en]
     *  [ja][/ja]
     */
    icon: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].objectOf(PropTypes__default["default"].string)]),

    /**
     * @name size
     * @type 'object or number'
     * @description
     *  [en] can be either a number or an object. If it is an number, it  specifies the icon size with a number in pixels. If it is an object, it represents a dictionary of the icon sizes depending on the modifier e.g.   `{{default: 20, material: 18}}` [/en]
     *  [ja][/ja]
     */
    size: PropTypes__default["default"].oneOfType([PropTypes__default["default"].number, PropTypes__default["default"].objectOf(PropTypes__default["default"].number)]),

    /**
     * @name rotate
     * @type number
     * @description
     *  [en] Number of degrees to rotate the icon. Valid values are 90, 180 and 270. [/en]
     *  [ja][/ja]
     */
    rotate: PropTypes__default["default"].oneOf([0, 90, 180, 270]),

    /**
     * @name fixedWidth
     * @type bool
     * @description
     * [en] When used in a list, you want the icons to have the same width so that they align vertically by defining this attribute. [/en]
     *  [ja][/ja]
     */
    fixedWidth: PropTypes__default["default"].bool,

    /**
     * @name spin
     * @type bool
     * @description
     * [en] Specify whether the icon should be spinning. [/en]
     *  [ja][/ja]
     */
    spin: PropTypes__default["default"].bool
  };

  var nameMap$5 = _objectSpread2({}, INPUT_PROPS);

  var withDefaultValue$3 = function withDefaultValue(component) {
    return oneTimeProp(component, 'defaultValue', 'value');
  };

  var notAttributes$9 = ['value' // value must be applied as property since attribute only works before input is touched
  ];
  /**
   * @original ons-input
   * @category form
   * @tutorial react/Reference/input
   * @description
   * [en]
   * An input element. The `type` attribute can be used to change the input type. All text input types as well as `checkbox` and `radio` are supported. The component will automatically render as a Material Design input on Android devices. Most attributes that can be used for a normal `<input>` element can also be used on the `<ons-input>` element..
   [/en]
   * [ja][/ja]
   * @example
   * <Input
   *   value={this.state.text} float
   *   onChange={(event) => { this.setState({text: event.target.value})} }
   *   modifier='material'
   *   placeholder='Username' />
   */

  var Input = withDefaultValue$3(onsCustomElement('ons-input', {
    deprecated: nameMap$5,
    notAttributes: notAttributes$9
  }));
  Input.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the input.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]Specifies whether the input is disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name readOnly
     * @type bool
     * @description
     *  [en]Specifies whether the input is read-only.[/en]
     *  [ja][/ja]
     */
    readOnly: PropTypes__default["default"].bool,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en]Called when the inner input fires a `change` event.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name onInput
     * @type function
     * @description
     *  [en]Called when the inner input fires an `input` event.[/en]
     *  [ja][/ja]
     */
    onInput: PropTypes__default["default"].func,

    /**
     * @name value
     * @type string
     * @description
     *  [en]Content of the input (controlled).[/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].instanceOf(Date)]),

    /**
     * @name defaultValue
     * @type string
     * @description
     *  [en]Content of the input at first render (uncontrolled).[/en]
     *  [ja][/ja]
     */
    defaultValue: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].instanceOf(Date)]),

    /**
     * @name placeholder
     * @type string
     * @description
     *  [en] Placeholder text. In Material Design this placeholder will be a floating label. [/en]
     *  [ja][/ja]
     */
    placeholder: PropTypes__default["default"].string,

    /**
     * @name type
     * @type string
     * @description
     *  [en]
     *    Specify the input type. This is the same as the "type" attribute for normal inputs. It expects strict text types such as `text`, `password`, etc. For checkbox, radio button, select or range, please have a look at the corresponding components.
     *
     *    Please take a look at [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-type) for an exhaustive list of possible values. Depending on the platform and browser version some of these might not work.
     *  [/en]
     *  [ja][/ja]
     */
    type: PropTypes__default["default"].string,

    /**
     * @name inputId
     * @type string
     * @description
     *  [en]  Specify the "id" attribute of the inner `<input>` element. This is useful when using <label for="..."> elements [/en]
     *  [ja][/ja]
     */
    inputId: PropTypes__default["default"].string,

    /**
     * @name float
     * @type bool
     * @description
     *  [en]  If this attribute is present, the placeholder will be animated in Material Design.  [/en]
     *  [ja][/ja]
     */
    "float": PropTypes__default["default"].bool
  };

  var _excluded$7 = ["renderHeader", "renderFooter", "renderRow", "dataSource"];
  var Element$7 = onsCustomElement('ons-list');
  /**
   * @original ons-list
   * @category list
   * @tutorial react/Reference/list
   * @description
   *   [en]
   *     Component for representing a list. It takes an array called datasource and calls renderRow(row, index) for every row.  Furthermore, the header and the footer can be specified with `renderRow` and `renderHeader` respectively. [/en]
   * [ja][/ja]
   * @example
    <List
      dataSource={['Row 1', 'Row 2']}
      renderHeader={this.renderHeader}
      renderRow={(row, idx) => (
        <ListItem modifier={idx === this.state.data.length - 1 ? 'longdivider' : null}>
        {row}
    <Button modifier="quiet" onClick={this.remove.bind(this, idx)}>Remove</Button>
    </ListItem>
    )}
    renderFooter={this.renderFooter}
    />
   */

  var List = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    var renderHeader = props.renderHeader,
        renderFooter = props.renderFooter,
        renderRow = props.renderRow,
        dataSource = props.dataSource,
        rest = _objectWithoutProperties(props, _excluded$7);

    var rows = dataSource.map(function (data, index) {
      return renderRow(data, index);
    });
    return /*#__PURE__*/React__default["default"].createElement(Element$7, _extends({}, rest, {
      ref: ref
    }), renderHeader(), rows, props.children, renderFooter());
  });
  List.propTypes = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name dataSource
     * @type string
     * @description
     *  [en]
     *    Source of the list data. Should be an array.
     *  [/en]
     *  [ja][/ja]
     */
    dataSource: PropTypes__default["default"].array,

    /**
     * @name renderRow
     * @type function
     * @description
     *  [en]
     *  Function to specify the rendering function for every element in
     *  in the dataSource.
     *  [/en]
     *  [ja][/ja]
     */
    renderRow: PropTypes__default["default"].func,

    /**
     * @name renderHeader
     * @type function
     * @description
     *  [en]
     *  Function to specify the rendering function for the header
     *  [/en]
     *  [ja][/ja]
     */
    renderHeader: PropTypes__default["default"].func,

    /**
     * @name renderFooter
     * @type function
     * @description
     *  [en]
     *  Function to specify the rendering function for the footer
     *  [/en]
     *  [ja][/ja]
     */
    renderFooter: PropTypes__default["default"].func
  };
  List.defaultProps = {
    dataSource: [],
    renderRow: function renderRow() {
      return null;
    },
    renderHeader: function renderHeader() {
      return null;
    },
    renderFooter: function renderFooter() {
      return null;
    }
  };

  var _excluded$6 = ["calculateItemHeight", "renderRow", "length"];
  /**
   * @original ons-lazy-repeat
   * @category list
   * @tutorial react/Reference/lazy-list
   * @description
   * [en] Using this component a list with millions of items can be rendered without a drop in performance.
   *     It does that by "lazily" loading elements into the DOM when they come into view and
   *     removing items from the DOM when they are not visible.
   [/en]
   * [ja][/ja]
   * @example
   *
    renderRow(index) {
      return (
        <ListItem key={index}>
          {'Item ' + (index + 1)}
        </ListItem>
      );
    }

    render() {
      return (
        <Page renderToolbar={() => <MyToolbar title='LazyList' />} >
          <div style={{height: 100}}>
            <LazyList
              length={1000}
              renderRow={() =>
                <ListItem key={index}>
                  {'Item ' + (index + 1)}
                </ListItem>
              }
              calculateItemHeight={() => 44}
            />
          </div>
        </Page>
      );
    }
  }
   */

  var LazyList = /*#__PURE__*/React__default["default"].forwardRef(function (props, forwardedRef) {
    var ref = forwardedRef || React.useRef();

    var _useState = React.useState([]),
        _useState2 = _slicedToArray(_useState, 2),
        children = _useState2[0],
        setChildren = _useState2[1];

    var _useState3 = React.useState(),
        _useState4 = _slicedToArray(_useState3, 2),
        setUpdateTop = _useState4[1];

    var _calculateItemHeight = props.calculateItemHeight,
        renderRow = props.renderRow,
        length = props.length,
        rest = _objectWithoutProperties(props, _excluded$6);

    React.useEffect(function () {
      ref.current.delegate = {
        calculateItemHeight: function calculateItemHeight(index) {
          return _calculateItemHeight(index);
        },
        _render: function _render(start, limit, updateTop) {
          var el = [];

          for (var i = start; i < limit; i++) {
            el.push(renderRow(i));
          }

          setChildren(el);
          setUpdateTop(updateTop); // doesn't work without this, but why? does it just trigger a rerender?
        },
        countItems: function countItems() {
          return length;
        }
      };
    }, [_calculateItemHeight, renderRow, length]);
    return /*#__PURE__*/React__default["default"].createElement(List, _extends({}, rest, {
      style: {
        position: 'relative'
      }
    }), /*#__PURE__*/React__default["default"].createElement("ons-lazy-repeat", {
      ref: ref
    }), children);
  });
  LazyList.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the lazy list.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name length
     * @type number
     * @description
     *  [en]The length of the list.[/en]
     *  [ja][/ja]
     */
    length: PropTypes__default["default"].number.isRequired,

    /**
     * @name renderRow
     * @type function
     * @description
     *  [en] A function given the index of the to display row, renders it.[/en]
     *  [ja][/ja]
     */
    renderRow: PropTypes__default["default"].func.isRequired,

    /**
     * @name calculateItemHeight
     * @type function
     * @description
     *  [en] A function given the index of the to row, returns the height of it.[/en]
     *  [ja][/ja]
     */
    calculateItemHeight: PropTypes__default["default"].func.isRequired
  };

  /**
   * @original ons-list-header
   * @category list
   * @tutorial react/Reference/list
   * @description
   * [en] Header element for list items. Must be put inside ons-list component.
   [/en]
   * [ja][/ja]
   * @example
     <List
       dataSource={this.state.data}
       renderHeader={() =>
          <ListHeader style={{fontSize: 15}} className="testClass"> Header Text </ListHeader> }
      renderRow={(row, idx) => (
        <ListItem > {row} </ListItem>
      )}
    />
   */

  var ListHeader = onsCustomElement('ons-list-header');
  ListHeader.propTypes = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles. Optional.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string
  };

  var propTypes$2 = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en] The appearance of the list item.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name tappable
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the list item is tappable.
     *  [/en]
     *  [ja][/ja]
     */
    tappable: PropTypes__default["default"].bool,

    /**
     * @name tapBackgroundColor
     * @type string
     * @description
     *  [en]
     *  Changes the background color when tapped. For this to work, the attribute "tappable" needs to be set. The default color is "#d9d9d9". It will display as a ripple effect on Android.
     *  [/en]
     *  [ja][/ja]
     */
    tapBackgroundColor: PropTypes__default["default"].string,

    /**
     * @name lockOnDrag
     * @type bool
     * @description
     *  [en] Prevent vertical scrolling when the user drags horizontally. [/en]
     *  [ja][/ja]
     */
    lockOnDrag: PropTypes__default["default"].bool,

    /**
     * @name expandable
     * @type bool
     * @description
     *  [en]Specifies whether list item can be expanded to reveal hidden content. Expanded content must be defined in `div.expandable-content`.[/en]
     *  [ja][/ja]
     */
    expandable: PropTypes__default["default"].bool,

    /**
     * @name expanded
     * @type bool
     * @description
     *  [en]For expandable list items, specifies whether item is expanded[/en]
     *  [ja][/ja]
     */
    expanded: PropTypes__default["default"].bool,

    /**
     * @name onExpand
     * @type function
     * @description
     *  [en] This function will be called when the expandable list item expands or contracts.[/en]
     *  [ja][/ja]
     */
    onExpand: PropTypes__default["default"].func,

    /**
     * @name animation
     * @type string
     * @description
     *  [en]The animation used when showing and hiding the expandable content. Can be either "default" or "none".[/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string
  };
  /**
   * @original ons-list-item
   * @category list
   * @tutorial react/Reference/list
   * @description
   *   [en]
   *   Component that represents each item in the list. Must be put inside the `List` component. The list item is composed of four parts that are represented with the `left`, `center`, `right` and `expandable-content` classes. These classes can be used to ensure that the content of the list items is properly aligned.
   *   [/en]
   * [ja][/ja]
   * @example
     <ListItem>
   *   <div className="left">Left</div>
   *   <div className="center">Center</div>
   *   <div className="right">Right</div>
   *   <div className="expandable-content">Expandable content</div>
   * </ListItem>
   */

  var ListItem = onsCustomElement('ons-list-item', {
    propTypes: propTypes$2
  });
  ListItem.propTypes = propTypes$2;

  var propTypes$1 = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles. Optional.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string
  };
  /**
   * @original ons-list-title
   * @category list
   * @tutorial react/Reference/list
   * @description
   * [en] Title element for lists. Usually comes before ons-list component.
   [/en]
   * [ja][/ja]
   * @example
   * <ListTitle>List Title</ListTitle>
     <List
       dataSource={this.state.data}
       renderHeader={() =>
          <ListHeader style={{fontSize: 15}} className="testClass"> Header Text </ListHeader> }
      renderRow={(row, idx) => (
        <ListItem > {row} </ListItem>
      )}
    />
   */

  var ListTitle = onsCustomElement('ons-list-title', {
    propTypes: propTypes$1
  });
  ListTitle.propTypes = propTypes$1;

  var _excluded$5 = ["innerRef", "renderPage", "initialRouteStack", "initialRoute", "onPrePush", "onPostPush", "onPrePop", "onPostPop", "swipePop", "onDeviceBackButton"];
  var Element$6 = onsCustomElement('ons-navigator');

  var NavigatorClass = /*#__PURE__*/function (_React$Component) {
    _inherits(NavigatorClass, _React$Component);

    var _super = _createSuper(NavigatorClass);

    function NavigatorClass() {
      var _this;

      _classCallCheck(this, NavigatorClass);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));
      _this.ref = /*#__PURE__*/React__default["default"].createRef();
      _this.pages = [];
      _this.state = {};
      _this._prePush = _this._prePush.bind(_assertThisInitialized(_this));
      _this._postPush = _this._postPush.bind(_assertThisInitialized(_this));
      _this._prePop = _this._prePop.bind(_assertThisInitialized(_this));
      _this._postPop = _this._postPop.bind(_assertThisInitialized(_this));
      return _this;
    }

    _createClass(NavigatorClass, [{
      key: "update",
      value: function update(pages, obj) {
        var _this2 = this;

        this.pages = pages || [];
        return new Promise(function (resolve) {
          _this2.forceUpdate(resolve);
        });
      }
      /**
       * @method resetPage
       * @signature resetPage(route, options = {})
       * @param {Object} route
       *   [en] The route that the page should be reset to.[/en]
       *   [ja][/ja]
       * @return {Promise}
       *   [en]Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en]Resets the current page[/en]
       *   [ja][/ja]
       */

    }, {
      key: "resetPage",
      value: function resetPage(route) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        return this.resetPageStack([route], options);
      }
      /**
       * @method resetPageStack
       * @signature resetPageStack(route, options = {})
       * @param {Array} routes
       *   [en] The routes that the navigator should be reset to.[/en]
       *   [ja][/ja]
       * @return {Promise}
       *   [en]Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en] Resets the navigator to the current page stack[/en]
       *   [ja][/ja]
       */

    }, {
      key: "resetPageStack",
      value: function resetPageStack(routes) {
        var _this3 = this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (this.isRunning()) {
          return Promise.reject('Navigator is already running animation.');
        }

        var hidePages = function hidePages() {
          var pageElements = _this3.ref.current.pages;

          for (var i = pageElements.length - 2; i >= 0; i--) {
            pageElements[i].style.display = 'none';
          }
        };

        if (options.pop) {
          this.routesBeforePop = this.routes.slice();
          this.routesAfterPop = routes;
          this.routes = routes.concat([this.routes[this.routes.length - 1]]);

          var _update = function _update() {
            _this3.pages.pop();

            _this3.routes = routes;
            return new Promise(function (resolve) {
              return _this3.forceUpdate(resolve);
            });
          };

          return this.update(this.pages).then(function () {
            return _this3.ref.current._popPage(options, _update);
          }).then(function () {
            return hidePages();
          });
        }

        var lastRoute = routes[routes.length - 1];
        var newPage = this.props.renderPage(lastRoute, this);
        this.routes.push(lastRoute);

        var update = function update() {
          _this3.pages.push(newPage);

          return new Promise(function (resolve) {
            return _this3.forceUpdate(resolve);
          });
        };

        return this.ref.current._pushPage(options, update).then(function () {
          _this3.routes = routes;
          _this3.pages = routes.map(function (route) {
            return _this3.props.renderPage(route, _this3);
          });
          return _this3.update(_this3.pages).then(function () {
            return hidePages();
          });
        });
      }
      /**
       * @method pushPage
       * @signature pushPage(route, options = {})
       * @param {Object} route
       *   [en] The route that the navigator should push to.[/en]
       *   [ja][/ja]
       * @return {Promise}
       *   [en] Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en] Pushes a page to the page stack[/en]
       *   [ja][/ja]
       */

    }, {
      key: "pushPage",
      value: function pushPage(route) {
        var _this4 = this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (this.isRunning()) {
          return Promise.reject('Navigator is already running animation.');
        }

        return new Promise(function (resolve) {
          var update = function update() {
            return new Promise(function (resolve) {
              _this4.pages.push(_this4.props.renderPage(route, _this4));

              _this4.forceUpdate(resolve);
            });
          };

          _this4.routes.push(route);

          _this4.ref.current._pushPage(options, update).then(resolve)["catch"](function (error) {
            _this4.routes.pop();

            _this4.pages.pop();

            throw error;
          });
        });
      }
    }, {
      key: "isRunning",
      value: function isRunning() {
        return this.ref.current._isRunning;
      }
      /*
       * @method replacePage
       * @signature replacePage(route, [options])
       * @param {Object} route
       *   [en] The route that the navigator should replace the top page with.[/en]
       *   [ja][/ja]
       * @return {Promise}
       *   [en]Promise which resolves to the new page.[/en]
       *   [ja]新しいページを解決するPromiseを返します。[/ja]
       * @description
       *   [en]Replaces the current top page with the specified one. Extends `pushPage()` parameters.[/en]
       *   [ja]現在表示中のページをを指定したページに置き換えます。[/ja]
       */

    }, {
      key: "replacePage",
      value: function replacePage(route) {
        var _this5 = this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (this.isRunning()) {
          return Promise.reject('Navigator is already running animation.');
        }

        return this.pushPage(route, options).then(function () {
          var pos = _this5.pages.length - 2;

          _this5.pages.splice(pos, 1);

          _this5.routes.splice(pos, 1);

          _this5.ref.current.topPage.updateBackButton(_this5.pages.length > 1);

          _this5.forceUpdate();
        });
      }
      /**
       * @method popPage
       * @signature popPage(options = {})
       * @return {Promise}
       *   [en] Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en] Pops a page out of the page stack[/en]
       *   [ja][/ja]
       */

    }, {
      key: "popPage",
      value: function popPage() {
        var _this6 = this;

        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        if (this.isRunning()) {
          return Promise.reject('Navigator is already running animation.');
        }

        this.routesBeforePop = this.routes.slice();
        this.routesAfterPop = this.routesBeforePop.slice(0, this.routesBeforePop.length - 1);

        var update = function update() {
          return new Promise(function (resolve) {
            _this6.pages.pop();

            _this6.routes.pop();

            ReactDOM__default["default"].flushSync(function () {
              // prevents flickering caused by React 18 batching
              _this6.forceUpdate(resolve);
            });
          });
        };

        return this.ref.current._popPage(options, update);
      }
    }, {
      key: "_onDeviceBackButton",
      value: function _onDeviceBackButton(event) {
        if (this.pages.length > 1) {
          this.popPage();
        } else {
          event.callParentHandler();
        }
      }
    }, {
      key: "_prePop",
      value: function _prePop(event) {
        if (event.target !== this.ref.current) {
          return;
        }

        event.routes = {
          poppingRoute: this.routesBeforePop[this.routesBeforePop.length - 1],
          routes: this.routesBeforePop
        };
        this.props.onPrePop(event);
      }
    }, {
      key: "_postPop",
      value: function _postPop(event) {
        if (event.target !== this.ref.current) {
          return;
        }

        event.routes = {
          poppedRoute: this.routesBeforePop[this.routesBeforePop.length - 1],
          routes: this.routesAfterPop
        };
        this.props.onPostPop(event);
      }
    }, {
      key: "_prePush",
      value: function _prePush(event) {
        if (event.target !== this.ref.current) {
          return;
        }

        event.routes = {
          pushingRoute: this.routes[this.routes.length - 1],
          routes: this.routes.slice(0, this.routes.length - 1)
        };
        this.props.onPrePush(event);
      }
    }, {
      key: "_postPush",
      value: function _postPush(event) {
        if (event.target !== this.ref.current) {
          return;
        }

        event.routes = {
          pushedRoute: this.routes[this.routes.length - 1],
          routes: this.routes
        };
        this.props.onPostPush(event);
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this7 = this;

        var node = this.ref.current;
        node.popPage = this.popPage.bind(this);
        node.addEventListener('prepush', this._prePush);
        node.addEventListener('postpush', this._postPush);
        node.addEventListener('prepop', this._prePop);
        node.addEventListener('postpop', this._postPop);
        node.swipeMax = this.props.swipePop;
        node.onDeviceBackButton = this.props.onDeviceBackButton || this._onDeviceBackButton.bind(this);

        if (this.props.initialRoute && this.props.initialRouteStack) {
          throw new Error('In Navigator either initalRoute or initalRoutes can be set');
        }

        if (this.props.initialRoute) {
          this.routes = [this.props.initialRoute];
        } else if (this.props.initialRouteStack) {
          this.routes = this.props.initialRouteStack;
        } else {
          this.routes = [];
        }

        this.pages = this.routes.map(function (route) {
          return _this7.props.renderPage(route, _this7);
        });
        this.forceUpdate();
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        if (this.props.onDeviceBackButton !== undefined) {
          this.ref.current.onDeviceBackButton = this.props.onDeviceBackButton;
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        var node = this.ref.current;
        node.removeEventListener('prepush', this.props.onPrePush);
        node.removeEventListener('postpush', this.props.onPostPush);
        node.removeEventListener('prepop', this.props.onPrePop);
        node.removeEventListener('postpop', this.props.onPostPop);
      }
    }, {
      key: "render",
      value: function render() {
        var _this8 = this;

        var _this$props = this.props,
            innerRef = _this$props.innerRef,
            renderPage = _this$props.renderPage;
            _this$props.initialRouteStack;
            _this$props.initialRoute;
            _this$props.onPrePush;
            _this$props.onPostPush;
            _this$props.onPrePop;
            _this$props.onPostPop;
            _this$props.swipePop;
            _this$props.onDeviceBackButton;
            var rest = _objectWithoutProperties(_this$props, _excluded$5);

        var pages = this.routes ? this.routes.map(function (route) {
          return renderPage(route, _this8);
        }) : null;

        if (innerRef && innerRef !== this.ref) {
          this.ref = innerRef;
        }

        return /*#__PURE__*/React__default["default"].createElement(Element$6, _extends({
          ref: this.ref
        }, rest), pages);
      }
    }]);

    return NavigatorClass;
  }(React__default["default"].Component);
  /**
   * @original ons-navigator
   * @category navigation
   * @tutorial react/Reference/navigator
   * @description
   * [en] This component is responsible for page transitioning and managing the pages of your OnsenUI application. In order to manage to display the pages, the  navigator needs to define the `renderPage` method, that takes an route and a navigator and  converts it to an page.  [/en]
   * [ja][/ja]
   * @example
    <Navigator
      renderPage={(route, navigator) =>
       <MyPage
         title={route.title}
         onPop={() => navigator.popPage()}
         />
      }
      initialRoute={{
          title: 'First Page'
      }} />
     }
   }
   */


  var Navigator = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    return /*#__PURE__*/React__default["default"].createElement(NavigatorClass, _extends({
      innerRef: ref
    }, props), props.children);
  });
  Navigator.propTypes = {
    /**
     * @name renderPage
     * @type function
     * @required true
     * @defaultValue null
     * @description
     *  [en] This function takes the current route object as a parameter and returns a React component.[/en]
     *  [ja][/ja]
     */
    renderPage: PropTypes__default["default"].func.isRequired,

    /**
     * @name initialRouteStack
     * @type array
     * @required false
     * @defaultValue null
     * @description
     *  [en] This array contains the initial routes from the Navigator,
     *  which will be used to render the initial pages in the `renderPage` method.
     *  [/en]
     *  [ja][/ja]
     */
    initialRouteStack: PropTypes__default["default"].array,

    /**
     * @name initialRoute
     * @type object
     * @required false
     * @defaultValue null
     * @description
     *  [en] This array contains the initial route of the navigator,
     *  which will be used to render the initial pages in the
     *  renderPage method.
     *  [/en]
     *  [ja][/ja]
     */
    initialRoute: PropTypes__default["default"].object,

    /**
     * @name onPrePush
     * @type function
     * @required false
     * @description
     *  [en]Called just before a page is pushed. It gets an event object with route information.[/en]
     *  [ja][/ja]
     */
    onPrePush: PropTypes__default["default"].func,

    /**
     * @name onPostPush
     * @type function
     * @required false
     * @description
     *  [en]Called just after a page is pushed. It gets an event object with route information.[/en]
     *  [ja][/ja]
     */
    onPostPush: PropTypes__default["default"].func,

    /**
     * @name onPrePop
     * @type function
     * @required false
     * @description
     *  [en]Called just before a page is popped. It gets an event object with route information.[/en]
     */
    onPrePop: PropTypes__default["default"].func,

    /**
     * @name onPostPop
     * @type function
     * @required false
     * @description
     *  [en]Called just after a page is popped. It gets an event object with route information.[/en]
     *  [ja][/ja]
     */
    onPostPop: PropTypes__default["default"].func,

    /**
     * @name animation
     * @type {String}
     * @description
     *   [en]
     *     Animation name. Available animations are `"slide"`, `"lift"`, `"fade"` and `"none"`.
     *     These are platform based animations. For fixed animations, add `"-ios"` or `"-md"` suffix to the animation name. E.g. `"lift-ios"`, `"lift-md"`. Defaults values are `"slide-ios"` and `"fade-md"`.
     *   [/en]
     *   [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name swipeable
     * @type bool|string
     * @required false
     * @description
     *  [en]Enables swipe-to-pop functionality for iOS.[/en]
     *  [ja][/ja]
     */
    swipeable: PropTypes__default["default"].oneOfType([PropTypes__default["default"].bool, PropTypes__default["default"].string]),

    /**
     * @name swipePop
     * @type function
     * @required false
     * @description
     *  [en]Optional function called on swipe-to-pop. If provided, must perform a popPage with the given options object.[/en]
     *  [ja][/ja]
     */
    swipePop: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]Custom handler for device back button.[/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  var NOOP$1 = function NOOP() {
    return null;
  };

  Navigator.defaultProps = {
    onPostPush: NOOP$1,
    onPrePush: NOOP$1,
    onPrePop: NOOP$1,
    onPostPop: NOOP$1
  };

  var deprecated$6 = {
    isOpen: 'visible'
  };
  var notAttributes$8 = ['onDeviceBackButton'];
  /**
   * @original ons-modal
   * @category dialog
   * @tutorial react/Reference/modal
   * @description
   * [en]
   *   A modal component covers the entire screen. Underlying components are not
   *   subject to any events while the modal component is shown.
   *
   *   This component can be used to block user input while some operation is
   *   running or to show some information to the user.
   * [/en]
   * [ja]
   *   画面全体をマスクするモーダル用コンポーネントです。下側にあるコンポーネントは、
   *   モーダルが表示されている間はイベント通知が行われません
   * [/ja]
   * @example
    <Page>
      <div> Page content </div>

      <Modal isOpen={this.state.isLoading}>
        Loading ...
      </Modal>
    </Page>
   */

  var Modal = onsCustomElement(baseDialog('ons-modal'), {
    deprecated: deprecated$6,
    notAttributes: notAttributes$8
  });
  Modal.propTypes = {
    /**
     * @name animation
     * @type {String}
     * @description
     *   [en]
     *     Animation name. Available animations are `"fade"`, `"lift"` and `"none"`.
     *   [/en]
     */
    animation: PropTypes__default["default"].oneOf(['none', 'fade', 'lift']),

    /**
     * @name animationOptions
     * @type object
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onPreShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just before the modal is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPreShow: PropTypes__default["default"].func,

    /**
     * @name onPostShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just after the modal is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPostShow: PropTypes__default["default"].func,

    /**
     * @name onPreHide
     * @type function
     * @required false
     * @description
     *  [en]Called just before the modal is hidden.[/en]
     *  [ja][/ja]
     */
    onPreHide: PropTypes__default["default"].func,

    /**
     * @name onPostHide
     * @type function
     * @required false
     * @description
     *  [en]Called just after the modal is hidden.[/en]
     *  [ja][/ja]
     */
    onPostHide: PropTypes__default["default"].func,

    /**
     * @name visible
     * @type boolean
     * @description
     *  [en]When `true` the modal will show itself.[/en]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name isOpen
     * @type boolean
     * @description
     *  [en]DEPRECATED! Use `visible` instead.[/en]
     */
    isOpen: PropTypes__default["default"].bool,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  var _excluded$4 = ["renderToolbar", "renderBottomToolbar", "renderModal", "renderFixed", "contentStyle", "children"];
  var notAttributes$7 = ['onInfiniteScroll', 'onDeviceBackButton'];
  var Element$5 = onsCustomElement('ons-page', {
    notAttributes: notAttributes$7
  });
  /**
   * @original ons-page
   * @category page
   * @tutorial react/Reference/page
   * @description
   * [en]
   *   This component is handling the entire page. The content can be scrolled.
   *
   *   To add fixed content that doesn't scroll with the page the `renderFixed` prop is used.
   *
   *   A page toolbar can be added with the `renderToolbar` prop.
   * [/en]
   * [ja][/ja]
   * @example
    <Page
      renderFixed={() => <Fab></Fab>}
      renderToolbar={() => <Toolbar>...</Toolbar>}
      contentStyle={{padding: 40}}>
      <div> Page content </div>
    </Page>
   */

  var Page = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    var renderToolbar = props.renderToolbar,
        renderBottomToolbar = props.renderBottomToolbar,
        renderModal = props.renderModal,
        renderFixed = props.renderFixed,
        contentStyle = props.contentStyle,
        children = props.children,
        rest = _objectWithoutProperties(props, _excluded$4);

    return /*#__PURE__*/React__default["default"].createElement(Element$5, _extends({}, rest, {
      ref: ref
    }), renderToolbar(ref), /*#__PURE__*/React__default["default"].createElement("div", {
      className: "page__background"
    }, " "), /*#__PURE__*/React__default["default"].createElement("div", {
      className: "page__content",
      style: contentStyle
    }, children), /*#__PURE__*/React__default["default"].createElement("div", {
      className: "page__extra",
      style: {
        zIndex: 10001
      }
    }, renderModal(ref)), renderFixed(ref), renderBottomToolbar(ref));
  });
  Page.propTypes = {
    /**
     * @name contentStyle
     * @type Object
     * @description
     *  [en]
     *  Specify the style of the page content. Optional.
     *  [/en]
     */
    contentStyle: PropTypes__default["default"].object,

    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles. Optional.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name renderModal
     * @type function
     * @required false
     * @defaultValue null
     * @description
     *  [en] This function renders a modal that masks current screen.[/en]
     */
    renderModal: PropTypes__default["default"].func,

    /**
     * @name renderToolbar
     * @type function
     * @required false
     * @defaultValue null
     * @description
     *  [en] This function renders the toolbar of the page.[/en]
     *  [ja][/ja]
     */
    renderToolbar: PropTypes__default["default"].func,

    /**
     * @name renderBottomToolbar
     * @type function
     * @defaultValue null
     * @description
     *  [en] This function renders the bottom toolbar of the page.[/en]
     *  [ja][/ja]
     */
    renderBottomToolbar: PropTypes__default["default"].func,

    /**
     * @name renderFixed
     * @type function
     * @defaultValue null
     * @description
     *  [en] This function renders fixed content of the page. Can be used to render `Fab` or `SpeedDial` components as well as other components that don't scroll with the page.[/en]
     *  [ja][/ja]
     */
    renderFixed: PropTypes__default["default"].func,

    /**
     * @name onInit
     * @type function
     * @required false
     * @description
     *  [en]
     *  	Fired right after the page is attached.
     *  [/en]
     *  [ja][/ja]
     */
    onInit: PropTypes__default["default"].func,

    /**
     * @name onShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called Fired right after the page is shown.
     *  [/en]
     *  [ja][/ja]
     */
    onShow: PropTypes__default["default"].func,

    /**
     * @name onHide
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called after the page is hidden.
     *  [/en]
     *  [ja][/ja]
     */
    onHide: PropTypes__default["default"].func,

    /**
     * @name onInfiniteScroll
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called when scrolling to the bottom of the page. It gets a 'done' callback (first argument) that must be called when it's finished.
     *  [/en]
     *  [ja][/ja]
     */
    onInfiniteScroll: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  var NOOP = function NOOP() {
    return null;
  };

  Page.defaultProps = {
    renderToolbar: NOOP,
    renderBottomToolbar: NOOP,
    renderModal: NOOP,
    renderFixed: NOOP
  };

  var _excluded$3 = ["isOpen", "getTarget", "children"];
  var deprecated$5 = {
    onCancel: 'onDialogCancel',
    isDisabled: 'disabled',
    isCancelable: 'cancelable'
  };
  var notAttributes$6 = ['onDeviceBackButton'];
  var Elem = onsCustomElement(baseDialog('ons-popover'), {
    deprecated: deprecated$5,
    notAttributes: notAttributes$6
  });
  /**
   * @original ons-popover
   * @category dialog
   * @tutorial react/Reference/popover
   * @description
   *   [en]
   *     A component that displays a popover next to an element. The popover can be used to display extra information about a component or a tooltip.
   *    Another common way to use the popover is to display a menu when a button on the screen is tapped.
   *   [/en]
   * [ja][/ja]
   * @example
   * <Page>
   *  <Button
   *    ref={(btn) => { this.btn = btn; }}
   *    onClick={() =>
   *      this.setState({target: this.btn, isOpen: true})
   *    }
   *  />
      <Popover
        isOpen={this.state.isOpen}
        onCancel={() => this.setState({isOpen: false})}
        getTarget={() => this.state.target}
      >
        <div style={{textAlign: 'center', opacity: 0.5}}>
          <p>This is a popover!</p>
            <p><small>Click the background to remove the popover.</small></p>
          </div>
          </Popover>
   * </Page>
   */

  var Popover = /*#__PURE__*/React__default["default"].forwardRef(function (props, forwardedRef) {
    var isOpen = props.isOpen,
        getTarget = props.getTarget,
        children = props.children,
        rest = _objectWithoutProperties(props, _excluded$3);

    var ref = forwardedRef || React.useRef();
    React.useEffect(function () {
      if (isOpen !== ref.current.visible) {
        if (isOpen) {
          var target = getTarget(); // if React ref was returned instead of DOM Element, use ref.current instead

          var isElement = function isElement(x) {
            return x instanceof Element || x instanceof HTMLDocument;
          };

          if (!isElement(target) && target.current) {
            target = target.current;
          }

          ref.current.show({
            target: target
          });
        } else {
          ref.current.hide();
        }
      }
    });
    return /*#__PURE__*/React__default["default"].createElement(Elem, _extends({
      ref: ref
    }, rest), children);
  });
  Popover.propTypes = {
    /**
     * @name getTarget
     * @type function
     * @required true
     * @description
     *  [en]
     *  This function should return a ref to the DOM node that the popover will target.
     *  [/en]
     *  [ja][/ja]
     */
    getTarget: PropTypes__default["default"].func.isRequired,

    /**
     * @name onDialogCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called only if isCancelable is true. It will be called after tapping the background or by pressing the back button on Android devices.
     *  [/en]
     *  [ja][/ja]
     */
    onDialogCancel: PropTypes__default["default"].func,

    /**
     * @name onCancel
     * @type function
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `onDialogCancel` instead.
     *  [/en]
     *  [ja][/ja]
     */
    onCancel: PropTypes__default["default"].func,

    /**
     * @name isOpen
     * @type bool
     * @required true
     * @description
     *  [en]
     *  Indicates whether the dialog is open and shown.
     *  [/en]
     *  [ja][/ja]
     */
    isOpen: PropTypes__default["default"].bool.isRequired,

    /**
     * @name cancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is cancelable or not.
     *  A cancelable dialog will call onCancel  when tapping the background or or  pressing the back button on Android devices
     *  [/en]
     *  [ja][/ja]
     */
    cancelable: PropTypes__default["default"].bool,

    /**
     * @name isCancelable
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `cancelable` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isCancelable: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  Specifies whether the dialog is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name isDisabled
     * @type bool
     * @required false
     * @description
     *  [en]
     *  DEPRECATED! Use `disabled` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isDisabled: PropTypes__default["default"].bool,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]
     *  The animation used when showing and hiding the dialog. Can be either `"none"` or `"default"`.
     *  [/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the dialog.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name maskColor
     * @type string
     * @required false
     * @description
     *  [en]Color of the background mask. Default is "rgba(0, 0, 0, 0.2)"[/en]
     *  [ja][/ja]
     */
    maskColor: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onPreShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just before the alert dialog is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPreShow: PropTypes__default["default"].func,

    /**
     * @name onPostShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just after the alert dialog is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPostShow: PropTypes__default["default"].func,

    /**
     * @name onPreHide
     * @type function
     * @required false
     * @description
     *  [en]Called just before the alert dialog is hidden.[/en]
     *  [ja][/ja]
     */
    onPreHide: PropTypes__default["default"].func,

    /**
     * @name onPostHide
     * @type function
     * @required false
     * @description
     *  [en]Called just after the alert dialog is hidden.[/en]
     *  [ja][/ja]
     */
    onPostHide: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  /**
   * @original ons-progress-bar
   * @category visual
   * @tutorial react/Reference/progress
   * @description
   * [en] The component is used to display a linear progress bar. It can either display a progress bar that shows the user how much of a task has been completed. In the case where the percentage is not known it can be used to display an animated progress bar so the user can see that an operation is in progress.  [/en]
   * [ja][/ja]
   * @example
   *<ProgressBar value={55} secondaryValue={87} />
   *<ProgressBar indeterminate />
   */

  var ProgressBar = onsCustomElement('ons-progress-bar');
  ProgressBar.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the progress indicator.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name value
     * @type number
     * @description
     *  [en]
     *  Current progress. Should be a value between 0 and 100.
     *  [/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].number,

    /**
     * @name secondaryValue
     * @type bool
     * @description
     *  [en]
     *  Current secondary progress. Should be a value between 0 and 100.
     *  [/en]
     *  [ja][/ja]
     */
    secondaryValue: PropTypes__default["default"].number,

    /**
     * @name indeterminate
     * @type bool
     * @description
     *  [en] If this property is set, an infinite looping animation will be shown. [/en]
     *  [ja][/ja]
     */
    indeterminate: PropTypes__default["default"].bool
  };

  /**
   * @original ons-progress-circular
   * @category visual
   * @tutorial react/Reference/progress-circular
   * @description
   * [en] This component displays a circular progress indicator. It can either be used to show how much of a task has been completed or to show a looping animation to indicate that an operation is currently running.
   * [/en]
   * [ja][/ja]
   * @example
   *<ProgressCircular value={55} secondaryValue={87} />
   *<ProgressCircular indeterminate />
   */

  var ProgressCircular = onsCustomElement('ons-progress-circular');
  ProgressCircular.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the progress indicator.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name value
     * @type number
     * @description
     *  [en]
     *  Current progress. Should be a value between 0 and 100.
     *  [/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].number,

    /**
     * @name secondaryValue
     * @type bool
     * @description
     *  [en]
     *  Current secondary progress. Should be a value between 0 and 100.
     *  [/en]
     *  [ja][/ja]
     */
    secondaryValue: PropTypes__default["default"].number,

    /**
     * @name indeterminate
     * @type bool
     * @description
     *  [en] If this property is set, an infinite looping animation will be shown. [/en]
     *  [ja][/ja]
     */
    indeterminate: PropTypes__default["default"].bool
  };

  var deprecated$4 = {
    onLoad: 'onAction',
    onChange: 'onChangeState'
  };
  var notAttributes$5 = ['onAction'];
  /**
   * @original ons-pull-hook
   * @category control
   * @tutorial react/Reference/pull-hook
   * @description
   * [en]  Component that adds **Pull to refresh** functionality to an `<ons-page>` element.
   *     It can be used to perform a task when the user pulls down at the top of the page. A common usage is to refresh the data displayed in a page.
   [/en]
   * [ja][/ja]
   * @example

      return (
        <PullHook onChange={this.onChange} onLoad={this.onLoad}>
        {
         (this.state.pullHookState === 'initial') ?
          <span >
            <Icon size={35} spin={false} icon='ion-arrow-down-a' />
            Pull down to refresh
          </span> :
          (this.state.pullHookState === 'preaction') ?
           <span>
             <Icon size={35} spin={false} icon='ion-arrow-up-a' />
             Release to refresh
          </span>
          :
          <span><Icon size={35} spin={true} icon='ion-load-d'></Icon> Loading data...</span>
      }
        </PullHook>
      );
   */

  var PullHook = onsCustomElement('ons-pull-hook', {
    deprecated: deprecated$4,
    notAttributes: notAttributes$5
  });
  PullHook.propTypes = {
    /**
     * @name onChangeState
     * @type function
     * @required false
     * @description
     *  [en]Called when the pull hook inner state is changed. The state can be either "initial", "preaction" or "action"[/en]
     *  [ja][/ja]
     */
    onChangeState: PropTypes__default["default"].func,

    /**
     * @name onChange
     * @type function
     * @required false
     * @description
     *  [en]DEPRECATED! Use `onChangeState` instead.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name onAction
     * @type function
     * @required false
     * @description
     *  [en]Called when the pull hook is in the `action` state[/en]
     *  [ja][/ja]
     */
    onAction: PropTypes__default["default"].func,

    /**
     * @name onLoad
     * @type function
     * @required false
     * @description
     *  [en]DEPRECATED! Use `onAction` instead.[/en]
     *  [ja][/ja]
     */
    onLoad: PropTypes__default["default"].func,

    /**
     * @name onPull
     * @type function
     * @required false
     * @description
     *  [en]Hook called whenever the user pulls the element. It gets the pulled distance ratio (scroll / height) and an animationOptions object as arguments.[/en]
     *  [ja][/ja]
     */
    onPull: PropTypes__default["default"].func,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en] When set to true, the pull hook will be disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name height
     * @type number
     * @description
     *  [en] The height of the pull hook in pixels. The default value is 64.[/en]
     *  [ja][/ja]
     */
    height: PropTypes__default["default"].number,

    /**
     * @name thresholdHeight
     * @type number
     * @description
     *  [en] The threshold height of the pull hook in pixels. The default value is 96.[/en]
     *  [ja][/ja]
     */
    thresholdHeight: PropTypes__default["default"].number,

    /**
     * @name fixedContent
     * @type number
     * @description
     *  [en] If set to true, the content of the page will not move when pulling.[/en]
     *  [ja][/ja]
     */
    fixedContent: PropTypes__default["default"].bool
  };

  var nameMap$4 = _objectSpread2({}, INPUT_PROPS);

  var withDefaultChecked$1 = function withDefaultChecked(component) {
    return oneTimeProp(component, 'defaultChecked', 'checked');
  };
  /**
   * @original ons-radio
   * @category form
   * @tutorial react/Reference/radio
   * @description
   * [en]
   *  A radio button element. The component will automatically render as a Material Design radio button on Android devices.
   *
   *  Most attributes that can be used for a normal `<input type="radio">` element can also be used on the `<Radio>` component.
   * [/en]
   * [ja][/ja]
   * @example
   * <Radio
   *   onChange={event => { this.setState({checked: event.target.checked})} }
   *   modifier='material' />
   */


  var Radio = withDefaultChecked$1(onsCustomElement('ons-radio', {
    deprecated: nameMap$4
  }));
  Radio.propTypes = {
    /**
     * @name name
     * @type string
     * @description
     *  [en]The name of the radio button.[/en]
     *  [ja][/ja]
     */
    name: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the radio button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the radio button is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en] Called when the radio button state changes.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name value
     * @type string
     * @description
     *  [en] Value of the radio button.[/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].instanceOf(Date)]),

    /**
     * @name checked
     * @type boolean
     * @description
     *  [en]Controls the state of the radio button (controlled).[/en]
     *  [ja][/ja]
     */
    checked: PropTypes__default["default"].bool,

    /**
     * @name defaultChecked
     * @type boolean
     * @description
     *  [en]Defined the state of the radio button at first render for uncontrolled inputs.[/en]
     *  [ja][/ja]
     */
    defaultChecked: PropTypes__default["default"].bool,

    /**
     * @name inputId
     * @type string
     * @description
     *  [en]Specify the "id" attribute of the inner `<input>` element. This is useful when using <label for="..."> elements.[/en]
     *  [ja][/ja]
     */
    inputId: PropTypes__default["default"].string
  };

  var nameMap$3 = _objectSpread2({}, INPUT_PROPS);

  var withDefaultValue$2 = function withDefaultValue(component) {
    return oneTimeProp(component, 'defaultValue', 'value');
  };
  /**
   * @original ons-range
   * @category form
   * @tutorial react/Reference/range
   * @description
   * [en]
   *   Range input component.
   * [/en]
   * [ja][/ja]
   * @example
   * <Range modifier="material"
   *   value={this.state.value}
   *   onChange={(event) => this.setState({value: parseInt(event.target.value)})}
   *   />
   */


  var Range = withDefaultValue$2(onsCustomElement('ons-range', {
    deprecated: nameMap$3
  }));
  Range.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the progress indicator.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en] Called when the value of the input changes.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name onInput
     * @type function
     * @description
     *  [en] Called when the inner range fires an `input` event.[/en]
     *  [ja][/ja]
     */
    onInput: PropTypes__default["default"].func,

    /**
     * @name value
     * @type number
     * @description
     *  [en]
     *  Current value of the element.
     *  [/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].number,

    /**
     * @name value
     * @type number
     * @description
     *  [en]
     *  Default value of the element (for uncontrolled components).
     *  [/en]
     *  [ja][/ja]
     */
    defaultValue: PropTypes__default["default"].number,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en] If true, the element is disabled. [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool
  };

  /**
   * @original ons-ripple
   * @category visual
   * @tutorial react/Reference/ripple
   * @description
   * [en]
   *   Adds a Material Design "ripple" effect to an element.
   * [/en]
   * [ja][/ja]
   * @example
     <div className='myList'>
       <Ripple color='red' />
     </div>
   */

  var Ripple = onsCustomElement('ons-ripple');
  Ripple.propTypes = {
    /**
     * @name color
     * @type string
     * @required false
     * @description
     *  [en]Color of the ripple effect.[/en]
     *  [ja][/ja]
     */
    color: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the ripple effect.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name background
     * @type string
     * @required false
     * @description
     *  [en]Color of the background.[/en]
     *  [ja][/ja]
     */
    background: PropTypes__default["default"].string,

    /**
     * @name size
     * @type string
     * @required false
     * @description
     *  [en]Sizing of the wave on ripple effect. Set "cover" or "contain". Default is "cover".[/en]
     *  [ja][/ja]
     */
    size: PropTypes__default["default"].string,

    /**
     * @name size
     * @type string
     * @required false
     * @description
     *  [en]Changes the position of wave effect to center of the target element.[/en]
     *  [ja][/ja]
     */
    center: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]
     *  Specifies whether the button is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool
  };

  var _excluded$2 = ["innerRef", "renderPage", "onPrePush", "onPostPush", "onPrePop", "onPostPop", "swipePop", "onDeviceBackButton"];
  var Element$4 = onsCustomElement('ons-navigator');

  var RouterNavigatorClass = /*#__PURE__*/function (_React$Component) {
    _inherits(RouterNavigatorClass, _React$Component);

    var _super = _createSuper(RouterNavigatorClass);

    function RouterNavigatorClass() {
      var _this;

      _classCallCheck(this, RouterNavigatorClass);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));
      _this.cancelUpdate = false;

      var callback = function callback(name, event) {
        if (_this.props[name]) {
          return _this.props[name](event);
        }
      };

      _this.onPrePush = callback.bind(_assertThisInitialized(_this), 'onPrePush');
      _this.onPostPush = callback.bind(_assertThisInitialized(_this), 'onPostPush');
      _this.onPrePop = callback.bind(_assertThisInitialized(_this), 'onPrePop');
      _this.onPostPop = callback.bind(_assertThisInitialized(_this), 'onPostPop');
      _this.ref = /*#__PURE__*/React__default["default"].createRef();
      _this.state = {
        internalStack: []
      };
      return _this;
    }

    _createClass(RouterNavigatorClass, [{
      key: "update",
      value: function update(cb) {
        if (!this.cancelUpdate) {
          this.setState({}, cb);
        }
      }
      /**
       * @method resetPageStack
       * @signature resetPageStack(route, options = {})
       * @param {Array} [routes]
       *   [en] The routes that the navigator should be reset to.[/en]
       *   [ja][/ja]
       * @return {Promise}
       *   [en]Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en] Resets the navigator to the current page stack[/en]
       *   [ja][/ja]
       */

    }, {
      key: "resetPageStack",
      value: function resetPageStack(routes) {
        var _this2 = this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (this.isRunning()) {
          return;
        }

        var update = function update() {
          return new Promise(function (resolve) {
            _this2.setState({
              internalStack: [].concat(_toConsumableArray(_this2.state.internalStack), [routes[routes.length - 1]])
            }, resolve);
          });
        };

        return this.ref.current._pushPage(options, update).then(function () {
          _this2.setState({
            internalStack: _toConsumableArray(routes)
          });
        });
      }
      /**
       * @method pushPage
       * @signature pushPage(route, options = {})
       * @param {Array} [routes]
       *   [en] The routes that the navigator should push to.[/en]
       *   [ja][/ja]
       * @return {Promise}
       *   [en] Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en] Pushes a page to the page stack[/en]
       *   [ja][/ja]
       */

    }, {
      key: "pushPage",
      value: function pushPage(route) {
        var _this3 = this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (this.isRunning()) {
          return;
        }

        var update = function update() {
          return new Promise(function (resolve) {
            _this3.setState({
              internalStack: [].concat(_toConsumableArray(_this3.state.internalStack), [route])
            }, resolve);
          });
        };

        return this.ref.current._pushPage(options, update);
      }
    }, {
      key: "isRunning",
      value: function isRunning() {
        return this.ref.current._isRunning;
      }
      /*
       * @method replacePage
       * @signature replacePage(page, [options])
       * @return {Promise}
       *   [en]Promise which resolves to the new page.[/en]
       *   [ja]新しいページを解決するPromiseを返します。[/ja]
       * @description
       *   [en]Replaces the current top page with the specified one. Extends `pushPage()` parameters.[/en]
       *   [ja]現在表示中のページをを指定したページに置き換えます。[/ja]
       */

    }, {
      key: "replacePage",
      value: function replacePage(route) {
        var _this4 = this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (this.isRunning()) {
          return;
        }

        var update = function update() {
          return new Promise(function (resolve) {
            _this4.setState({
              internalStack: [].concat(_toConsumableArray(_this4.state.internalStack), [route])
            }, resolve);
          });
        };

        return this.ref.current._pushPage(options, update).then(function () {
          _this4.setState({
            internalStack: [].concat(_toConsumableArray(_this4.state.internalStack.slice(0, -2)), [route])
          });
        });
      }
      /**
       * @method popPage
       * @signature popPage(route, options = {})
       * @return {Promise}
       *   [en] Promise which resolves to the revealed page.[/en]
       *   [ja]明らかにしたページを解決するPromiseを返します。[/ja]
       * @description
       *   [en] Pops a page out of the page stack[/en]
       *   [ja][/ja]
       */

    }, {
      key: "popPage",
      value: function popPage() {
        var _this5 = this;

        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        if (this.isRunning()) {
          return;
        }

        var update = function update() {
          return new Promise(function (resolve) {
            ReactDOM__default["default"].flushSync(function () {
              // prevents flickering caused by React 18 batching
              _this5.setState({
                internalStack: _this5.state.internalStack.slice(0, -1)
              }, resolve);
            });
          });
        };

        return this.ref.current._popPage(options, update);
      }
    }, {
      key: "_onDeviceBackButton",
      value: function _onDeviceBackButton(event) {
        if (this.props.routeConfig.routeStack.length > 1) {
          this.popPage();
        } else {
          event.callParentHandler();
        }
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        var node = this.ref.current;
        this.cancelUpdate = false;
        node.addEventListener('prepush', this.onPrePush);
        node.addEventListener('postpush', this.onPostPush);
        node.addEventListener('prepop', this.onPrePop);
        node.addEventListener('postpop', this.onPostPop);

        if (!this.props.routeConfig) {
          throw new Error('In RouterNavigator the property routeConfig needs to be set');
        }

        node.swipeMax = this.props.swipePop;
        node.onDeviceBackButton = this.props.onDeviceBackButton || this._onDeviceBackButton.bind(this);
        this.setState({
          internalStack: this.props.routeConfig.routeStack
        });
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        var node = this.ref.current;
        node.removeEventListener('prepush', this.onPrePush);
        node.removeEventListener('postpush', this.onPostPush);
        node.removeEventListener('prepop', this.onPrePop);
        node.removeEventListener('postpop', this.onPostPop);
        this.cancelUpdate = true;
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (this.props.onDeviceBackButton !== undefined) {
          this.ref.current.onDeviceBackButton = this.props.onDeviceBackButton;
        }

        var processStack = _toConsumableArray(this.props.routeConfig.processStack);
        /**
         * Fix for Redux Timetravel.
         */


        if (prevProps.routeConfig.processStack.length < this.props.routeConfig.processStack.length && prevProps.routeConfig.routeStack.length > this.props.routeConfig.routeStack.length) {
          return;
        }

        if (processStack.length > 0) {
          var _processStack$ = processStack[0],
              type = _processStack$.type,
              route = _processStack$.route,
              options = _processStack$.options;

          switch (type) {
            case 'push':
              this.pushPage(route, options);
              break;

            case 'pop':
              this.popPage(options);
              break;

            case 'reset':
              if (Array.isArray(route)) {
                this.resetPageStack(route, options);
              } else {
                this.resetPageStack([route], options);
              }

              break;

            case 'replace':
              this.replacePage(route, options);
              break;

            default:
              throw new Error("Unknown type ".concat(type, " in processStack"));
          }
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            innerRef = _this$props.innerRef,
            renderPage = _this$props.renderPage;
            _this$props.onPrePush;
            _this$props.onPostPush;
            _this$props.onPrePop;
            _this$props.onPostPop;
            _this$props.swipePop;
            _this$props.onDeviceBackButton;
            var rest = _objectWithoutProperties(_this$props, _excluded$2);

        var pagesToRender = this.state.internalStack.map(function (route) {
          return renderPage(route);
        });

        if (innerRef && innerRef !== this.ref) {
          this.ref = innerRef;
        }

        return /*#__PURE__*/React__default["default"].createElement(Element$4, _extends({}, rest, {
          ref: this.ref
        }), pagesToRender);
      }
    }]);

    return RouterNavigatorClass;
  }(React__default["default"].Component);
  /**
   * @original ons-navigator
   * @category navigation
   * @tutorial react/Reference/navigator
   * @description
   * [en] This component is a variant of the Navigator with a declarative API. In order to manage to display the pages, the  navigator needs to define the `renderPage` method, that takes an route and a navigator and  converts it to an page.[/en]
   * [ja][/ja]
   */


  var RouterNavigator = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    return /*#__PURE__*/React__default["default"].createElement(RouterNavigatorClass, _extends({
      innerRef: ref
    }, props), props.children);
  });
  RouterNavigator.propTypes = {
    /**
     * @name renderPage
     * @type function
     * @required true
     * @defaultValue null
     * @description
     *  [en] This function takes the current route object as a parameter and returns a react componen.[/en]
     *  [ja][/ja]
     */
    renderPage: PropTypes__default["default"].func.isRequired,

    /**
     * @name routeConfig
     * @type object
     * @required true
     * @defaultValue null
     * @description
     *  [en] This object must contain two properties:
     *  `routeStack`: An array of route objects,
     *  `processStack`: An array of process objects `{ type: push | pop | reset, route: userRoute }` that
     *  describe the transition from the current state to the next state.
     *  Make sure that the route stack is not emptied before the animations for the `processStack` have completed.
     *  It is recommended to update the `routeStack` and empty the `processStack` in the 'onPostPop' callback.
     *  [/en]
     *  [ja][/ja]
     */
    routeConfig: PropTypes__default["default"].shape({
      routeStack: PropTypes__default["default"].arrayOf(PropTypes__default["default"].object),
      processStack: PropTypes__default["default"].arrayOf(PropTypes__default["default"].object)
    }),

    /**
     * @name onPrePush
     * @type function
     * @required false
     * @description
     *  [en]Called just before a page is pushed.[/en]
     */
    onPrePush: PropTypes__default["default"].func,

    /**
     * @name onPostPush
     * @type function
     * @required false
     * @description
     *  [en]Called just after a page is pushed.[/en]
     */
    onPostPush: PropTypes__default["default"].func,

    /**
     * @name onPrePop
     * @type function
     * @required false
     * @description
     *  [en]Called just before a page is popped.[/en]
     */
    onPrePop: PropTypes__default["default"].func,

    /**
     * @name onPostPop
     * @type function
     * @required false
     * @description
     *  [en]Called just after a page is popped.[/en]
     */
    onPostPop: PropTypes__default["default"].func,

    /**
     * @property animation
     * @type {String}
     * @description
     *   [en]
     *     Animation name. Available animations are `"slide"`, `"lift"`, `"fade"` and `"none"`.
     *     These are platform based animations. For fixed animations, add `"-ios"` or `"-md"` suffix to the animation name. E.g. `"lift-ios"`, `"lift-md"`. Defaults values are `"slide-ios"` and `"fade-md"`.
     *   [/en]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name swipeable
     * @type bool|string
     * @required false
     * @description
     *  [en]
     *  Enables swipe-to-pop functionality for iOS.
     *  [/en]
     *  [ja][/ja]
     */
    swipeable: PropTypes__default["default"].oneOfType([PropTypes__default["default"].bool, PropTypes__default["default"].string]),

    /**
     * @name swipePop
     * @type function
     * @required false
     * @description
     *  [en]
     *  Function called on swipe-to-pop. Must perform a popPage with the given options object.
     *  [/en]
     *  [ja][/ja]
     */
    swipePop: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  /**
   * @original ons-row
   * @category grid
   * @description
   * [en]
   * Represents a row in the grid system. Use with `Col` to layout components.
   * [/en]
   * [ja][/ja]
   * <Row>
   *   <Col width={50}>
    *   <ons-icon icon="fa-twitter"></ons-icon>
   *   </Col>
   *   <Col>Text</Col>
   * </Row>
   */

  var Row = onsCustomElement('ons-row');
  Row.propTypes = {
    /**
    * @name verticalAlign
    * @type {String}
    * @description
    *   [en]Short hand attribute for aligning vertically. Valid values are top, bottom, and center.[/en]
    *   [ja][/ja]
    */
    verticalAlign: PropTypes__default["default"].oneOf(['top', 'bottom', 'center'])
  };

  var nameMap$2 = _objectSpread2({}, INPUT_PROPS);

  var withDefaultValue$1 = function withDefaultValue(component) {
    return oneTimeProp(component, 'defaultValue', 'value');
  };

  var notAttributes$4 = ['value' // value must be applied as property since attribute only works before input is touched
  ];
  /**
   * @original ons-search-input
   * @category form
   * @tutorial react/Reference/search-input
   * @description
   * [en]
   *  A search input component. The component will automatically render as a Material Design search input on Android devices.
   *
   *  Most attributes that can be used for a normal `<input>` element can also be used on the `<SearchInput>` component.
   * [/en]
   * [ja][/ja]
   * @example
   * <SearchInput
   *   value={this.state.text}
   *   onChange={(event) => { this.setState({text: event.target.value})} }
   *   modifier='material'
   *   placeholder='Username' />
   */

  var SearchInput = withDefaultValue$1(onsCustomElement('ons-search-input', {
    deprecated: nameMap$2,
    notAttributes: notAttributes$4
  }));
  SearchInput.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the input.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]Specifies whether the input is disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name readOnly
     * @type bool
     * @description
     *  [en]Specifies whether the input is read-only.[/en]
     *  [ja][/ja]
     */
    readOnly: PropTypes__default["default"].bool,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en]Called when the inner input fires a `change` event.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name onInput
     * @type function
     * @description
     *  [en]Called when the inner input fires an `input` event.[/en]
     *  [ja][/ja]
     */
    onInput: PropTypes__default["default"].func,

    /**
     * @name value
     * @type string
     * @description
     *  [en]Content of the input (controlled).[/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].instanceOf(Date)]),

    /**
     * @name defaultValue
     * @type string
     * @description
     *  [en]Content of the input at first render (uncontrolled).[/en]
     *  [ja][/ja]
     */
    defaultValue: PropTypes__default["default"].oneOfType([PropTypes__default["default"].string, PropTypes__default["default"].instanceOf(Date)]),

    /**
     * @name placeholder
     * @type string
     * @description
     *  [en] Placeholder text. In Material Design this placeholder will be a floating label. [/en]
     *  [ja][/ja]
     */
    placeholder: PropTypes__default["default"].string,

    /**
     * @name inputId
     * @type string
     * @description
     *  [en]  Specify the "id" attribute of the inner `<input>` element. This is useful when using <label for="..."> elements [/en]
     *  [ja][/ja]
     */
    inputId: PropTypes__default["default"].string
  };

  var deprecated$3 = {
    index: 'activeIndex'
  };
  /**
   * @original ons-segment
   * @category control
   * @tutorial react/Reference/segment
   * @description
   * [en]
   *   Segment component.
   * [/en]
   * [ja][/ja]
   * @example
   * <Segment modifier="material">
   *  <button>Label 1</button>
   *  <button>Label 2</button>
   *  <button>Label 3</button>
   * </Segment>
   */

  var Segment = onsCustomElement('ons-segment', {
    deprecated: deprecated$3
  });
  Segment.propTypes = {
    /**
     * @name activeIndex
     * @type number
     * @description
     *  [en]The index of the button to highlight.[/en]
     *  [ja][/ja]
     */
    activeIndex: PropTypes__default["default"].number,

    /**
     * @name index
     * @type number
     * @description
     *  [en]DEPRECATED! Use `activeIndex` instead.[/en]
     *  [ja][/ja]
     */
    index: PropTypes__default["default"].number,

    /**
     * @name tabbarId
     * @type string
     * @description
     *  [en] ID of the `<Tabbar>` to "connect" to the segment. [/en]
     *  [ja][/ja]
     */
    tabbarId: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the segment.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name onPostChange
     * @type function
     * @description
     *  [en] Called after the active button changes.[/en]
     *  [ja][/ja]
     */
    onPostChange: PropTypes__default["default"].func,

    /**
     * @name disabled
     * @type boolean
     * @description
     *   [en]Specifies whether the segment should be disabled.[/en]
     *   [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool
  };

  var nameMap$1 = _objectSpread2({}, INPUT_PROPS);

  var withDefaultValue = function withDefaultValue(component) {
    return oneTimeProp(component, 'defaultValue', 'value');
  };

  var Element$3 = withDefaultValue(onsCustomElement('ons-select', {
    deprecated: nameMap$1
  }));
  /**
   * @original ons-select
   * @category form
   * @tutorial react/Reference/select
   * @description
   * [en]
   *   Select input component.
   * [/en]
   * [ja][/ja]
   * @example
   * <Select modifier="material"
   *   value={this.state.value}
   *   onChange={(event) => this.setState({value: event.target.value})}>
   *   <option value="1">1</option>
   *   <option value="2">2nd</option>
   *   <option value="3">3rd option</option>
   * </Select>
   */

  var Select = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    return /*#__PURE__*/React__default["default"].createElement(Element$3, _extends({}, props, {
      ref: ref
    }), /*#__PURE__*/React__default["default"].createElement("select", null, props.children));
  });
  Select.propTypes = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]The appearance of the select box.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]Specifies whether the select is disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en]Called when the value of the select changes.[/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name value
     * @type string
     * @description
     *  [en]Use this prop to set the selected option value.[/en]
     *  [ja][/ja]
     */
    value: PropTypes__default["default"].string,

    /**
     * @name defaultValue
     * @type string
     * @description
     *  [en]Use this prop to set the defalut selected option value (uncontrolled components).[/en]
     *  [ja][/ja]
     */
    defaultValue: PropTypes__default["default"].string,

    /**
     * @name multiple
     * @type boolean
     * @description
     *  [en]If this attribute is defined, multiple options can be selected at once.[/en]
     *  [ja][/ja]
     */
    multiple: PropTypes__default["default"].bool,

    /**
     * @name autofocus
     * @type boolean
     * @description
     *  [en]Element automatically gains focus on page load.[/en]
     *  [ja][/ja]
     */
    autofocus: PropTypes__default["default"].bool,

    /**
     * @name required
     * @type boolean
     * @description
     *  [en]Make the select input required for submitting the form it is part of.[/en]
     *  [ja][/ja]
     */
    required: PropTypes__default["default"].bool,

    /**
     * @name form
     * @type string
     * @description
     *  [en]Associate a select element to an existing form on the page, even if not nested.[/en]
     *  [ja][/ja]
     */
    form: PropTypes__default["default"].string,

    /**
     * @name size
     * @type number
     * @description
     *  [en]How many options are displayed; if there are more than the size then a scroll appears to navigate them[/en]
     *  [ja][/ja]
     */
    size: PropTypes__default["default"].number,

    /**
     * @name name
     * @type string
     * @description
     *  [en]Name the select element, useful for instance if it is part of a form.[/en]
     *  [ja][/ja]
     */
    name: PropTypes__default["default"].string
  };

  /**
   * @original ons-speed-dial
   * @category control
   * @tutorial react/Reference/speed-dial
   * @description
   * [en] Element that displays a Material Design Speed Dialog component. It is useful when there are more than one primary action that can be performed in a page.
   *  The Speed dial looks like a `Fab` element but will expand a menu when tapped.
   [/en]
   * [ja][/ja]
   * @example
   * <SpeedDial disabled={false} direction='right' onClick={() => console.log('test1')} position='left bottom'>
       <Fab>
         <Icon icon='fa-twitter' size={26} fixedWidth={false} style={{verticalAlign: 'middle'}} />
       </Fab>
       <SpeedDialItem onClick={() => console.log('speed A')}> A </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed B')}> B </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed C')}> C </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed D')}> D </SpeedDialItem>
     </SpeedDial>
   */

  var SpeedDial = onsCustomElement('ons-speed-dial');
  SpeedDial.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the speed dial.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name position
     * @type string
     * @description
     *  [en]Specify the vertical and horizontal position of the component.
     *     I.e. to display it in the top right corner specify "right top".
     *     Choose from "right", "left", "top" and "bottom".
    [/en]
     *  [ja][/ja]
     */
    position: PropTypes__default["default"].string,

    /**
     * @name direction
     * @type string
     * @description
     *  [en]Specify the direction the items are displayed. Possible values are "up", "down", "left" and "right".[/en]
     *  [ja][/ja]
     */
    direction: PropTypes__default["default"].oneOf(['up', 'down', 'left', 'right']),

    /**
     * @name disabled
     * @type string
     * @description
     *  [en]Specify if button should be disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool
  };

  /**
   * @original ons-speed-dial-item
   * @category control
   * @tutorial react/Reference/speed-dial
   * @description
   * [en] This component displays the child elements of the Material Design Speed dial component. [/en]
   * [ja][/ja]
   * @example
   * <SpeedDial disabled={false} direction='right' onClick={() => console.log('test1')} position='left bottom'>
       <Fab>
         <Icon icon='fa-twitter' size={26} fixedWidth={false} style={{verticalAlign: 'middle'}} />
       </Fab>
       <SpeedDialItem onClick={() => console.log('speed A')}> A </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed B')}> B </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed C')}> C </SpeedDialItem>
       <SpeedDialItem onClick={() => console.log('speed D')}> D </SpeedDialItem>
     </SpeedDial>
   */

  var SpeedDialItem = onsCustomElement('ons-speed-dial-item');
  SpeedDialItem.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en]This function will be called when the button is clicked.[/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func
  };

  var notAttributes$3 = ['onDeviceBackButton'];
  /**
   * @original ons-splitter
   * @category menu
   * @tutorial react/Reference/splitter
   * @description
   * [en]  A component that enables responsive layout by implementing both a two-column layout and a sliding menu layout.
   *
   *    It can be configured to automatically expand into a column layout on large screens and collapse the menu on smaller screens. When the menu is collapsed the user can open it by swiping.
   [/en]
   * [ja][/ja]
   * @example
    <Splitter>
      <SplitterSide
        side="left"
        width={200}
        isSwipeable={true}>
        <Page> Page Left </Page>
      </SplitterSide>
      <SplitterContent>
        <Page> Page Content </Page>
      </SplitterContent>
      <SplitterSide
        side="right"
        width={300}
        collapse={!this.state.showRight}
        isOpen={this.state.openRight}
        onClose={this.handleRightClose.bind(this)}
        onOpen={this.handleRightOpen.bind(this)}
        isSwipeable={true}>
        <Page> Page Right </Page>
      </SplitterSide>
    </Splitter>
   */

  var Splitter = onsCustomElement('ons-splitter', {
    notAttributes: notAttributes$3
  });
  Splitter.propTypes = {
    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };

  /**
   * @original ons-splitter-content
   * @category menu
   * @tutorial react/Reference/splitter
   * @description
   * [en]  The SplitterContent  element is used as a child element of Splitter.
   *    It contains the main content of the page while SplitterSide contains the list.
   [/en]
   * [ja][/ja]
   * @example
    <Splitter>
      <SplitterSide
        side="left"
        width={200}
        isSwipeable={true}>
        <Page> Page Left </Page>
      </SplitterSide>
      <SplitterContent>
        <Page> Page Content </Page>
      </SplitterContent>
      <SplitterSide
        side="right"
        width={300}
        collapse={!this.state.showRight}
        isOpen={this.state.openRight}
        onClose={this.handleRightClose.bind(this)}
        onOpen={this.handleRightOpen.bind(this)}
        isSwipeable={true}>
        <Page> Page Right </Page>
      </SplitterSide>
    </Splitter>
   */

  var SplitterContent = onsCustomElement('ons-splitter-content');

  var _excluded$1 = ["width"];
  var deprecated$2 = {
    onOpen: 'onPostOpen',
    onClose: 'onPostClose'
  };
  var notAttributes$2 = ['isOpen'];
  var Element$2 = onsCustomElement('ons-splitter-side', {
    deprecated: deprecated$2,
    notAttributes: notAttributes$2
  });
  /**
   * @original ons-splitter-side
   * @category menu
   * @tutorial react/Reference/splitter
   * @description
   * [en]  The SplitterContent  element is used as a child element of Splitter.
   *    It contains the main content of the page while SplitterSide contains the list.
   [/en]
   * [ja][/ja]
   * @example
    <Splitter>
      <SplitterSide
        side="left"
        width={200}
        swipeable={true}>
        <Page> Page Left </Page>
      </SplitterSide>
      <SplitterContent>
        <Page> Page Content </Page>
      </SplitterContent>
      <SplitterSide
        side="right"
        width={300}
        collapse={!this.state.showRight}
        isOpen={this.state.openRight}
        onClose={this.handleRightClose.bind(this)}
        onOpen={this.handleRightOpen.bind(this)}
        swipeable={true}>
        <Page> Page Right </Page>
      </SplitterSide>
    </Splitter>
   */

  var SplitterSide = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    var width = props.width,
        rest = _objectWithoutProperties(props, _excluded$1); // number values for width are deprecated but handle them safely to avoid breaking user code


    var realWidth = typeof width === 'number' ? "".concat(width, "px") : width;
    return /*#__PURE__*/React__default["default"].createElement(Element$2, _extends({
      width: realWidth,
      ref: ref
    }, rest), props.children);
  });
  SplitterSide.propTypes = {
    /**
     * @name collapse
     * @type string
     * @description
     *  [en] Specify the collapse behavior. Valid values are `"portrait"`, `"landscape"` or a media query.
     *     The strings `"portrait"` and `"landscape"` means the view will collapse when device is in landscape or portrait orientation.
     *     If the value is not defined, the view always be in `"collapse"` mode.
    [/en]
     *  [ja][/ja]
     */
    collapse: PropTypes__default["default"].oneOfType([PropTypes__default["default"].bool, PropTypes__default["default"].string]),

    /**
     * @name swipeable
     * @type bool
     * @description
     *  [en]Ennable swipe interaction on collapse mode.[/en]
     *  [ja][/ja]
     */
    swipeable: PropTypes__default["default"].bool,

    /**
     * @name isOpen
     * @type bool
     * @description
     *  [en]Specifies whether the menu is open.[/en]
     *  [ja][/ja]
     */
    isOpen: PropTypes__default["default"].bool,

    /**
     * @name onPostOpen
     * @type function
     * @description
     *  [en]Called after the menu is opened.[/en]
     *  [ja][/ja]
     */
    onPostOpen: PropTypes__default["default"].func,

    /**
     * @name onOpen
     * @type function
     * @description
     *  [en]DEPRECATED! Use `onPostOpen` instead.[/en]
     *  [ja][/ja]
     */
    onOpen: PropTypes__default["default"].func,

    /**
     * @name onPostClose
     * @type function
     * @description
     *  [en]Called after the menu is closed.[/en]
     *  [ja][/ja]
     */
    onPostClose: PropTypes__default["default"].func,

    /**
     * @name onClose
     * @type function
     * @description
     *  [en]DEPRECATED! Use `onPostClose` instead.[/en]
     *  [ja][/ja]
     */
    onClose: PropTypes__default["default"].func,

    /**
     * @name side
     * @type string
     * @description
     *  [en]Specify which side of the screen the SplitterSide element is located. Possible values are `"left"` and `"right"`.[/en]
     *  [ja][/ja]
     */
    side: PropTypes__default["default"].oneOf(['left', 'right']),

    /**
     * @name swipeTargetWidth
     * @type number
     * @description
     *  [en]The width of swipeable area calculated from the edge (in pixels). Use this to enable swipe only when the finger touch on the screen edge.[/en]
     *  [ja][/ja]
     */
    swipeTargetWidth: PropTypes__default["default"].number,

    /**
     * @name width
     * @type  number
     * @description
     *  [en]Specifies the width of the menu. Can be specified in either pixels or as a percentage, e.g. `"90%"` or `"200px"`.[/en]
     *  [ja][/ja]
     */
    width: PropTypes__default["default"].string,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]Specify the animation. Use one of `overlay`, `push`, `reveal`, or `default`.[/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name openThreshold
     * @type object
     * @required false
     * @description
     *  [en] Specify how much the menu needs to be swiped before opening. A value between `0` and `1`.  [/en]
     *  [ja][/ja]
     */
    openThreshold: PropTypes__default["default"].number,

    /**
     * @name onPreOpen
     * @type string
     * @description
     *  [en] Called before the menu opens.  [/en]
     *  [ja][/ja]
     */
    onPreOpen: PropTypes__default["default"].func,

    /**
     * @name onPreClose
     * @type string
     * @description
     *  [en] Called before the menu closes.  [/en]
     *  [ja][/ja]
     */
    onPreClose: PropTypes__default["default"].func,

    /**
     * @name onModeChange
     * @type string
     * @description
     *  [en] Called after the component's mode changes. [/en]
     *  [ja][/ja]
     */
    onModeChange: PropTypes__default["default"].func
  };

  var nameMap = _objectSpread2({}, INPUT_PROPS);

  var withDefaultChecked = function withDefaultChecked(component) {
    return oneTimeProp(component, 'defaultChecked', 'checked');
  };
  /**
   * @original ons-switch
   * @category form
   * @tutorial react/Reference/switch
   * @description
   * [en]   Switch component. The switch can be toggled both by dragging and tapping.
   *     Will automatically displays a Material Design switch on Android devices.
   [/en]
   * [ja][/ja]
   * @example
   * <Switch checked={this.state.checked} onChange={this.onChange} />
   */


  var Switch = withDefaultChecked(onsCustomElement('ons-switch', {
    deprecated: nameMap
  }));
  Switch.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the checkbox.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name onChange
     * @type function
     * @description
     *  [en] Called when the value of the switch changes (checked/unchecked) [/en]
     *  [ja][/ja]
     */
    onChange: PropTypes__default["default"].func,

    /**
     * @name checked
     * @type bool
     * @description
     *  [en] Whether the switch is checked.[/en]
     *  [ja][/ja]
     */
    checked: PropTypes__default["default"].bool,

    /**
     * @name defaultChecked
     * @type boolean
     * @description
     *  [en]Defined the state of the switch at first render for uncontrolled inputs.[/en]
     *  [ja][/ja]
     */
    defaultChecked: PropTypes__default["default"].bool,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en] If set, the switch is disabled.[/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name inputId
     * @type string
     * @description
     *  [en] Specify the `id` attribute of the inner `<input>` element. This is useful when using `<label for="...">` elements.[/en]
     *  [ja][/ja]
     */
    inputId: PropTypes__default["default"].string
  };

  /**
   * @original ons-tab
   * @category tabbar
   * @tutorial react/Reference/tabbar
   * @description
   * [en] Represents a tab inside tab bar.
   [/en]
   * [ja][/ja]
   * @example
   * <Tap>
   *   Home
   * </Tap>
   */

  var Tab = onsCustomElement('ons-tab');
  Tab.propTypes = {
    /**
     * @name icon
     * @type string
     * @description
     *  [en]The icon name for the tab. Can specify the same icon name as <ons-icon>.[/en]
     *  [ja][/ja]
     */
    icon: PropTypes__default["default"].string,

    /**
     * @name activeIcon
     * @type string
     * @description
     *  [en]The name of the icon when the tab is active.[/en]
     *  [ja][/ja]
     */
    activeIcon: PropTypes__default["default"].string,

    /**
     * @name label
     * @type string
     * @description
     *  [en]The label of the tab item.[/en]
     *  [ja][/ja]
     */
    label: PropTypes__default["default"].string,

    /**
     * @name badge
     * @type string
     * @description
     *  [en]Display a notification badge on top of the tab.[/en]
     *  [ja][/ja]
     */
    badge: PropTypes__default["default"].string
  };

  var _excluded = ["visible", "hideTabs", "renderTabs"];
  var deprecated$1 = {
    index: 'activeIndex'
  };
  var Element$1 = onsCustomElement('ons-tabbar', {
    deprecated: deprecated$1
  });
  /**
   * @original ons-tabbar
   * @category tabbar
   * @tutorial react/Reference/tabbar
   * @description
   * [en] Component to display a tabbar on either the top or the bottom of a page.
   * To define the tabs and the content the property renderTabs need to be implemented, that returns an array of tabs and their content. See the example for specifics. [/en]* [ja][/ja]
   * @example

    <Page>
      <Tabbar
        onPreChange={({index}) => this.setState(index)}
        onPostChange={() => console.log('postChange')}
        onReactive={() => console.log('postChange')}
        position='bottom'
        index={this.state.index}
        renderTabs={(activeIndex, tabbar) => [
          {
            content: <TabPage title="Home" active={activeIndex === 0} tabbar={tabbar} />,
            tab: <Tab label="Home" icon="md-home" />
          },
          {
            content: <TabPage title="Settings" active={activeIndex === 1} tabbar={tabbar} />,
            tab: <Tab label="Settings" icon="md-settings" />
          }]
        }
      />
    </Page>
   */

  var Tabbar = /*#__PURE__*/React__default["default"].forwardRef(function (props, ref) {
    var visible = props.visible,
        hideTabs = props.hideTabs,
        renderTabs = props.renderTabs,
        rest = _objectWithoutProperties(props, _excluded);

    var tabs = renderTabs(props.activeIndex, ref); // visible is deprecated in favour of hideTabs, but if visible is defined and
    // hideTabs is not, we use its negation as the value of hideTabs

    var reallyHideTabs;

    if (hideTabs === undefined && visible !== undefined) {
      reallyHideTabs = !visible;
    } else {
      reallyHideTabs = hideTabs;
    }

    return /*#__PURE__*/React__default["default"].createElement(Element$1, _extends({
      hideTabs: reallyHideTabs
    }, rest, {
      ref: ref
    }), /*#__PURE__*/React__default["default"].createElement("div", {
      className: "tabbar__content"
    }, /*#__PURE__*/React__default["default"].createElement("div", null, tabs.map(function (tab) {
      return tab.content;
    })), /*#__PURE__*/React__default["default"].createElement("div", null)), /*#__PURE__*/React__default["default"].createElement("div", {
      className: "tabbar"
    }, tabs.map(function (tab) {
      return tab.tab;
    }), /*#__PURE__*/React__default["default"].createElement("div", {
      className: "tabbar__border"
    })));
  });
  Tabbar.propTypes = {
    /**
     * @name activeIndex
     * @type number
     * @description
     *  [en]The index of the tab to highlight.[/en]
     *  [ja][/ja]
     */
    activeIndex: PropTypes__default["default"].number,

    /**
     * @name index
     * @type number
     * @description
     *  [en]DEPRECATED! Use `activeIndex` instead.[/en]
     *  [ja][/ja]
     */
    index: PropTypes__default["default"].number,

    /**
     * @name renderTabs
     * @type function
     * @description
     *  [en]Function that returns an array of objects with the keys `content` and `tab`.[/en]
     *  [ja][/ja]
     */
    renderTabs: PropTypes__default["default"].func.isRequired,

    /**
     * @name position
     * @type string
     * @description
     *  [en]Tabbar's position. Available values are `"bottom"` and `"top"`. Use `"auto"` to choose position depending on platform (iOS bottom, Android top). [/en]
     *  [ja][/ja]
     */
    position: PropTypes__default["default"].string,

    /**
     * @name swipeable
     * @type bool
     * @description
     *  [en]Enable swipe interaction.[/en]
     *  [ja][/ja]
     */
    swipeable: PropTypes__default["default"].bool,

    /**
     * @name ignoreEdgeWidth
     * @type number
     * @description
     *  [en]Distance in pixels from both edges. Swiping on these areas will prioritize parent components such as `Splitter` or `Navigator`.[/en]
     *  [ja][/ja]
     */
    ignoreEdgeWidth: PropTypes__default["default"].number,

    /**
     * @name animation
     * @type string
     * @description
     *  [en]If this attribute is set to `"none"` the transitions will not be animated.[/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].oneOf(['none', 'slide']),

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g. `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name tabBorder
     * @type bool
     * @description
     *  [en]If true, the tabs show a dynamic bottom border. Only works for iOS since the border is always visible in Material Design.[/en]
     *  [ja][/ja]
     */
    tabBorder: PropTypes__default["default"].bool,

    /**
     * @name onPreChange
     * @type function
     * @description
     *  [en]Called just before the tab is changed.[/en]
     *  [ja][/ja]
     */
    onPreChange: PropTypes__default["default"].func,

    /**
     * @name onPostChange
     * @type function
     * @description
     *  [en]Called just after the tab is changed.[/en]
     *  [ja][/ja]
     */
    onPostChange: PropTypes__default["default"].func,

    /**
     * @name onReactive
     * @type function
     * @description
     *  [en]Called if the already open tab is tapped again.[/en]
     *  [ja][/ja]
     */
    onReactive: PropTypes__default["default"].func,

    /**
     * @name onSwipe
     * @type function
     * @description
     *  [en]Hook called whenever the user slides the tabbar. It gets a decimal index and an animationOptions object as arguments.[/en]
     *  [ja][/ja]
     */
    onSwipe: PropTypes__default["default"].func,

    /**
     * @name visible
     * @type bool
     * @description
     *  [en]If true, the tabbar is not shown on the screen. Otherwise, the tabbar is shown.[/en]
     *  [ja][/ja]
     */
    hideTabs: PropTypes__default["default"].bool,

    /**
     * @name visible
     * @type bool
     * @description
     *  [en]DEPRECATED! Use `hideTabs` instead.[/en]
     *  [ja][/ja]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name modifier
     * @type string
     * @description
     *  [en]The appearance of the tabbar.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string
  };

  var propTypes = {
    /**
     * @name visible
     * @type bool
     * @description
     *  [en]
     *  Indicates whether the toast open and shown.
     *  [/en]
     *  [ja][/ja]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name isOpen
     * @type bool
     * @description
     *  [en]
     *  DEPRECATED! Use `visible` instead.
     *  [/en]
     *  [ja][/ja]
     */
    isOpen: PropTypes__default["default"].bool,

    /**
     * @name animation
     * @type string
     * @required false
     * @description
     *  [en]Animation name. Available animations are `"default"`, `"ascend"` (Android), `"lift"` (iOS), `"fall"`, `"fade"` or `"none"`.[/en]
     *  [ja][/ja]
     */
    animation: PropTypes__default["default"].string,

    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the toast.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name animationOptions
     * @type object
     * @required false
     * @description
     *  [en]Specify the animation's duration, delay and timing. E.g.  `{duration: 0.2, delay: 0.4, timing: 'ease-in'}`.[/en]
     *  [ja][/ja]
     */
    animationOptions: PropTypes__default["default"].object,

    /**
     * @name onPreShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just before the toast is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPreShow: PropTypes__default["default"].func,

    /**
     * @name onPostShow
     * @type function
     * @required false
     * @description
     *  [en]
     *  Called just after the toast is displayed.
     *  [/en]
     *  [ja][/ja]
     */
    onPostShow: PropTypes__default["default"].func,

    /**
     * @name onPreHide
     * @type function
     * @required false
     * @description
     *  [en]Called just before the toast is hidden.[/en]
     *  [ja][/ja]
     */
    onPreHide: PropTypes__default["default"].func,

    /**
     * @name onPostHide
     * @type function
     * @required false
     * @description
     *  [en]Called just after the toast is hidden.[/en]
     *  [ja][/ja]
     */
    onPostHide: PropTypes__default["default"].func,

    /**
     * @name onDeviceBackButton
     * @type function
     * @required false
     * @description
     *  [en]
     *  Custom handler for device back button.
     *  [/en]
     *  [ja][/ja]
     */
    onDeviceBackButton: PropTypes__default["default"].func
  };
  var deprecated = {
    isOpen: 'visible'
  };
  var notAttributes$1 = ['onDeviceBackButton'];
  /**
   * @original ons-toast
   * @category dialog
   * @tutorial react/Reference/toast
   * @description
   * [en]
   *  The Toast or Snackbar component is useful for displaying dismissable information or simple actions at (normally) the bottom of the page.
   *
   *  This component does not block user input, allowing the app to continue its flow. Furthermore, it can be automatically hidden after a timeout.
   * [/en]
   * [ja][/ja]
   */

  var Toast = onsCustomElement(baseDialog('ons-toast'), {
    propTypes: propTypes,
    deprecated: deprecated,
    notAttributes: notAttributes$1
  });
  Toast.propTypes = propTypes;

  var notAttributes = ['visible'];
  /**
   * @original ons-toolbar
   * @category page
   * @tutorial react/Reference/toolbar
   * @description
   * [en]Toolbar component that can be used with navigation. Left, center and right container can be specified by class names. This component will automatically displays as a Material Design toolbar when running on Android devices.[/en]
   * [ja][/ja]
   * @example
   *
  <Page renderToolbar={() =>
    <Toolbar>
      <div className="left">
        <BackButton>
            Back
        </BackButton>
      </div>
      <div className="center">
        Title
      </div>
      <div className="right">
        <ToolbarButton>
          <Icon icon="md-menu" />
        </ToolbarButton>
      </div>
    </Toolbar> }
  />
   */

  var Toolbar = onsCustomElement('ons-toolbar', {
    notAttributes: notAttributes
  });
  Toolbar.propTypes = {
    /**
     * @name modifier
     * @type string
     * @description
     *  [en]
     *  Specify modifier name to specify custom styles. Optional.
     *  [/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name visible
     * @type bool
     * @description
     *  [en]If true, the toolbar is shown on the screen. Otherwise, the toolbar is not shown.[/en]
     *  [ja][/ja]
     */
    visible: PropTypes__default["default"].bool,

    /**
     * @name static
     * @type bool
     * @description
     *   [en]Static toolbars are not animated by `ons-navigator` when pushing or popping pages. This can be useful to improve performance in some situations.[/en]
     *  [ja][/ja]
     */
    "static": PropTypes__default["default"].bool,

    /**
     * @name inline
     * @type bool
     * @description
     *   [en]Display the toolbar as an inline element.[/en]
     *   [ja]ツールバーをインラインに置きます。スクロール領域内にそのまま表示されます。[/ja]
     */
    inline: PropTypes__default["default"].bool
  };

  /**
   * @original ons-toolbar-button
   * @category page
   * @tutorial react/Reference/page
   * @description
   *   [en]
   *   Button component for the Toolbar. Using this component gives a nice default style.
   *
   *
   *   [/en]
   * [ja][/ja]
   * @example
   * <Page
       renderToolbar = { () =>
        <Toolbar>
          <div className='left'><BackButton>Back</BackButton></div>
          <div className='center'>Input</div>
          <div className='right'>
            <ToolbarButton onClick={this.add} >Add</ToolbarButton>
          </div>
        </Toolbar>
       }>
        Page Content
      </Page>
   */

  var ToolbarButton = onsCustomElement('ons-toolbar-button');
  ToolbarButton.propTypes = {
    /**
     * @name modifier
     * @type string
     * @required false
     * @description
     *  [en]The appearance of the button.[/en]
     *  [ja][/ja]
     */
    modifier: PropTypes__default["default"].string,

    /**
     * @name disabled
     * @type bool
     * @description
     *  [en]
     *  Indicates whether the button is disabled.
     *  [/en]
     *  [ja][/ja]
     */
    disabled: PropTypes__default["default"].bool,

    /**
     * @name icon
     * @type string
     * @description
     *  [en]Creates an `Icon` component with this string.[/en]
     *  [ja][/ja]
     */
    icon: PropTypes__default["default"].string,

    /**
     * @name onClick
     * @type function
     * @description
     *  [en]This function will be called when the button is clicked.[/en]
     *  [ja][/ja]
     */
    onClick: PropTypes__default["default"].func
  };

  /*
   * routeStack : [userRoute, userRoute2, ...]
   * processStack: [
   * { type: push | pop | reset, route: userRoute },
   * { type: push | pop | reset, route: userRoute2 },
   * ...
   * ]
   */
  var RouterUtil = {
    init: function init(routes) {
      return {
        routeStack: _toConsumableArray(routes),
        processStack: []
      };
    },
    replace: function replace(_ref) {
      var routeConfig = _ref.routeConfig,
          route = _ref.route,
          options = _ref.options,
          key = _ref.key;

      var config = _objectSpread2({}, routeConfig);

      var routeStack = _toConsumableArray(config.routeStack);

      var processStack = _toConsumableArray(config.processStack);

      if (key == null || processStack.filter(function (el) {
        return el.key === key;
      }).length === 0) {
        var process = {
          type: 'replace',
          route: route,
          options: options,
          key: key
        };
        processStack = [].concat(_toConsumableArray(processStack), [process]);
      }

      return {
        routeStack: routeStack,
        processStack: processStack
      };
    },
    reset: function reset(_ref2) {
      var routeConfig = _ref2.routeConfig,
          route = _ref2.route,
          options = _ref2.options,
          key = _ref2.key;

      var config = _objectSpread2({}, routeConfig);

      var routeStack = _toConsumableArray(config.routeStack);

      var processStack = _toConsumableArray(config.processStack);

      if (key == null || processStack.filter(function (el) {
        return el.key === key;
      }).length === 0) {
        var process = {
          type: 'reset',
          route: route,
          options: options,
          key: key
        };
        processStack = [].concat(_toConsumableArray(processStack), [process]);
      }

      return {
        routeStack: routeStack,
        processStack: processStack
      };
    },
    push: function push(_ref3) {
      var routeConfig = _ref3.routeConfig,
          route = _ref3.route,
          options = _ref3.options,
          key = _ref3.key;

      var config = _objectSpread2({}, routeConfig);

      var routeStack = _toConsumableArray(config.routeStack);

      var processStack = _toConsumableArray(config.processStack);

      if (key == null || config.processStack.filter(function (el) {
        return el.key === key;
      }).length === 0) {
        var process = {
          type: 'push',
          route: route,
          options: options,
          key: key
        };
        processStack = [].concat(_toConsumableArray(processStack), [process]);
      }

      return {
        routeStack: routeStack,
        processStack: processStack
      };
    },
    pop: function pop(_ref4) {
      var routeConfig = _ref4.routeConfig,
          options = _ref4.options,
          key = _ref4.key;

      var config = _objectSpread2({}, routeConfig);

      var routeStack = _toConsumableArray(config.routeStack);

      var processStack = _toConsumableArray(config.processStack);
      /**
       * Safegaurd to ensure that not
       * too many pages are popped from
       * the stack.
       */


      var pops = processStack.filter(function (x) {
        return x.type === 'pop';
      }).length;

      if (pops + 1 >= routeStack.length) {
        console.warn('Page stack is already empty');
        return config;
      }

      var process = {
        type: 'pop',
        key: key,
        options: options
      };
      processStack = [].concat(_toConsumableArray(processStack), [process]);
      return {
        routeStack: routeStack,
        processStack: processStack
      };
    },
    postPush: function postPush(routeConfig) {
      var config = _objectSpread2({}, routeConfig);

      var routeStack = _toConsumableArray(config.routeStack);

      var processStack = _toConsumableArray(config.processStack);

      var next = processStack.shift();
      var type = next.type;
      var route = next.route;

      if (type === 'push') {
        if (route !== null) {
          routeStack = [].concat(_toConsumableArray(routeStack), [route]);
        }
      } else if (type === 'reset') {
        if (!Array.isArray(route)) route = [route];
        routeStack = route;
      } else if (type === 'replace') {
        routeStack.pop();
        routeStack.push(route);
      }

      return {
        routeStack: routeStack,
        processStack: processStack
      };
    },
    postPop: function postPop(routeConfig) {
      var config = _objectSpread2({}, routeConfig);

      var routeStack = _toConsumableArray(config.routeStack);

      var processStack = _toConsumableArray(config.processStack);

      routeStack = routeStack.slice(0, routeStack.length - 1);
      processStack = processStack.slice(1);
      return {
        routeStack: routeStack,
        processStack: processStack
      };
    }
  };

  exports.ActionSheet = ActionSheet;
  exports.ActionSheetButton = ActionSheetButton;
  exports.AlertDialog = AlertDialog;
  exports.AlertDialogButton = AlertDialogButton;
  exports.BackButton = BackButton;
  exports.BottomToolbar = BottomToolbar;
  exports.Button = Button;
  exports.Card = Card;
  exports.Carousel = Carousel;
  exports.CarouselItem = CarouselItem;
  exports.Checkbox = Checkbox;
  exports.Col = Col;
  exports.Dialog = Dialog;
  exports.Fab = Fab;
  exports.GestureDetector = GestureDetector;
  exports.Icon = Icon;
  exports.Input = Input;
  exports.LazyList = LazyList;
  exports.List = List;
  exports.ListHeader = ListHeader;
  exports.ListItem = ListItem;
  exports.ListTitle = ListTitle;
  exports.Modal = Modal;
  exports.Navigator = Navigator;
  exports.Page = Page;
  exports.Popover = Popover;
  exports.ProgressBar = ProgressBar;
  exports.ProgressCircular = ProgressCircular;
  exports.PullHook = PullHook;
  exports.Radio = Radio;
  exports.Range = Range;
  exports.Ripple = Ripple;
  exports.RouterNavigator = RouterNavigator;
  exports.RouterUtil = RouterUtil;
  exports.Row = Row;
  exports.SearchInput = SearchInput;
  exports.Segment = Segment;
  exports.Select = Select;
  exports.SpeedDial = SpeedDial;
  exports.SpeedDialItem = SpeedDialItem;
  exports.Splitter = Splitter;
  exports.SplitterContent = SplitterContent;
  exports.SplitterSide = SplitterSide;
  exports.Switch = Switch;
  exports.Tab = Tab;
  exports.Tabbar = Tabbar;
  exports.Toast = Toast;
  exports.Toolbar = Toolbar;
  exports.ToolbarButton = ToolbarButton;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhY3Qtb25zZW51aS5qcyIsInNvdXJjZXMiOlsiLi4vc3JjL29uc0N1c3RvbUVsZW1lbnQuanN4IiwiLi4vc3JjL2Jhc2VEaWFsb2cuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQWN0aW9uU2hlZXQuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQWN0aW9uU2hlZXRCdXR0b24uanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQWxlcnREaWFsb2cuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQWxlcnREaWFsb2dCdXR0b24uanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQmFja0J1dHRvbi5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9Cb3R0b21Ub29sYmFyLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0J1dHRvbi5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9DYXJkLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0Nhcm91c2VsLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0Nhcm91c2VsSXRlbS5qc3giLCIuLi9zcmMvb25lVGltZVByb3AuanN4IiwiLi4vc3JjL2lucHV0UHJvcHMuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQ2hlY2tib3guanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvQ29sLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0RpYWxvZy5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9GYWIuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvR2VzdHVyZURldGVjdG9yLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0ljb24uanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvSW5wdXQuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvTGlzdC5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9MYXp5TGlzdC5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9MaXN0SGVhZGVyLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0xpc3RJdGVtLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL0xpc3RUaXRsZS5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9OYXZpZ2F0b3IuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvTW9kYWwuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvUGFnZS5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9Qb3BvdmVyLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1Byb2dyZXNzQmFyLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1Byb2dyZXNzQ2lyY3VsYXIuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvUHVsbEhvb2suanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvUmFkaW8uanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvUmFuZ2UuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvUmlwcGxlLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1JvdXRlck5hdmlnYXRvci5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9Sb3cuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvU2VhcmNoSW5wdXQuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvU2VnbWVudC5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9TZWxlY3QuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvU3BlZWREaWFsLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1NwZWVkRGlhbEl0ZW0uanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvU3BsaXR0ZXIuanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvU3BsaXR0ZXJDb250ZW50LmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1NwbGl0dGVyU2lkZS5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9Td2l0Y2guanN4IiwiLi4vc3JjL2NvbXBvbmVudHMvVGFiLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1RhYmJhci5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9Ub2FzdC5qc3giLCIuLi9zcmMvY29tcG9uZW50cy9Ub29sYmFyLmpzeCIsIi4uL3NyYy9jb21wb25lbnRzL1Rvb2xiYXJCdXR0b24uanN4IiwiLi4vc3JjL1JvdXRlclV0aWwuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZVJlZiwgdXNlRWZmZWN0IH0gZnJvbSAncmVhY3QnO1xuY29uc3Qga2ViYWJpemUgPSBjYW1lbFN0cmluZyA9PlxuICBjYW1lbFN0cmluZy5yZXBsYWNlKC8oW2EtekEtWl0pKFtBLVpdKS9nLCAnJDEtJDInKS50b0xvd2VyQ2FzZSgpO1xuXG5jb25zdCBhZGREZXByZWNhdGVkID0gKHByb3BzLCBkZXByZWNhdGVkKSA9PiB7XG4gIGNvbnN0IHByb3BzQ29weSA9IHsgLi4ucHJvcHMgfTtcblxuICBjb25zdCBuYW1lTWFwID0ge1xuICAgIGNsYXNzTmFtZTogJ2NsYXNzJyxcbiAgICAuLi5kZXByZWNhdGVkXG4gIH07XG5cbiAgZm9yIChjb25zdCBbb2xkTmFtZSwgbmV3TmFtZV0gb2YgT2JqZWN0LmVudHJpZXMobmFtZU1hcCkpIHtcbiAgICBpZiAocHJvcHNDb3B5W25ld05hbWVdID09PSB1bmRlZmluZWQgJiYgcHJvcHNDb3B5W29sZE5hbWVdICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIHByb3BzQ29weVtuZXdOYW1lXSA9IHByb3BzQ29weVtvbGROYW1lXTtcbiAgICAgIGRlbGV0ZSBwcm9wc0NvcHlbb2xkTmFtZV07XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHByb3BzQ29weTtcbn07XG5cbmZ1bmN0aW9uIHVzZUN1c3RvbUVsZW1lbnRMaXN0ZW5lcihyZWYsIHByb3AsIGhhbmRsZXIpIHtcbiAgY29uc3QgZXZlbnQgPSBwcm9wLnNsaWNlKDIpLnRvTG93ZXJDYXNlKCk7XG4gIHVzZUVmZmVjdCgoKSA9PiB7XG4gICAgY29uc3QgY3VycmVudCA9IHJlZi5jdXJyZW50O1xuICAgIGN1cnJlbnQuYWRkRXZlbnRMaXN0ZW5lcihldmVudCwgaGFuZGxlcik7XG5cbiAgICByZXR1cm4gZnVuY3Rpb24gY2xlYW51cCgpIHtcbiAgICAgIGN1cnJlbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcihldmVudCwgaGFuZGxlcik7XG4gICAgfTtcbiAgfSwgW3JlZiwgaGFuZGxlcl0pO1xufVxuXG5mdW5jdGlvbiB1c2VDdXN0b21FbGVtZW50KHByb3BzLCBvcHRpb25zID0ge30sIHJlZikge1xuICBjb25zdCBub3RBdHRyaWJ1dGVzID0gb3B0aW9ucy5ub3RBdHRyaWJ1dGVzIHx8IFtdO1xuICBjb25zdCBkZXByZWNhdGVkID0gb3B0aW9ucy5kZXByZWNhdGVkIHx8IHt9O1xuXG4gIGNvbnN0IHByb3BlcnRpZXMgPSB7fTtcbiAgZm9yIChjb25zdCBbcHJvcCwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKGFkZERlcHJlY2F0ZWQocHJvcHMsIGRlcHJlY2F0ZWQpKSkge1xuICAgIGNvbnN0IGpzTmFtZSA9IGtlYmFiaXplKHByb3ApO1xuXG4gICAgaWYgKG5vdEF0dHJpYnV0ZXMuaW5jbHVkZXMocHJvcCkpIHtcbiAgICAgIHVzZUVmZmVjdCgoKSA9PiB7XG4gICAgICAgIHJlZi5jdXJyZW50W3Byb3BdID0gdmFsdWU7XG4gICAgICB9KTtcbiAgICB9IGVsc2UgaWYgKC9eb25bQS1aXS8udGVzdChwcm9wKSkge1xuICAgICAgdXNlQ3VzdG9tRWxlbWVudExpc3RlbmVyKHJlZiwgcHJvcCwgdmFsdWUpO1xuICAgIH0gZWxzZSBpZiAodHlwZW9mIHZhbHVlID09PSAnYm9vbGVhbicpIHtcbiAgICAgIHByb3BlcnRpZXNbanNOYW1lXSA9IHZhbHVlID8gJycgOiBudWxsO1xuICAgIH0gZWxzZSBpZiAodHlwZW9mIHZhbHVlID09PSAnb2JqZWN0JyAmJiB2YWx1ZSAhPT0gbnVsbCkge1xuICAgICAgcHJvcGVydGllc1tqc05hbWVdID0gSlNPTi5zdHJpbmdpZnkodmFsdWUpO1xuICAgIH0gZWxzZSB7XG4gICAgICBwcm9wZXJ0aWVzW2pzTmFtZV0gPSB2YWx1ZTtcbiAgICB9XG4gIH1cblxuICByZXR1cm4ge3Byb3BlcnRpZXN9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBvbnNDdXN0b21FbGVtZW50KFdyYXBwZWRDb21wb25lbnQsIG9wdGlvbnMpIHtcbiAgcmV0dXJuIFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCBfcmVmKSA9PiB7XG4gICAgY29uc3QgcmVmID0gX3JlZiB8fCB1c2VSZWYoKTtcblxuICAgIGNvbnN0IHtzdHlsZSwgY2hpbGRyZW4sIC4uLnJlc3R9ID0gcHJvcHM7XG4gICAgY29uc3Qge3Byb3BlcnRpZXN9ID0gdXNlQ3VzdG9tRWxlbWVudChyZXN0LCBvcHRpb25zLCByZWYpO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxXcmFwcGVkQ29tcG9uZW50XG4gICAgICAgIHJlZj17cmVmfVxuICAgICAgICBzdHlsZT17c3R5bGV9XG4gICAgICAgIHsuLi5wcm9wZXJ0aWVzfVxuICAgICAgPlxuICAgICAgICB7Y2hpbGRyZW59XG4gICAgICA8L1dyYXBwZWRDb21wb25lbnQ+XG4gICAgKTtcbiAgfSk7XG59XG4iLCJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFJlYWN0RE9NIGZyb20gJ3JlYWN0LWRvbSc7XG5cbmNsYXNzIFBvcnRhbCBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICAgIHRoaXMuY29udGFpbmVyID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gIH1cblxuICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICBkb2N1bWVudC5ib2R5LmFwcGVuZENoaWxkKHRoaXMuY29udGFpbmVyKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIGRvY3VtZW50LmJvZHkucmVtb3ZlQ2hpbGQodGhpcy5jb250YWluZXIpO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiBSZWFjdERPTS5jcmVhdGVQb3J0YWwoXG4gICAgICB0aGlzLnByb3BzLmNoaWxkcmVuLFxuICAgICAgdGhpcy5jb250YWluZXJcbiAgICApO1xuICB9XG59XG5cbmNvbnN0IGJhc2VEaWFsb2cgPSBEaWFsb2dDb21wb25lbnQgPT5cbiAgUmVhY3QuZm9yd2FyZFJlZigocHJvcHMsIHJlZikgPT4ge1xuICAgIC8vIHZpc2libGUgcHJvcCBzaG91bGQgYmUgYXBwbGllZCBsYXN0IHNpbmNlIGl0IGRlcGVuZHMgb24gYW5pbWF0aW9uIGFuZFxuICAgIC8vIG1hc2tDb2xvciBwcm9wcyBiZWluZyBzZXQgZmlyc3RcbiAgICBjb25zdCB7dmlzaWJsZSwgLi4ucmVzdH0gPSBwcm9wcztcblxuICAgIHJldHVybiAoXG4gICAgICA8UG9ydGFsPlxuICAgICAgICA8RGlhbG9nQ29tcG9uZW50XG4gICAgICAgICAgey4uLnJlc3R9XG4gICAgICAgICAgdmlzaWJsZT17dmlzaWJsZX1cblxuICAgICAgICAgIHJlZj17cmVmfVxuICAgICAgICA+XG4gICAgICAgICAge3Byb3BzLmNoaWxkcmVufVxuICAgICAgICA8L0RpYWxvZ0NvbXBvbmVudD5cbiAgICAgIDwvUG9ydGFsPlxuICAgICk7XG4gIH0pO1xuXG5leHBvcnQgZGVmYXVsdCBiYXNlRGlhbG9nO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLWFjdGlvbi1zaGVldCc7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuaW1wb3J0IGJhc2VEaWFsb2cgZnJvbSAnLi4vYmFzZURpYWxvZyc7XG5cbmNvbnN0IHByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIHRpdGxlXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBPcHRpb25hbCB0aXRsZSBvZiB0aGUgYWN0aW9uIHNoZWV0LiBBIG5ldyBlbGVtZW50IHdpbGwgYmUgY3JlYXRlZCBjb250YWluaW5nIHRoaXMgc3RyaW5nLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgdGl0bGU6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uRGlhbG9nQ2FuY2VsXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBvbmx5IGlmIGNhbmNlbGFibGUgaXMgdHJ1ZS4gSXQgd2lsbCBiZSBjYWxsZWQgYWZ0ZXIgdGFwcGluZyB0aGUgYmFja2dyb3VuZCBvciBieSBwcmVzc2luZyB0aGUgYmFjayBidXR0b24gb24gQW5kcm9pZCBkZXZpY2VzLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25EaWFsb2dDYW5jZWw6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSB2aXNpYmxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBJbmRpY2F0ZXMgd2hldGhlciB0aGUgZGlhbG9nIGlzIG9wZW4gYW5kIHNob3duLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgdmlzaWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGNhbmNlbGFibGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBTcGVjaWZpZXMgd2hldGhlciB0aGUgZGlhbG9nIGlzIGNhbmNlbGFibGUgb3Igbm90LlxuICAgKiAgQSBjYW5jZWxhYmxlIGRpYWxvZyB3aWxsIGNhbGwgb25DYW5jZWwgIHdoZW4gdGFwcGluZyB0aGUgYmFja2dyb3VuZCBvciBvciAgcHJlc3NpbmcgdGhlIGJhY2sgYnV0dG9uIG9uIEFuZHJvaWQgZGV2aWNlc1xuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgY2FuY2VsYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGRpYWxvZyBpcyBkaXNhYmxlZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25DYW5jZWxcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgREVQUkVDQVRFRCEgVXNlIGBvbkRpYWxvZ0NhbmNlbGAgaW5zdGVhZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQ2FuY2VsOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgaXNPcGVuXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBERVBSRUNBVEVEISBVc2UgYHZpc2libGVgIGluc3RlYWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpc09wZW46IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpc0NhbmNlbGFibGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBERVBSRUNBVEVEISBVc2UgYGNhbmNlbGFibGVgIGluc3RlYWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpc0NhbmNlbGFibGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpc0Rpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgREVQUkVDQVRFRCEgVXNlIGBkaXNhYmxlZGAgaW5zdGVhZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGlzRGlzYWJsZWQ6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhbmltYXRpb25cbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFRoZSBhbmltYXRpb24gdXNlZCB3aGVuIHNob3dpbmcgYW5kIGhpZGluZyB0aGUgZGlhbG9nLiBDYW4gYmUgZWl0aGVyIGBcIm5vbmVcImAgb3IgYFwiZGVmYXVsdFwiYC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGFuaW1hdGlvbjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgZGlhbG9nLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBtYXNrQ29sb3JcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Db2xvciBvZiB0aGUgYmFja2dyb3VuZCBtYXNrLiBEZWZhdWx0IGlzIFwicmdiYSgwLCAwLCAwLCAwLjIpXCJbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtYXNrQ29sb3I6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFuaW1hdGlvbk9wdGlvbnNcbiAgICogQHR5cGUgb2JqZWN0XG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TcGVjaWZ5IHRoZSBhbmltYXRpb24ncyBkdXJhdGlvbiwgZGVsYXkgYW5kIHRpbWluZy4gRS5nLiAgYHtkdXJhdGlvbjogMC4yLCBkZWxheTogMC40LCB0aW1pbmc6ICdlYXNlLWluJ31gLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGFuaW1hdGlvbk9wdGlvbnM6IFByb3BUeXBlcy5vYmplY3QsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlU2hvd1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQganVzdCBiZWZvcmUgdGhlIGFjdGlvbiBzaGVldCBpcyBkaXNwbGF5ZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblByZVNob3c6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblBvc3RTaG93XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBqdXN0IGFmdGVyIHRoZSBhY3Rpb24gc2hlZXQgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Qb3N0U2hvdzogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlSGlkZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYmVmb3JlIHRoZSBhY3Rpb24gc2hlZXQgaXMgaGlkZGVuLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUHJlSGlkZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUG9zdEhpZGVcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBqdXN0IGFmdGVyIHRoZSBhY3Rpb24gc2hlZXQgaXMgaGlkZGVuLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUG9zdEhpZGU6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkRldmljZUJhY2tCdXR0b25cbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ3VzdG9tIGhhbmRsZXIgZm9yIGRldmljZSBiYWNrIGJ1dHRvbi5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRGV2aWNlQmFja0J1dHRvbjogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbmNvbnN0IGRlcHJlY2F0ZWQgPSB7XG4gIG9uQ2FuY2VsOiAnb25EaWFsb2dDYW5jZWwnLFxuICBpc09wZW46ICd2aXNpYmxlJyxcbiAgaXNEaXNhYmxlZDogJ2Rpc2FibGVkJyxcbiAgaXNDYW5jZWxhYmxlOiAnY2FuY2VsYWJsZSdcbn07XG5cbmNvbnN0IG5vdEF0dHJpYnV0ZXMgPSBbJ29uRGV2aWNlQmFja0J1dHRvbiddO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtYWN0aW9uLXNoZWV0XG4gKiBAY2F0ZWdvcnkgZGlhbG9nXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL2FjdGlvbi1zaGVldFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dXG4gKiAgQWN0aW9uL2JvdHRvbSBzaGVldCB0aGF0IGlzIGRpc3BsYXllZCBvbiB0b3Agb2YgY3VycmVudCBzY3JlZW4uXG4gKiAgVGhlIGFjdGlvbiBzaGVldCBpcyB1c2VmdWwgZm9yIGRpc3BsYXlpbmcgYSBsaXN0IG9mIG9wdGlvbnMgYW5kIGFza2luZyB0aGUgdXNlciB0byBtYWtlIGEgZGVjaXNpb24uIEFuIEFjdGlvblNoZWV0QnV0dG9uIGNvbXBvbmVudCBpcyBwcm92aWRlZCBmb3IgdGhpcyBwdXJwb3NlLCBhbHRob3VnaCBpdCBjYW4gY29udGFpbiBhbnkgdHlwZSBvZiBjb250ZW50LlxuICogIEl0IHdpbGwgYXV0b21hdGljYWxseSBiZSBkaXNwbGF5ZWQgYXMgTWF0ZXJpYWwgRGVzaWduIChib3R0b20gc2hlZXQpIHdoZW4gcnVubmluZyBvbiBhbiBBbmRyb2lkIGRldmljZS5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqL1xuY29uc3QgQWN0aW9uU2hlZXQgPSBvbnNDdXN0b21FbGVtZW50KGJhc2VEaWFsb2coJ29ucy1hY3Rpb24tc2hlZXQnKSwge3Byb3BUeXBlcywgZGVwcmVjYXRlZCwgbm90QXR0cmlidXRlc30pO1xuQWN0aW9uU2hlZXQucHJvcFR5cGVzID0gcHJvcFR5cGVzO1xuXG5leHBvcnQgZGVmYXVsdCBBY3Rpb25TaGVldDtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1hY3Rpb24tc2hlZXQtYnV0dG9uJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IHByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIGFjdGlvbiBzaGVldCBidXR0b24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGljb25cbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNyZWF0ZXMgYW4gYEljb25gIGNvbXBvbmVudCB3aXRoIHRoaXMgc3RyaW5nLiBPbmx5IHZpc2libGUgb24gQW5kcm9pZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpY29uOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkNsaWNrXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoaXMgZnVuY3Rpb24gd2lsbCBiZSBjYWxsZWQgd2hlbiB0aGUgYnV0dG9uIGlzIGNsaWNrZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DbGljazogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1hY3Rpb24tc2hlZXQtYnV0dG9uXG4gKiBAY2F0ZWdvcnkgZGlhbG9nXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL2FjdGlvbi1zaGVldFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dQ29tcG9uZW50IHRoYXQgcmVwcmVzZW50IGVhY2ggYnV0dG9uIG9mIHRoZSBhY3Rpb24gc2hlZXQuWy9lbl1cbiAqIFtqYV1bL2phXVxuICovXG5jb25zdCBBY3Rpb25TaGVldEJ1dHRvbiA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1hY3Rpb24tc2hlZXQtYnV0dG9uJywge3Byb3BUeXBlc30pO1xuQWN0aW9uU2hlZXRCdXR0b24ucHJvcFR5cGVzID0gcHJvcFR5cGVzO1xuXG5leHBvcnQgZGVmYXVsdCBBY3Rpb25TaGVldEJ1dHRvbjtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1hbGVydC1kaWFsb2cnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcbmltcG9ydCBiYXNlRGlhbG9nIGZyb20gJy4uL2Jhc2VEaWFsb2cnO1xuXG5jb25zdCBkZXByZWNhdGVkID0ge1xuICBvbkNhbmNlbDogJ29uRGlhbG9nQ2FuY2VsJyxcbiAgaXNPcGVuOiAndmlzaWJsZScsXG4gIGlzRGlzYWJsZWQ6ICdkaXNhYmxlZCcsXG4gIGlzQ2FuY2VsYWJsZTogJ2NhbmNlbGFibGUnXG59O1xuXG5jb25zdCBub3RBdHRyaWJ1dGVzID0gWydvbkRldmljZUJhY2tCdXR0b24nXTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWFsZXJ0LWRpYWxvZ1xuICogQGNhdGVnb3J5IGRpYWxvZ1xuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9hbGVydC1kaWFsb2dcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXVxuICogICBBbGVydCBkaWFsb2cgdGhhdCBpcyBkaXNwbGF5ZWQgb24gdG9wIG9mIHRoZSBjdXJyZW50IHNjcmVlbi4gVXNlZnVsIGZvciBkaXNwbGF5aW5nIHF1ZXN0aW9ucywgd2FybmluZ3Mgb3IgZXJyb3IgbWVzc2FnZXMgdG8gdGhlIHVzZXIuIFRoZSB0aXRsZSwgY29udGVudCBhbmQgYnV0dG9ucyBjYW4gYmUgZWFzaWx5IGN1c3RvbWl6ZWQgYW5kIGl0IHdpbGwgYXV0b21hdGljYWxseSBzd2l0Y2ggc3R5bGUgYmFzZWQgb24gdGhlIHBsYXRmb3JtLlxuICogWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAgIDxBbGVydERpYWxvZyBpc09wZW49e3RoaXMuc3RhdGUuaXNPcGVufSBvbkNhbmNlbD17dGhpcy5oYW5kbGVDYW5jZWwuYmluZCh0aGlzKX0gY2FuY2VsYWJsZT5cbiAgICAgPGRpdiBjbGFzc05hbWU9XCJhbGVydC1kaWFsb2ctdGl0bGVcIj5XYXJuaW5nITwvZGl2PlxuICAgICA8ZGl2IGNsYXNzTmFtZT1cImFsZXJ0LWRpYWxvZy1jb250ZW50XCI+XG4gICAgICAgQW4gZXJyb3IgaGFzIG9jY3VycmVkIVxuICAgICA8L2Rpdj5cbiAgICAgPGRpdiBjbGFzc05hbWU9XCJhbGVydC1kaWFsb2ctZm9vdGVyXCI+XG4gICAgICAgPEJ1dHRvbiBvbkNsaWNrPXt0aGlzLmhhbmRsZUNhbmNlbC5iaW5kKHRoaXMpfSBjbGFzc05hbWU9XCJhbGVydC1kaWFsb2ctYnV0dG9uXCI+XG4gICAgICAgICBDYW5jZWxcbiAgICAgICA8L0J1dHRvbj5cbiAgICAgICA8QnV0dG9uIG9uQ2xpY2s9e3RoaXMuaGFuZGxlQ2FuY2VsLmJpbmQodGhpcyl9IGNsYXNzTmFtZT1cImFsZXJ0LWRpYWxvZy1idXR0b25cIj5cbiAgICAgICAgIE9rXG4gICAgICAgPC9CdXR0b24+XG4gICAgIDwvZGl2PlxuICAgPC9BbGVydERpYWxvZz5cbiAqL1xuY29uc3QgQWxlcnREaWFsb2cgPSBvbnNDdXN0b21FbGVtZW50KGJhc2VEaWFsb2coJ29ucy1hbGVydC1kaWFsb2cnKSwge2RlcHJlY2F0ZWQsIG5vdEF0dHJpYnV0ZXN9KTtcblxuQWxlcnREaWFsb2cucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgdmlzaWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgSW5kaWNhdGVzIHdoZXRoZXIgdGhlIGRpYWxvZyBpcyBvcGVuIGFuZCBzaG93bi5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHZpc2libGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZmllcyB3aGV0aGVyIHRoZSBkaWFsb2cgaXMgZGlzYWJsZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGNhbmNlbGFibGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBTcGVjaWZpZXMgd2hldGhlciB0aGUgZGlhbG9nIGlzIGNhbmNlbGFibGUgb3Igbm90LlxuICAgKiAgQSBjYW5jZWxhYmxlIGRpYWxvZyB3aWxsIGNhbGwgYG9uRGlhbG9nQ2FuY2VsYCB3aGVuIHRhcHBpbmcgdGhlIGJhY2tncm91bmQgb3IgcHJlc3NpbmcgdGhlIGJhY2sgYnV0dG9uIG9uIEFuZHJvaWQgZGV2aWNlcy5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGNhbmNlbGFibGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkRpYWxvZ0NhbmNlbFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQgb25seSBpZiBgY2FuY2VsYWJsZWAgaXMgdHJ1ZS4gSXQgd2lsbCBiZSBjYWxsZWQgYWZ0ZXIgdGFwcGluZyB0aGUgYmFja2dyb3VuZCBvciBieSBwcmVzc2luZyB0aGUgYmFjayBidXR0b24gb24gQW5kcm9pZCBkZXZpY2VzLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25EaWFsb2dDYW5jZWw6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkNhbmNlbFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBERVBSRUNBVEVEISBVc2UgYG9uRGlhbG9nQ2FuY2VsYCBpbnN0ZWFkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DYW5jZWw6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpc09wZW5cbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIERFUFJFQ0FURUQhIFVzZSBgdmlzaWJsZWAgaW5zdGVhZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGlzT3BlbjogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlzQ2FuY2VsYWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIERFUFJFQ0FURUQhIFVzZSBgY2FuY2VsYWJsZWAgaW5zdGVhZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGlzQ2FuY2VsYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlzRGlzYWJsZWRcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBERVBSRUNBVEVEISBVc2UgYGRpc2FibGVkYCBpbnN0ZWFkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaXNEaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFuaW1hdGlvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgVGhlIGFuaW1hdGlvbiB1c2VkIHdoZW4gc2hvd2luZyBhbmQgaGlkaW5nIHRoZSBkaWFsb2cuIENhbiBiZSBlaXRoZXIgYFwibm9uZVwiYCBvciBgXCJkZWZhdWx0XCJgLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBkaWFsb2cuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG1hc2tDb2xvclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNvbG9yIG9mIHRoZSBiYWNrZ3JvdW5kIG1hc2suIERlZmF1bHQgaXMgXCJyZ2JhKDAsIDAsIDAsIDAuMilcIlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1hc2tDb2xvcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uT3B0aW9uc1xuICAgKiBAdHlwZSBvYmplY3RcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIGFuaW1hdGlvbidzIGR1cmF0aW9uLCBkZWxheSBhbmQgdGltaW5nLiBFLmcuICBge2R1cmF0aW9uOiAwLjIsIGRlbGF5OiAwLjQsIHRpbWluZzogJ2Vhc2UtaW4nfWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVTaG93XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBqdXN0IGJlZm9yZSB0aGUgYWxlcnQgZGlhbG9nIGlzIGRpc3BsYXllZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUHJlU2hvdzogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUG9zdFNob3dcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ2FsbGVkIGp1c3QgYWZ0ZXIgdGhlIGFsZXJ0IGRpYWxvZyBpcyBkaXNwbGF5ZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RTaG93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVIaWRlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQganVzdCBiZWZvcmUgdGhlIGFsZXJ0IGRpYWxvZyBpcyBoaWRkZW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0SGlkZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgdGhlIGFsZXJ0IGRpYWxvZyBpcyBoaWRkZW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Qb3N0SGlkZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uRGV2aWNlQmFja0J1dHRvblxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDdXN0b20gaGFuZGxlciBmb3IgZGV2aWNlIGJhY2sgYnV0dG9uLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25EZXZpY2VCYWNrQnV0dG9uOiBQcm9wVHlwZXMuZnVuY1xufTtcblxuZXhwb3J0IGRlZmF1bHQgQWxlcnREaWFsb2c7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtYWxlcnQtZGlhbG9nLWJ1dHRvbic7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtYWxlcnQtZGlhbG9nLWJ1dHRvblxuICogQGNhdGVnb3J5IGRpYWxvZ1xuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9kaWFsb2dcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXUNvbXBvbmVudCB0aGF0IHJlcHJlc2VudCBlYWNoIGJ1dHRvbiBvZiB0aGUgYWxlcnQgZGlhbG9nLlsvZW5dXG4gKiBbamFdWy9qYV1cbiAqL1xuY29uc3QgQWxlcnREaWFsb2dCdXR0b24gPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtYWxlcnQtZGlhbG9nLWJ1dHRvbicpO1xuXG5BbGVydERpYWxvZ0J1dHRvbi5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBhbGVydCBkaWFsb2cgYnV0dG9uLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGJ1dHRvbiBpcyBkaXNhYmxlZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25DbGlja1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGlzIGZ1bmN0aW9uIHdpbGwgYmUgY2FsbGVkIHdoZW4gdGhlIGJ1dHRvbiBpcyBjbGlja2VkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQ2xpY2s6IFByb3BUeXBlcy5mdW5jXG59O1xuXG5leHBvcnQgZGVmYXVsdCBBbGVydERpYWxvZ0J1dHRvbjtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1iYWNrLWJ1dHRvbic7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG5jb25zdCBub3RBdHRyaWJ1dGVzID0gWydvcHRpb25zJ107XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1iYWNrLWJ1dHRvblxuICogQGNhdGVnb3J5IG5hdmlnYXRpb25cbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvYmFjay1idXR0b25cbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXVxuICogICBCYWNrIGJ1dHRvbiBjb21wb25lbnQgZm9yIFRvb2xiYXIuIEl0IGVuYWJsZXMgdG8gYXV0b21hdGljYWxseSB0byBwb3AgdGhlIHRvcCBwYWdlIG9mIHRoZSBuYXZpZ2F0b3IuIFdoZW4gb25seSBwcmVzZW50ZWQgd2l0aCBvbmUgcGFnZSwgdGhlIGJ1dHRvbiBpcyBoaWRkZW4gYXV0b21hdGljYWxseS5cbiAqXG4gKiAgIFRoZSBkZWZhdWx0IGJlaGF2aW9yIGNhbiBiZSBvdmVycmlkZGVuIHVzaW5nIHRoZSBgb25DbGlja2AgcHJvcC5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gKiA8VG9vbGJhciBtb2RpZmllcj17dGhpcy5wcm9wcy5tb2RpZmllcn0gPlxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJsZWZ0XCI+PEJhY2tCdXR0b24gbW9kaWZpZXI9e3RoaXMucHJvcHMubW9kaWZpZXJ9PkJhY2s8L0JhY2tCdXR0b24+PC9kaXY+XG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImNlbnRlclwiPnt0aGlzLnByb3BzLnRpdGxlfTwvZGl2PlxuICAgPC9Ub29sYmFyPlxuICovXG5jb25zdCBCYWNrQnV0dG9uID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLWJhY2stYnV0dG9uJywge25vdEF0dHJpYnV0ZXN9KTtcblxuQmFja0J1dHRvbi5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBiYWNrIGJ1dHRvbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgb25DbGlja1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGlzIGZ1bmN0aW9uIHdpbGwgYmUgY2FsbGVkIHdoZW4gdGhlIGJ1dHRvbiBpcyBjbGlja2VkLiBUbyBwcmV2ZW50IHRoZSBkZWZhdWx0IGNsaWNrIGJlaGF2aW91ciwgY2FsbCBgZXZlbnQucHJldmVudERlZmF1bHQoKWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DbGljazogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9wdGlvbnNcbiAgICogQHR5cGUgb2JqZWN0XG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZmllcyB0aGUgYW5pbWF0aW9uLCBhbmltYXRpb25PcHRpb25zLCBhbmQgY2FsbGJhY2suWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb3B0aW9uczogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICBhbmltYXRpb246IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcbiAgICBjYWxsYmFjazogUHJvcFR5cGVzLmZ1bmNcbiAgfSlcbn07XG5cbmV4cG9ydCBkZWZhdWx0IEJhY2tCdXR0b247XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtYm90dG9tLXRvb2xiYXInO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3QgcHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgbW9kaWZpZXIgbmFtZSB0byBzcGVjaWZ5IGN1c3RvbSBzdHlsZXMuIE9wdGlvbmFsLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtYm90dG9tLXRvb2xiYXJcbiAqIEBjYXRlZ29yeSBwYWdlXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1Ub29sYmFyIGNvbXBvbmVudCB0aGF0IGlzIHBvc2l0aW9uZWQgYXQgdGhlIGJvdHRvbSBvZiB0aGUgcGFnZS5bL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPEJvdHRvbVRvb2xiYXIgbW9kaWZpZXI9XCJtYXRlcmlhbFwiPiBDb250ZW50IDwvQm90dG9tVG9vbGJhcj5cbiAqL1xuY29uc3QgQm90dG9tVG9vbGJhciA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1ib3R0b20tdG9vbGJhcicsIHtwcm9wVHlwZXN9KTtcbkJvdHRvbVRvb2xiYXIucHJvcFR5cGVzID0gcHJvcFR5cGVzO1xuXG5leHBvcnQgZGVmYXVsdCBCb3R0b21Ub29sYmFyO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLWJ1dHRvbic7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG5jb25zdCBwcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBidXR0b24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBTcGVjaWZpZXMgd2hldGhlciB0aGUgYnV0dG9uIGlzIGRpc2FibGVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZGlzYWJsZWQ6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSByaXBwbGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZmllcyB3aGV0aGVyIHRoZSBidXR0b24gaGFzIGEgcmlwcGxlIGVmZmVjdC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHJpcHBsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uQ2xpY2tcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIFRoaXMgZnVuY3Rpb24gd2lsbCBiZSBjYWxsZWQgd2hlbiB0aGUgYnV0dG9uIGlzIGNsaWNrZWQuIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQ2xpY2s6IFByb3BUeXBlcy5mdW5jXG59O1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtYnV0dG9uXG4gKiBAY2F0ZWdvcnkgZm9ybVxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9idXR0b25cbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXSBCdXR0b24gY29tcG9uZW50LiBJZiB5b3Ugd2FudCB0byBwbGFjZSBhIGJ1dHRvbiBpbiBhIHRvb2xiYXIsIHVzZSBgVG9vbGJhckJ1dHRvbmAgb3IgYEJhY2tCdXR0b25gIGluc3RlYWQuIFdpbGwgYXV0b21hdGljYWxseSBkaXNwbGF5IGFzIGEgTWF0ZXJpYWwgRGVzaWduIGJ1dHRvbiB3aXRoIGEgcmlwcGxlIGVmZmVjdCBvbiBBbmRyb2lkLlxuIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gKiA8QnV0dG9uIG1vZGlmaWVyPVwibGFyZ2UtLWN0YVwiPlxuICogICBUYXAgTWVcbiAqIDwvQnV0dG9uPlxuICovXG5jb25zdCBCdXR0b24gPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtYnV0dG9uJywge3Byb3BUeXBlc30pO1xuQnV0dG9uLnByb3BUeXBlcyA9IHByb3BUeXBlcztcblxuZXhwb3J0IGRlZmF1bHQgQnV0dG9uO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLWNhcmQnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWNhcmRcbiAqIEBjYXRlZ29yeSB2aXN1YWxcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvdmlzdWFsXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1DYXJkIGNvbXBvbmVudCB0aGF0IGNhbiBiZSB1c2VkIHRvIGRpc3BsYXkgY29udGVudC5bL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICpcbjxDYXJkPlxuICA8cD5Tb21lIGNvbnRlbnQ8L3A+XG48L0NhcmQ+XG4gKi9cbmNvbnN0IENhcmQgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtY2FyZCcpO1xuXG5DYXJkLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZnkgbW9kaWZpZXIgbmFtZSB0byBzcGVjaWZ5IGN1c3RvbSBzdHlsZXMuIE9wdGlvbmFsLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmdcbn07XG5cbmV4cG9ydCBkZWZhdWx0IENhcmQ7XG4iLCJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLWNhcm91c2VsJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IGRlcHJlY2F0ZWQgPSB7XG4gIGluZGV4OiAnYWN0aXZlSW5kZXgnXG59O1xuXG5jb25zdCBFbGVtZW50ID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLWNhcm91c2VsJywge2RlcHJlY2F0ZWR9KTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWNhcm91c2VsXG4gKiBAY2F0ZWdvcnkgY2Fyb3VzZWxcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvY2Fyb3VzZWxcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXSBDYXJvdXNlbCBjb21wb25lbnQuIEEgY2Fyb3VzZWwgY2FuIGJlIHVzZWQgdG8gZGlzcGxheSBzZXZlcmFsIGl0ZW1zIGluIHRoZSBzYW1lIHNwYWNlLlxuICogICAgIFRoZSBjb21wb25lbnQgc3VwcG9ydHMgZGlzcGxheWluZyBjb250ZW50IGJvdGggaG9yaXpvbnRhbGx5IGFuZCB2ZXJ0aWNhbGx5LiBUaGUgdXNlciBjYW4gc2Nyb2xsIHRocm91Z2ggdGhlIGl0ZW1zIGJ5IGRyYWdnaW5nIGFuZCBpdCBjYW4gYWxzbyBiZSBjb250cm9sbGVyIHByb2dyYW1tYXRpY2FsbHkuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqICAgIDxDYXJvdXNlbFxuICAgICAgICAgIG9uUG9zdENoYW5nZT17KCkgPT4gY29uc29sZS5sb2coJ29uUG9zdENoYW5nZScpfVxuICAgICAgICAgIG9uT3ZlcnNjcm9sbD17KCkgPT4gY29uc29sZS5sb2coJ29uT3ZlcnNjcm9sbCcpfVxuICAgICAgICAgIG9uUmVmcmVzaD17KCkgPT4gY29uc29sZS5sb2coJ29uUmVmcmVzaCcpfVxuICAgICAgICAgIHJlZj17KGNhcm91c2VsKSA9PiB7IHRoaXMuY2Fyb3VzZWwgPSBjYXJvdXNlbDsgfX1cbiAgICAgICAgICBzd2lwZWFibGVcbiAgICAgICAgICBvdmVyc2Nyb2xsYWJsZVxuICAgICAgICAgIGF1dG9TY3JvbGxcbiAgICAgICAgICBmdWxsc2NyZWVuXG4gICAgICAgICAgYXV0b1Njcm9sbFJhdGlvPXswLjJ9XG4gICAgICA+XG4gICAgICAgICAgPENhcm91c2VsSXRlbSBzdHlsZT17e2JhY2tncm91bmRDb2xvcjogJ2dyYXknfX0+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0naXRlbS1sYWJlbCc+R1JBWTwvZGl2PlxuICAgICAgICAgIDwvQ2Fyb3VzZWxJdGVtPlxuICAgICAgICAgIDxDYXJvdXNlbEl0ZW0gc3R5bGU9e3tiYWNrZ3JvdW5kQ29sb3I6ICcjMDg1MDc4J319PlxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2l0ZW0tbGFiZWwnPkJMVUU8L2Rpdj5cbiAgICAgICAgICA8L0Nhcm91c2VsSXRlbT5cbiAgICAgICAgPC9DYXJvdXNlbD5cblxuICovXG5jb25zdCBDYXJvdXNlbCA9IFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCByZWYpID0+IHtcbiAgY29uc3Qge2l0ZW1XaWR0aCwgaXRlbUhlaWdodCwgLi4ucmVzdH0gPSBwcm9wcztcblxuICAvLyBzdHJpbmcgdmFsdWVzIGZvciBpdGVtV2lkdGggYW5kIGl0ZW1IZWlnaHQgYXJlIGRlcHJlY2F0ZWQgYnV0IGhhbmRsZSB0aGVtXG4gIC8vIHNhZmVseSBhbnl3YXkgdG8gYXZvaWQgYnJlYWtpbmcgdXNlciBjb2RlXG4gIGNvbnN0IHN0cmluZ2lmeSA9IHggPT4gdHlwZW9mIHggPT09ICdudW1iZXInID8gYCR7eH1weGAgOiB4O1xuICBjb25zdCByZWFsSXRlbVdpZHRoID0gc3RyaW5naWZ5KGl0ZW1XaWR0aCk7XG4gIGNvbnN0IHJlYWxJdGVtSGVpZ2h0ID0gc3RyaW5naWZ5KGl0ZW1IZWlnaHQpO1xuXG4gIHJldHVybiAoXG4gICAgPEVsZW1lbnRcbiAgICAgIGl0ZW1XaWR0aD17cmVhbEl0ZW1XaWR0aH1cbiAgICAgIGl0ZW1IZWlnaHQ9e3JlYWxJdGVtSGVpZ2h0fVxuICAgICAgcmVmPXtyZWZ9XG4gICAgICB7Li4ucmVzdH1cbiAgICA+XG4gICAgICB7cHJvcHMuY2hpbGRyZW59XG4gICAgPC9FbGVtZW50PlxuICApO1xufSk7XG5cbkNhcm91c2VsLnByb3BUeXBlcyA9IHtcblxuICAvKipcbiAgICogQG5hbWUgZGlyZWN0aW9uXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGRpcmVjdGlvbiBvZiB0aGUgY2Fyb3VzZWwuIENhbiBiZSBlaXRoZXIgXCJob3Jpem9udGFsXCIgb3IgXCJ2ZXJ0aWNhbFwiLiBEZWZhdWx0IGlzIFwiaG9yaXpvbnRhbFwiLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpcmVjdGlvbjogUHJvcFR5cGVzLm9uZU9mKFsnaG9yaXpvbnRhbCcsICd2ZXJ0aWNhbCddKSxcblxuICAvKipcbiAgICogQG5hbWUgZnVsbHNjcmVlblxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRydWUsIHRoZSBjYXJvdXNlbCB3aWxsIGNvdmVyIHRoZSB3aG9sZSBzY3JlZW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZnVsbHNjcmVlbjogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG92ZXJzY3JvbGxhYmxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSWYgdHJ1ZSwgdGhlIGNhcm91c2VsIHdpbGwgYmUgc2Nyb2xsYWJsZSBvdmVyIHRoZSBlZGdlLiBJdCB3aWxsIGJvdW5jZSBiYWNrIHdoZW4gcmVsZWFzZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb3ZlcnNjcm9sbGFibGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBjZW50ZXJlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRydWUsIHRoZSBjYXJvdXNlbCB0aGVuIHRoZSBzZWxlY3RlZCBpdGVtIHdpbGwgYmUgaW4gdGhlIGNlbnRlciBvZiB0aGUgY2Fyb3VzZWwgaW5zdGVhZCBvZiB0aGUgYmVnaW5uaW5nLiBVc2VmdWwgb25seSB3aGVuIHRoZSBpdGVtcyBhcmUgc21hbGxlciB0aGFuIHRoZSBjYXJvdXNlbC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBjZW50ZXJlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGl0ZW1XaWR0aFxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5db25zLWNhcm91c2VsLWl0ZW0ncyB3aWR0aC4gT25seSB3b3JrcyB3aGVuIHRoZSBkaXJlY3Rpb24gaXMgc2V0IHRvIFwiaG9yaXpvbnRhbFwiLiBDYW4gYmUgaW4gcGl4ZWxzIG9yIGEgcGVyY2VudGFnZS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpdGVtV2lkdGg6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGl0ZW1IZWlnaHRcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXW9ucy1jYXJvdXNlbC1pdGVtJ3MgaGVpZ2h0LiBPbmx5IHdvcmtzIHdoZW4gdGhlIGRpcmVjdGlvbiBpcyBzZXQgdG8gXCJ2ZXJ0aWNhbFwiLiBDYW4gYmUgaW4gcGl4ZWxzIG9yIGEgcGVyY2VudGFnZS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpdGVtSGVpZ2h0OiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhdXRvU2Nyb2xsXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSWYgdHJ1ZSwgdGhlIGNhcm91c2VsIHdpbGwgYmUgYXV0b21hdGljYWxseSBzY3JvbGxlZCB0byB0aGUgY2xvc2VzdCBpdGVtIGJvcmRlciB3aGVuIHJlbGVhc2VkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGF1dG9TY3JvbGw6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhdXRvU2Nyb2xsUmF0aW9cbiAgICogQHR5cGUgbnVtYmVyXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUEgbnVtYmVyIGJldHdlZW4gMC4wIGFuZCAxLjAgdGhhdCBzcGVjaWZpZXMgaG93IG11Y2ggdGhlIHVzZXIgbXVzdCBkcmFnIHRoZSBjYXJvdXNlbCBpbiBvcmRlciBmb3IgaXQgdG8gYXV0byBzY3JvbGwgdG8gdGhlIG5leHQgaXRlbS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhdXRvU2Nyb2xsUmF0aW86IFByb3BUeXBlcy5udW1iZXIsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHN3aXBlYWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRydWUsIHRoZSBjYXJvdXNlbCBjYW4gYmUgc2Nyb2xsZWQgYnkgZHJhZyBvciBzd2lwZS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBzd2lwZWFibGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRydWUsIHRoZSBjYXJvdXNlbCB3aWxsIGJlIGRpc2FibGVkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgYWN0aXZlSW5kZXhcbiAgICogQHR5cGUgbnVtYmVyXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIGluZGV4IG9mIHRoZSBvbnMtY2Fyb3VzZWwtaXRlbSB0byBzaG93LiBEZWZhdWx0IGlzIDAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYWN0aXZlSW5kZXg6IFByb3BUeXBlcy5udW1iZXIsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGluZGV4XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1ERVBSRUNBVEVEISBVc2UgYGFjdGl2ZUluZGV4YCBpbnN0ZWFkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGluZGV4OiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhdXRvUmVmcmVzaFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVdoZW4gdGhpcyBhdHRyaWJ1dGUgaXMgc2V0IHRoZSBjYXJvdXNlbCB3aWxsIGF1dG9tYXRpY2FsbHkgcmVmcmVzaCB3aGVuIHRoZSBudW1iZXIgb2YgY2hpbGQgbm9kZXMgY2hhbmdlLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGF1dG9SZWZyZXNoOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVDaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYmVmb3JlIHRoZSBjdXJyZW50IGNhcm91c2VsIGl0ZW0gY2hhbmdlcy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblByZUNoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUG9zdENoYW5nZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQganVzdCBhZnRlciB0aGUgY3VycmVudCBjYXJvdXNlbCBpdGVtIGhhcyBjaGFuZ2VkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUG9zdENoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUmVmcmVzaFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgY2Fyb3VzZWwgaGFzIGJlZW4gcmVmcmVzaGVkLiBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblJlZnJlc2g6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbk92ZXJzY3JvbGxcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIGNhcm91c2VsIGhhcyBiZWVuIG92ZXJzY3JvbGxlZC4gWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25PdmVyc2Nyb2xsOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSWYgdGhpcyBwcm9wIGlzIHNldCB0byBcIm5vbmVcIiB0aGUgdHJhbnNpdGlvbnMgd2lsbCBub3QgYmUgYW5pbWF0ZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhbmltYXRpb25PcHRpb25zXG4gICAqIEB0eXBlIG9iamVjdFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgYW5pbWF0aW9uJ3MgZHVyYXRpb24sIGRlbGF5IGFuZCB0aW1pbmcuIEUuZy4gIGB7ZHVyYXRpb246IDAuMiwgZGVsYXk6IDAuNCwgdGltaW5nOiAnZWFzZS1pbid9YC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb25PcHRpb25zOiBQcm9wVHlwZXMub2JqZWN0LFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblN3aXBlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUhvb2sgY2FsbGVkIHdoZW5ldmVyIHRoZSB1c2VyIHNsaWRlcyB0aGUgY2Fyb3VzZWwuIEl0IGdldHMgYSBkZWNpbWFsIGluZGV4IGFuZCBhbiBhbmltYXRpb25PcHRpb25zIG9iamVjdCBhcyBhcmd1bWVudHMuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Td2lwZTogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbmV4cG9ydCBkZWZhdWx0IENhcm91c2VsO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLWNhcm91c2VsLWl0ZW0nO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWNhcm91c2VsLWl0ZW1cbiAqIEBjYXRlZ29yeSBjYXJvdXNlbFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9jYXJvdXNlbFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dIENhcm91c2VsIGl0ZW0gY29tcG9uZW50LiBVc2VkIGFzIGEgY2hpbGQgb2YgdGhlIGA8b25zLWNhcm91c2VsPmAgZWxlbWVudC5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuKiAgPENhcm91c2VsIHN3aXBlYWJsZSBvdmVyc2Nyb2xsYWJsZSBhdXRvU2Nyb2xsIGZ1bGxzY3JlZW4gPlxuICAgICA8Q2Fyb3VzZWxJdGVtIHN0eWxlPXt7YmFja2dyb3VuZENvbG9yOiAnZ3JheSd9fT5cbiAgICAgICA8ZGl2IGNsYXNzTmFtZT0naXRlbS1sYWJlbCc+R1JBWTwvZGl2PlxuICAgICA8L0Nhcm91c2VsSXRlbT5cbiAgICAgPENhcm91c2VsSXRlbSBzdHlsZT17e2JhY2tncm91bmRDb2xvcjogJyMwODUwNzgnfX0+XG4gICAgICAgPGRpdiBjbGFzc05hbWU9J2l0ZW0tbGFiZWwnPkJMVUU8L2Rpdj5cbiAgICAgPC9DYXJvdXNlbEl0ZW0+XG4gICA8L0Nhcm91c2VsPlxuICovXG5jb25zdCBDYXJvdXNlbEl0ZW0gPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtY2Fyb3VzZWwtaXRlbScpO1xuXG5DYXJvdXNlbEl0ZW0ucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmeSBtb2RpZmllciBuYW1lIHRvIHNwZWNpZnkgY3VzdG9tIHN0eWxlcy4gT3B0aW9uYWwuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZ1xufTtcblxuZXhwb3J0IGRlZmF1bHQgQ2Fyb3VzZWxJdGVtO1xuIiwiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcblxuLy8gRm9yIGEgcHJvcCB3aXRoIG5hbWUgYGRlZmF1bHRQcm9wYCwgc2V0cyB0aGUgY29tcG9uZW50J3MgYHByb3BgIHByb3AgdG8gdGhlXG4vLyB2YWx1ZSBvZiBgZGVmYXVsdFByb3BgIHdoZW4gdGhlIGNvbXBvbmVudCBtb3VudHMgb25seS5cbi8vXG4vLyBGb3IgZXhhbXBsZSwgSW5wdXQgaGFzIGEgZGVmYXVsdHRWYWx1ZSBwcm9wIHRoYXQgc2hvdWxkIHNldCB0aGUgaW5uZXIgaW5wdXQnc1xuLy8gdmFsdWUgd2hlbiB0aGUgY29tcG9uZW50IG1vdW50ZWQgYW5kIGRvIG5vdGhpbmcgYWZ0ZXJ3YXJkcy5cbmNvbnN0IG9uZVRpbWVQcm9wID0gKFdyYXBwZWRDb21wb25lbnQsIGRlZmF1bHRQcm9wLCBwcm9wKSA9PiB7XG4gIGNsYXNzIE9uZVRpbWVQcm9wIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgICAgc3VwZXIocHJvcHMpO1xuICAgICAgdGhpcy5yZWYgPSBSZWFjdC5jcmVhdGVSZWYoKTtcbiAgICB9XG5cbiAgICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICAgIGNvbnN0IHZhbHVlID0gdGhpcy5wcm9wc1tkZWZhdWx0UHJvcF07XG4gICAgICBpZiAodmFsdWUpIHtcbiAgICAgICAgdGhpcy5yZWYuY3VycmVudFtwcm9wXSA9IHZhbHVlO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJlbmRlcigpIHtcbiAgICAgIGNvbnN0IHtpbm5lclJlZiwgLi4ucmVzdH0gPSB0aGlzLnByb3BzO1xuICAgICAgZGVsZXRlIHJlc3RbZGVmYXVsdFByb3BdO1xuXG4gICAgICBpZiAoaW5uZXJSZWYgJiYgaW5uZXJSZWYgIT09IHRoaXMucmVmKSB7XG4gICAgICAgIHRoaXMucmVmID0gaW5uZXJSZWY7XG4gICAgICB9XG5cbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxXcmFwcGVkQ29tcG9uZW50XG4gICAgICAgICAgcmVmPXt0aGlzLnJlZn1cbiAgICAgICAgICB7Li4ucmVzdH1cbiAgICAgICAgPlxuICAgICAgICAgIHt0aGlzLnByb3BzLmNoaWxkcmVufVxuICAgICAgICA8L1dyYXBwZWRDb21wb25lbnQ+XG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBSZWFjdC5mb3J3YXJkUmVmKChwcm9wcywgcmVmKSA9PlxuICAgIDxPbmVUaW1lUHJvcCBpbm5lclJlZj17cmVmfSB7Li4ucHJvcHN9Pntwcm9wcy5jaGlsZHJlbn08L09uZVRpbWVQcm9wPlxuICApO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgb25lVGltZVByb3A7XG4iLCJjb25zdCBJTlBVVF9QUk9QUyA9IHtcbiAgYXV0b0NhcGl0YWxpemU6ICdhdXRvY2FwaXRhbGl6ZScsXG4gIGF1dG9Db21wbGV0ZTogJ2F1dG9jb21wbGV0ZScsXG4gIGF1dG9Db3JyZWN0OiAnYXV0b2NvcnJlY3QnLFxuICBhdXRvRm9jdXM6ICdhdXRvZm9jdXMnLFxuICBpbnB1dE1vZGU6ICdpbnB1dG1vZGUnLFxuICBtYXhMZW5ndGg6ICdtYXhsZW5ndGgnLFxuICBtaW5MZW5ndGg6ICdtaW5sZW5ndGgnLFxuICByZWFkT25seTogJ3JlYWRvbmx5JyxcbiAgc3BlbGxDaGVjazogJ3NwZWxsY2hlY2snXG59O1xuXG5leHBvcnQgZGVmYXVsdCBJTlBVVF9QUk9QUztcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1jaGVja2JveCc7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuaW1wb3J0IG9uZVRpbWVQcm9wIGZyb20gJy4uL29uZVRpbWVQcm9wJztcbmltcG9ydCBJTlBVVF9QUk9QUyBmcm9tICcuLi9pbnB1dFByb3BzJztcblxuY29uc3QgbmFtZU1hcCA9IHtcbiAgLi4uSU5QVVRfUFJPUFNcbn07XG5cbmNvbnN0IHdpdGhEZWZhdWx0Q2hlY2tlZCA9IGNvbXBvbmVudCA9PiBvbmVUaW1lUHJvcChjb21wb25lbnQsICdkZWZhdWx0Q2hlY2tlZCcsICdjaGVja2VkJyk7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1jaGVja2JveFxuICogQGNhdGVnb3J5IGZvcm1cbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvY2hlY2tib3hcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXVxuICogIEEgY2hlY2tib3ggZWxlbWVudC4gVGhlIGNvbXBvbmVudCB3aWxsIGF1dG9tYXRpY2FsbHkgcmVuZGVyIGFzIGEgTWF0ZXJpYWwgRGVzaWduIGNoZWNrYm94IG9uIEFuZHJvaWQgZGV2aWNlcy5cbiAqXG4gKiAgTW9zdCBhdHRyaWJ1dGVzIHRoYXQgY2FuIGJlIHVzZWQgZm9yIGEgbm9ybWFsIGA8aW5wdXQgdHlwZT1cImNoZWNrYm94XCI+YCBlbGVtZW50IGNhbiBhbHNvIGJlIHVzZWQgb24gdGhlIGA8Q2hlY2tib3g+YCBjb21wb25lbnQuXG4gKiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPENoZWNrYm94XG4gKiAgIG9uQ2hhbmdlPXtldmVudCA9PiB7IHRoaXMuc2V0U3RhdGUoe2NoZWNrZWQ6IGV2ZW50LnRhcmdldC5jaGVja2VkfSl9IH1cbiAqICAgbW9kaWZpZXI9J21hdGVyaWFsJyAvPlxuICovXG5jb25zdCBDaGVja2JveCA9IHdpdGhEZWZhdWx0Q2hlY2tlZChvbnNDdXN0b21FbGVtZW50KCdvbnMtY2hlY2tib3gnLCB7ZGVwcmVjYXRlZDogbmFtZU1hcH0pKTtcblxuQ2hlY2tib3gucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgY2hlY2tib3guWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBTcGVjaWZpZXMgd2hldGhlciB0aGUgY2hlY2tib3ggaXMgZGlzYWJsZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uQ2hhbmdlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSBpbm5lciBjaGVja2JveCBmaXJlcyBhIGBjaGFuZ2VgIGV2ZW50LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQ2hhbmdlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25JbnB1dFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgaW5uZXIgY2hlY2tib3ggZmlyZXMgYW4gYGlucHV0YCBldmVudC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbklucHV0OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgdmFsdWVcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBWYWx1ZSBvZiB0aGUgY2hlY2tib3guWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgdmFsdWU6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgUHJvcFR5cGVzLmluc3RhbmNlT2YoRGF0ZSlcbiAgXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIGNoZWNrZWRcbiAgICogQHR5cGUgYm9vbGVhblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Db250cm9scyB0aGUgc3RhdGUgb2YgdGhlIGNoZWNrYm94IChjb250cm9sbGVkKS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBjaGVja2VkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgZGVmYXVsdENoZWNrZWRcbiAgICogQHR5cGUgYm9vbGVhblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1EZWZpbmVkIHRoZSBzdGF0ZSBvZiB0aGUgY2hlY2tib3ggYXQgZmlyc3QgcmVuZGVyIGZvciB1bmNvbnRyb2xsZWQgaW5wdXRzLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRlZmF1bHRDaGVja2VkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaW5wdXRJZFxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgXCJpZFwiIGF0dHJpYnV0ZSBvZiB0aGUgaW5uZXIgYDxpbnB1dD5gIGVsZW1lbnQuIFRoaXMgaXMgdXNlZnVsIHdoZW4gdXNpbmcgPGxhYmVsIGZvcj1cIi4uLlwiPiBlbGVtZW50cy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpbnB1dElkOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG5leHBvcnQgZGVmYXVsdCBDaGVja2JveDtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1jb2wnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWNvbFxuICogQGNhdGVnb3J5IGdyaWRcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXVxuICogUmVwcmVzZW50cyBhIGNvbHVtbiBpbiB0aGUgZ3JpZCBzeXN0ZW0uIFVzZSB3aXRoIGA8b25zLXJvdz5gIHRvIGxheW91dCBjb21wb25lbnRzLlxuICogWy9lbl1cbiAqIFtqYV1bL2phXVxuICogPFJvdz5cbiAqICAgPENvbCB3aWR0aD17NTB9PlxuICAqICAgPG9ucy1pY29uIGljb249XCJmYS10d2l0dGVyXCI+PC9vbnMtaWNvbj5cbiAqICAgPC9Db2w+XG4gKiAgIDxDb2w+VGV4dDwvQ29sPlxuICogPC9Sb3c+XG4gKi9cbmNvbnN0IENvbCA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1jb2wnKTtcblxuQ29sLnByb3BUeXBlcyA9IHtcblxuICAvKipcbiAgKiBAbmFtZSB2ZXJ0aWNhbEFsaWduXG4gICogQHR5cGUge1N0cmluZ31cbiAgKiBAZGVzY3JpcHRpb25cbiAgKiAgIFtlbl1TaG9ydCBoYW5kIGF0dHJpYnV0ZSBmb3IgYWxpZ25pbmcgdmVydGljYWxseS4gVmFsaWQgdmFsdWVzIGFyZSB0b3AsIGJvdHRvbSwgYW5kIGNlbnRlci5bL2VuXVxuICAqICAgW2phXVsvamFdXG4gICovXG4gIHZlcnRpY2FsQWxpZ246IFByb3BUeXBlcy5vbmVPZihbJ3RvcCcsICdib3R0b20nLCAnY2VudGVyJ10pLFxuXG4gIC8qKlxuICAqIEBuYW1lIHdpZHRoXG4gICogQHR5cGUge1N0cmluZ31cbiAgKiBAZGVzY3JpcHRpb25cbiAgKiAgIFtlbl1UaGUgd2lkdGggb2YgdGhlIGNvbHVtbi4gVmFsaWQgdmFsdWVzIGFyZSBjc3Mgd2lkdGggdmFsdWVzIChcIjEwJVwiLCA1MCkuWy9lbl1cbiAgKiAgIFtqYV1bL2phXVxuICAqL1xuICB3aWR0aDogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLm51bWJlciwgUHJvcFR5cGVzLnN0cmluZ10pXG59O1xuXG5leHBvcnQgZGVmYXVsdCBDb2w7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtZGlhbG9nJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5pbXBvcnQgYmFzZURpYWxvZyBmcm9tICcuLi9iYXNlRGlhbG9nJztcblxuY29uc3QgZGVwcmVjYXRlZCA9IHtcbiAgb25DYW5jZWw6ICdvbkRpYWxvZ0NhbmNlbCcsXG4gIGlzT3BlbjogJ3Zpc2libGUnLFxuICBpc0Rpc2FibGVkOiAnZGlzYWJsZWQnLFxuICBpc0NhbmNlbGFibGU6ICdjYW5jZWxhYmxlJ1xufTtcblxuY29uc3Qgbm90QXR0cmlidXRlcyA9IFsnb25EZXZpY2VCYWNrQnV0dG9uJ107XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1kaWFsb2dcbiAqIEBjYXRlZ29yeSBkaWFsb2dcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvZGlhbG9nXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gIERpYWxvZyB0aGF0IGlzIGRpc3BsYXllZCBvbiB0b3Agb2YgY3VycmVudCBzY3JlZW4uIEFzIG9wcG9zZWQgdG8gdGhlIEFsZXJ0RGlhbG9nIGVsZW1lbnQsIHRoaXMgY29tcG9uZW50IGNhbiBjb250YWluIGFueSBraW5kIG9mIGNvbnRlbnQuICBUaGUgZGlhbG9nIGlzIHVzZWZ1bCBmb3IgZGlzcGxheWluZyBtZW51cywgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiBvciB0byBhc2sgdGhlIHVzZXIgdG8gbWFrZSBhIGRlY2lzaW9uLiAgSXQgd2lsbCBhdXRvbWF0aWNhbGx5IGJlIGRpc3BsYXllZCBhcyBNYXRlcmlhbCBEZXNpZ24gd2hlbiBydW5uaW5nIG9uIGFuIEFuZHJvaWQgZGV2aWNlLlxuIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gICA8RGlhbG9nIG9uQ2FuY2VsPXt0aGlzLm9uQ2FuY2VsfVxuICAgICBpc09wZW49e3RoaXMucHJvcHMuaXNPcGVufVxuICAgICBzdHlsZT17e2hlaWdodDogMjUwfX0gIGNhbmNlbGFibGU+XG4gICAgIDxQYWdlPlxuICAgICAgIFBhZ2UgQ29udGVudFxuICAgICA8L1BhZ2U+XG4gICAgPC9EaWFsb2c+XG5cbiAqL1xuY29uc3QgRGlhbG9nID0gb25zQ3VzdG9tRWxlbWVudChiYXNlRGlhbG9nKCdvbnMtZGlhbG9nJyksIHtkZXByZWNhdGVkLCBub3RBdHRyaWJ1dGVzfSk7XG5cbkRpYWxvZy5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSB2aXNpYmxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBJbmRpY2F0ZXMgd2hldGhlciB0aGUgZGlhbG9nIGlzIG9wZW4gYW5kIHNob3duLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgdmlzaWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGRpYWxvZyBpcyBkaXNhYmxlZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgY2FuY2VsYWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZmllcyB3aGV0aGVyIHRoZSBkaWFsb2cgaXMgY2FuY2VsYWJsZSBvciBub3QuXG4gICAqICBBIGNhbmNlbGFibGUgZGlhbG9nIHdpbGwgY2FsbCBgb25EaWFsb2dDYW5jZWxgIHdoZW4gdGFwcGluZyB0aGUgYmFja2dyb3VuZCBvciBwcmVzc2luZyB0aGUgYmFjayBidXR0b24gb24gQW5kcm9pZCBkZXZpY2VzLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgY2FuY2VsYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uRGlhbG9nQ2FuY2VsXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBvbmx5IGlmIGBjYW5jZWxhYmxlYCBpcyB0cnVlLiBJdCB3aWxsIGJlIGNhbGxlZCBhZnRlciB0YXBwaW5nIHRoZSBiYWNrZ3JvdW5kIG9yIGJ5IHByZXNzaW5nIHRoZSBiYWNrIGJ1dHRvbiBvbiBBbmRyb2lkIGRldmljZXMuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRpYWxvZ0NhbmNlbDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uQ2FuY2VsXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIERFUFJFQ0FURUQhIFVzZSBgb25EaWFsb2dDYW5jZWxgIGluc3RlYWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkNhbmNlbDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlzT3BlblxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgREVQUkVDQVRFRCEgVXNlIGB2aXNpYmxlYCBpbnN0ZWFkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaXNPcGVuOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaXNDYW5jZWxhYmxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgREVQUkVDQVRFRCEgVXNlIGBjYW5jZWxhYmxlYCBpbnN0ZWFkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaXNDYW5jZWxhYmxlOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaXNEaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIERFUFJFQ0FURUQhIFVzZSBgZGlzYWJsZWRgIGluc3RlYWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpc0Rpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBUaGUgYW5pbWF0aW9uIHVzZWQgd2hlbiBzaG93aW5nIGFuZCBoaWRpbmcgdGhlIGRpYWxvZy4gQ2FuIGJlIGVpdGhlciBgXCJub25lXCJgIG9yIGBcImRlZmF1bHRcImAuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb246IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIGRpYWxvZy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbWFza0NvbG9yXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ29sb3Igb2YgdGhlIGJhY2tncm91bmQgbWFzay4gRGVmYXVsdCBpcyBcInJnYmEoMCwgMCwgMCwgMC4yKVwiWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbWFza0NvbG9yOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhbmltYXRpb25PcHRpb25zXG4gICAqIEB0eXBlIG9iamVjdFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgYW5pbWF0aW9uJ3MgZHVyYXRpb24sIGRlbGF5IGFuZCB0aW1pbmcuIEUuZy4gIGB7ZHVyYXRpb246IDAuMiwgZGVsYXk6IDAuNCwgdGltaW5nOiAnZWFzZS1pbid9YC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb25PcHRpb25zOiBQcm9wVHlwZXMub2JqZWN0LFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblByZVNob3dcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ2FsbGVkIGp1c3QgYmVmb3JlIHRoZSBhbGVydCBkaWFsb2cgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVTaG93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0U2hvd1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQganVzdCBhZnRlciB0aGUgYWxlcnQgZGlhbG9nIGlzIGRpc3BsYXllZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUG9zdFNob3c6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblByZUhpZGVcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBqdXN0IGJlZm9yZSB0aGUgYWxlcnQgZGlhbG9nIGlzIGhpZGRlbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblByZUhpZGU6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblBvc3RIaWRlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQganVzdCBhZnRlciB0aGUgYWxlcnQgZGlhbG9nIGlzIGhpZGRlbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EZXZpY2VCYWNrQnV0dG9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1c3RvbSBoYW5kbGVyIGZvciBkZXZpY2UgYmFjayBidXR0b24uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRldmljZUJhY2tCdXR0b246IFByb3BUeXBlcy5mdW5jXG59O1xuXG5leHBvcnQgZGVmYXVsdCBEaWFsb2c7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtZmFiJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1mYWJcbiAqIEBjYXRlZ29yeSBmb3JtXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL2ZhYlxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dIFRoZSBGbG9hdGluZyBhY3Rpb24gYnV0dG9uIGlzIGEgY2lyY3VsYXIgYnV0dG9uIGRlZmluZWQgaW4gdGhlIFtNYXRlcmlhbCBEZXNpZ24gc3BlY2lmaWNhdGlvbl0oaHR0cHM6Ly93d3cuZ29vZ2xlLmNvbS9kZXNpZ24vc3BlYy9jb21wb25lbnRzL2J1dHRvbnMtZmxvYXRpbmctYWN0aW9uLWJ1dHRvbi5odG1sKS4gVGhleSBhcmUgb2Z0ZW4gdXNlZCB0byBwcm9tb3RlIHRoZSBwcmltYXJ5IGFjdGlvbiBvZiB0aGUgYXBwLlxuICogICAgIEl0IGNhbiBiZSBkaXNwbGF5ZWQgZWl0aGVyIGFzIGFuIGlubGluZSBlbGVtZW50IG9yIGluIG9uZSBvZiB0aGUgY29ybmVycy4gTm9ybWFsbHkgaXQgd2lsbCBiZSBwb3NpdGlvbmVkIGluIHRoZSBsb3dlciByaWdodCBjb3JuZXIgb2YgdGhlIHNjcmVlbi5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPFNwZWVkRGlhbCBkaXNhYmxlZD17ZmFsc2V9IGRpcmVjdGlvbj0ncmlnaHQnIG9uQ2xpY2s9eygpID0+IGNvbnNvbGUubG9nKCd0ZXN0MScpfSBwb3NpdGlvbj0nbGVmdCBib3R0b20nPlxuICAgICA8RmFiPlxuICAgICAgIDxJY29uIGljb249J2ZhLXR3aXR0ZXInIHNpemU9ezI2fSBmaXhlZFdpZHRoPXtmYWxzZX0gc3R5bGU9e3t2ZXJ0aWNhbEFsaWduOiAnbWlkZGxlJ319IC8+XG4gICAgIDwvRmFiPlxuICAgICA8U3BlZWREaWFsSXRlbSBvbkNsaWNrPXsoKSA9PiBjb25zb2xlLmxvZygnc3BlZWQgQScpfT4gQSA8L1NwZWVkRGlhbEl0ZW0+XG4gICAgIDxTcGVlZERpYWxJdGVtIG9uQ2xpY2s9eygpID0+IGNvbnNvbGUubG9nKCdzcGVlZCBCJyl9PiBCIDwvU3BlZWREaWFsSXRlbT5cbiAgICAgPFNwZWVkRGlhbEl0ZW0gb25DbGljaz17KCkgPT4gY29uc29sZS5sb2coJ3NwZWVkIEMnKX0+IEMgPC9TcGVlZERpYWxJdGVtPlxuICAgICA8U3BlZWREaWFsSXRlbSBvbkNsaWNrPXsoKSA9PiBjb25zb2xlLmxvZygnc3BlZWQgRCcpfT4gRCA8L1NwZWVkRGlhbEl0ZW0+XG4gICA8L1NwZWVkRGlhbD5cbiAgKi9cbmNvbnN0IEZhYiA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1mYWInKTtcblxuRmFiLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIGJ1dHRvbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgcmlwcGxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSWYgdHJ1ZSwgIHRoZSBidXR0b24gd2lsbCBoYXZlIGEgcmlwcGxlIGVmZmVjdCB3aGVuIHRhcHBlZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICByaXBwbGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBwb3NpdGlvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBwb3NpdGlvbiBvZiB0aGUgYnV0dG9uLiBTaG91bGQgYmUgYSBzdHJpbmcgbGlrZSBgXCJib3R0b20gcmlnaHRcImAgb3IgYFwidG9wIGxlZnRcImAuIElmIHRoaXMgYXR0cmlidXRlIGlzIG5vdCBkZWZpbmVkIGl0IHdpbGwgYmUgZGlzcGxheWVkIGFzIGFuIGlubGluZSBlbGVtZW50LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHBvc2l0aW9uOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBJZiB0cnVlLCB0aGUgYnV0dG9uIHdpbGwgYmUgZGlzYWJsZWQuIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25DbGlja1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhpcyBmdW5jdGlvbiB3aWxsIGJlIGNhbGxlZCBvbmVzIHRoZSBidXR0b24gaXMgY2xpY2tlZC4gWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DbGljazogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbmV4cG9ydCBkZWZhdWx0IEZhYjtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1nZXN0dXJlLWRldGVjdG9yJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IHByb3BUeXBlcyA9IHtcblxuICAvKipcbiAgICogQG5hbWUgb25EcmFnXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIGRyYWdzIGluIGFueSBkaXJlY3Rpb24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25EcmFnOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EcmFnTGVmdFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciBkcmFncyBsZWZ0LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRHJhZ0xlZnQ6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkRyYWdSaWdodFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciBkcmFncyByaWdodC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRyYWdSaWdodDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uRHJhZ1VwXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIGRyYWdzIHVwLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRHJhZ1VwOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EcmFnRG93blxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciBkcmFncyBkb3duLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRHJhZ0Rvd246IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkhvbGRcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIHVzZXIgaG9sZHMuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Ib2xkOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25SZWxlYXNlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIHJlbGVhc2VzLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUmVsZWFzZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uU3dpcGVcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIHVzZXIgc3dpcGVzIGluIGFueSBkaXJlY3Rpb24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Td2lwZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uU3dpcGVMZWZ0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIHN3aXBlcyBsZWZ0LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uU3dpcGVMZWZ0OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Td2lwZVJpZ2h0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIHN3aXBlcyByaWdodC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblN3aXBlUmlnaHQ6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblN3aXBlVXBcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIHVzZXIgc3dpcGVzIHVwLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uU3dpcGVVcDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uU3dpcGVEb3duXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIHN3aXBlcyBkb3duLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uU3dpcGVEb3duOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25UYXBcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIHVzZXIgdGFwcy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblRhcDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uRG91YmxlVGFwXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIGRvdWJsZSB0YXBzLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRG91YmxlVGFwOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25QaW5jaFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciBwaW5jaGVzIGluIG9yIG91dC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBpbmNoOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25QaW5jaEluXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB1c2VyIHBpbmNoZXMgaW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QaW5jaEluOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25QaW5jaE91dFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciBwaW5jaGVzIG91dC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBpbmNoT3V0OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Ub3VjaFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciB0b3VjaGVzLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uVG91Y2g6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblRyYW5zZm9ybVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgdXNlciB0cmFuc2Zvcm1zLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uVHJhbnNmb3JtOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Sb3RhdGVcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIHVzZXIgcm90YXRlcy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblJvdGF0ZTogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1nZXN0dXJlLWRldGVjdG9yXG4gKiBAY2F0ZWdvcnkgZ2VzdHVyZVxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9nZXN0dXJlLWRldGVjdG9yXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1Db21wb25lbnQgdG8gZGV0ZWN0IGZpbmdlciBnZXN0dXJlcyB3aXRoaW4gYSB3cmFwcGVkIGVsZW1lbnQuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqIDxHZXN0dXJlRGV0ZWN0b3JcbiAqICAgb25UYXA9eygpID0+IGNvbnNvbGUubG9nKCd0YXAnKX1cbiAqICAgb25Td2lwZWxlZnQ9eygpID0+IGNvbnNvbGUubG9nKCdzd2lwZSBsZWZ0Jyl9XG4gKiA+XG4gKiAgIDxkaXYgc3R5bGU9e3tiYWNrZ3JvdW5kQ29sb3I6ICdwaW5rJywgd2lkdGg6ICcxMDBweCcsIGhlaWdodDogJzEwMHB4J319PlxuICogICAgIFN3aXBlIEhlcmVcbiAqICAgPC9kaXY+XG4gKiA8L0dlc3R1cmVEZXRlY3Rvcj5cbiAqXG4gKi9cbmNvbnN0IEdlc3R1cmVEZXRlY3RvciA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1nZXN0dXJlLWRldGVjdG9yJywge3Byb3BUeXBlc30pO1xuR2VzdHVyZURldGVjdG9yLnByb3BUeXBlcyA9IHByb3BUeXBlcztcblxuZXhwb3J0IGRlZmF1bHQgR2VzdHVyZURldGVjdG9yO1xuIiwiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1pY29uJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IHBhcnNlSWNvbiA9IGljb24gPT4ge1xuICBpZiAoaWNvbikge1xuICAgIGlmICgodHlwZW9mIGljb24pID09PSAnc3RyaW5nJykge1xuICAgICAgcmV0dXJuIGljb247XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhpY29uKS5maWx0ZXIoKGEpID0+IGEgIT09ICdkZWZhdWx0Jyk7XG4gICAgICBjb25zdCBpbm5lclN0cmluZyA9IGtleXMubWFwKChrZXkpID0+IGtleSArICc6JyArIGljb25ba2V5XSArICcnKTtcbiAgICAgIHJldHVybiBpY29uLmRlZmF1bHQgKyAnLCAnICsgaW5uZXJTdHJpbmcuam9pbignLCcpO1xuICAgIH1cbiAgfVxufTtcblxuY29uc3QgcGFyc2VTaXplID0gc2l6ZSA9PiB7XG4gIGlmIChzaXplKSB7XG4gICAgaWYgKCh0eXBlb2Ygc2l6ZSkgPT09ICdudW1iZXInKSB7XG4gICAgICByZXR1cm4gYCR7c2l6ZX1weGA7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhzaXplKS5maWx0ZXIoKGEpID0+IGEgIT09ICdkZWZhdWx0Jyk7XG4gICAgICBjb25zdCBpbm5lclN0cmluZyA9IGtleXMubWFwKChrZXkpID0+IGtleSArICc6JyArIHNpemVba2V5XSArICdweCcpO1xuICAgICAgcmV0dXJuIHNpemUuZGVmYXVsdCArICdweCwgJyArIGlubmVyU3RyaW5nLmpvaW4oJywnKTtcbiAgICB9XG4gIH1cbn07XG5cbmNvbnN0IEVsZW1lbnQgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtaWNvbicpO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtaWNvblxuICogQGNhdGVnb3J5IHZpc3VhbFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9pY29uXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqIERpc3BsYXlzIGFuIGljb24uIFRoZSBmb2xsb3dpbmcgaWNvbiBzdWl0ZXMgYXJlIGF2YWlsYWJsZTpcbiAqICAgKiAgW0ZvbnQgQXdlc29tZV0oaHR0cHM6Ly9mb3J0YXdlc29tZS5naXRodWIuaW8vRm9udC1Bd2Vzb21lLylcbiAqICAgKiAgW0lvbmljb25zXShodHRwOi8vaW9uaWNvbnMuY29tLylcbiAqICAgKiAgW01hdGVyaWFsIERlc2lnbiBJY29uaWMgRm9udF0oaHR0cDovL3phdm9sb2tsb20uZ2l0aHViLmlvL21hdGVyaWFsLWRlc2lnbi1pY29uaWMtZm9udC8pXG4gKiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICA8SWNvblxuICAgIHNpemU9e3tkZWZhdWx0OiAzMiwgbWF0ZXJpYWw6IDQwfX1cbiAgICBpY29uPXt7ZGVmYXVsdDogJ2lvbi1uYXZpY29uJywgbWF0ZXJpYWw6ICdtZC1tZW51J319XG4gIC8+XG4qL1xuY29uc3QgSWNvbiA9IFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCByZWYpID0+IHtcbiAgY29uc3Qge2ljb24sIHNpemUsIC4uLnJlc3R9ID0gcHJvcHM7XG5cbiAgcmV0dXJuIChcbiAgICA8RWxlbWVudFxuICAgICAgaWNvbj17cGFyc2VJY29uKGljb24pfVxuICAgICAgc2l6ZT17cGFyc2VTaXplKHNpemUpfVxuICAgICAgey4uLnJlc3R9XG4gICAgICByZWY9e3JlZn1cbiAgICA+XG4gICAgICB7cHJvcHMuY2hpbGRyZW59XG4gICAgPC9FbGVtZW50PlxuICApO1xufSk7XG5cbkljb24ucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgaWNvbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgaWNvblxuICAgKiBAdHlwZSAnb2JqZWN0IG9yIHN0cmluZydcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIGNhbiBiZSBlaXRoZXIgYSBzdHJpbmcgb3IgYW4gb2JqZWN0LiBJZiBpdCBpcyBhbiBzdHJpbmcsIGl0IGlzIHNldCB0byBhbiBzcGVjaWZpYyBpY29uIGxpa2UgJ2lvbnMtbmF2aWNvbicuIElmIGl0IGlzIGFuIG9iamVjdCwgaXQgcmVwcmVzZW50cyBhIGRpY3Rpb25hcnkgb2YgdGhlIGljb25zIGRlcGVuZGluZyBvbiB0aGUgbW9kaWZpZXIgZS5nLiAgIGB7e2RlZmF1bHQ6ICdpb24tbmF2aWNvbicsIG1hdGVyaWFsOiAnbWQtbWVudSd9fWAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaWNvbjogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgUHJvcFR5cGVzLnN0cmluZyxcbiAgICBQcm9wVHlwZXMub2JqZWN0T2YoUHJvcFR5cGVzLnN0cmluZylcbiAgXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIHNpemVcbiAgICogQHR5cGUgJ29iamVjdCBvciBudW1iZXInXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBjYW4gYmUgZWl0aGVyIGEgbnVtYmVyIG9yIGFuIG9iamVjdC4gSWYgaXQgaXMgYW4gbnVtYmVyLCBpdCAgc3BlY2lmaWVzIHRoZSBpY29uIHNpemUgd2l0aCBhIG51bWJlciBpbiBwaXhlbHMuIElmIGl0IGlzIGFuIG9iamVjdCwgaXQgcmVwcmVzZW50cyBhIGRpY3Rpb25hcnkgb2YgdGhlIGljb24gc2l6ZXMgZGVwZW5kaW5nIG9uIHRoZSBtb2RpZmllciBlLmcuICAgYHt7ZGVmYXVsdDogMjAsIG1hdGVyaWFsOiAxOH19YCBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBzaXplOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICBQcm9wVHlwZXMubnVtYmVyLFxuICAgIFByb3BUeXBlcy5vYmplY3RPZihQcm9wVHlwZXMubnVtYmVyKVxuICBdKSxcblxuICAvKipcbiAgICogQG5hbWUgcm90YXRlXG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gTnVtYmVyIG9mIGRlZ3JlZXMgdG8gcm90YXRlIHRoZSBpY29uLiBWYWxpZCB2YWx1ZXMgYXJlIDkwLCAxODAgYW5kIDI3MC4gWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgcm90YXRlOiBQcm9wVHlwZXMub25lT2YoWzAsIDkwLCAxODAsIDI3MF0pLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBmaXhlZFdpZHRoXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqIFtlbl0gV2hlbiB1c2VkIGluIGEgbGlzdCwgeW91IHdhbnQgdGhlIGljb25zIHRvIGhhdmUgdGhlIHNhbWUgd2lkdGggc28gdGhhdCB0aGV5IGFsaWduIHZlcnRpY2FsbHkgYnkgZGVmaW5pbmcgdGhpcyBhdHRyaWJ1dGUuIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGZpeGVkV2lkdGg6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBzcGluXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqIFtlbl0gU3BlY2lmeSB3aGV0aGVyIHRoZSBpY29uIHNob3VsZCBiZSBzcGlubmluZy4gWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc3BpbjogUHJvcFR5cGVzLmJvb2xcbn07XG5cbmV4cG9ydCBkZWZhdWx0IEljb247XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtaW5wdXQnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcbmltcG9ydCBvbmVUaW1lUHJvcCBmcm9tICcuLi9vbmVUaW1lUHJvcCc7XG5pbXBvcnQgSU5QVVRfUFJPUFMgZnJvbSAnLi4vaW5wdXRQcm9wcyc7XG5cbmNvbnN0IG5hbWVNYXAgPSB7XG4gIC4uLklOUFVUX1BST1BTXG59O1xuXG5jb25zdCB3aXRoRGVmYXVsdFZhbHVlID0gY29tcG9uZW50ID0+IG9uZVRpbWVQcm9wKGNvbXBvbmVudCwgJ2RlZmF1bHRWYWx1ZScsICd2YWx1ZScpO1xuXG5jb25zdCBub3RBdHRyaWJ1dGVzID0gW1xuICAndmFsdWUnIC8vIHZhbHVlIG11c3QgYmUgYXBwbGllZCBhcyBwcm9wZXJ0eSBzaW5jZSBhdHRyaWJ1dGUgb25seSB3b3JrcyBiZWZvcmUgaW5wdXQgaXMgdG91Y2hlZFxuXTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWlucHV0XG4gKiBAY2F0ZWdvcnkgZm9ybVxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9pbnB1dFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dXG4gKiBBbiBpbnB1dCBlbGVtZW50LiBUaGUgYHR5cGVgIGF0dHJpYnV0ZSBjYW4gYmUgdXNlZCB0byBjaGFuZ2UgdGhlIGlucHV0IHR5cGUuIEFsbCB0ZXh0IGlucHV0IHR5cGVzIGFzIHdlbGwgYXMgYGNoZWNrYm94YCBhbmQgYHJhZGlvYCBhcmUgc3VwcG9ydGVkLiBUaGUgY29tcG9uZW50IHdpbGwgYXV0b21hdGljYWxseSByZW5kZXIgYXMgYSBNYXRlcmlhbCBEZXNpZ24gaW5wdXQgb24gQW5kcm9pZCBkZXZpY2VzLiBNb3N0IGF0dHJpYnV0ZXMgdGhhdCBjYW4gYmUgdXNlZCBmb3IgYSBub3JtYWwgYDxpbnB1dD5gIGVsZW1lbnQgY2FuIGFsc28gYmUgdXNlZCBvbiB0aGUgYDxvbnMtaW5wdXQ+YCBlbGVtZW50Li5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPElucHV0XG4gKiAgIHZhbHVlPXt0aGlzLnN0YXRlLnRleHR9IGZsb2F0XG4gKiAgIG9uQ2hhbmdlPXsoZXZlbnQpID0+IHsgdGhpcy5zZXRTdGF0ZSh7dGV4dDogZXZlbnQudGFyZ2V0LnZhbHVlfSl9IH1cbiAqICAgbW9kaWZpZXI9J21hdGVyaWFsJ1xuICogICBwbGFjZWhvbGRlcj0nVXNlcm5hbWUnIC8+XG4gKi9cbmNvbnN0IElucHV0ID0gd2l0aERlZmF1bHRWYWx1ZShvbnNDdXN0b21FbGVtZW50KCdvbnMtaW5wdXQnLCB7ZGVwcmVjYXRlZDogbmFtZU1hcCwgbm90QXR0cmlidXRlc30pKTtcblxuSW5wdXQucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgaW5wdXQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGlucHV0IGlzIGRpc2FibGVkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgcmVhZE9ubHlcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TcGVjaWZpZXMgd2hldGhlciB0aGUgaW5wdXQgaXMgcmVhZC1vbmx5LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHJlYWRPbmx5OiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25DaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIGlubmVyIGlucHV0IGZpcmVzIGEgYGNoYW5nZWAgZXZlbnQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbklucHV0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSBpbm5lciBpbnB1dCBmaXJlcyBhbiBgaW5wdXRgIGV2ZW50LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uSW5wdXQ6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSB2YWx1ZVxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ29udGVudCBvZiB0aGUgaW5wdXQgKGNvbnRyb2xsZWQpLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHZhbHVlOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIFByb3BUeXBlcy5pbnN0YW5jZU9mKERhdGUpXG4gIF0pLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkZWZhdWx0VmFsdWVcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNvbnRlbnQgb2YgdGhlIGlucHV0IGF0IGZpcnN0IHJlbmRlciAodW5jb250cm9sbGVkKS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkZWZhdWx0VmFsdWU6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgUHJvcFR5cGVzLmluc3RhbmNlT2YoRGF0ZSlcbiAgXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIHBsYWNlaG9sZGVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gUGxhY2Vob2xkZXIgdGV4dC4gSW4gTWF0ZXJpYWwgRGVzaWduIHRoaXMgcGxhY2Vob2xkZXIgd2lsbCBiZSBhIGZsb2F0aW5nIGxhYmVsLiBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBwbGFjZWhvbGRlcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgdHlwZVxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICAgIFNwZWNpZnkgdGhlIGlucHV0IHR5cGUuIFRoaXMgaXMgdGhlIHNhbWUgYXMgdGhlIFwidHlwZVwiIGF0dHJpYnV0ZSBmb3Igbm9ybWFsIGlucHV0cy4gSXQgZXhwZWN0cyBzdHJpY3QgdGV4dCB0eXBlcyBzdWNoIGFzIGB0ZXh0YCwgYHBhc3N3b3JkYCwgZXRjLiBGb3IgY2hlY2tib3gsIHJhZGlvIGJ1dHRvbiwgc2VsZWN0IG9yIHJhbmdlLCBwbGVhc2UgaGF2ZSBhIGxvb2sgYXQgdGhlIGNvcnJlc3BvbmRpbmcgY29tcG9uZW50cy5cbiAgICpcbiAgICogICAgUGxlYXNlIHRha2UgYSBsb29rIGF0IFtNRE5dKGh0dHBzOi8vZGV2ZWxvcGVyLm1vemlsbGEub3JnL2VuLVVTL2RvY3MvV2ViL0hUTUwvRWxlbWVudC9pbnB1dCNhdHRyLXR5cGUpIGZvciBhbiBleGhhdXN0aXZlIGxpc3Qgb2YgcG9zc2libGUgdmFsdWVzLiBEZXBlbmRpbmcgb24gdGhlIHBsYXRmb3JtIGFuZCBicm93c2VyIHZlcnNpb24gc29tZSBvZiB0aGVzZSBtaWdodCBub3Qgd29yay5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHR5cGU6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlucHV0SWRcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSAgU3BlY2lmeSB0aGUgXCJpZFwiIGF0dHJpYnV0ZSBvZiB0aGUgaW5uZXIgYDxpbnB1dD5gIGVsZW1lbnQuIFRoaXMgaXMgdXNlZnVsIHdoZW4gdXNpbmcgPGxhYmVsIGZvcj1cIi4uLlwiPiBlbGVtZW50cyBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpbnB1dElkOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBmbG9hdFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSAgSWYgdGhpcyBhdHRyaWJ1dGUgaXMgcHJlc2VudCwgdGhlIHBsYWNlaG9sZGVyIHdpbGwgYmUgYW5pbWF0ZWQgaW4gTWF0ZXJpYWwgRGVzaWduLiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZmxvYXQ6IFByb3BUeXBlcy5ib29sXG59O1xuXG5leHBvcnQgZGVmYXVsdCBJbnB1dDtcbiIsImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtbGlzdCc7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG5jb25zdCBFbGVtZW50ID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLWxpc3QnKTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWxpc3RcbiAqIEBjYXRlZ29yeSBsaXN0XG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL2xpc3RcbiAqIEBkZXNjcmlwdGlvblxuICogICBbZW5dXG4gKiAgICAgQ29tcG9uZW50IGZvciByZXByZXNlbnRpbmcgYSBsaXN0LiBJdCB0YWtlcyBhbiBhcnJheSBjYWxsZWQgZGF0YXNvdXJjZSBhbmQgY2FsbHMgcmVuZGVyUm93KHJvdywgaW5kZXgpIGZvciBldmVyeSByb3cuICBGdXJ0aGVybW9yZSwgdGhlIGhlYWRlciBhbmQgdGhlIGZvb3RlciBjYW4gYmUgc3BlY2lmaWVkIHdpdGggYHJlbmRlclJvd2AgYW5kIGByZW5kZXJIZWFkZXJgIHJlc3BlY3RpdmVseS4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAgPExpc3RcbiAgICBkYXRhU291cmNlPXtbJ1JvdyAxJywgJ1JvdyAyJ119XG4gICAgcmVuZGVySGVhZGVyPXt0aGlzLnJlbmRlckhlYWRlcn1cbiAgICByZW5kZXJSb3c9eyhyb3csIGlkeCkgPT4gKFxuICAgICAgPExpc3RJdGVtIG1vZGlmaWVyPXtpZHggPT09IHRoaXMuc3RhdGUuZGF0YS5sZW5ndGggLSAxID8gJ2xvbmdkaXZpZGVyJyA6IG51bGx9PlxuICAgICAge3Jvd31cbiAgPEJ1dHRvbiBtb2RpZmllcj1cInF1aWV0XCIgb25DbGljaz17dGhpcy5yZW1vdmUuYmluZCh0aGlzLCBpZHgpfT5SZW1vdmU8L0J1dHRvbj5cbiAgPC9MaXN0SXRlbT5cbiAgKX1cbiAgcmVuZGVyRm9vdGVyPXt0aGlzLnJlbmRlckZvb3Rlcn1cbiAgLz5cbiAqL1xuY29uc3QgTGlzdCA9IFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCByZWYpID0+IHtcbiAgY29uc3Qge3JlbmRlckhlYWRlciwgcmVuZGVyRm9vdGVyLCByZW5kZXJSb3csIGRhdGFTb3VyY2UsIC4uLnJlc3R9ID0gcHJvcHM7XG5cbiAgY29uc3Qgcm93cyA9IGRhdGFTb3VyY2UubWFwKChkYXRhLCBpbmRleCkgPT4gcmVuZGVyUm93KGRhdGEsIGluZGV4KSk7XG5cbiAgcmV0dXJuIChcbiAgICA8RWxlbWVudFxuICAgICAgey4uLnJlc3R9XG4gICAgICByZWY9e3JlZn1cbiAgICA+XG4gICAgICB7cmVuZGVySGVhZGVyKCl9XG4gICAgICB7cm93c31cbiAgICAgIHtwcm9wcy5jaGlsZHJlbn1cbiAgICAgIHtyZW5kZXJGb290ZXIoKX1cbiAgICA8L0VsZW1lbnQ+XG4gICk7XG59KTtcblxuTGlzdC5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBTcGVjaWZ5IG1vZGlmaWVyIG5hbWUgdG8gc3BlY2lmeSBjdXN0b20gc3R5bGVzLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRhdGFTb3VyY2VcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgICBTb3VyY2Ugb2YgdGhlIGxpc3QgZGF0YS4gU2hvdWxkIGJlIGFuIGFycmF5LlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZGF0YVNvdXJjZTogUHJvcFR5cGVzLmFycmF5LFxuXG4gIC8qKlxuICAgKiBAbmFtZSByZW5kZXJSb3dcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBGdW5jdGlvbiB0byBzcGVjaWZ5IHRoZSByZW5kZXJpbmcgZnVuY3Rpb24gZm9yIGV2ZXJ5IGVsZW1lbnQgaW5cbiAgICogIGluIHRoZSBkYXRhU291cmNlLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgcmVuZGVyUm93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgcmVuZGVySGVhZGVyXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgRnVuY3Rpb24gdG8gc3BlY2lmeSB0aGUgcmVuZGVyaW5nIGZ1bmN0aW9uIGZvciB0aGUgaGVhZGVyXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICByZW5kZXJIZWFkZXI6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSByZW5kZXJGb290ZXJcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBGdW5jdGlvbiB0byBzcGVjaWZ5IHRoZSByZW5kZXJpbmcgZnVuY3Rpb24gZm9yIHRoZSBmb290ZXJcbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHJlbmRlckZvb3RlcjogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbkxpc3QuZGVmYXVsdFByb3BzID0ge1xuICBkYXRhU291cmNlOiBbXSxcbiAgcmVuZGVyUm93OiAoKSA9PiBudWxsLFxuICByZW5kZXJIZWFkZXI6ICgpID0+IG51bGwsXG4gIHJlbmRlckZvb3RlcjogKCkgPT4gbnVsbFxufTtcblxuZXhwb3J0IGRlZmF1bHQgTGlzdDtcbiIsImltcG9ydCBSZWFjdCwgeyB1c2VSZWYsIHVzZUVmZmVjdCwgdXNlU3RhdGUgfSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtbGF6eS1yZXBlYXQnO1xuXG5pbXBvcnQgTGlzdCBmcm9tICcuL0xpc3QnO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtbGF6eS1yZXBlYXRcbiAqIEBjYXRlZ29yeSBsaXN0XG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL2xhenktbGlzdFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dIFVzaW5nIHRoaXMgY29tcG9uZW50IGEgbGlzdCB3aXRoIG1pbGxpb25zIG9mIGl0ZW1zIGNhbiBiZSByZW5kZXJlZCB3aXRob3V0IGEgZHJvcCBpbiBwZXJmb3JtYW5jZS5cbiAqICAgICBJdCBkb2VzIHRoYXQgYnkgXCJsYXppbHlcIiBsb2FkaW5nIGVsZW1lbnRzIGludG8gdGhlIERPTSB3aGVuIHRoZXkgY29tZSBpbnRvIHZpZXcgYW5kXG4gKiAgICAgcmVtb3ZpbmcgaXRlbXMgZnJvbSB0aGUgRE9NIHdoZW4gdGhleSBhcmUgbm90IHZpc2libGUuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqXG4gIHJlbmRlclJvdyhpbmRleCkge1xuICAgIHJldHVybiAoXG4gICAgICA8TGlzdEl0ZW0ga2V5PXtpbmRleH0+XG4gICAgICAgIHsnSXRlbSAnICsgKGluZGV4ICsgMSl9XG4gICAgICA8L0xpc3RJdGVtPlxuICAgICk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxQYWdlIHJlbmRlclRvb2xiYXI9eygpID0+IDxNeVRvb2xiYXIgdGl0bGU9J0xhenlMaXN0JyAvPn0gPlxuICAgICAgICA8ZGl2IHN0eWxlPXt7aGVpZ2h0OiAxMDB9fT5cbiAgICAgICAgICA8TGF6eUxpc3RcbiAgICAgICAgICAgIGxlbmd0aD17MTAwMH1cbiAgICAgICAgICAgIHJlbmRlclJvdz17KCkgPT5cbiAgICAgICAgICAgICAgPExpc3RJdGVtIGtleT17aW5kZXh9PlxuICAgICAgICAgICAgICAgIHsnSXRlbSAnICsgKGluZGV4ICsgMSl9XG4gICAgICAgICAgICAgIDwvTGlzdEl0ZW0+XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBjYWxjdWxhdGVJdGVtSGVpZ2h0PXsoKSA9PiA0NH1cbiAgICAgICAgICAvPlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvUGFnZT5cbiAgICApO1xuICB9XG59XG4gKi9cbmNvbnN0IExhenlMaXN0ID0gUmVhY3QuZm9yd2FyZFJlZigocHJvcHMsIGZvcndhcmRlZFJlZikgPT4ge1xuICBjb25zdCByZWYgPSBmb3J3YXJkZWRSZWYgfHwgdXNlUmVmKCk7XG4gIGNvbnN0IFtjaGlsZHJlbiwgc2V0Q2hpbGRyZW5dID0gdXNlU3RhdGUoW10pO1xuICBjb25zdCBbLCBzZXRVcGRhdGVUb3BdID0gdXNlU3RhdGUoKTtcblxuICBjb25zdCB7Y2FsY3VsYXRlSXRlbUhlaWdodCwgcmVuZGVyUm93LCBsZW5ndGgsIC4uLnJlc3R9ID0gcHJvcHM7XG5cbiAgdXNlRWZmZWN0KCgpID0+IHtcbiAgICByZWYuY3VycmVudC5kZWxlZ2F0ZSA9IHtcbiAgICAgIGNhbGN1bGF0ZUl0ZW1IZWlnaHQ6IGZ1bmN0aW9uKGluZGV4KSB7XG4gICAgICAgIHJldHVybiBjYWxjdWxhdGVJdGVtSGVpZ2h0KGluZGV4KTtcbiAgICAgIH0sXG4gICAgICBfcmVuZGVyOiBmdW5jdGlvbihzdGFydCwgbGltaXQsIHVwZGF0ZVRvcCkge1xuICAgICAgICBjb25zdCBlbCA9IFtdO1xuICAgICAgICBmb3IgKGxldCBpID0gc3RhcnQ7IGkgPCBsaW1pdDsgaSsrKSB7XG4gICAgICAgICAgZWwucHVzaChyZW5kZXJSb3coaSkpO1xuICAgICAgICB9XG4gICAgICAgIHNldENoaWxkcmVuKGVsKTtcbiAgICAgICAgc2V0VXBkYXRlVG9wKHVwZGF0ZVRvcCk7IC8vIGRvZXNuJ3Qgd29yayB3aXRob3V0IHRoaXMsIGJ1dCB3aHk/IGRvZXMgaXQganVzdCB0cmlnZ2VyIGEgcmVyZW5kZXI/XG4gICAgICB9LFxuICAgICAgY291bnRJdGVtczogZnVuY3Rpb24oKSB7XG4gICAgICAgIHJldHVybiBsZW5ndGg7XG4gICAgICB9XG4gICAgfTtcbiAgfSwgW2NhbGN1bGF0ZUl0ZW1IZWlnaHQsIHJlbmRlclJvdywgbGVuZ3RoXSk7XG5cbiAgcmV0dXJuIChcbiAgICA8TGlzdFxuICAgICAgey4uLnJlc3R9XG4gICAgICBzdHlsZT17e3Bvc2l0aW9uOiAncmVsYXRpdmUnfX1cbiAgICA+XG4gICAgICA8b25zLWxhenktcmVwZWF0IHJlZj17cmVmfSAvPlxuICAgICAge2NoaWxkcmVufVxuICAgIDwvTGlzdD5cbiAgKTtcbn0pO1xuXG5MYXp5TGlzdC5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBsYXp5IGxpc3QuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGxlbmd0aFxuICAgKiBAdHlwZSBudW1iZXJcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGxlbmd0aCBvZiB0aGUgbGlzdC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBsZW5ndGg6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCxcblxuICAvKipcbiAgICogQG5hbWUgcmVuZGVyUm93XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBBIGZ1bmN0aW9uIGdpdmVuIHRoZSBpbmRleCBvZiB0aGUgdG8gZGlzcGxheSByb3csIHJlbmRlcnMgaXQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgcmVuZGVyUm93OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBjYWxjdWxhdGVJdGVtSGVpZ2h0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBBIGZ1bmN0aW9uIGdpdmVuIHRoZSBpbmRleCBvZiB0aGUgdG8gcm93LCByZXR1cm5zIHRoZSBoZWlnaHQgb2YgaXQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgY2FsY3VsYXRlSXRlbUhlaWdodDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZFxufTtcblxuZXhwb3J0IGRlZmF1bHQgTGF6eUxpc3Q7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtbGlzdC1oZWFkZXInO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLWxpc3QtaGVhZGVyXG4gKiBAY2F0ZWdvcnkgbGlzdFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9saXN0XG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gSGVhZGVyIGVsZW1lbnQgZm9yIGxpc3QgaXRlbXMuIE11c3QgYmUgcHV0IGluc2lkZSBvbnMtbGlzdCBjb21wb25lbnQuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAgIDxMaXN0XG4gICAgIGRhdGFTb3VyY2U9e3RoaXMuc3RhdGUuZGF0YX1cbiAgICAgcmVuZGVySGVhZGVyPXsoKSA9PlxuICAgICAgICA8TGlzdEhlYWRlciBzdHlsZT17e2ZvbnRTaXplOiAxNX19IGNsYXNzTmFtZT1cInRlc3RDbGFzc1wiPiBIZWFkZXIgVGV4dCA8L0xpc3RIZWFkZXI+IH1cbiAgICByZW5kZXJSb3c9eyhyb3csIGlkeCkgPT4gKFxuICAgICAgPExpc3RJdGVtID4ge3Jvd30gPC9MaXN0SXRlbT5cbiAgICApfVxuICAvPlxuICovXG5jb25zdCBMaXN0SGVhZGVyID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLWxpc3QtaGVhZGVyJyk7XG5cbkxpc3RIZWFkZXIucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmeSBtb2RpZmllciBuYW1lIHRvIHNwZWNpZnkgY3VzdG9tIHN0eWxlcy4gT3B0aW9uYWwuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZ1xufTtcblxuZXhwb3J0IGRlZmF1bHQgTGlzdEhlYWRlcjtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1saXN0LWl0ZW0nO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3QgcHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIGxpc3QgaXRlbS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgdGFwcGFibGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZmllcyB3aGV0aGVyIHRoZSBsaXN0IGl0ZW0gaXMgdGFwcGFibGUuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB0YXBwYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHRhcEJhY2tncm91bmRDb2xvclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDaGFuZ2VzIHRoZSBiYWNrZ3JvdW5kIGNvbG9yIHdoZW4gdGFwcGVkLiBGb3IgdGhpcyB0byB3b3JrLCB0aGUgYXR0cmlidXRlIFwidGFwcGFibGVcIiBuZWVkcyB0byBiZSBzZXQuIFRoZSBkZWZhdWx0IGNvbG9yIGlzIFwiI2Q5ZDlkOVwiLiBJdCB3aWxsIGRpc3BsYXkgYXMgYSByaXBwbGUgZWZmZWN0IG9uIEFuZHJvaWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB0YXBCYWNrZ3JvdW5kQ29sb3I6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGxvY2tPbkRyYWdcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gUHJldmVudCB2ZXJ0aWNhbCBzY3JvbGxpbmcgd2hlbiB0aGUgdXNlciBkcmFncyBob3Jpem9udGFsbHkuIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGxvY2tPbkRyYWc6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBleHBhbmRhYmxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmaWVzIHdoZXRoZXIgbGlzdCBpdGVtIGNhbiBiZSBleHBhbmRlZCB0byByZXZlYWwgaGlkZGVuIGNvbnRlbnQuIEV4cGFuZGVkIGNvbnRlbnQgbXVzdCBiZSBkZWZpbmVkIGluIGBkaXYuZXhwYW5kYWJsZS1jb250ZW50YC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBleHBhbmRhYmxlOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgZXhwYW5kZWRcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Gb3IgZXhwYW5kYWJsZSBsaXN0IGl0ZW1zLCBzcGVjaWZpZXMgd2hldGhlciBpdGVtIGlzIGV4cGFuZGVkWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZXhwYW5kZWQ6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkV4cGFuZFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhpcyBmdW5jdGlvbiB3aWxsIGJlIGNhbGxlZCB3aGVuIHRoZSBleHBhbmRhYmxlIGxpc3QgaXRlbSBleHBhbmRzIG9yIGNvbnRyYWN0cy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkV4cGFuZDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFuaW1hdGlvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFuaW1hdGlvbiB1c2VkIHdoZW4gc2hvd2luZyBhbmQgaGlkaW5nIHRoZSBleHBhbmRhYmxlIGNvbnRlbnQuIENhbiBiZSBlaXRoZXIgXCJkZWZhdWx0XCIgb3IgXCJub25lXCIuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtbGlzdC1pdGVtXG4gKiBAY2F0ZWdvcnkgbGlzdFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9saXN0XG4gKiBAZGVzY3JpcHRpb25cbiAqICAgW2VuXVxuICogICBDb21wb25lbnQgdGhhdCByZXByZXNlbnRzIGVhY2ggaXRlbSBpbiB0aGUgbGlzdC4gTXVzdCBiZSBwdXQgaW5zaWRlIHRoZSBgTGlzdGAgY29tcG9uZW50LiBUaGUgbGlzdCBpdGVtIGlzIGNvbXBvc2VkIG9mIGZvdXIgcGFydHMgdGhhdCBhcmUgcmVwcmVzZW50ZWQgd2l0aCB0aGUgYGxlZnRgLCBgY2VudGVyYCwgYHJpZ2h0YCBhbmQgYGV4cGFuZGFibGUtY29udGVudGAgY2xhc3Nlcy4gVGhlc2UgY2xhc3NlcyBjYW4gYmUgdXNlZCB0byBlbnN1cmUgdGhhdCB0aGUgY29udGVudCBvZiB0aGUgbGlzdCBpdGVtcyBpcyBwcm9wZXJseSBhbGlnbmVkLlxuICogICBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICAgPExpc3RJdGVtPlxuICogICA8ZGl2IGNsYXNzTmFtZT1cImxlZnRcIj5MZWZ0PC9kaXY+XG4gKiAgIDxkaXYgY2xhc3NOYW1lPVwiY2VudGVyXCI+Q2VudGVyPC9kaXY+XG4gKiAgIDxkaXYgY2xhc3NOYW1lPVwicmlnaHRcIj5SaWdodDwvZGl2PlxuICogICA8ZGl2IGNsYXNzTmFtZT1cImV4cGFuZGFibGUtY29udGVudFwiPkV4cGFuZGFibGUgY29udGVudDwvZGl2PlxuICogPC9MaXN0SXRlbT5cbiAqL1xuY29uc3QgTGlzdEl0ZW0gPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtbGlzdC1pdGVtJywge3Byb3BUeXBlc30pO1xuTGlzdEl0ZW0ucHJvcFR5cGVzID0gcHJvcFR5cGVzO1xuXG5leHBvcnQgZGVmYXVsdCBMaXN0SXRlbTtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1saXN0LXRpdGxlJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IHByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZnkgbW9kaWZpZXIgbmFtZSB0byBzcGVjaWZ5IGN1c3RvbSBzdHlsZXMuIE9wdGlvbmFsLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmdcbn07XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1saXN0LXRpdGxlXG4gKiBAY2F0ZWdvcnkgbGlzdFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9saXN0XG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gVGl0bGUgZWxlbWVudCBmb3IgbGlzdHMuIFVzdWFsbHkgY29tZXMgYmVmb3JlIG9ucy1saXN0IGNvbXBvbmVudC5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPExpc3RUaXRsZT5MaXN0IFRpdGxlPC9MaXN0VGl0bGU+XG4gICA8TGlzdFxuICAgICBkYXRhU291cmNlPXt0aGlzLnN0YXRlLmRhdGF9XG4gICAgIHJlbmRlckhlYWRlcj17KCkgPT5cbiAgICAgICAgPExpc3RIZWFkZXIgc3R5bGU9e3tmb250U2l6ZTogMTV9fSBjbGFzc05hbWU9XCJ0ZXN0Q2xhc3NcIj4gSGVhZGVyIFRleHQgPC9MaXN0SGVhZGVyPiB9XG4gICAgcmVuZGVyUm93PXsocm93LCBpZHgpID0+IChcbiAgICAgIDxMaXN0SXRlbSA+IHtyb3d9IDwvTGlzdEl0ZW0+XG4gICAgKX1cbiAgLz5cbiAqL1xuY29uc3QgTGlzdFRpdGxlID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLWxpc3QtdGl0bGUnLCB7cHJvcFR5cGVzfSk7XG5MaXN0VGl0bGUucHJvcFR5cGVzID0gcHJvcFR5cGVzO1xuXG5leHBvcnQgZGVmYXVsdCBMaXN0VGl0bGU7XG4iLCJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFJlYWN0RE9NIGZyb20gJ3JlYWN0LWRvbSc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtbmF2aWdhdG9yJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IEVsZW1lbnQgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtbmF2aWdhdG9yJyk7XG5cbmNsYXNzIE5hdmlnYXRvckNsYXNzIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgY29uc3RydWN0b3IoLi4uYXJncykge1xuICAgIHN1cGVyKC4uLmFyZ3MpO1xuICAgIHRoaXMucmVmID0gUmVhY3QuY3JlYXRlUmVmKCk7XG4gICAgdGhpcy5wYWdlcyA9IFtdO1xuICAgIHRoaXMuc3RhdGUgPSB7IH07XG4gICAgdGhpcy5fcHJlUHVzaCA9IHRoaXMuX3ByZVB1c2guYmluZCh0aGlzKTtcbiAgICB0aGlzLl9wb3N0UHVzaCA9IHRoaXMuX3Bvc3RQdXNoLmJpbmQodGhpcyk7XG4gICAgdGhpcy5fcHJlUG9wID0gdGhpcy5fcHJlUG9wLmJpbmQodGhpcyk7XG4gICAgdGhpcy5fcG9zdFBvcCA9IHRoaXMuX3Bvc3RQb3AuYmluZCh0aGlzKTtcbiAgfVxuXG4gIHVwZGF0ZShwYWdlcywgb2JqKSB7XG4gICAgdGhpcy5wYWdlcyA9IHBhZ2VzIHx8IFtdO1xuICAgIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSkgPT4ge1xuICAgICAgdGhpcy5mb3JjZVVwZGF0ZShyZXNvbHZlKTtcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAbWV0aG9kIHJlc2V0UGFnZVxuICAgKiBAc2lnbmF0dXJlIHJlc2V0UGFnZShyb3V0ZSwgb3B0aW9ucyA9IHt9KVxuICAgKiBAcGFyYW0ge09iamVjdH0gcm91dGVcbiAgICogICBbZW5dIFRoZSByb3V0ZSB0aGF0IHRoZSBwYWdlIHNob3VsZCBiZSByZXNldCB0by5bL2VuXVxuICAgKiAgIFtqYV1bL2phXVxuICAgKiBAcmV0dXJuIHtQcm9taXNlfVxuICAgKiAgIFtlbl1Qcm9taXNlIHdoaWNoIHJlc29sdmVzIHRvIHRoZSByZXZlYWxlZCBwYWdlLlsvZW5dXG4gICAqICAgW2phXeaYjuOCieOBi+OBq+OBl+OBn+ODmuODvOOCuOOCkuino+axuuOBmeOCi1Byb21pc2XjgpLov5TjgZfjgb7jgZnjgIJbL2phXVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogICBbZW5dUmVzZXRzIHRoZSBjdXJyZW50IHBhZ2VbL2VuXVxuICAgKiAgIFtqYV1bL2phXVxuICAgKi9cbiAgcmVzZXRQYWdlKHJvdXRlLCBvcHRpb25zID0ge30pIHtcbiAgICByZXR1cm4gdGhpcy5yZXNldFBhZ2VTdGFjayhbcm91dGVdLCBvcHRpb25zKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAbWV0aG9kIHJlc2V0UGFnZVN0YWNrXG4gICAqIEBzaWduYXR1cmUgcmVzZXRQYWdlU3RhY2socm91dGUsIG9wdGlvbnMgPSB7fSlcbiAgICogQHBhcmFtIHtBcnJheX0gcm91dGVzXG4gICAqICAgW2VuXSBUaGUgcm91dGVzIHRoYXQgdGhlIG5hdmlnYXRvciBzaG91bGQgYmUgcmVzZXQgdG8uWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICogQHJldHVybiB7UHJvbWlzZX1cbiAgICogICBbZW5dUHJvbWlzZSB3aGljaCByZXNvbHZlcyB0byB0aGUgcmV2ZWFsZWQgcGFnZS5bL2VuXVxuICAgKiAgIFtqYV3mmI7jgonjgYvjgavjgZfjgZ/jg5rjg7zjgrjjgpLop6PmsbrjgZnjgotQcm9taXNl44KS6L+U44GX44G+44GZ44CCWy9qYV1cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICAgW2VuXSBSZXNldHMgdGhlIG5hdmlnYXRvciB0byB0aGUgY3VycmVudCBwYWdlIHN0YWNrWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICovXG4gIHJlc2V0UGFnZVN0YWNrKHJvdXRlcywgb3B0aW9ucyA9IHt9KSB7XG4gICAgaWYgKHRoaXMuaXNSdW5uaW5nKCkpIHtcbiAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnTmF2aWdhdG9yIGlzIGFscmVhZHkgcnVubmluZyBhbmltYXRpb24uJyk7XG4gICAgfVxuXG4gICAgY29uc3QgaGlkZVBhZ2VzID0gKCkgPT4ge1xuICAgICAgY29uc3QgcGFnZUVsZW1lbnRzID0gdGhpcy5yZWYuY3VycmVudC5wYWdlcztcbiAgICAgIGZvciAobGV0IGkgPSBwYWdlRWxlbWVudHMubGVuZ3RoIC0gMjsgaSA+PSAwOyBpLS0pIHtcbiAgICAgICAgcGFnZUVsZW1lbnRzW2ldLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSc7XG4gICAgICB9XG4gICAgfTtcblxuICAgIGlmIChvcHRpb25zLnBvcCkge1xuICAgICAgdGhpcy5yb3V0ZXNCZWZvcmVQb3AgPSB0aGlzLnJvdXRlcy5zbGljZSgpO1xuICAgICAgdGhpcy5yb3V0ZXNBZnRlclBvcCA9IHJvdXRlcztcbiAgICAgIHRoaXMucm91dGVzID0gcm91dGVzLmNvbmNhdChbdGhpcy5yb3V0ZXNbdGhpcy5yb3V0ZXMubGVuZ3RoIC0gMV1dKTtcblxuICAgICAgY29uc3QgdXBkYXRlID0gKCkgPT4ge1xuICAgICAgICB0aGlzLnBhZ2VzLnBvcCgpO1xuICAgICAgICB0aGlzLnJvdXRlcyA9IHJvdXRlcztcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlKSA9PiB0aGlzLmZvcmNlVXBkYXRlKHJlc29sdmUpKTtcbiAgICAgIH07XG5cbiAgICAgIHJldHVybiB0aGlzLnVwZGF0ZSh0aGlzLnBhZ2VzKVxuICAgICAgICAudGhlbigoKSA9PiB0aGlzLnJlZi5jdXJyZW50Ll9wb3BQYWdlKG9wdGlvbnMsIHVwZGF0ZSkpXG4gICAgICAgIC50aGVuKCgpID0+IGhpZGVQYWdlcygpKTtcbiAgICB9XG5cbiAgICBjb25zdCBsYXN0Um91dGUgPSByb3V0ZXNbcm91dGVzLmxlbmd0aCAtIDFdO1xuICAgIGNvbnN0IG5ld1BhZ2UgPSB0aGlzLnByb3BzLnJlbmRlclBhZ2UobGFzdFJvdXRlLCB0aGlzKTtcbiAgICB0aGlzLnJvdXRlcy5wdXNoKGxhc3RSb3V0ZSk7XG5cbiAgICBjb25zdCB1cGRhdGUgPSAoKSA9PiB7XG4gICAgICB0aGlzLnBhZ2VzLnB1c2gobmV3UGFnZSk7XG4gICAgICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUpID0+IHRoaXMuZm9yY2VVcGRhdGUocmVzb2x2ZSkpO1xuICAgIH07XG5cbiAgICByZXR1cm4gdGhpcy5yZWYuY3VycmVudC5fcHVzaFBhZ2Uob3B0aW9ucywgdXBkYXRlKS50aGVuKCgpID0+IHtcbiAgICAgIHRoaXMucm91dGVzID0gcm91dGVzO1xuICAgICAgdGhpcy5wYWdlcyA9IHJvdXRlcy5tYXAocm91dGUgPT4gdGhpcy5wcm9wcy5yZW5kZXJQYWdlKHJvdXRlLCB0aGlzKSk7XG4gICAgICByZXR1cm4gdGhpcy51cGRhdGUodGhpcy5wYWdlcykudGhlbigoKSA9PiBoaWRlUGFnZXMoKSk7XG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQG1ldGhvZCBwdXNoUGFnZVxuICAgKiBAc2lnbmF0dXJlIHB1c2hQYWdlKHJvdXRlLCBvcHRpb25zID0ge30pXG4gICAqIEBwYXJhbSB7T2JqZWN0fSByb3V0ZVxuICAgKiAgIFtlbl0gVGhlIHJvdXRlIHRoYXQgdGhlIG5hdmlnYXRvciBzaG91bGQgcHVzaCB0by5bL2VuXVxuICAgKiAgIFtqYV1bL2phXVxuICAgKiBAcmV0dXJuIHtQcm9taXNlfVxuICAgKiAgIFtlbl0gUHJvbWlzZSB3aGljaCByZXNvbHZlcyB0byB0aGUgcmV2ZWFsZWQgcGFnZS5bL2VuXVxuICAgKiAgIFtqYV3mmI7jgonjgYvjgavjgZfjgZ/jg5rjg7zjgrjjgpLop6PmsbrjgZnjgotQcm9taXNl44KS6L+U44GX44G+44GZ44CCWy9qYV1cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICAgW2VuXSBQdXNoZXMgYSBwYWdlIHRvIHRoZSBwYWdlIHN0YWNrWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICovXG4gIHB1c2hQYWdlKHJvdXRlLCBvcHRpb25zID0ge30pIHtcbiAgICBpZiAodGhpcy5pc1J1bm5pbmcoKSkge1xuICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdOYXZpZ2F0b3IgaXMgYWxyZWFkeSBydW5uaW5nIGFuaW1hdGlvbi4nKTtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUpID0+IHtcbiAgICAgIGNvbnN0IHVwZGF0ZSA9ICgpID0+IHtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlKSA9PiB7XG4gICAgICAgICAgdGhpcy5wYWdlcy5wdXNoKHRoaXMucHJvcHMucmVuZGVyUGFnZShyb3V0ZSwgdGhpcykpO1xuICAgICAgICAgIHRoaXMuZm9yY2VVcGRhdGUocmVzb2x2ZSk7XG4gICAgICAgIH0pO1xuICAgICAgfTtcblxuICAgICAgdGhpcy5yb3V0ZXMucHVzaChyb3V0ZSk7XG4gICAgICB0aGlzLnJlZi5jdXJyZW50XG4gICAgICAgIC5fcHVzaFBhZ2UoXG4gICAgICAgICAgb3B0aW9ucyxcbiAgICAgICAgICB1cGRhdGVcbiAgICAgICAgKVxuICAgICAgICAudGhlbihyZXNvbHZlKVxuICAgICAgICAuY2F0Y2goKGVycm9yKSA9PiB7XG4gICAgICAgICAgdGhpcy5yb3V0ZXMucG9wKCk7XG4gICAgICAgICAgdGhpcy5wYWdlcy5wb3AoKTtcbiAgICAgICAgICB0aHJvdyBlcnJvcjtcbiAgICAgICAgfSk7XG4gICAgfSk7XG4gIH1cblxuICBpc1J1bm5pbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMucmVmLmN1cnJlbnQuX2lzUnVubmluZztcbiAgfVxuXG4gIC8qXG4gICAqIEBtZXRob2QgcmVwbGFjZVBhZ2VcbiAgICogQHNpZ25hdHVyZSByZXBsYWNlUGFnZShyb3V0ZSwgW29wdGlvbnNdKVxuICAgKiBAcGFyYW0ge09iamVjdH0gcm91dGVcbiAgICogICBbZW5dIFRoZSByb3V0ZSB0aGF0IHRoZSBuYXZpZ2F0b3Igc2hvdWxkIHJlcGxhY2UgdGhlIHRvcCBwYWdlIHdpdGguWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICogQHJldHVybiB7UHJvbWlzZX1cbiAgICogICBbZW5dUHJvbWlzZSB3aGljaCByZXNvbHZlcyB0byB0aGUgbmV3IHBhZ2UuWy9lbl1cbiAgICogICBbamFd5paw44GX44GE44Oa44O844K444KS6Kej5rG644GZ44KLUHJvbWlzZeOCkui/lOOBl+OBvuOBmeOAglsvamFdXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgIFtlbl1SZXBsYWNlcyB0aGUgY3VycmVudCB0b3AgcGFnZSB3aXRoIHRoZSBzcGVjaWZpZWQgb25lLiBFeHRlbmRzIGBwdXNoUGFnZSgpYCBwYXJhbWV0ZXJzLlsvZW5dXG4gICAqICAgW2phXeePvuWcqOihqOekuuS4reOBruODmuODvOOCuOOCkuOCkuaMh+WumuOBl+OBn+ODmuODvOOCuOOBq+e9ruOBjeaPm+OBiOOBvuOBmeOAglsvamFdXG4gICAqL1xuICByZXBsYWNlUGFnZShyb3V0ZSwgb3B0aW9ucyA9IHt9KSB7XG4gICAgaWYgKHRoaXMuaXNSdW5uaW5nKCkpIHtcbiAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnTmF2aWdhdG9yIGlzIGFscmVhZHkgcnVubmluZyBhbmltYXRpb24uJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMucHVzaFBhZ2Uocm91dGUsIG9wdGlvbnMpLnRoZW4oKCkgPT4ge1xuICAgICAgY29uc3QgcG9zID0gdGhpcy5wYWdlcy5sZW5ndGggLSAyO1xuICAgICAgdGhpcy5wYWdlcy5zcGxpY2UocG9zLCAxKTtcbiAgICAgIHRoaXMucm91dGVzLnNwbGljZShwb3MsIDEpO1xuICAgICAgdGhpcy5yZWYuY3VycmVudC50b3BQYWdlLnVwZGF0ZUJhY2tCdXR0b24odGhpcy5wYWdlcy5sZW5ndGggPiAxKTtcbiAgICAgIHRoaXMuZm9yY2VVcGRhdGUoKTtcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAbWV0aG9kIHBvcFBhZ2VcbiAgICogQHNpZ25hdHVyZSBwb3BQYWdlKG9wdGlvbnMgPSB7fSlcbiAgICogQHJldHVybiB7UHJvbWlzZX1cbiAgICogICBbZW5dIFByb21pc2Ugd2hpY2ggcmVzb2x2ZXMgdG8gdGhlIHJldmVhbGVkIHBhZ2UuWy9lbl1cbiAgICogICBbamFd5piO44KJ44GL44Gr44GX44Gf44Oa44O844K444KS6Kej5rG644GZ44KLUHJvbWlzZeOCkui/lOOBl+OBvuOBmeOAglsvamFdXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgIFtlbl0gUG9wcyBhIHBhZ2Ugb3V0IG9mIHRoZSBwYWdlIHN0YWNrWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICovXG4gIHBvcFBhZ2Uob3B0aW9ucyA9IHt9KSB7XG4gICAgaWYgKHRoaXMuaXNSdW5uaW5nKCkpIHtcbiAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnTmF2aWdhdG9yIGlzIGFscmVhZHkgcnVubmluZyBhbmltYXRpb24uJyk7XG4gICAgfVxuXG4gICAgdGhpcy5yb3V0ZXNCZWZvcmVQb3AgPSB0aGlzLnJvdXRlcy5zbGljZSgpO1xuICAgIHRoaXMucm91dGVzQWZ0ZXJQb3AgPSB0aGlzLnJvdXRlc0JlZm9yZVBvcC5zbGljZSgwLCB0aGlzLnJvdXRlc0JlZm9yZVBvcC5sZW5ndGggLSAxKTtcblxuICAgIGNvbnN0IHVwZGF0ZSA9ICgpID0+IHtcbiAgICAgIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSkgPT4ge1xuICAgICAgICB0aGlzLnBhZ2VzLnBvcCgpO1xuICAgICAgICB0aGlzLnJvdXRlcy5wb3AoKTtcblxuICAgICAgICBSZWFjdERPTS5mbHVzaFN5bmMoKCkgPT4geyAvLyBwcmV2ZW50cyBmbGlja2VyaW5nIGNhdXNlZCBieSBSZWFjdCAxOCBiYXRjaGluZ1xuICAgICAgICAgIHRoaXMuZm9yY2VVcGRhdGUocmVzb2x2ZSk7XG4gICAgICAgIH0pO1xuICAgICAgfSk7XG4gICAgfTtcblxuICAgIHJldHVybiB0aGlzLnJlZi5jdXJyZW50Ll9wb3BQYWdlKG9wdGlvbnMsIHVwZGF0ZSk7XG4gIH1cblxuICBfb25EZXZpY2VCYWNrQnV0dG9uKGV2ZW50KSB7XG4gICAgaWYgKHRoaXMucGFnZXMubGVuZ3RoID4gMSkge1xuICAgICAgdGhpcy5wb3BQYWdlKCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGV2ZW50LmNhbGxQYXJlbnRIYW5kbGVyKCk7XG4gICAgfVxuICB9XG5cbiAgX3ByZVBvcChldmVudCkge1xuICAgIGlmIChldmVudC50YXJnZXQgIT09IHRoaXMucmVmLmN1cnJlbnQpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBldmVudC5yb3V0ZXMgPSB7XG4gICAgICBwb3BwaW5nUm91dGU6IHRoaXMucm91dGVzQmVmb3JlUG9wW3RoaXMucm91dGVzQmVmb3JlUG9wLmxlbmd0aCAtIDFdLFxuICAgICAgcm91dGVzOiB0aGlzLnJvdXRlc0JlZm9yZVBvcFxuICAgIH07XG5cbiAgICB0aGlzLnByb3BzLm9uUHJlUG9wKGV2ZW50KTtcbiAgfVxuXG4gIF9wb3N0UG9wKGV2ZW50KSB7XG4gICAgaWYgKGV2ZW50LnRhcmdldCAhPT0gdGhpcy5yZWYuY3VycmVudCkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGV2ZW50LnJvdXRlcyA9IHtcbiAgICAgIHBvcHBlZFJvdXRlOiB0aGlzLnJvdXRlc0JlZm9yZVBvcFt0aGlzLnJvdXRlc0JlZm9yZVBvcC5sZW5ndGggLSAxXSxcbiAgICAgIHJvdXRlczogdGhpcy5yb3V0ZXNBZnRlclBvcFxuICAgIH07XG5cbiAgICB0aGlzLnByb3BzLm9uUG9zdFBvcChldmVudCk7XG4gIH1cblxuICBfcHJlUHVzaChldmVudCkge1xuICAgIGlmIChldmVudC50YXJnZXQgIT09IHRoaXMucmVmLmN1cnJlbnQpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBldmVudC5yb3V0ZXMgPSB7XG4gICAgICBwdXNoaW5nUm91dGU6IHRoaXMucm91dGVzW3RoaXMucm91dGVzLmxlbmd0aCAtIDFdLFxuICAgICAgcm91dGVzOiB0aGlzLnJvdXRlcy5zbGljZSgwLCB0aGlzLnJvdXRlcy5sZW5ndGggLSAxKVxuICAgIH07XG5cbiAgICB0aGlzLnByb3BzLm9uUHJlUHVzaChldmVudCk7XG4gIH1cblxuICBfcG9zdFB1c2goZXZlbnQpIHtcbiAgICBpZiAoZXZlbnQudGFyZ2V0ICE9PSB0aGlzLnJlZi5jdXJyZW50KSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgZXZlbnQucm91dGVzID0ge1xuICAgICAgcHVzaGVkUm91dGU6IHRoaXMucm91dGVzW3RoaXMucm91dGVzLmxlbmd0aCAtIDFdLFxuICAgICAgcm91dGVzOiB0aGlzLnJvdXRlc1xuICAgIH07XG5cbiAgICB0aGlzLnByb3BzLm9uUG9zdFB1c2goZXZlbnQpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgY29uc3Qgbm9kZSA9IHRoaXMucmVmLmN1cnJlbnQ7XG4gICAgbm9kZS5wb3BQYWdlID0gdGhpcy5wb3BQYWdlLmJpbmQodGhpcyk7XG5cbiAgICBub2RlLmFkZEV2ZW50TGlzdGVuZXIoJ3ByZXB1c2gnLCB0aGlzLl9wcmVQdXNoKTtcbiAgICBub2RlLmFkZEV2ZW50TGlzdGVuZXIoJ3Bvc3RwdXNoJywgdGhpcy5fcG9zdFB1c2gpO1xuICAgIG5vZGUuYWRkRXZlbnRMaXN0ZW5lcigncHJlcG9wJywgdGhpcy5fcHJlUG9wKTtcbiAgICBub2RlLmFkZEV2ZW50TGlzdGVuZXIoJ3Bvc3Rwb3AnLCB0aGlzLl9wb3N0UG9wKTtcblxuICAgIG5vZGUuc3dpcGVNYXggPSB0aGlzLnByb3BzLnN3aXBlUG9wO1xuICAgIG5vZGUub25EZXZpY2VCYWNrQnV0dG9uID0gdGhpcy5wcm9wcy5vbkRldmljZUJhY2tCdXR0b24gfHwgdGhpcy5fb25EZXZpY2VCYWNrQnV0dG9uLmJpbmQodGhpcyk7XG5cbiAgICBpZiAodGhpcy5wcm9wcy5pbml0aWFsUm91dGUgJiYgdGhpcy5wcm9wcy5pbml0aWFsUm91dGVTdGFjaykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbiBOYXZpZ2F0b3IgZWl0aGVyIGluaXRhbFJvdXRlIG9yIGluaXRhbFJvdXRlcyBjYW4gYmUgc2V0Jyk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMucHJvcHMuaW5pdGlhbFJvdXRlKSB7XG4gICAgICB0aGlzLnJvdXRlcyA9IFt0aGlzLnByb3BzLmluaXRpYWxSb3V0ZV07XG4gICAgfSBlbHNlIGlmICh0aGlzLnByb3BzLmluaXRpYWxSb3V0ZVN0YWNrKSB7XG4gICAgICB0aGlzLnJvdXRlcyA9IHRoaXMucHJvcHMuaW5pdGlhbFJvdXRlU3RhY2s7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucm91dGVzID0gW107XG4gICAgfVxuXG4gICAgdGhpcy5wYWdlcyA9IHRoaXMucm91dGVzLm1hcChcbiAgICAgIChyb3V0ZSkgPT4gdGhpcy5wcm9wcy5yZW5kZXJQYWdlKHJvdXRlLCB0aGlzKVxuICAgICk7XG4gICAgdGhpcy5mb3JjZVVwZGF0ZSgpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKCkge1xuICAgIGlmICh0aGlzLnByb3BzLm9uRGV2aWNlQmFja0J1dHRvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLnJlZi5jdXJyZW50Lm9uRGV2aWNlQmFja0J1dHRvbiA9IHRoaXMucHJvcHMub25EZXZpY2VCYWNrQnV0dG9uO1xuICAgIH1cbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIGNvbnN0IG5vZGUgPSB0aGlzLnJlZi5jdXJyZW50O1xuICAgIG5vZGUucmVtb3ZlRXZlbnRMaXN0ZW5lcigncHJlcHVzaCcsIHRoaXMucHJvcHMub25QcmVQdXNoKTtcbiAgICBub2RlLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3Bvc3RwdXNoJywgdGhpcy5wcm9wcy5vblBvc3RQdXNoKTtcbiAgICBub2RlLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3ByZXBvcCcsIHRoaXMucHJvcHMub25QcmVQb3ApO1xuICAgIG5vZGUucmVtb3ZlRXZlbnRMaXN0ZW5lcigncG9zdHBvcCcsIHRoaXMucHJvcHMub25Qb3N0UG9wKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7XG4gICAgICBpbm5lclJlZixcbiAgICAgIHJlbmRlclBhZ2UsXG5cbiAgICAgIC8vIHRoZXNlIHByb3BzIHNob3VsZCBub3QgYmUgcGFzc2VkIGRvd25cbiAgICAgIGluaXRpYWxSb3V0ZVN0YWNrLFxuICAgICAgaW5pdGlhbFJvdXRlLFxuICAgICAgb25QcmVQdXNoLFxuICAgICAgb25Qb3N0UHVzaCxcbiAgICAgIG9uUHJlUG9wLFxuICAgICAgb25Qb3N0UG9wLFxuICAgICAgc3dpcGVQb3AsXG4gICAgICBvbkRldmljZUJhY2tCdXR0b24sXG5cbiAgICAgIC4uLnJlc3RcbiAgICB9ID0gdGhpcy5wcm9wcztcblxuICAgIGNvbnN0IHBhZ2VzID0gdGhpcy5yb3V0ZXMgPyB0aGlzLnJvdXRlcy5tYXAoKHJvdXRlKSA9PiByZW5kZXJQYWdlKHJvdXRlLCB0aGlzKSkgOiBudWxsO1xuXG4gICAgaWYgKGlubmVyUmVmICYmIGlubmVyUmVmICE9PSB0aGlzLnJlZikge1xuICAgICAgdGhpcy5yZWYgPSBpbm5lclJlZjtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPEVsZW1lbnRcbiAgICAgICAgcmVmPXt0aGlzLnJlZn1cbiAgICAgICAgey4uLnJlc3R9XG4gICAgICA+XG4gICAgICAgIHtwYWdlc31cbiAgICAgIDwvRWxlbWVudD5cbiAgICApO1xuICB9XG59XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1uYXZpZ2F0b3JcbiAqIEBjYXRlZ29yeSBuYXZpZ2F0aW9uXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL25hdmlnYXRvclxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dIFRoaXMgY29tcG9uZW50IGlzIHJlc3BvbnNpYmxlIGZvciBwYWdlIHRyYW5zaXRpb25pbmcgYW5kIG1hbmFnaW5nIHRoZSBwYWdlcyBvZiB5b3VyIE9uc2VuVUkgYXBwbGljYXRpb24uIEluIG9yZGVyIHRvIG1hbmFnZSB0byBkaXNwbGF5IHRoZSBwYWdlcywgdGhlICBuYXZpZ2F0b3IgbmVlZHMgdG8gZGVmaW5lIHRoZSBgcmVuZGVyUGFnZWAgbWV0aG9kLCB0aGF0IHRha2VzIGFuIHJvdXRlIGFuZCBhIG5hdmlnYXRvciBhbmQgIGNvbnZlcnRzIGl0IHRvIGFuIHBhZ2UuICBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICA8TmF2aWdhdG9yXG4gICAgcmVuZGVyUGFnZT17KHJvdXRlLCBuYXZpZ2F0b3IpID0+XG4gICAgIDxNeVBhZ2VcbiAgICAgICB0aXRsZT17cm91dGUudGl0bGV9XG4gICAgICAgb25Qb3A9eygpID0+IG5hdmlnYXRvci5wb3BQYWdlKCl9XG4gICAgICAgLz5cbiAgICB9XG4gICAgaW5pdGlhbFJvdXRlPXt7XG4gICAgICAgIHRpdGxlOiAnRmlyc3QgUGFnZSdcbiAgICB9fSAvPlxuICAgfVxuIH1cbiAqL1xuY29uc3QgTmF2aWdhdG9yID0gUmVhY3QuZm9yd2FyZFJlZigocHJvcHMsIHJlZikgPT4gKFxuICA8TmF2aWdhdG9yQ2xhc3MgaW5uZXJSZWY9e3JlZn0gey4uLnByb3BzfT57cHJvcHMuY2hpbGRyZW59PC9OYXZpZ2F0b3JDbGFzcz5cbikpO1xuXG5OYXZpZ2F0b3IucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgcmVuZGVyUGFnZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgdHJ1ZVxuICAgKiBAZGVmYXVsdFZhbHVlIG51bGxcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIFRoaXMgZnVuY3Rpb24gdGFrZXMgdGhlIGN1cnJlbnQgcm91dGUgb2JqZWN0IGFzIGEgcGFyYW1ldGVyIGFuZCByZXR1cm5zIGEgUmVhY3QgY29tcG9uZW50LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHJlbmRlclBhZ2U6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gIC8qKlxuICAgKiBAbmFtZSBpbml0aWFsUm91dGVTdGFja1xuICAgKiBAdHlwZSBhcnJheVxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlZmF1bHRWYWx1ZSBudWxsXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBUaGlzIGFycmF5IGNvbnRhaW5zIHRoZSBpbml0aWFsIHJvdXRlcyBmcm9tIHRoZSBOYXZpZ2F0b3IsXG4gICAqICB3aGljaCB3aWxsIGJlIHVzZWQgdG8gcmVuZGVyIHRoZSBpbml0aWFsIHBhZ2VzIGluIHRoZSBgcmVuZGVyUGFnZWAgbWV0aG9kLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaW5pdGlhbFJvdXRlU3RhY2s6IFByb3BUeXBlcy5hcnJheSxcblxuICAvKipcbiAgICogQG5hbWUgaW5pdGlhbFJvdXRlXG4gICAqIEB0eXBlIG9iamVjdFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlZmF1bHRWYWx1ZSBudWxsXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBUaGlzIGFycmF5IGNvbnRhaW5zIHRoZSBpbml0aWFsIHJvdXRlIG9mIHRoZSBuYXZpZ2F0b3IsXG4gICAqICB3aGljaCB3aWxsIGJlIHVzZWQgdG8gcmVuZGVyIHRoZSBpbml0aWFsIHBhZ2VzIGluIHRoZVxuICAgKiAgcmVuZGVyUGFnZSBtZXRob2QuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpbml0aWFsUm91dGU6IFByb3BUeXBlcy5vYmplY3QsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlUHVzaFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYmVmb3JlIGEgcGFnZSBpcyBwdXNoZWQuIEl0IGdldHMgYW4gZXZlbnQgb2JqZWN0IHdpdGggcm91dGUgaW5mb3JtYXRpb24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVQdXNoOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0UHVzaFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgYSBwYWdlIGlzIHB1c2hlZC4gSXQgZ2V0cyBhbiBldmVudCBvYmplY3Qgd2l0aCByb3V0ZSBpbmZvcm1hdGlvbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RQdXNoOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVQb3BcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBqdXN0IGJlZm9yZSBhIHBhZ2UgaXMgcG9wcGVkLiBJdCBnZXRzIGFuIGV2ZW50IG9iamVjdCB3aXRoIHJvdXRlIGluZm9ybWF0aW9uLlsvZW5dXG4gICAqL1xuICBvblByZVBvcDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUG9zdFBvcFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgYSBwYWdlIGlzIHBvcHBlZC4gSXQgZ2V0cyBhbiBldmVudCBvYmplY3Qgd2l0aCByb3V0ZSBpbmZvcm1hdGlvbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RQb3A6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhbmltYXRpb25cbiAgICogQHR5cGUge1N0cmluZ31cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICAgW2VuXVxuICAgKiAgICAgQW5pbWF0aW9uIG5hbWUuIEF2YWlsYWJsZSBhbmltYXRpb25zIGFyZSBgXCJzbGlkZVwiYCwgYFwibGlmdFwiYCwgYFwiZmFkZVwiYCBhbmQgYFwibm9uZVwiYC5cbiAgICogICAgIFRoZXNlIGFyZSBwbGF0Zm9ybSBiYXNlZCBhbmltYXRpb25zLiBGb3IgZml4ZWQgYW5pbWF0aW9ucywgYWRkIGBcIi1pb3NcImAgb3IgYFwiLW1kXCJgIHN1ZmZpeCB0byB0aGUgYW5pbWF0aW9uIG5hbWUuIEUuZy4gYFwibGlmdC1pb3NcImAsIGBcImxpZnQtbWRcImAuIERlZmF1bHRzIHZhbHVlcyBhcmUgYFwic2xpZGUtaW9zXCJgIGFuZCBgXCJmYWRlLW1kXCJgLlxuICAgKiAgIFsvZW5dXG4gICAqICAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb246IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFuaW1hdGlvbk9wdGlvbnNcbiAgICogQHR5cGUgb2JqZWN0XG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIGFuaW1hdGlvbidzIGR1cmF0aW9uLCBkZWxheSBhbmQgdGltaW5nLiBFLmcuICBge2R1cmF0aW9uOiAwLjIsIGRlbGF5OiAwLjQsIHRpbWluZzogJ2Vhc2UtaW4nfWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgc3dpcGVhYmxlXG4gICAqIEB0eXBlIGJvb2x8c3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1FbmFibGVzIHN3aXBlLXRvLXBvcCBmdW5jdGlvbmFsaXR5IGZvciBpT1MuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc3dpcGVhYmxlOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuYm9vbCwgUHJvcFR5cGVzLnN0cmluZ10pLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBzd2lwZVBvcFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dT3B0aW9uYWwgZnVuY3Rpb24gY2FsbGVkIG9uIHN3aXBlLXRvLXBvcC4gSWYgcHJvdmlkZWQsIG11c3QgcGVyZm9ybSBhIHBvcFBhZ2Ugd2l0aCB0aGUgZ2l2ZW4gb3B0aW9ucyBvYmplY3QuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc3dpcGVQb3A6IFByb3BUeXBlcy5mdW5jLFxuICAvKipcbiAgICogQG5hbWUgb25EZXZpY2VCYWNrQnV0dG9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DdXN0b20gaGFuZGxlciBmb3IgZGV2aWNlIGJhY2sgYnV0dG9uLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRGV2aWNlQmFja0J1dHRvbjogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbmNvbnN0IE5PT1AgPSAoKSA9PiBudWxsO1xuXG5OYXZpZ2F0b3IuZGVmYXVsdFByb3BzID0ge1xuICBvblBvc3RQdXNoOiBOT09QLFxuICBvblByZVB1c2g6IE5PT1AsXG4gIG9uUHJlUG9wOiBOT09QLFxuICBvblBvc3RQb3A6IE5PT1Bcbn07XG5cbmV4cG9ydCBkZWZhdWx0IE5hdmlnYXRvcjtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1tb2RhbCc7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuaW1wb3J0IGJhc2VEaWFsb2cgZnJvbSAnLi4vYmFzZURpYWxvZyc7XG5cbmNvbnN0IGRlcHJlY2F0ZWQgPSB7XG4gIGlzT3BlbjogJ3Zpc2libGUnXG59O1xuXG5jb25zdCBub3RBdHRyaWJ1dGVzID0gWydvbkRldmljZUJhY2tCdXR0b24nXTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLW1vZGFsXG4gKiBAY2F0ZWdvcnkgZGlhbG9nXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL21vZGFsXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqICAgQSBtb2RhbCBjb21wb25lbnQgY292ZXJzIHRoZSBlbnRpcmUgc2NyZWVuLiBVbmRlcmx5aW5nIGNvbXBvbmVudHMgYXJlIG5vdFxuICogICBzdWJqZWN0IHRvIGFueSBldmVudHMgd2hpbGUgdGhlIG1vZGFsIGNvbXBvbmVudCBpcyBzaG93bi5cbiAqXG4gKiAgIFRoaXMgY29tcG9uZW50IGNhbiBiZSB1c2VkIHRvIGJsb2NrIHVzZXIgaW5wdXQgd2hpbGUgc29tZSBvcGVyYXRpb24gaXNcbiAqICAgcnVubmluZyBvciB0byBzaG93IHNvbWUgaW5mb3JtYXRpb24gdG8gdGhlIHVzZXIuXG4gKiBbL2VuXVxuICogW2phXVxuICogICDnlLvpnaLlhajkvZPjgpLjg57jgrnjgq/jgZnjgovjg6Ljg7zjg4Djg6vnlKjjgrPjg7Pjg53jg7zjg43jg7Pjg4jjgafjgZnjgILkuIvlgbTjgavjgYLjgovjgrPjg7Pjg53jg7zjg43jg7Pjg4jjga/jgIFcbiAqICAg44Oi44O844OA44Or44GM6KGo56S644GV44KM44Gm44GE44KL6ZaT44Gv44Kk44OZ44Oz44OI6YCa55+l44GM6KGM44KP44KM44G+44Gb44KTXG4gKiBbL2phXVxuICogQGV4YW1wbGVcbiAgPFBhZ2U+XG4gICAgPGRpdj4gUGFnZSBjb250ZW50IDwvZGl2PlxuXG4gICAgPE1vZGFsIGlzT3Blbj17dGhpcy5zdGF0ZS5pc0xvYWRpbmd9PlxuICAgICAgTG9hZGluZyAuLi5cbiAgICA8L01vZGFsPlxuICA8L1BhZ2U+XG4gKi9cbmNvbnN0IE1vZGFsID0gb25zQ3VzdG9tRWxlbWVudChiYXNlRGlhbG9nKCdvbnMtbW9kYWwnKSwge2RlcHJlY2F0ZWQsIG5vdEF0dHJpYnV0ZXN9KTtcblxuTW9kYWwucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uXG4gICAqIEB0eXBlIHtTdHJpbmd9XG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgIFtlbl1cbiAgICogICAgIEFuaW1hdGlvbiBuYW1lLiBBdmFpbGFibGUgYW5pbWF0aW9ucyBhcmUgYFwiZmFkZVwiYCwgYFwibGlmdFwiYCBhbmQgYFwibm9uZVwiYC5cbiAgICogICBbL2VuXVxuICAgKi9cbiAgYW5pbWF0aW9uOiBQcm9wVHlwZXMub25lT2YoWydub25lJywgJ2ZhZGUnLCAnbGlmdCddKSxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uT3B0aW9uc1xuICAgKiBAdHlwZSBvYmplY3RcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgYW5pbWF0aW9uJ3MgZHVyYXRpb24sIGRlbGF5IGFuZCB0aW1pbmcuIEUuZy4gIGB7ZHVyYXRpb246IDAuMiwgZGVsYXk6IDAuNCwgdGltaW5nOiAnZWFzZS1pbid9YC5bL2VuXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVTaG93XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBqdXN0IGJlZm9yZSB0aGUgbW9kYWwgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVTaG93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0U2hvd1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQganVzdCBhZnRlciB0aGUgbW9kYWwgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Qb3N0U2hvdzogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlSGlkZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYmVmb3JlIHRoZSBtb2RhbCBpcyBoaWRkZW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0SGlkZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgdGhlIG1vZGFsIGlzIGhpZGRlbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgdmlzaWJsZVxuICAgKiBAdHlwZSBib29sZWFuXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVdoZW4gYHRydWVgIHRoZSBtb2RhbCB3aWxsIHNob3cgaXRzZWxmLlsvZW5dXG4gICAqL1xuICB2aXNpYmxlOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaXNPcGVuXG4gICAqIEB0eXBlIGJvb2xlYW5cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dREVQUkVDQVRFRCEgVXNlIGB2aXNpYmxlYCBpbnN0ZWFkLlsvZW5dXG4gICAqL1xuICBpc09wZW46IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkRldmljZUJhY2tCdXR0b25cbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ3VzdG9tIGhhbmRsZXIgZm9yIGRldmljZSBiYWNrIGJ1dHRvbi5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uRGV2aWNlQmFja0J1dHRvbjogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbmV4cG9ydCBkZWZhdWx0IE1vZGFsO1xuIiwiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1wYWdlJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbmNvbnN0IG5vdEF0dHJpYnV0ZXMgPSBbJ29uSW5maW5pdGVTY3JvbGwnLCAnb25EZXZpY2VCYWNrQnV0dG9uJ107XG5jb25zdCBFbGVtZW50ID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLXBhZ2UnLCB7bm90QXR0cmlidXRlc30pO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtcGFnZVxuICogQGNhdGVnb3J5IHBhZ2VcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvcGFnZVxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dXG4gKiAgIFRoaXMgY29tcG9uZW50IGlzIGhhbmRsaW5nIHRoZSBlbnRpcmUgcGFnZS4gVGhlIGNvbnRlbnQgY2FuIGJlIHNjcm9sbGVkLlxuICpcbiAqICAgVG8gYWRkIGZpeGVkIGNvbnRlbnQgdGhhdCBkb2Vzbid0IHNjcm9sbCB3aXRoIHRoZSBwYWdlIHRoZSBgcmVuZGVyRml4ZWRgIHByb3AgaXMgdXNlZC5cbiAqXG4gKiAgIEEgcGFnZSB0b29sYmFyIGNhbiBiZSBhZGRlZCB3aXRoIHRoZSBgcmVuZGVyVG9vbGJhcmAgcHJvcC5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gIDxQYWdlXG4gICAgcmVuZGVyRml4ZWQ9eygpID0+IDxGYWI+PC9GYWI+fVxuICAgIHJlbmRlclRvb2xiYXI9eygpID0+IDxUb29sYmFyPi4uLjwvVG9vbGJhcj59XG4gICAgY29udGVudFN0eWxlPXt7cGFkZGluZzogNDB9fT5cbiAgICA8ZGl2PiBQYWdlIGNvbnRlbnQgPC9kaXY+XG4gIDwvUGFnZT5cbiAqL1xuY29uc3QgUGFnZSA9IFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCByZWYpID0+IHtcbiAgY29uc3Qge1xuICAgIHJlbmRlclRvb2xiYXIsXG4gICAgcmVuZGVyQm90dG9tVG9vbGJhcixcbiAgICByZW5kZXJNb2RhbCxcbiAgICByZW5kZXJGaXhlZCxcbiAgICBjb250ZW50U3R5bGUsXG4gICAgY2hpbGRyZW4sXG4gICAgLi4ucmVzdFxuICB9ID0gcHJvcHM7XG5cbiAgcmV0dXJuIChcbiAgICA8RWxlbWVudFxuICAgICAgey4uLnJlc3R9XG4gICAgICByZWY9e3JlZn1cbiAgICA+XG4gICAgICB7cmVuZGVyVG9vbGJhcihyZWYpfVxuICAgICAgPGRpdiBjbGFzc05hbWU9J3BhZ2VfX2JhY2tncm91bmQnPiA8L2Rpdj5cbiAgICAgIDxkaXYgY2xhc3NOYW1lPSdwYWdlX19jb250ZW50JyBzdHlsZT17Y29udGVudFN0eWxlfT5cbiAgICAgICAge2NoaWxkcmVufVxuICAgICAgPC9kaXY+XG4gICAgICA8ZGl2IGNsYXNzTmFtZT0ncGFnZV9fZXh0cmEnIHN0eWxlPXt7ekluZGV4OiAxMDAwMX19PlxuICAgICAgICB7cmVuZGVyTW9kYWwocmVmKX1cbiAgICAgIDwvZGl2PlxuICAgICAge3JlbmRlckZpeGVkKHJlZil9XG4gICAgICB7cmVuZGVyQm90dG9tVG9vbGJhcihyZWYpfVxuICAgIDwvRWxlbWVudD5cbiAgKTtcbn0pO1xuXG5QYWdlLnByb3BUeXBlcyA9IHtcblxuICAvKipcbiAgICogQG5hbWUgY29udGVudFN0eWxlXG4gICAqIEB0eXBlIE9iamVjdFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZnkgdGhlIHN0eWxlIG9mIHRoZSBwYWdlIGNvbnRlbnQuIE9wdGlvbmFsLlxuICAgKiAgWy9lbl1cbiAgICovXG4gIGNvbnRlbnRTdHlsZTogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmeSBtb2RpZmllciBuYW1lIHRvIHNwZWNpZnkgY3VzdG9tIHN0eWxlcy4gT3B0aW9uYWwuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgcmVuZGVyTW9kYWxcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZWZhdWx0VmFsdWUgbnVsbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhpcyBmdW5jdGlvbiByZW5kZXJzIGEgbW9kYWwgdGhhdCBtYXNrcyBjdXJyZW50IHNjcmVlbi5bL2VuXVxuICAgKi9cbiAgcmVuZGVyTW9kYWw6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSByZW5kZXJUb29sYmFyXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVmYXVsdFZhbHVlIG51bGxcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIFRoaXMgZnVuY3Rpb24gcmVuZGVycyB0aGUgdG9vbGJhciBvZiB0aGUgcGFnZS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICByZW5kZXJUb29sYmFyOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgcmVuZGVyQm90dG9tVG9vbGJhclxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVmYXVsdFZhbHVlIG51bGxcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIFRoaXMgZnVuY3Rpb24gcmVuZGVycyB0aGUgYm90dG9tIHRvb2xiYXIgb2YgdGhlIHBhZ2UuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgcmVuZGVyQm90dG9tVG9vbGJhcjogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHJlbmRlckZpeGVkXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZWZhdWx0VmFsdWUgbnVsbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhpcyBmdW5jdGlvbiByZW5kZXJzIGZpeGVkIGNvbnRlbnQgb2YgdGhlIHBhZ2UuIENhbiBiZSB1c2VkIHRvIHJlbmRlciBgRmFiYCBvciBgU3BlZWREaWFsYCBjb21wb25lbnRzIGFzIHdlbGwgYXMgb3RoZXIgY29tcG9uZW50cyB0aGF0IGRvbid0IHNjcm9sbCB3aXRoIHRoZSBwYWdlLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHJlbmRlckZpeGVkOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Jbml0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFx0RmlyZWQgcmlnaHQgYWZ0ZXIgdGhlIHBhZ2UgaXMgYXR0YWNoZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkluaXQ6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblNob3dcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ2FsbGVkIEZpcmVkIHJpZ2h0IGFmdGVyIHRoZSBwYWdlIGlzIHNob3duLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25TaG93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25IaWRlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBhZnRlciB0aGUgcGFnZSBpcyBoaWRkZW4uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkhpZGU6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkluZmluaXRlU2Nyb2xsXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCB3aGVuIHNjcm9sbGluZyB0byB0aGUgYm90dG9tIG9mIHRoZSBwYWdlLiBJdCBnZXRzIGEgJ2RvbmUnIGNhbGxiYWNrIChmaXJzdCBhcmd1bWVudCkgdGhhdCBtdXN0IGJlIGNhbGxlZCB3aGVuIGl0J3MgZmluaXNoZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkluZmluaXRlU2Nyb2xsOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EZXZpY2VCYWNrQnV0dG9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1c3RvbSBoYW5kbGVyIGZvciBkZXZpY2UgYmFjayBidXR0b24uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRldmljZUJhY2tCdXR0b246IFByb3BUeXBlcy5mdW5jXG59O1xuXG5jb25zdCBOT09QID0gKCkgPT4gbnVsbDtcblxuUGFnZS5kZWZhdWx0UHJvcHMgPSB7XG4gIHJlbmRlclRvb2xiYXI6IE5PT1AsXG4gIHJlbmRlckJvdHRvbVRvb2xiYXI6IE5PT1AsXG4gIHJlbmRlck1vZGFsOiBOT09QLFxuICByZW5kZXJGaXhlZDogTk9PUFxufTtcblxuZXhwb3J0IGRlZmF1bHQgUGFnZTtcbiIsImltcG9ydCBSZWFjdCwgeyB1c2VFZmZlY3QsIHVzZVJlZiB9IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1wb3BvdmVyJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5pbXBvcnQgYmFzZURpYWxvZyBmcm9tICcuLi9iYXNlRGlhbG9nJztcblxuY29uc3QgZGVwcmVjYXRlZCA9IHtcbiAgb25DYW5jZWw6ICdvbkRpYWxvZ0NhbmNlbCcsXG4gIGlzRGlzYWJsZWQ6ICdkaXNhYmxlZCcsXG4gIGlzQ2FuY2VsYWJsZTogJ2NhbmNlbGFibGUnXG59O1xuXG5jb25zdCBub3RBdHRyaWJ1dGVzID0gWydvbkRldmljZUJhY2tCdXR0b24nXTtcblxuY29uc3QgRWxlbSA9IG9uc0N1c3RvbUVsZW1lbnQoYmFzZURpYWxvZygnb25zLXBvcG92ZXInKSwge2RlcHJlY2F0ZWQsIG5vdEF0dHJpYnV0ZXN9KTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXBvcG92ZXJcbiAqIEBjYXRlZ29yeSBkaWFsb2dcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvcG9wb3ZlclxuICogQGRlc2NyaXB0aW9uXG4gKiAgIFtlbl1cbiAqICAgICBBIGNvbXBvbmVudCB0aGF0IGRpc3BsYXlzIGEgcG9wb3ZlciBuZXh0IHRvIGFuIGVsZW1lbnQuIFRoZSBwb3BvdmVyIGNhbiBiZSB1c2VkIHRvIGRpc3BsYXkgZXh0cmEgaW5mb3JtYXRpb24gYWJvdXQgYSBjb21wb25lbnQgb3IgYSB0b29sdGlwLlxuICogICAgQW5vdGhlciBjb21tb24gd2F5IHRvIHVzZSB0aGUgcG9wb3ZlciBpcyB0byBkaXNwbGF5IGEgbWVudSB3aGVuIGEgYnV0dG9uIG9uIHRoZSBzY3JlZW4gaXMgdGFwcGVkLlxuICogICBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPFBhZ2U+XG4gKiAgPEJ1dHRvblxuICogICAgcmVmPXsoYnRuKSA9PiB7IHRoaXMuYnRuID0gYnRuOyB9fVxuICogICAgb25DbGljaz17KCkgPT5cbiAqICAgICAgdGhpcy5zZXRTdGF0ZSh7dGFyZ2V0OiB0aGlzLmJ0biwgaXNPcGVuOiB0cnVlfSlcbiAqICAgIH1cbiAqICAvPlxuICAgIDxQb3BvdmVyXG4gICAgICBpc09wZW49e3RoaXMuc3RhdGUuaXNPcGVufVxuICAgICAgb25DYW5jZWw9eygpID0+IHRoaXMuc2V0U3RhdGUoe2lzT3BlbjogZmFsc2V9KX1cbiAgICAgIGdldFRhcmdldD17KCkgPT4gdGhpcy5zdGF0ZS50YXJnZXR9XG4gICAgPlxuICAgICAgPGRpdiBzdHlsZT17e3RleHRBbGlnbjogJ2NlbnRlcicsIG9wYWNpdHk6IDAuNX19PlxuICAgICAgICA8cD5UaGlzIGlzIGEgcG9wb3ZlciE8L3A+XG4gICAgICAgICAgPHA+PHNtYWxsPkNsaWNrIHRoZSBiYWNrZ3JvdW5kIHRvIHJlbW92ZSB0aGUgcG9wb3Zlci48L3NtYWxsPjwvcD5cbiAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvUG9wb3Zlcj5cbiAqIDwvUGFnZT5cbiAqL1xuY29uc3QgUG9wb3ZlciA9IFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCBmb3J3YXJkZWRSZWYpID0+IHtcbiAgY29uc3Qge2lzT3BlbiwgZ2V0VGFyZ2V0LCBjaGlsZHJlbiwgLi4ucmVzdH0gPSBwcm9wcztcbiAgY29uc3QgcmVmID0gZm9yd2FyZGVkUmVmIHx8IHVzZVJlZigpO1xuXG4gIHVzZUVmZmVjdCgoKSA9PiB7XG4gICAgaWYgKGlzT3BlbiAhPT0gcmVmLmN1cnJlbnQudmlzaWJsZSkge1xuICAgICAgaWYgKGlzT3Blbikge1xuICAgICAgICBsZXQgdGFyZ2V0ID0gZ2V0VGFyZ2V0KCk7XG5cbiAgICAgICAgLy8gaWYgUmVhY3QgcmVmIHdhcyByZXR1cm5lZCBpbnN0ZWFkIG9mIERPTSBFbGVtZW50LCB1c2UgcmVmLmN1cnJlbnQgaW5zdGVhZFxuICAgICAgICBjb25zdCBpc0VsZW1lbnQgPSB4ID0+IHggaW5zdGFuY2VvZiBFbGVtZW50IHx8IHggaW5zdGFuY2VvZiBIVE1MRG9jdW1lbnQ7XG4gICAgICAgIGlmICghaXNFbGVtZW50KHRhcmdldCkgJiYgdGFyZ2V0LmN1cnJlbnQpIHtcbiAgICAgICAgICB0YXJnZXQgPSB0YXJnZXQuY3VycmVudDtcbiAgICAgICAgfVxuXG4gICAgICAgIHJlZi5jdXJyZW50LnNob3coe3RhcmdldH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmVmLmN1cnJlbnQuaGlkZSgpO1xuICAgICAgfVxuICAgIH1cbiAgfSk7XG5cbiAgcmV0dXJuIChcbiAgICA8RWxlbVxuICAgICAgcmVmPXtyZWZ9XG4gICAgICB7Li4ucmVzdH1cbiAgICA+XG4gICAgICB7Y2hpbGRyZW59XG4gICAgPC9FbGVtPlxuICApO1xufSk7XG5cblBvcG92ZXIucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgZ2V0VGFyZ2V0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCB0cnVlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgVGhpcyBmdW5jdGlvbiBzaG91bGQgcmV0dXJuIGEgcmVmIHRvIHRoZSBET00gbm9kZSB0aGF0IHRoZSBwb3BvdmVyIHdpbGwgdGFyZ2V0LlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZ2V0VGFyZ2V0OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkRpYWxvZ0NhbmNlbFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQgb25seSBpZiBpc0NhbmNlbGFibGUgaXMgdHJ1ZS4gSXQgd2lsbCBiZSBjYWxsZWQgYWZ0ZXIgdGFwcGluZyB0aGUgYmFja2dyb3VuZCBvciBieSBwcmVzc2luZyB0aGUgYmFjayBidXR0b24gb24gQW5kcm9pZCBkZXZpY2VzLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25EaWFsb2dDYW5jZWw6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkNhbmNlbFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBERVBSRUNBVEVEISBVc2UgYG9uRGlhbG9nQ2FuY2VsYCBpbnN0ZWFkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DYW5jZWw6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpc09wZW5cbiAgICogQHR5cGUgYm9vbFxuICAgKiBAcmVxdWlyZWQgdHJ1ZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEluZGljYXRlcyB3aGV0aGVyIHRoZSBkaWFsb2cgaXMgb3BlbiBhbmQgc2hvd24uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpc09wZW46IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGNhbmNlbGFibGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBTcGVjaWZpZXMgd2hldGhlciB0aGUgZGlhbG9nIGlzIGNhbmNlbGFibGUgb3Igbm90LlxuICAgKiAgQSBjYW5jZWxhYmxlIGRpYWxvZyB3aWxsIGNhbGwgb25DYW5jZWwgIHdoZW4gdGFwcGluZyB0aGUgYmFja2dyb3VuZCBvciBvciAgcHJlc3NpbmcgdGhlIGJhY2sgYnV0dG9uIG9uIEFuZHJvaWQgZGV2aWNlc1xuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgY2FuY2VsYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlzQ2FuY2VsYWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIERFUFJFQ0FURUQhIFVzZSBgY2FuY2VsYWJsZWAgaW5zdGVhZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGlzQ2FuY2VsYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGRpYWxvZyBpcyBkaXNhYmxlZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaXNEaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIERFUFJFQ0FURUQhIFVzZSBgZGlzYWJsZWRgIGluc3RlYWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpc0Rpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBUaGUgYW5pbWF0aW9uIHVzZWQgd2hlbiBzaG93aW5nIGFuZCBoaWRpbmcgdGhlIGRpYWxvZy4gQ2FuIGJlIGVpdGhlciBgXCJub25lXCJgIG9yIGBcImRlZmF1bHRcImAuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb246IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIGRpYWxvZy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbWFza0NvbG9yXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ29sb3Igb2YgdGhlIGJhY2tncm91bmQgbWFzay4gRGVmYXVsdCBpcyBcInJnYmEoMCwgMCwgMCwgMC4yKVwiWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbWFza0NvbG9yOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhbmltYXRpb25PcHRpb25zXG4gICAqIEB0eXBlIG9iamVjdFxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgYW5pbWF0aW9uJ3MgZHVyYXRpb24sIGRlbGF5IGFuZCB0aW1pbmcuIEUuZy4gIGB7ZHVyYXRpb246IDAuMiwgZGVsYXk6IDAuNCwgdGltaW5nOiAnZWFzZS1pbid9YC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb25PcHRpb25zOiBQcm9wVHlwZXMub2JqZWN0LFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblByZVNob3dcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ2FsbGVkIGp1c3QgYmVmb3JlIHRoZSBhbGVydCBkaWFsb2cgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVTaG93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0U2hvd1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQganVzdCBhZnRlciB0aGUgYWxlcnQgZGlhbG9nIGlzIGRpc3BsYXllZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUG9zdFNob3c6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblByZUhpZGVcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBqdXN0IGJlZm9yZSB0aGUgYWxlcnQgZGlhbG9nIGlzIGhpZGRlbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblByZUhpZGU6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblBvc3RIaWRlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQganVzdCBhZnRlciB0aGUgYWxlcnQgZGlhbG9nIGlzIGhpZGRlbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EZXZpY2VCYWNrQnV0dG9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1c3RvbSBoYW5kbGVyIGZvciBkZXZpY2UgYmFjayBidXR0b24uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRldmljZUJhY2tCdXR0b246IFByb3BUeXBlcy5mdW5jXG59O1xuXG5leHBvcnQgZGVmYXVsdCBQb3BvdmVyO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXByb2dyZXNzLWJhcic7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtcHJvZ3Jlc3MtYmFyXG4gKiBAY2F0ZWdvcnkgdmlzdWFsXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL3Byb2dyZXNzXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gVGhlIGNvbXBvbmVudCBpcyB1c2VkIHRvIGRpc3BsYXkgYSBsaW5lYXIgcHJvZ3Jlc3MgYmFyLiBJdCBjYW4gZWl0aGVyIGRpc3BsYXkgYSBwcm9ncmVzcyBiYXIgdGhhdCBzaG93cyB0aGUgdXNlciBob3cgbXVjaCBvZiBhIHRhc2sgaGFzIGJlZW4gY29tcGxldGVkLiBJbiB0aGUgY2FzZSB3aGVyZSB0aGUgcGVyY2VudGFnZSBpcyBub3Qga25vd24gaXQgY2FuIGJlIHVzZWQgdG8gZGlzcGxheSBhbiBhbmltYXRlZCBwcm9ncmVzcyBiYXIgc28gdGhlIHVzZXIgY2FuIHNlZSB0aGF0IGFuIG9wZXJhdGlvbiBpcyBpbiBwcm9ncmVzcy4gIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gKjxQcm9ncmVzc0JhciB2YWx1ZT17NTV9IHNlY29uZGFyeVZhbHVlPXs4N30gLz5cbiAqPFByb2dyZXNzQmFyIGluZGV0ZXJtaW5hdGUgLz5cbiAqL1xuY29uc3QgUHJvZ3Jlc3NCYXIgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtcHJvZ3Jlc3MtYmFyJyk7XG5cblByb2dyZXNzQmFyLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIHByb2dyZXNzIGluZGljYXRvci5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgdmFsdWVcbiAgICogQHR5cGUgbnVtYmVyXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ3VycmVudCBwcm9ncmVzcy4gU2hvdWxkIGJlIGEgdmFsdWUgYmV0d2VlbiAwIGFuZCAxMDAuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB2YWx1ZTogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgc2Vjb25kYXJ5VmFsdWVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1cnJlbnQgc2Vjb25kYXJ5IHByb2dyZXNzLiBTaG91bGQgYmUgYSB2YWx1ZSBiZXR3ZWVuIDAgYW5kIDEwMC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHNlY29uZGFyeVZhbHVlOiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpbmRldGVybWluYXRlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIElmIHRoaXMgcHJvcGVydHkgaXMgc2V0LCBhbiBpbmZpbml0ZSBsb29waW5nIGFuaW1hdGlvbiB3aWxsIGJlIHNob3duLiBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpbmRldGVybWluYXRlOiBQcm9wVHlwZXMuYm9vbFxufTtcblxuZXhwb3J0IGRlZmF1bHQgUHJvZ3Jlc3NCYXI7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtcHJvZ3Jlc3MtY2lyY3VsYXInO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXByb2dyZXNzLWNpcmN1bGFyXG4gKiBAY2F0ZWdvcnkgdmlzdWFsXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL3Byb2dyZXNzLWNpcmN1bGFyXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gVGhpcyBjb21wb25lbnQgZGlzcGxheXMgYSBjaXJjdWxhciBwcm9ncmVzcyBpbmRpY2F0b3IuIEl0IGNhbiBlaXRoZXIgYmUgdXNlZCB0byBzaG93IGhvdyBtdWNoIG9mIGEgdGFzayBoYXMgYmVlbiBjb21wbGV0ZWQgb3IgdG8gc2hvdyBhIGxvb3BpbmcgYW5pbWF0aW9uIHRvIGluZGljYXRlIHRoYXQgYW4gb3BlcmF0aW9uIGlzIGN1cnJlbnRseSBydW5uaW5nLlxuICogWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqPFByb2dyZXNzQ2lyY3VsYXIgdmFsdWU9ezU1fSBzZWNvbmRhcnlWYWx1ZT17ODd9IC8+XG4gKjxQcm9ncmVzc0NpcmN1bGFyIGluZGV0ZXJtaW5hdGUgLz5cbiAqL1xuY29uc3QgUHJvZ3Jlc3NDaXJjdWxhciA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1wcm9ncmVzcy1jaXJjdWxhcicpO1xuXG5Qcm9ncmVzc0NpcmN1bGFyLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG1vZGlmaWVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIHByb2dyZXNzIGluZGljYXRvci5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgdmFsdWVcbiAgICogQHR5cGUgbnVtYmVyXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgQ3VycmVudCBwcm9ncmVzcy4gU2hvdWxkIGJlIGEgdmFsdWUgYmV0d2VlbiAwIGFuZCAxMDAuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB2YWx1ZTogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgc2Vjb25kYXJ5VmFsdWVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1cnJlbnQgc2Vjb25kYXJ5IHByb2dyZXNzLiBTaG91bGQgYmUgYSB2YWx1ZSBiZXR3ZWVuIDAgYW5kIDEwMC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHNlY29uZGFyeVZhbHVlOiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpbmRldGVybWluYXRlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIElmIHRoaXMgcHJvcGVydHkgaXMgc2V0LCBhbiBpbmZpbml0ZSBsb29waW5nIGFuaW1hdGlvbiB3aWxsIGJlIHNob3duLiBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpbmRldGVybWluYXRlOiBQcm9wVHlwZXMuYm9vbFxufTtcblxuZXhwb3J0IGRlZmF1bHQgUHJvZ3Jlc3NDaXJjdWxhcjtcbiIsImltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1wdWxsLWhvb2snO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3QgZGVwcmVjYXRlZCA9IHtcbiAgb25Mb2FkOiAnb25BY3Rpb24nLFxuICBvbkNoYW5nZTogJ29uQ2hhbmdlU3RhdGUnXG59O1xuXG5jb25zdCBub3RBdHRyaWJ1dGVzID0gWydvbkFjdGlvbiddO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtcHVsbC1ob29rXG4gKiBAY2F0ZWdvcnkgY29udHJvbFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9wdWxsLWhvb2tcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXSAgQ29tcG9uZW50IHRoYXQgYWRkcyAqKlB1bGwgdG8gcmVmcmVzaCoqIGZ1bmN0aW9uYWxpdHkgdG8gYW4gYDxvbnMtcGFnZT5gIGVsZW1lbnQuXG4gKiAgICAgSXQgY2FuIGJlIHVzZWQgdG8gcGVyZm9ybSBhIHRhc2sgd2hlbiB0aGUgdXNlciBwdWxscyBkb3duIGF0IHRoZSB0b3Agb2YgdGhlIHBhZ2UuIEEgY29tbW9uIHVzYWdlIGlzIHRvIHJlZnJlc2ggdGhlIGRhdGEgZGlzcGxheWVkIGluIGEgcGFnZS5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxQdWxsSG9vayBvbkNoYW5nZT17dGhpcy5vbkNoYW5nZX0gb25Mb2FkPXt0aGlzLm9uTG9hZH0+XG4gICAgICB7XG4gICAgICAgKHRoaXMuc3RhdGUucHVsbEhvb2tTdGF0ZSA9PT0gJ2luaXRpYWwnKSA/XG4gICAgICAgIDxzcGFuID5cbiAgICAgICAgICA8SWNvbiBzaXplPXszNX0gc3Bpbj17ZmFsc2V9IGljb249J2lvbi1hcnJvdy1kb3duLWEnIC8+XG4gICAgICAgICAgUHVsbCBkb3duIHRvIHJlZnJlc2hcbiAgICAgICAgPC9zcGFuPiA6XG4gICAgICAgICh0aGlzLnN0YXRlLnB1bGxIb29rU3RhdGUgPT09ICdwcmVhY3Rpb24nKSA/XG4gICAgICAgICA8c3Bhbj5cbiAgICAgICAgICAgPEljb24gc2l6ZT17MzV9IHNwaW49e2ZhbHNlfSBpY29uPSdpb24tYXJyb3ctdXAtYScgLz5cbiAgICAgICAgICAgUmVsZWFzZSB0byByZWZyZXNoXG4gICAgICAgIDwvc3Bhbj5cbiAgICAgICAgOlxuICAgICAgICA8c3Bhbj48SWNvbiBzaXplPXszNX0gc3Bpbj17dHJ1ZX0gaWNvbj0naW9uLWxvYWQtZCc+PC9JY29uPiBMb2FkaW5nIGRhdGEuLi48L3NwYW4+XG4gICAgfVxuICAgICAgPC9QdWxsSG9vaz5cbiAgICApO1xuICovXG5jb25zdCBQdWxsSG9vayA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1wdWxsLWhvb2snLCB7ZGVwcmVjYXRlZCwgbm90QXR0cmlidXRlc30pO1xuXG5QdWxsSG9vay5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBvbkNoYW5nZVN0YXRlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgcHVsbCBob29rIGlubmVyIHN0YXRlIGlzIGNoYW5nZWQuIFRoZSBzdGF0ZSBjYW4gYmUgZWl0aGVyIFwiaW5pdGlhbFwiLCBcInByZWFjdGlvblwiIG9yIFwiYWN0aW9uXCJbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkNoYW5nZVN0YXRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25DaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXURFUFJFQ0FURUQhIFVzZSBgb25DaGFuZ2VTdGF0ZWAgaW5zdGVhZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkNoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uQWN0aW9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgd2hlbiB0aGUgcHVsbCBob29rIGlzIGluIHRoZSBgYWN0aW9uYCBzdGF0ZVsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQWN0aW9uOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Mb2FkXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1ERVBSRUNBVEVEISBVc2UgYG9uQWN0aW9uYCBpbnN0ZWFkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uTG9hZDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHVsbFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSG9vayBjYWxsZWQgd2hlbmV2ZXIgdGhlIHVzZXIgcHVsbHMgdGhlIGVsZW1lbnQuIEl0IGdldHMgdGhlIHB1bGxlZCBkaXN0YW5jZSByYXRpbyAoc2Nyb2xsIC8gaGVpZ2h0KSBhbmQgYW4gYW5pbWF0aW9uT3B0aW9ucyBvYmplY3QgYXMgYXJndW1lbnRzLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUHVsbDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIFdoZW4gc2V0IHRvIHRydWUsIHRoZSBwdWxsIGhvb2sgd2lsbCBiZSBkaXNhYmxlZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGhlaWdodFxuICAgKiBAdHlwZSBudW1iZXJcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIFRoZSBoZWlnaHQgb2YgdGhlIHB1bGwgaG9vayBpbiBwaXhlbHMuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIDY0LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGhlaWdodDogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgdGhyZXNob2xkSGVpZ2h0XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhlIHRocmVzaG9sZCBoZWlnaHQgb2YgdGhlIHB1bGwgaG9vayBpbiBwaXhlbHMuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIDk2LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHRocmVzaG9sZEhlaWdodDogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgZml4ZWRDb250ZW50XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gSWYgc2V0IHRvIHRydWUsIHRoZSBjb250ZW50IG9mIHRoZSBwYWdlIHdpbGwgbm90IG1vdmUgd2hlbiBwdWxsaW5nLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGZpeGVkQ29udGVudDogUHJvcFR5cGVzLmJvb2xcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFB1bGxIb29rO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXJhZGlvJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5pbXBvcnQgb25lVGltZVByb3AgZnJvbSAnLi4vb25lVGltZVByb3AnO1xuaW1wb3J0IElOUFVUX1BST1BTIGZyb20gJy4uL2lucHV0UHJvcHMnO1xuXG5jb25zdCBuYW1lTWFwID0ge1xuICAuLi5JTlBVVF9QUk9QU1xufTtcblxuY29uc3Qgd2l0aERlZmF1bHRDaGVja2VkID0gY29tcG9uZW50ID0+IG9uZVRpbWVQcm9wKGNvbXBvbmVudCwgJ2RlZmF1bHRDaGVja2VkJywgJ2NoZWNrZWQnKTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXJhZGlvXG4gKiBAY2F0ZWdvcnkgZm9ybVxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9yYWRpb1xuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dXG4gKiAgQSByYWRpbyBidXR0b24gZWxlbWVudC4gVGhlIGNvbXBvbmVudCB3aWxsIGF1dG9tYXRpY2FsbHkgcmVuZGVyIGFzIGEgTWF0ZXJpYWwgRGVzaWduIHJhZGlvIGJ1dHRvbiBvbiBBbmRyb2lkIGRldmljZXMuXG4gKlxuICogIE1vc3QgYXR0cmlidXRlcyB0aGF0IGNhbiBiZSB1c2VkIGZvciBhIG5vcm1hbCBgPGlucHV0IHR5cGU9XCJyYWRpb1wiPmAgZWxlbWVudCBjYW4gYWxzbyBiZSB1c2VkIG9uIHRoZSBgPFJhZGlvPmAgY29tcG9uZW50LlxuICogWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqIDxSYWRpb1xuICogICBvbkNoYW5nZT17ZXZlbnQgPT4geyB0aGlzLnNldFN0YXRlKHtjaGVja2VkOiBldmVudC50YXJnZXQuY2hlY2tlZH0pfSB9XG4gKiAgIG1vZGlmaWVyPSdtYXRlcmlhbCcgLz5cbiAqL1xuY29uc3QgUmFkaW8gPSB3aXRoRGVmYXVsdENoZWNrZWQob25zQ3VzdG9tRWxlbWVudCgnb25zLXJhZGlvJywge2RlcHJlY2F0ZWQ6IG5hbWVNYXB9KSk7XG5cblJhZGlvLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG5hbWVcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBuYW1lIG9mIHRoZSByYWRpbyBidXR0b24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbmFtZTogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgcmFkaW8gYnV0dG9uLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmaWVzIHdoZXRoZXIgdGhlIHJhZGlvIGJ1dHRvbiBpcyBkaXNhYmxlZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25DaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIENhbGxlZCB3aGVuIHRoZSByYWRpbyBidXR0b24gc3RhdGUgY2hhbmdlcy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkNoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHZhbHVlXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVmFsdWUgb2YgdGhlIHJhZGlvIGJ1dHRvbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB2YWx1ZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgUHJvcFR5cGVzLnN0cmluZyxcbiAgICBQcm9wVHlwZXMuaW5zdGFuY2VPZihEYXRlKVxuICBdKSxcblxuICAvKipcbiAgICogQG5hbWUgY2hlY2tlZFxuICAgKiBAdHlwZSBib29sZWFuXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNvbnRyb2xzIHRoZSBzdGF0ZSBvZiB0aGUgcmFkaW8gYnV0dG9uIChjb250cm9sbGVkKS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBjaGVja2VkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgZGVmYXVsdENoZWNrZWRcbiAgICogQHR5cGUgYm9vbGVhblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1EZWZpbmVkIHRoZSBzdGF0ZSBvZiB0aGUgcmFkaW8gYnV0dG9uIGF0IGZpcnN0IHJlbmRlciBmb3IgdW5jb250cm9sbGVkIGlucHV0cy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkZWZhdWx0Q2hlY2tlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlucHV0SWRcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIFwiaWRcIiBhdHRyaWJ1dGUgb2YgdGhlIGlubmVyIGA8aW5wdXQ+YCBlbGVtZW50LiBUaGlzIGlzIHVzZWZ1bCB3aGVuIHVzaW5nIDxsYWJlbCBmb3I9XCIuLi5cIj4gZWxlbWVudHMuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaW5wdXRJZDogUHJvcFR5cGVzLnN0cmluZ1xufTtcblxuZXhwb3J0IGRlZmF1bHQgUmFkaW87XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtcmFuZ2UnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcbmltcG9ydCBvbmVUaW1lUHJvcCBmcm9tICcuLi9vbmVUaW1lUHJvcCc7XG5pbXBvcnQgSU5QVVRfUFJPUFMgZnJvbSAnLi4vaW5wdXRQcm9wcyc7XG5cbmNvbnN0IG5hbWVNYXAgPSB7XG4gIC4uLklOUFVUX1BST1BTXG59O1xuXG5jb25zdCB3aXRoRGVmYXVsdFZhbHVlID0gY29tcG9uZW50ID0+IG9uZVRpbWVQcm9wKGNvbXBvbmVudCwgJ2RlZmF1bHRWYWx1ZScsICd2YWx1ZScpO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtcmFuZ2VcbiAqIEBjYXRlZ29yeSBmb3JtXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL3JhbmdlXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqICAgUmFuZ2UgaW5wdXQgY29tcG9uZW50LlxuICogWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqIDxSYW5nZSBtb2RpZmllcj1cIm1hdGVyaWFsXCJcbiAqICAgdmFsdWU9e3RoaXMuc3RhdGUudmFsdWV9XG4gKiAgIG9uQ2hhbmdlPXsoZXZlbnQpID0+IHRoaXMuc2V0U3RhdGUoe3ZhbHVlOiBwYXJzZUludChldmVudC50YXJnZXQudmFsdWUpfSl9XG4gKiAgIC8+XG4gKi9cbmNvbnN0IFJhbmdlID0gd2l0aERlZmF1bHRWYWx1ZShvbnNDdXN0b21FbGVtZW50KCdvbnMtcmFuZ2UnLCB7ZGVwcmVjYXRlZDogbmFtZU1hcH0pKTtcblxuUmFuZ2UucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgcHJvZ3Jlc3MgaW5kaWNhdG9yLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkNoYW5nZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gQ2FsbGVkIHdoZW4gdGhlIHZhbHVlIG9mIHRoZSBpbnB1dCBjaGFuZ2VzLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQ2hhbmdlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25JbnB1dFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gQ2FsbGVkIHdoZW4gdGhlIGlubmVyIHJhbmdlIGZpcmVzIGFuIGBpbnB1dGAgZXZlbnQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25JbnB1dDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHZhbHVlXG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1cnJlbnQgdmFsdWUgb2YgdGhlIGVsZW1lbnQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB2YWx1ZTogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgdmFsdWVcbiAgICogQHR5cGUgbnVtYmVyXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgRGVmYXVsdCB2YWx1ZSBvZiB0aGUgZWxlbWVudCAoZm9yIHVuY29udHJvbGxlZCBjb21wb25lbnRzKS5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRlZmF1bHRWYWx1ZTogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgZGlzYWJsZWRcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gSWYgdHJ1ZSwgdGhlIGVsZW1lbnQgaXMgZGlzYWJsZWQuIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbFxufTtcblxuZXhwb3J0IGRlZmF1bHQgUmFuZ2U7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtcmlwcGxlJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1yaXBwbGVcbiAqIEBjYXRlZ29yeSB2aXN1YWxcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvcmlwcGxlXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqICAgQWRkcyBhIE1hdGVyaWFsIERlc2lnbiBcInJpcHBsZVwiIGVmZmVjdCB0byBhbiBlbGVtZW50LlxuICogWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAgIDxkaXYgY2xhc3NOYW1lPSdteUxpc3QnPlxuICAgICA8UmlwcGxlIGNvbG9yPSdyZWQnIC8+XG4gICA8L2Rpdj5cbiAqL1xuY29uc3QgUmlwcGxlID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLXJpcHBsZScpO1xuXG5SaXBwbGUucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgY29sb3JcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Db2xvciBvZiB0aGUgcmlwcGxlIGVmZmVjdC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBjb2xvcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgcmlwcGxlIGVmZmVjdC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgYmFja2dyb3VuZFxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNvbG9yIG9mIHRoZSBiYWNrZ3JvdW5kLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGJhY2tncm91bmQ6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHNpemVcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TaXppbmcgb2YgdGhlIHdhdmUgb24gcmlwcGxlIGVmZmVjdC4gU2V0IFwiY292ZXJcIiBvciBcImNvbnRhaW5cIi4gRGVmYXVsdCBpcyBcImNvdmVyXCIuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc2l6ZTogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgc2l6ZVxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNoYW5nZXMgdGhlIHBvc2l0aW9uIG9mIHdhdmUgZWZmZWN0IHRvIGNlbnRlciBvZiB0aGUgdGFyZ2V0IGVsZW1lbnQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgY2VudGVyOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgZGlzYWJsZWRcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIFNwZWNpZmllcyB3aGV0aGVyIHRoZSBidXR0b24gaXMgZGlzYWJsZWQuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2xcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFJpcHBsZTtcbiIsImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVhY3RET00gZnJvbSAncmVhY3QtZG9tJztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1uYXZpZ2F0b3InO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3QgRWxlbWVudCA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1uYXZpZ2F0b3InKTtcblxuY2xhc3MgUm91dGVyTmF2aWdhdG9yQ2xhc3MgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBjb25zdHJ1Y3RvciguLi5hcmdzKSB7XG4gICAgc3VwZXIoLi4uYXJncyk7XG5cbiAgICB0aGlzLmNhbmNlbFVwZGF0ZSA9IGZhbHNlO1xuXG4gICAgY29uc3QgY2FsbGJhY2sgPSAobmFtZSwgZXZlbnQpID0+IHtcbiAgICAgIGlmICh0aGlzLnByb3BzW25hbWVdKSB7XG4gICAgICAgIHJldHVybiB0aGlzLnByb3BzW25hbWVdKGV2ZW50KTtcbiAgICAgIH1cbiAgICB9O1xuICAgIHRoaXMub25QcmVQdXNoID0gY2FsbGJhY2suYmluZCh0aGlzLCAnb25QcmVQdXNoJyk7XG4gICAgdGhpcy5vblBvc3RQdXNoID0gY2FsbGJhY2suYmluZCh0aGlzLCAnb25Qb3N0UHVzaCcpO1xuICAgIHRoaXMub25QcmVQb3AgPSBjYWxsYmFjay5iaW5kKHRoaXMsICdvblByZVBvcCcpO1xuICAgIHRoaXMub25Qb3N0UG9wID0gY2FsbGJhY2suYmluZCh0aGlzLCAnb25Qb3N0UG9wJyk7XG5cbiAgICB0aGlzLnJlZiA9IFJlYWN0LmNyZWF0ZVJlZigpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGludGVybmFsU3RhY2s6IFtdXG4gICAgfTtcbiAgfVxuXG4gIHVwZGF0ZShjYikge1xuICAgIGlmICghdGhpcy5jYW5jZWxVcGRhdGUpIHtcbiAgICAgIHRoaXMuc2V0U3RhdGUoe30sIGNiKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogQG1ldGhvZCByZXNldFBhZ2VTdGFja1xuICAgKiBAc2lnbmF0dXJlIHJlc2V0UGFnZVN0YWNrKHJvdXRlLCBvcHRpb25zID0ge30pXG4gICAqIEBwYXJhbSB7QXJyYXl9IFtyb3V0ZXNdXG4gICAqICAgW2VuXSBUaGUgcm91dGVzIHRoYXQgdGhlIG5hdmlnYXRvciBzaG91bGQgYmUgcmVzZXQgdG8uWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICogQHJldHVybiB7UHJvbWlzZX1cbiAgICogICBbZW5dUHJvbWlzZSB3aGljaCByZXNvbHZlcyB0byB0aGUgcmV2ZWFsZWQgcGFnZS5bL2VuXVxuICAgKiAgIFtqYV3mmI7jgonjgYvjgavjgZfjgZ/jg5rjg7zjgrjjgpLop6PmsbrjgZnjgotQcm9taXNl44KS6L+U44GX44G+44GZ44CCWy9qYV1cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICAgW2VuXSBSZXNldHMgdGhlIG5hdmlnYXRvciB0byB0aGUgY3VycmVudCBwYWdlIHN0YWNrWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICovXG4gIHJlc2V0UGFnZVN0YWNrKHJvdXRlcywgb3B0aW9ucyA9IHt9KSB7XG4gICAgaWYgKHRoaXMuaXNSdW5uaW5nKCkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCB1cGRhdGUgPSAoKSA9PiB7XG4gICAgICByZXR1cm4gbmV3IFByb21pc2UocmVzb2x2ZSA9PiB7XG4gICAgICAgIHRoaXMuc2V0U3RhdGUoe2ludGVybmFsU3RhY2s6IFsuLi50aGlzLnN0YXRlLmludGVybmFsU3RhY2ssIHJvdXRlc1tyb3V0ZXMubGVuZ3RoIC0gMV1dfSwgcmVzb2x2ZSk7XG4gICAgICB9KTtcbiAgICB9O1xuXG4gICAgcmV0dXJuIHRoaXMucmVmLmN1cnJlbnQuX3B1c2hQYWdlKG9wdGlvbnMsIHVwZGF0ZSlcbiAgICAgIC50aGVuKCgpID0+IHtcbiAgICAgICAgdGhpcy5zZXRTdGF0ZSh7aW50ZXJuYWxTdGFjazogWy4uLnJvdXRlc119KTtcbiAgICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIEBtZXRob2QgcHVzaFBhZ2VcbiAgICogQHNpZ25hdHVyZSBwdXNoUGFnZShyb3V0ZSwgb3B0aW9ucyA9IHt9KVxuICAgKiBAcGFyYW0ge0FycmF5fSBbcm91dGVzXVxuICAgKiAgIFtlbl0gVGhlIHJvdXRlcyB0aGF0IHRoZSBuYXZpZ2F0b3Igc2hvdWxkIHB1c2ggdG8uWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICogQHJldHVybiB7UHJvbWlzZX1cbiAgICogICBbZW5dIFByb21pc2Ugd2hpY2ggcmVzb2x2ZXMgdG8gdGhlIHJldmVhbGVkIHBhZ2UuWy9lbl1cbiAgICogICBbamFd5piO44KJ44GL44Gr44GX44Gf44Oa44O844K444KS6Kej5rG644GZ44KLUHJvbWlzZeOCkui/lOOBl+OBvuOBmeOAglsvamFdXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgIFtlbl0gUHVzaGVzIGEgcGFnZSB0byB0aGUgcGFnZSBzdGFja1svZW5dXG4gICAqICAgW2phXVsvamFdXG4gICAqL1xuICBwdXNoUGFnZShyb3V0ZSwgb3B0aW9ucyA9IHt9KSB7XG4gICAgaWYgKHRoaXMuaXNSdW5uaW5nKCkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCB1cGRhdGUgPSAoKSA9PiB7XG4gICAgICByZXR1cm4gbmV3IFByb21pc2UocmVzb2x2ZSA9PiB7XG4gICAgICAgIHRoaXMuc2V0U3RhdGUoe2ludGVybmFsU3RhY2s6IFsuLi50aGlzLnN0YXRlLmludGVybmFsU3RhY2ssIHJvdXRlXX0sIHJlc29sdmUpO1xuICAgICAgfSk7XG4gICAgfTtcblxuICAgIHJldHVybiB0aGlzLnJlZi5jdXJyZW50Ll9wdXNoUGFnZShvcHRpb25zLCB1cGRhdGUpXG4gIH1cblxuICBpc1J1bm5pbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMucmVmLmN1cnJlbnQuX2lzUnVubmluZztcbiAgfVxuXG4gIC8qXG4gICAqIEBtZXRob2QgcmVwbGFjZVBhZ2VcbiAgICogQHNpZ25hdHVyZSByZXBsYWNlUGFnZShwYWdlLCBbb3B0aW9uc10pXG4gICAqIEByZXR1cm4ge1Byb21pc2V9XG4gICAqICAgW2VuXVByb21pc2Ugd2hpY2ggcmVzb2x2ZXMgdG8gdGhlIG5ldyBwYWdlLlsvZW5dXG4gICAqICAgW2phXeaWsOOBl+OBhOODmuODvOOCuOOCkuino+axuuOBmeOCi1Byb21pc2XjgpLov5TjgZfjgb7jgZnjgIJbL2phXVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogICBbZW5dUmVwbGFjZXMgdGhlIGN1cnJlbnQgdG9wIHBhZ2Ugd2l0aCB0aGUgc3BlY2lmaWVkIG9uZS4gRXh0ZW5kcyBgcHVzaFBhZ2UoKWAgcGFyYW1ldGVycy5bL2VuXVxuICAgKiAgIFtqYV3nj77lnKjooajnpLrkuK3jga7jg5rjg7zjgrjjgpLjgpLmjIflrprjgZfjgZ/jg5rjg7zjgrjjgavnva7jgY3mj5vjgYjjgb7jgZnjgIJbL2phXVxuICAgKi9cbiAgcmVwbGFjZVBhZ2Uocm91dGUsIG9wdGlvbnMgPSB7fSkge1xuICAgIGlmICh0aGlzLmlzUnVubmluZygpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgdXBkYXRlID0gKCkgPT4ge1xuICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgICB0aGlzLnNldFN0YXRlKHtpbnRlcm5hbFN0YWNrOiBbLi4udGhpcy5zdGF0ZS5pbnRlcm5hbFN0YWNrLCByb3V0ZV19LCByZXNvbHZlKTtcbiAgICAgIH0pO1xuICAgIH07XG5cbiAgICByZXR1cm4gdGhpcy5yZWYuY3VycmVudC5fcHVzaFBhZ2Uob3B0aW9ucywgdXBkYXRlKVxuICAgICAgLnRoZW4oKCkgPT4ge1xuICAgICAgICB0aGlzLnNldFN0YXRlKHtpbnRlcm5hbFN0YWNrOiBbLi4udGhpcy5zdGF0ZS5pbnRlcm5hbFN0YWNrLnNsaWNlKDAsIC0yKSwgcm91dGVdfSk7XG4gICAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAbWV0aG9kIHBvcFBhZ2VcbiAgICogQHNpZ25hdHVyZSBwb3BQYWdlKHJvdXRlLCBvcHRpb25zID0ge30pXG4gICAqIEByZXR1cm4ge1Byb21pc2V9XG4gICAqICAgW2VuXSBQcm9taXNlIHdoaWNoIHJlc29sdmVzIHRvIHRoZSByZXZlYWxlZCBwYWdlLlsvZW5dXG4gICAqICAgW2phXeaYjuOCieOBi+OBq+OBl+OBn+ODmuODvOOCuOOCkuino+axuuOBmeOCi1Byb21pc2XjgpLov5TjgZfjgb7jgZnjgIJbL2phXVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogICBbZW5dIFBvcHMgYSBwYWdlIG91dCBvZiB0aGUgcGFnZSBzdGFja1svZW5dXG4gICAqICAgW2phXVsvamFdXG4gICAqL1xuICBwb3BQYWdlKG9wdGlvbnMgPSB7fSkge1xuICAgIGlmICh0aGlzLmlzUnVubmluZygpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgdXBkYXRlID0gKCkgPT4ge1xuICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgICBSZWFjdERPTS5mbHVzaFN5bmMoKCkgPT4geyAvLyBwcmV2ZW50cyBmbGlja2VyaW5nIGNhdXNlZCBieSBSZWFjdCAxOCBiYXRjaGluZ1xuICAgICAgICAgIHRoaXMuc2V0U3RhdGUoe2ludGVybmFsU3RhY2s6IHRoaXMuc3RhdGUuaW50ZXJuYWxTdGFjay5zbGljZSgwLCAtMSl9LCByZXNvbHZlKTtcbiAgICAgICAgfSk7XG4gICAgICB9KTtcbiAgICB9O1xuXG4gICAgcmV0dXJuIHRoaXMucmVmLmN1cnJlbnQuX3BvcFBhZ2Uob3B0aW9ucywgdXBkYXRlKTtcbiAgfVxuXG4gIF9vbkRldmljZUJhY2tCdXR0b24oZXZlbnQpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5yb3V0ZUNvbmZpZy5yb3V0ZVN0YWNrLmxlbmd0aCA+IDEpIHtcbiAgICAgIHRoaXMucG9wUGFnZSgpO1xuICAgIH0gZWxzZSB7XG4gICAgICBldmVudC5jYWxsUGFyZW50SGFuZGxlcigpO1xuICAgIH1cbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIGNvbnN0IG5vZGUgPSB0aGlzLnJlZi5jdXJyZW50O1xuXG4gICAgdGhpcy5jYW5jZWxVcGRhdGUgPSBmYWxzZTtcblxuICAgIG5vZGUuYWRkRXZlbnRMaXN0ZW5lcigncHJlcHVzaCcsIHRoaXMub25QcmVQdXNoKTtcbiAgICBub2RlLmFkZEV2ZW50TGlzdGVuZXIoJ3Bvc3RwdXNoJywgdGhpcy5vblBvc3RQdXNoKTtcbiAgICBub2RlLmFkZEV2ZW50TGlzdGVuZXIoJ3ByZXBvcCcsIHRoaXMub25QcmVQb3ApO1xuICAgIG5vZGUuYWRkRXZlbnRMaXN0ZW5lcigncG9zdHBvcCcsIHRoaXMub25Qb3N0UG9wKTtcblxuICAgIGlmICghdGhpcy5wcm9wcy5yb3V0ZUNvbmZpZykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbiBSb3V0ZXJOYXZpZ2F0b3IgdGhlIHByb3BlcnR5IHJvdXRlQ29uZmlnIG5lZWRzIHRvIGJlIHNldCcpO1xuICAgIH1cblxuICAgIG5vZGUuc3dpcGVNYXggPSB0aGlzLnByb3BzLnN3aXBlUG9wO1xuICAgIG5vZGUub25EZXZpY2VCYWNrQnV0dG9uID0gdGhpcy5wcm9wcy5vbkRldmljZUJhY2tCdXR0b24gfHwgdGhpcy5fb25EZXZpY2VCYWNrQnV0dG9uLmJpbmQodGhpcyk7XG5cbiAgICB0aGlzLnNldFN0YXRlKHtpbnRlcm5hbFN0YWNrOiB0aGlzLnByb3BzLnJvdXRlQ29uZmlnLnJvdXRlU3RhY2t9KTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIGNvbnN0IG5vZGUgPSB0aGlzLnJlZi5jdXJyZW50O1xuICAgIG5vZGUucmVtb3ZlRXZlbnRMaXN0ZW5lcigncHJlcHVzaCcsIHRoaXMub25QcmVQdXNoKTtcbiAgICBub2RlLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3Bvc3RwdXNoJywgdGhpcy5vblBvc3RQdXNoKTtcbiAgICBub2RlLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3ByZXBvcCcsIHRoaXMub25QcmVQb3ApO1xuICAgIG5vZGUucmVtb3ZlRXZlbnRMaXN0ZW5lcigncG9zdHBvcCcsIHRoaXMub25Qb3N0UG9wKTtcbiAgICB0aGlzLmNhbmNlbFVwZGF0ZSA9IHRydWU7XG4gIH1cblxuICBjb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzKSB7XG4gICAgaWYgKHRoaXMucHJvcHMub25EZXZpY2VCYWNrQnV0dG9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMucmVmLmN1cnJlbnQub25EZXZpY2VCYWNrQnV0dG9uID0gdGhpcy5wcm9wcy5vbkRldmljZUJhY2tCdXR0b247XG4gICAgfVxuXG4gICAgY29uc3QgcHJvY2Vzc1N0YWNrID0gWy4uLnRoaXMucHJvcHMucm91dGVDb25maWcucHJvY2Vzc1N0YWNrXTtcblxuICAgIC8qKlxuICAgICAqIEZpeCBmb3IgUmVkdXggVGltZXRyYXZlbC5cbiAgICAgKi9cbiAgICBpZiAocHJldlByb3BzLnJvdXRlQ29uZmlnLnByb2Nlc3NTdGFjay5sZW5ndGggPCB0aGlzLnByb3BzLnJvdXRlQ29uZmlnLnByb2Nlc3NTdGFjay5sZW5ndGggJiZcbiAgICAgIHByZXZQcm9wcy5yb3V0ZUNvbmZpZy5yb3V0ZVN0YWNrLmxlbmd0aCA+IHRoaXMucHJvcHMucm91dGVDb25maWcucm91dGVTdGFjay5sZW5ndGgpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBpZiAocHJvY2Vzc1N0YWNrLmxlbmd0aCA+IDApIHtcbiAgICAgIGNvbnN0IHt0eXBlLCByb3V0ZSwgb3B0aW9uc30gPSBwcm9jZXNzU3RhY2tbMF07XG5cbiAgICAgIHN3aXRjaCAodHlwZSkge1xuICAgICAgICBjYXNlICdwdXNoJzpcbiAgICAgICAgICB0aGlzLnB1c2hQYWdlKHJvdXRlLCBvcHRpb25zKTtcbiAgICAgICAgICBicmVhaztcbiAgICAgICAgY2FzZSAncG9wJzpcbiAgICAgICAgICB0aGlzLnBvcFBhZ2Uob3B0aW9ucyk7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGNhc2UgJ3Jlc2V0JzpcbiAgICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShyb3V0ZSkpIHtcbiAgICAgICAgICAgIHRoaXMucmVzZXRQYWdlU3RhY2socm91dGUsIG9wdGlvbnMpO1xuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB0aGlzLnJlc2V0UGFnZVN0YWNrKFtyb3V0ZV0sIG9wdGlvbnMpO1xuICAgICAgICAgIH1cbiAgICAgICAgICBicmVhaztcbiAgICAgICAgY2FzZSAncmVwbGFjZSc6XG4gICAgICAgICAgdGhpcy5yZXBsYWNlUGFnZShyb3V0ZSwgb3B0aW9ucyk7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBVbmtub3duIHR5cGUgJHt0eXBlfSBpbiBwcm9jZXNzU3RhY2tgKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3Qge1xuICAgICAgaW5uZXJSZWYsXG4gICAgICByZW5kZXJQYWdlLFxuXG4gICAgICAvLyB0aGVzZSBwcm9wcyBzaG91bGQgbm90IGJlIHBhc3NlZCBkb3duXG4gICAgICBvblByZVB1c2gsXG4gICAgICBvblBvc3RQdXNoLFxuICAgICAgb25QcmVQb3AsXG4gICAgICBvblBvc3RQb3AsXG4gICAgICBzd2lwZVBvcCxcbiAgICAgIG9uRGV2aWNlQmFja0J1dHRvbixcblxuICAgICAgLi4ucmVzdFxuICAgIH0gPSB0aGlzLnByb3BzO1xuXG4gICAgY29uc3QgcGFnZXNUb1JlbmRlciA9IHRoaXMuc3RhdGUuaW50ZXJuYWxTdGFjay5tYXAocm91dGUgPT4gcmVuZGVyUGFnZShyb3V0ZSkpO1xuXG4gICAgaWYgKGlubmVyUmVmICYmIGlubmVyUmVmICE9PSB0aGlzLnJlZikge1xuICAgICAgdGhpcy5yZWYgPSBpbm5lclJlZjtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPEVsZW1lbnQgey4uLnJlc3R9IHJlZj17dGhpcy5yZWZ9PlxuICAgICAgICB7cGFnZXNUb1JlbmRlcn1cbiAgICAgIDwvRWxlbWVudD5cbiAgICApO1xuICB9XG59XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1uYXZpZ2F0b3JcbiAqIEBjYXRlZ29yeSBuYXZpZ2F0aW9uXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL25hdmlnYXRvclxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dIFRoaXMgY29tcG9uZW50IGlzIGEgdmFyaWFudCBvZiB0aGUgTmF2aWdhdG9yIHdpdGggYSBkZWNsYXJhdGl2ZSBBUEkuIEluIG9yZGVyIHRvIG1hbmFnZSB0byBkaXNwbGF5IHRoZSBwYWdlcywgdGhlICBuYXZpZ2F0b3IgbmVlZHMgdG8gZGVmaW5lIHRoZSBgcmVuZGVyUGFnZWAgbWV0aG9kLCB0aGF0IHRha2VzIGFuIHJvdXRlIGFuZCBhIG5hdmlnYXRvciBhbmQgIGNvbnZlcnRzIGl0IHRvIGFuIHBhZ2UuWy9lbl1cbiAqIFtqYV1bL2phXVxuICovXG5jb25zdCBSb3V0ZXJOYXZpZ2F0b3IgPSBSZWFjdC5mb3J3YXJkUmVmKChwcm9wcywgcmVmKSA9PiAoXG4gIDxSb3V0ZXJOYXZpZ2F0b3JDbGFzcyBpbm5lclJlZj17cmVmfSB7Li4ucHJvcHN9Pntwcm9wcy5jaGlsZHJlbn08L1JvdXRlck5hdmlnYXRvckNsYXNzPlxuKSk7XG5cblJvdXRlck5hdmlnYXRvci5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSByZW5kZXJQYWdlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCB0cnVlXG4gICAqIEBkZWZhdWx0VmFsdWUgbnVsbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhpcyBmdW5jdGlvbiB0YWtlcyB0aGUgY3VycmVudCByb3V0ZSBvYmplY3QgYXMgYSBwYXJhbWV0ZXIgYW5kIHJldHVybnMgYSByZWFjdCBjb21wb25lbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICByZW5kZXJQYWdlOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAvKipcbiAgICogQG5hbWUgcm91dGVDb25maWdcbiAgICogQHR5cGUgb2JqZWN0XG4gICAqIEByZXF1aXJlZCB0cnVlXG4gICAqIEBkZWZhdWx0VmFsdWUgbnVsbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gVGhpcyBvYmplY3QgbXVzdCBjb250YWluIHR3byBwcm9wZXJ0aWVzOlxuICAgKiAgYHJvdXRlU3RhY2tgOiBBbiBhcnJheSBvZiByb3V0ZSBvYmplY3RzLFxuICAgKiAgYHByb2Nlc3NTdGFja2A6IEFuIGFycmF5IG9mIHByb2Nlc3Mgb2JqZWN0cyBgeyB0eXBlOiBwdXNoIHwgcG9wIHwgcmVzZXQsIHJvdXRlOiB1c2VyUm91dGUgfWAgdGhhdFxuICAgKiAgZGVzY3JpYmUgdGhlIHRyYW5zaXRpb24gZnJvbSB0aGUgY3VycmVudCBzdGF0ZSB0byB0aGUgbmV4dCBzdGF0ZS5cbiAgICogIE1ha2Ugc3VyZSB0aGF0IHRoZSByb3V0ZSBzdGFjayBpcyBub3QgZW1wdGllZCBiZWZvcmUgdGhlIGFuaW1hdGlvbnMgZm9yIHRoZSBgcHJvY2Vzc1N0YWNrYCBoYXZlIGNvbXBsZXRlZC5cbiAgICogIEl0IGlzIHJlY29tbWVuZGVkIHRvIHVwZGF0ZSB0aGUgYHJvdXRlU3RhY2tgIGFuZCBlbXB0eSB0aGUgYHByb2Nlc3NTdGFja2AgaW4gdGhlICdvblBvc3RQb3AnIGNhbGxiYWNrLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgcm91dGVDb25maWc6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgcm91dGVTdGFjazogUHJvcFR5cGVzLmFycmF5T2YoUHJvcFR5cGVzLm9iamVjdCksXG4gICAgcHJvY2Vzc1N0YWNrOiBQcm9wVHlwZXMuYXJyYXlPZihQcm9wVHlwZXMub2JqZWN0KVxuICB9KSxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVQdXNoXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQganVzdCBiZWZvcmUgYSBwYWdlIGlzIHB1c2hlZC5bL2VuXVxuICAgKi9cbiAgb25QcmVQdXNoOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0UHVzaFxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgYSBwYWdlIGlzIHB1c2hlZC5bL2VuXVxuICAgKi9cbiAgb25Qb3N0UHVzaDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlUG9wXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQganVzdCBiZWZvcmUgYSBwYWdlIGlzIHBvcHBlZC5bL2VuXVxuICAgKi9cbiAgb25QcmVQb3A6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblBvc3RQb3BcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBqdXN0IGFmdGVyIGEgcGFnZSBpcyBwb3BwZWQuWy9lbl1cbiAgICovXG4gIG9uUG9zdFBvcDogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBwcm9wZXJ0eSBhbmltYXRpb25cbiAgICogQHR5cGUge1N0cmluZ31cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICAgW2VuXVxuICAgKiAgICAgQW5pbWF0aW9uIG5hbWUuIEF2YWlsYWJsZSBhbmltYXRpb25zIGFyZSBgXCJzbGlkZVwiYCwgYFwibGlmdFwiYCwgYFwiZmFkZVwiYCBhbmQgYFwibm9uZVwiYC5cbiAgICogICAgIFRoZXNlIGFyZSBwbGF0Zm9ybSBiYXNlZCBhbmltYXRpb25zLiBGb3IgZml4ZWQgYW5pbWF0aW9ucywgYWRkIGBcIi1pb3NcImAgb3IgYFwiLW1kXCJgIHN1ZmZpeCB0byB0aGUgYW5pbWF0aW9uIG5hbWUuIEUuZy4gYFwibGlmdC1pb3NcImAsIGBcImxpZnQtbWRcImAuIERlZmF1bHRzIHZhbHVlcyBhcmUgYFwic2xpZGUtaW9zXCJgIGFuZCBgXCJmYWRlLW1kXCJgLlxuICAgKiAgIFsvZW5dXG4gICAqL1xuICBhbmltYXRpb246IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFuaW1hdGlvbk9wdGlvbnNcbiAgICogQHR5cGUgb2JqZWN0XG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIGFuaW1hdGlvbidzIGR1cmF0aW9uLCBkZWxheSBhbmQgdGltaW5nLiBFLmcuICBge2R1cmF0aW9uOiAwLjIsIGRlbGF5OiAwLjQsIHRpbWluZzogJ2Vhc2UtaW4nfWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgc3dpcGVhYmxlXG4gICAqIEB0eXBlIGJvb2x8c3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEVuYWJsZXMgc3dpcGUtdG8tcG9wIGZ1bmN0aW9uYWxpdHkgZm9yIGlPUy5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHN3aXBlYWJsZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmJvb2wsIFByb3BUeXBlcy5zdHJpbmddKSxcblxuICAvKipcbiAgICogQG5hbWUgc3dpcGVQb3BcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgRnVuY3Rpb24gY2FsbGVkIG9uIHN3aXBlLXRvLXBvcC4gTXVzdCBwZXJmb3JtIGEgcG9wUGFnZSB3aXRoIHRoZSBnaXZlbiBvcHRpb25zIG9iamVjdC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHN3aXBlUG9wOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EZXZpY2VCYWNrQnV0dG9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1c3RvbSBoYW5kbGVyIGZvciBkZXZpY2UgYmFjayBidXR0b24uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRldmljZUJhY2tCdXR0b246IFByb3BUeXBlcy5mdW5jXG59O1xuXG5leHBvcnQgZGVmYXVsdCBSb3V0ZXJOYXZpZ2F0b3I7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtcm93JztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1yb3dcbiAqIEBjYXRlZ29yeSBncmlkXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqIFJlcHJlc2VudHMgYSByb3cgaW4gdGhlIGdyaWQgc3lzdGVtLiBVc2Ugd2l0aCBgQ29sYCB0byBsYXlvdXQgY29tcG9uZW50cy5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIDxSb3c+XG4gKiAgIDxDb2wgd2lkdGg9ezUwfT5cbiAgKiAgIDxvbnMtaWNvbiBpY29uPVwiZmEtdHdpdHRlclwiPjwvb25zLWljb24+XG4gKiAgIDwvQ29sPlxuICogICA8Q29sPlRleHQ8L0NvbD5cbiAqIDwvUm93PlxuICovXG5jb25zdCBSb3cgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtcm93Jyk7XG5cblJvdy5wcm9wVHlwZXMgPSB7XG5cbiAgLyoqXG4gICogQG5hbWUgdmVydGljYWxBbGlnblxuICAqIEB0eXBlIHtTdHJpbmd9XG4gICogQGRlc2NyaXB0aW9uXG4gICogICBbZW5dU2hvcnQgaGFuZCBhdHRyaWJ1dGUgZm9yIGFsaWduaW5nIHZlcnRpY2FsbHkuIFZhbGlkIHZhbHVlcyBhcmUgdG9wLCBib3R0b20sIGFuZCBjZW50ZXIuWy9lbl1cbiAgKiAgIFtqYV1bL2phXVxuICAqL1xuICB2ZXJ0aWNhbEFsaWduOiBQcm9wVHlwZXMub25lT2YoWyd0b3AnLCAnYm90dG9tJywgJ2NlbnRlciddKVxuXG59O1xuXG5leHBvcnQgZGVmYXVsdCBSb3c7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtc2VhcmNoLWlucHV0JztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5pbXBvcnQgb25lVGltZVByb3AgZnJvbSAnLi4vb25lVGltZVByb3AnO1xuaW1wb3J0IElOUFVUX1BST1BTIGZyb20gJy4uL2lucHV0UHJvcHMnO1xuXG5jb25zdCBuYW1lTWFwID0ge1xuICAuLi5JTlBVVF9QUk9QU1xufTtcblxuY29uc3Qgd2l0aERlZmF1bHRWYWx1ZSA9IGNvbXBvbmVudCA9PiBvbmVUaW1lUHJvcChjb21wb25lbnQsICdkZWZhdWx0VmFsdWUnLCAndmFsdWUnKTtcblxuY29uc3Qgbm90QXR0cmlidXRlcyA9IFtcbiAgJ3ZhbHVlJyAvLyB2YWx1ZSBtdXN0IGJlIGFwcGxpZWQgYXMgcHJvcGVydHkgc2luY2UgYXR0cmlidXRlIG9ubHkgd29ya3MgYmVmb3JlIGlucHV0IGlzIHRvdWNoZWRcbl07XG5cblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXNlYXJjaC1pbnB1dFxuICogQGNhdGVnb3J5IGZvcm1cbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2Uvc2VhcmNoLWlucHV0XG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqICBBIHNlYXJjaCBpbnB1dCBjb21wb25lbnQuIFRoZSBjb21wb25lbnQgd2lsbCBhdXRvbWF0aWNhbGx5IHJlbmRlciBhcyBhIE1hdGVyaWFsIERlc2lnbiBzZWFyY2ggaW5wdXQgb24gQW5kcm9pZCBkZXZpY2VzLlxuICpcbiAqICBNb3N0IGF0dHJpYnV0ZXMgdGhhdCBjYW4gYmUgdXNlZCBmb3IgYSBub3JtYWwgYDxpbnB1dD5gIGVsZW1lbnQgY2FuIGFsc28gYmUgdXNlZCBvbiB0aGUgYDxTZWFyY2hJbnB1dD5gIGNvbXBvbmVudC5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gKiA8U2VhcmNoSW5wdXRcbiAqICAgdmFsdWU9e3RoaXMuc3RhdGUudGV4dH1cbiAqICAgb25DaGFuZ2U9eyhldmVudCkgPT4geyB0aGlzLnNldFN0YXRlKHt0ZXh0OiBldmVudC50YXJnZXQudmFsdWV9KX0gfVxuICogICBtb2RpZmllcj0nbWF0ZXJpYWwnXG4gKiAgIHBsYWNlaG9sZGVyPSdVc2VybmFtZScgLz5cbiAqL1xuY29uc3QgU2VhcmNoSW5wdXQgPSB3aXRoRGVmYXVsdFZhbHVlKG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1zZWFyY2gtaW5wdXQnLCB7ZGVwcmVjYXRlZDogbmFtZU1hcCwgbm90QXR0cmlidXRlc30pKTtcblxuU2VhcmNoSW5wdXQucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgaW5wdXQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGlucHV0IGlzIGRpc2FibGVkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgcmVhZE9ubHlcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TcGVjaWZpZXMgd2hldGhlciB0aGUgaW5wdXQgaXMgcmVhZC1vbmx5LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHJlYWRPbmx5OiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25DaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIHdoZW4gdGhlIGlubmVyIGlucHV0IGZpcmVzIGEgYGNoYW5nZWAgZXZlbnQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbklucHV0XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSBpbm5lciBpbnB1dCBmaXJlcyBhbiBgaW5wdXRgIGV2ZW50LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uSW5wdXQ6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSB2YWx1ZVxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ29udGVudCBvZiB0aGUgaW5wdXQgKGNvbnRyb2xsZWQpLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHZhbHVlOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIFByb3BUeXBlcy5pbnN0YW5jZU9mKERhdGUpXG4gIF0pLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkZWZhdWx0VmFsdWVcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNvbnRlbnQgb2YgdGhlIGlucHV0IGF0IGZpcnN0IHJlbmRlciAodW5jb250cm9sbGVkKS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkZWZhdWx0VmFsdWU6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgUHJvcFR5cGVzLmluc3RhbmNlT2YoRGF0ZSlcbiAgXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIHBsYWNlaG9sZGVyXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gUGxhY2Vob2xkZXIgdGV4dC4gSW4gTWF0ZXJpYWwgRGVzaWduIHRoaXMgcGxhY2Vob2xkZXIgd2lsbCBiZSBhIGZsb2F0aW5nIGxhYmVsLiBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBwbGFjZWhvbGRlcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgaW5wdXRJZFxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dICBTcGVjaWZ5IHRoZSBcImlkXCIgYXR0cmlidXRlIG9mIHRoZSBpbm5lciBgPGlucHV0PmAgZWxlbWVudC4gVGhpcyBpcyB1c2VmdWwgd2hlbiB1c2luZyA8bGFiZWwgZm9yPVwiLi4uXCI+IGVsZW1lbnRzIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGlucHV0SWQ6IFByb3BUeXBlcy5zdHJpbmdcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFNlYXJjaElucHV0O1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXNlZ21lbnQnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3QgZGVwcmVjYXRlZCA9IHtcbiAgaW5kZXg6ICdhY3RpdmVJbmRleCdcbn07XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1zZWdtZW50XG4gKiBAY2F0ZWdvcnkgY29udHJvbFxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9zZWdtZW50XG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqICAgU2VnbWVudCBjb21wb25lbnQuXG4gKiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPFNlZ21lbnQgbW9kaWZpZXI9XCJtYXRlcmlhbFwiPlxuICogIDxidXR0b24+TGFiZWwgMTwvYnV0dG9uPlxuICogIDxidXR0b24+TGFiZWwgMjwvYnV0dG9uPlxuICogIDxidXR0b24+TGFiZWwgMzwvYnV0dG9uPlxuICogPC9TZWdtZW50PlxuICovXG5jb25zdCBTZWdtZW50ID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLXNlZ21lbnQnLCB7ZGVwcmVjYXRlZH0pO1xuXG5TZWdtZW50LnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIGFjdGl2ZUluZGV4XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgaW5kZXggb2YgdGhlIGJ1dHRvbiB0byBoaWdobGlnaHQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYWN0aXZlSW5kZXg6IFByb3BUeXBlcy5udW1iZXIsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGluZGV4XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1ERVBSRUNBVEVEISBVc2UgYGFjdGl2ZUluZGV4YCBpbnN0ZWFkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGluZGV4OiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSB0YWJiYXJJZFxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIElEIG9mIHRoZSBgPFRhYmJhcj5gIHRvIFwiY29ubmVjdFwiIHRvIHRoZSBzZWdtZW50LiBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB0YWJiYXJJZDogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgc2VnbWVudC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0Q2hhbmdlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBDYWxsZWQgYWZ0ZXIgdGhlIGFjdGl2ZSBidXR0b24gY2hhbmdlcy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RDaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sZWFuXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgIFtlbl1TcGVjaWZpZXMgd2hldGhlciB0aGUgc2VnbWVudCBzaG91bGQgYmUgZGlzYWJsZWQuWy9lbl1cbiAgICogICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbFxufTtcblxuZXhwb3J0IGRlZmF1bHQgU2VnbWVudDtcbiIsImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtc2VsZWN0JztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5pbXBvcnQgb25lVGltZVByb3AgZnJvbSAnLi4vb25lVGltZVByb3AnO1xuaW1wb3J0IElOUFVUX1BST1BTIGZyb20gJy4uL2lucHV0UHJvcHMnO1xuXG5jb25zdCBuYW1lTWFwID0ge1xuICAuLi5JTlBVVF9QUk9QU1xufTtcblxuY29uc3Qgd2l0aERlZmF1bHRWYWx1ZSA9IGNvbXBvbmVudCA9PiBvbmVUaW1lUHJvcChjb21wb25lbnQsICdkZWZhdWx0VmFsdWUnLCAndmFsdWUnKTtcbmNvbnN0IEVsZW1lbnQgPSB3aXRoRGVmYXVsdFZhbHVlKG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1zZWxlY3QnLCB7ZGVwcmVjYXRlZDogbmFtZU1hcH0pKTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXNlbGVjdFxuICogQGNhdGVnb3J5IGZvcm1cbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2Uvc2VsZWN0XG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl1cbiAqICAgU2VsZWN0IGlucHV0IGNvbXBvbmVudC5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gKiA8U2VsZWN0IG1vZGlmaWVyPVwibWF0ZXJpYWxcIlxuICogICB2YWx1ZT17dGhpcy5zdGF0ZS52YWx1ZX1cbiAqICAgb25DaGFuZ2U9eyhldmVudCkgPT4gdGhpcy5zZXRTdGF0ZSh7dmFsdWU6IGV2ZW50LnRhcmdldC52YWx1ZX0pfT5cbiAqICAgPG9wdGlvbiB2YWx1ZT1cIjFcIj4xPC9vcHRpb24+XG4gKiAgIDxvcHRpb24gdmFsdWU9XCIyXCI+Mm5kPC9vcHRpb24+XG4gKiAgIDxvcHRpb24gdmFsdWU9XCIzXCI+M3JkIG9wdGlvbjwvb3B0aW9uPlxuICogPC9TZWxlY3Q+XG4gKi9cbmNvbnN0IFNlbGVjdCA9IFJlYWN0LmZvcndhcmRSZWYoKHByb3BzLCByZWYpID0+IChcbiAgPEVsZW1lbnQgey4uLnByb3BzfSByZWY9e3JlZn0+XG4gICAgPHNlbGVjdD5cbiAgICAgIHtwcm9wcy5jaGlsZHJlbn1cbiAgICA8L3NlbGVjdD5cbiAgPC9FbGVtZW50PlxuKSk7XG5cblNlbGVjdC5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIHNlbGVjdCBib3guWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbW9kaWZpZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmaWVzIHdoZXRoZXIgdGhlIHNlbGVjdCBpcyBkaXNhYmxlZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uQ2hhbmdlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCB3aGVuIHRoZSB2YWx1ZSBvZiB0aGUgc2VsZWN0IGNoYW5nZXMuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSB2YWx1ZVxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVXNlIHRoaXMgcHJvcCB0byBzZXQgdGhlIHNlbGVjdGVkIG9wdGlvbiB2YWx1ZS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB2YWx1ZTogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgZGVmYXVsdFZhbHVlXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Vc2UgdGhpcyBwcm9wIHRvIHNldCB0aGUgZGVmYWx1dCBzZWxlY3RlZCBvcHRpb24gdmFsdWUgKHVuY29udHJvbGxlZCBjb21wb25lbnRzKS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBkZWZhdWx0VmFsdWU6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG11bHRpcGxlXG4gICAqIEB0eXBlIGJvb2xlYW5cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSWYgdGhpcyBhdHRyaWJ1dGUgaXMgZGVmaW5lZCwgbXVsdGlwbGUgb3B0aW9ucyBjYW4gYmUgc2VsZWN0ZWQgYXQgb25jZS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtdWx0aXBsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGF1dG9mb2N1c1xuICAgKiBAdHlwZSBib29sZWFuXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUVsZW1lbnQgYXV0b21hdGljYWxseSBnYWlucyBmb2N1cyBvbiBwYWdlIGxvYWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYXV0b2ZvY3VzOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgcmVxdWlyZWRcbiAgICogQHR5cGUgYm9vbGVhblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1NYWtlIHRoZSBzZWxlY3QgaW5wdXQgcmVxdWlyZWQgZm9yIHN1Ym1pdHRpbmcgdGhlIGZvcm0gaXQgaXMgcGFydCBvZi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICByZXF1aXJlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGZvcm1cbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUFzc29jaWF0ZSBhIHNlbGVjdCBlbGVtZW50IHRvIGFuIGV4aXN0aW5nIGZvcm0gb24gdGhlIHBhZ2UsIGV2ZW4gaWYgbm90IG5lc3RlZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBmb3JtOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBzaXplXG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Ib3cgbWFueSBvcHRpb25zIGFyZSBkaXNwbGF5ZWQ7IGlmIHRoZXJlIGFyZSBtb3JlIHRoYW4gdGhlIHNpemUgdGhlbiBhIHNjcm9sbCBhcHBlYXJzIHRvIG5hdmlnYXRlIHRoZW1bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBzaXplOiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBuYW1lXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1OYW1lIHRoZSBzZWxlY3QgZWxlbWVudCwgdXNlZnVsIGZvciBpbnN0YW5jZSBpZiBpdCBpcyBwYXJ0IG9mIGEgZm9ybS5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBuYW1lOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG5leHBvcnQgZGVmYXVsdCBTZWxlY3Q7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtc3BlZWQtZGlhbCc7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtc3BlZWQtZGlhbFxuICogQGNhdGVnb3J5IGNvbnRyb2xcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2Uvc3BlZWQtZGlhbFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dIEVsZW1lbnQgdGhhdCBkaXNwbGF5cyBhIE1hdGVyaWFsIERlc2lnbiBTcGVlZCBEaWFsb2cgY29tcG9uZW50LiBJdCBpcyB1c2VmdWwgd2hlbiB0aGVyZSBhcmUgbW9yZSB0aGFuIG9uZSBwcmltYXJ5IGFjdGlvbiB0aGF0IGNhbiBiZSBwZXJmb3JtZWQgaW4gYSBwYWdlLlxuICogIFRoZSBTcGVlZCBkaWFsIGxvb2tzIGxpa2UgYSBgRmFiYCBlbGVtZW50IGJ1dCB3aWxsIGV4cGFuZCBhIG1lbnUgd2hlbiB0YXBwZWQuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqIDxTcGVlZERpYWwgZGlzYWJsZWQ9e2ZhbHNlfSBkaXJlY3Rpb249J3JpZ2h0JyBvbkNsaWNrPXsoKSA9PiBjb25zb2xlLmxvZygndGVzdDEnKX0gcG9zaXRpb249J2xlZnQgYm90dG9tJz5cbiAgICAgPEZhYj5cbiAgICAgICA8SWNvbiBpY29uPSdmYS10d2l0dGVyJyBzaXplPXsyNn0gZml4ZWRXaWR0aD17ZmFsc2V9IHN0eWxlPXt7dmVydGljYWxBbGlnbjogJ21pZGRsZSd9fSAvPlxuICAgICA8L0ZhYj5cbiAgICAgPFNwZWVkRGlhbEl0ZW0gb25DbGljaz17KCkgPT4gY29uc29sZS5sb2coJ3NwZWVkIEEnKX0+IEEgPC9TcGVlZERpYWxJdGVtPlxuICAgICA8U3BlZWREaWFsSXRlbSBvbkNsaWNrPXsoKSA9PiBjb25zb2xlLmxvZygnc3BlZWQgQicpfT4gQiA8L1NwZWVkRGlhbEl0ZW0+XG4gICAgIDxTcGVlZERpYWxJdGVtIG9uQ2xpY2s9eygpID0+IGNvbnNvbGUubG9nKCdzcGVlZCBDJyl9PiBDIDwvU3BlZWREaWFsSXRlbT5cbiAgICAgPFNwZWVkRGlhbEl0ZW0gb25DbGljaz17KCkgPT4gY29uc29sZS5sb2coJ3NwZWVkIEQnKX0+IEQgPC9TcGVlZERpYWxJdGVtPlxuICAgPC9TcGVlZERpYWw+XG4gKi9cbmNvbnN0IFNwZWVkRGlhbCA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1zcGVlZC1kaWFsJyk7XG5cblNwZWVkRGlhbC5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBzcGVlZCBkaWFsLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBwb3NpdGlvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgdmVydGljYWwgYW5kIGhvcml6b250YWwgcG9zaXRpb24gb2YgdGhlIGNvbXBvbmVudC5cbiAgICogICAgIEkuZS4gdG8gZGlzcGxheSBpdCBpbiB0aGUgdG9wIHJpZ2h0IGNvcm5lciBzcGVjaWZ5IFwicmlnaHQgdG9wXCIuXG4gICAqICAgICBDaG9vc2UgZnJvbSBcInJpZ2h0XCIsIFwibGVmdFwiLCBcInRvcFwiIGFuZCBcImJvdHRvbVwiLlxuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgcG9zaXRpb246IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpcmVjdGlvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgZGlyZWN0aW9uIHRoZSBpdGVtcyBhcmUgZGlzcGxheWVkLiBQb3NzaWJsZSB2YWx1ZXMgYXJlIFwidXBcIiwgXCJkb3duXCIsIFwibGVmdFwiIGFuZCBcInJpZ2h0XCIuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZGlyZWN0aW9uOiBQcm9wVHlwZXMub25lT2YoWyd1cCcsICdkb3duJywgJ2xlZnQnLCAncmlnaHQnXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRpc2FibGVkXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TcGVjaWZ5IGlmIGJ1dHRvbiBzaG91bGQgYmUgZGlzYWJsZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZGlzYWJsZWQ6IFByb3BUeXBlcy5ib29sXG59O1xuXG5leHBvcnQgZGVmYXVsdCBTcGVlZERpYWw7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtc3BlZWQtZGlhbC1pdGVtJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1zcGVlZC1kaWFsLWl0ZW1cbiAqIEBjYXRlZ29yeSBjb250cm9sXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL3NwZWVkLWRpYWxcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXSBUaGlzIGNvbXBvbmVudCBkaXNwbGF5cyB0aGUgY2hpbGQgZWxlbWVudHMgb2YgdGhlIE1hdGVyaWFsIERlc2lnbiBTcGVlZCBkaWFsIGNvbXBvbmVudC4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqIDxTcGVlZERpYWwgZGlzYWJsZWQ9e2ZhbHNlfSBkaXJlY3Rpb249J3JpZ2h0JyBvbkNsaWNrPXsoKSA9PiBjb25zb2xlLmxvZygndGVzdDEnKX0gcG9zaXRpb249J2xlZnQgYm90dG9tJz5cbiAgICAgPEZhYj5cbiAgICAgICA8SWNvbiBpY29uPSdmYS10d2l0dGVyJyBzaXplPXsyNn0gZml4ZWRXaWR0aD17ZmFsc2V9IHN0eWxlPXt7dmVydGljYWxBbGlnbjogJ21pZGRsZSd9fSAvPlxuICAgICA8L0ZhYj5cbiAgICAgPFNwZWVkRGlhbEl0ZW0gb25DbGljaz17KCkgPT4gY29uc29sZS5sb2coJ3NwZWVkIEEnKX0+IEEgPC9TcGVlZERpYWxJdGVtPlxuICAgICA8U3BlZWREaWFsSXRlbSBvbkNsaWNrPXsoKSA9PiBjb25zb2xlLmxvZygnc3BlZWQgQicpfT4gQiA8L1NwZWVkRGlhbEl0ZW0+XG4gICAgIDxTcGVlZERpYWxJdGVtIG9uQ2xpY2s9eygpID0+IGNvbnNvbGUubG9nKCdzcGVlZCBDJyl9PiBDIDwvU3BlZWREaWFsSXRlbT5cbiAgICAgPFNwZWVkRGlhbEl0ZW0gb25DbGljaz17KCkgPT4gY29uc29sZS5sb2coJ3NwZWVkIEQnKX0+IEQgPC9TcGVlZERpYWxJdGVtPlxuICAgPC9TcGVlZERpYWw+XG4gKi9cbmNvbnN0IFNwZWVkRGlhbEl0ZW0gPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtc3BlZWQtZGlhbC1pdGVtJyk7XG5cblNwZWVkRGlhbEl0ZW0ucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgYnV0dG9uLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkNsaWNrXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoaXMgZnVuY3Rpb24gd2lsbCBiZSBjYWxsZWQgd2hlbiB0aGUgYnV0dG9uIGlzIGNsaWNrZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DbGljazogUHJvcFR5cGVzLmZ1bmNcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFNwZWVkRGlhbEl0ZW07XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtc3BsaXR0ZXInO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3Qgbm90QXR0cmlidXRlcyA9IFsnb25EZXZpY2VCYWNrQnV0dG9uJ107XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1zcGxpdHRlclxuICogQGNhdGVnb3J5IG1lbnVcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2Uvc3BsaXR0ZXJcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXSAgQSBjb21wb25lbnQgdGhhdCBlbmFibGVzIHJlc3BvbnNpdmUgbGF5b3V0IGJ5IGltcGxlbWVudGluZyBib3RoIGEgdHdvLWNvbHVtbiBsYXlvdXQgYW5kIGEgc2xpZGluZyBtZW51IGxheW91dC5cbiAqXG4gKiAgICBJdCBjYW4gYmUgY29uZmlndXJlZCB0byBhdXRvbWF0aWNhbGx5IGV4cGFuZCBpbnRvIGEgY29sdW1uIGxheW91dCBvbiBsYXJnZSBzY3JlZW5zIGFuZCBjb2xsYXBzZSB0aGUgbWVudSBvbiBzbWFsbGVyIHNjcmVlbnMuIFdoZW4gdGhlIG1lbnUgaXMgY29sbGFwc2VkIHRoZSB1c2VyIGNhbiBvcGVuIGl0IGJ5IHN3aXBpbmcuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAgPFNwbGl0dGVyPlxuICAgIDxTcGxpdHRlclNpZGVcbiAgICAgIHNpZGU9XCJsZWZ0XCJcbiAgICAgIHdpZHRoPXsyMDB9XG4gICAgICBpc1N3aXBlYWJsZT17dHJ1ZX0+XG4gICAgICA8UGFnZT4gUGFnZSBMZWZ0IDwvUGFnZT5cbiAgICA8L1NwbGl0dGVyU2lkZT5cbiAgICA8U3BsaXR0ZXJDb250ZW50PlxuICAgICAgPFBhZ2U+IFBhZ2UgQ29udGVudCA8L1BhZ2U+XG4gICAgPC9TcGxpdHRlckNvbnRlbnQ+XG4gICAgPFNwbGl0dGVyU2lkZVxuICAgICAgc2lkZT1cInJpZ2h0XCJcbiAgICAgIHdpZHRoPXszMDB9XG4gICAgICBjb2xsYXBzZT17IXRoaXMuc3RhdGUuc2hvd1JpZ2h0fVxuICAgICAgaXNPcGVuPXt0aGlzLnN0YXRlLm9wZW5SaWdodH1cbiAgICAgIG9uQ2xvc2U9e3RoaXMuaGFuZGxlUmlnaHRDbG9zZS5iaW5kKHRoaXMpfVxuICAgICAgb25PcGVuPXt0aGlzLmhhbmRsZVJpZ2h0T3Blbi5iaW5kKHRoaXMpfVxuICAgICAgaXNTd2lwZWFibGU9e3RydWV9PlxuICAgICAgPFBhZ2U+IFBhZ2UgUmlnaHQgPC9QYWdlPlxuICAgIDwvU3BsaXR0ZXJTaWRlPlxuICA8L1NwbGl0dGVyPlxuICovXG5jb25zdCBTcGxpdHRlciA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1zcGxpdHRlcicsIHtub3RBdHRyaWJ1dGVzfSk7XG5cblNwbGl0dGVyLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIG9uRGV2aWNlQmFja0J1dHRvblxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDdXN0b20gaGFuZGxlciBmb3IgZGV2aWNlIGJhY2sgYnV0dG9uLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25EZXZpY2VCYWNrQnV0dG9uOiBQcm9wVHlwZXMuZnVuY1xufTtcblxuZXhwb3J0IGRlZmF1bHQgU3BsaXR0ZXI7XG4iLCJpbXBvcnQgJ29uc2VudWkvZXNtL2VsZW1lbnRzL29ucy1zcGxpdHRlci1jb250ZW50JztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1zcGxpdHRlci1jb250ZW50XG4gKiBAY2F0ZWdvcnkgbWVudVxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9zcGxpdHRlclxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dICBUaGUgU3BsaXR0ZXJDb250ZW50ICBlbGVtZW50IGlzIHVzZWQgYXMgYSBjaGlsZCBlbGVtZW50IG9mIFNwbGl0dGVyLlxuICogICAgSXQgY29udGFpbnMgdGhlIG1haW4gY29udGVudCBvZiB0aGUgcGFnZSB3aGlsZSBTcGxpdHRlclNpZGUgY29udGFpbnMgdGhlIGxpc3QuXG4gWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAgPFNwbGl0dGVyPlxuICAgIDxTcGxpdHRlclNpZGVcbiAgICAgIHNpZGU9XCJsZWZ0XCJcbiAgICAgIHdpZHRoPXsyMDB9XG4gICAgICBpc1N3aXBlYWJsZT17dHJ1ZX0+XG4gICAgICA8UGFnZT4gUGFnZSBMZWZ0IDwvUGFnZT5cbiAgICA8L1NwbGl0dGVyU2lkZT5cbiAgICA8U3BsaXR0ZXJDb250ZW50PlxuICAgICAgPFBhZ2U+IFBhZ2UgQ29udGVudCA8L1BhZ2U+XG4gICAgPC9TcGxpdHRlckNvbnRlbnQ+XG4gICAgPFNwbGl0dGVyU2lkZVxuICAgICAgc2lkZT1cInJpZ2h0XCJcbiAgICAgIHdpZHRoPXszMDB9XG4gICAgICBjb2xsYXBzZT17IXRoaXMuc3RhdGUuc2hvd1JpZ2h0fVxuICAgICAgaXNPcGVuPXt0aGlzLnN0YXRlLm9wZW5SaWdodH1cbiAgICAgIG9uQ2xvc2U9e3RoaXMuaGFuZGxlUmlnaHRDbG9zZS5iaW5kKHRoaXMpfVxuICAgICAgb25PcGVuPXt0aGlzLmhhbmRsZVJpZ2h0T3Blbi5iaW5kKHRoaXMpfVxuICAgICAgaXNTd2lwZWFibGU9e3RydWV9PlxuICAgICAgPFBhZ2U+IFBhZ2UgUmlnaHQgPC9QYWdlPlxuICAgIDwvU3BsaXR0ZXJTaWRlPlxuICA8L1NwbGl0dGVyPlxuICovXG5jb25zdCBTcGxpdHRlckNvbnRlbnQgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtc3BsaXR0ZXItY29udGVudCcpO1xuXG5leHBvcnQgZGVmYXVsdCBTcGxpdHRlckNvbnRlbnQ7XG4iLCJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXNwbGl0dGVyLXNpZGUnO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3QgZGVwcmVjYXRlZCA9IHtcbiAgb25PcGVuOiAnb25Qb3N0T3BlbicsXG4gIG9uQ2xvc2U6ICdvblBvc3RDbG9zZSdcbn07XG5jb25zdCBub3RBdHRyaWJ1dGVzID0gWydpc09wZW4nXTtcblxuY29uc3QgRWxlbWVudCA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy1zcGxpdHRlci1zaWRlJywge2RlcHJlY2F0ZWQsIG5vdEF0dHJpYnV0ZXN9KTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXNwbGl0dGVyLXNpZGVcbiAqIEBjYXRlZ29yeSBtZW51XG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL3NwbGl0dGVyXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gIFRoZSBTcGxpdHRlckNvbnRlbnQgIGVsZW1lbnQgaXMgdXNlZCBhcyBhIGNoaWxkIGVsZW1lbnQgb2YgU3BsaXR0ZXIuXG4gKiAgICBJdCBjb250YWlucyB0aGUgbWFpbiBjb250ZW50IG9mIHRoZSBwYWdlIHdoaWxlIFNwbGl0dGVyU2lkZSBjb250YWlucyB0aGUgbGlzdC5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICA8U3BsaXR0ZXI+XG4gICAgPFNwbGl0dGVyU2lkZVxuICAgICAgc2lkZT1cImxlZnRcIlxuICAgICAgd2lkdGg9ezIwMH1cbiAgICAgIHN3aXBlYWJsZT17dHJ1ZX0+XG4gICAgICA8UGFnZT4gUGFnZSBMZWZ0IDwvUGFnZT5cbiAgICA8L1NwbGl0dGVyU2lkZT5cbiAgICA8U3BsaXR0ZXJDb250ZW50PlxuICAgICAgPFBhZ2U+IFBhZ2UgQ29udGVudCA8L1BhZ2U+XG4gICAgPC9TcGxpdHRlckNvbnRlbnQ+XG4gICAgPFNwbGl0dGVyU2lkZVxuICAgICAgc2lkZT1cInJpZ2h0XCJcbiAgICAgIHdpZHRoPXszMDB9XG4gICAgICBjb2xsYXBzZT17IXRoaXMuc3RhdGUuc2hvd1JpZ2h0fVxuICAgICAgaXNPcGVuPXt0aGlzLnN0YXRlLm9wZW5SaWdodH1cbiAgICAgIG9uQ2xvc2U9e3RoaXMuaGFuZGxlUmlnaHRDbG9zZS5iaW5kKHRoaXMpfVxuICAgICAgb25PcGVuPXt0aGlzLmhhbmRsZVJpZ2h0T3Blbi5iaW5kKHRoaXMpfVxuICAgICAgc3dpcGVhYmxlPXt0cnVlfT5cbiAgICAgIDxQYWdlPiBQYWdlIFJpZ2h0IDwvUGFnZT5cbiAgICA8L1NwbGl0dGVyU2lkZT5cbiAgPC9TcGxpdHRlcj5cbiAqL1xuY29uc3QgU3BsaXR0ZXJTaWRlID0gUmVhY3QuZm9yd2FyZFJlZigocHJvcHMsIHJlZikgPT4ge1xuICBjb25zdCB7d2lkdGgsIC4uLnJlc3R9ID0gcHJvcHM7XG5cbiAgLy8gbnVtYmVyIHZhbHVlcyBmb3Igd2lkdGggYXJlIGRlcHJlY2F0ZWQgYnV0IGhhbmRsZSB0aGVtIHNhZmVseSB0byBhdm9pZCBicmVha2luZyB1c2VyIGNvZGVcbiAgY29uc3QgcmVhbFdpZHRoID0gdHlwZW9mIHdpZHRoID09PSAnbnVtYmVyJyA/IGAke3dpZHRofXB4YCA6IHdpZHRoO1xuXG4gIHJldHVybiAoXG4gICAgPEVsZW1lbnRcbiAgICAgIHdpZHRoPXtyZWFsV2lkdGh9XG4gICAgICByZWY9e3JlZn1cbiAgICAgIHsuLi5yZXN0fVxuICAgID5cbiAgICAgIHtwcm9wcy5jaGlsZHJlbn1cbiAgICA8L0VsZW1lbnQ+XG4gICk7XG59KTtcblxuU3BsaXR0ZXJTaWRlLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIGNvbGxhcHNlXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gU3BlY2lmeSB0aGUgY29sbGFwc2UgYmVoYXZpb3IuIFZhbGlkIHZhbHVlcyBhcmUgYFwicG9ydHJhaXRcImAsIGBcImxhbmRzY2FwZVwiYCBvciBhIG1lZGlhIHF1ZXJ5LlxuICAgKiAgICAgVGhlIHN0cmluZ3MgYFwicG9ydHJhaXRcImAgYW5kIGBcImxhbmRzY2FwZVwiYCBtZWFucyB0aGUgdmlldyB3aWxsIGNvbGxhcHNlIHdoZW4gZGV2aWNlIGlzIGluIGxhbmRzY2FwZSBvciBwb3J0cmFpdCBvcmllbnRhdGlvbi5cbiAgICogICAgIElmIHRoZSB2YWx1ZSBpcyBub3QgZGVmaW5lZCwgdGhlIHZpZXcgYWx3YXlzIGJlIGluIGBcImNvbGxhcHNlXCJgIG1vZGUuXG5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBjb2xsYXBzZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmJvb2wsIFByb3BUeXBlcy5zdHJpbmddKSxcblxuICAvKipcbiAgICogQG5hbWUgc3dpcGVhYmxlXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dRW5uYWJsZSBzd2lwZSBpbnRlcmFjdGlvbiBvbiBjb2xsYXBzZSBtb2RlLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHN3aXBlYWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlzT3BlblxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZmllcyB3aGV0aGVyIHRoZSBtZW51IGlzIG9wZW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaXNPcGVuOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0T3BlblxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1DYWxsZWQgYWZ0ZXIgdGhlIG1lbnUgaXMgb3BlbmVkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUG9zdE9wZW46IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbk9wZW5cbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dREVQUkVDQVRFRCEgVXNlIGBvblBvc3RPcGVuYCBpbnN0ZWFkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uT3BlbjogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUG9zdENsb3NlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBhZnRlciB0aGUgbWVudSBpcyBjbG9zZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Qb3N0Q2xvc2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbkNsb3NlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXURFUFJFQ0FURUQhIFVzZSBgb25Qb3N0Q2xvc2VgIGluc3RlYWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25DbG9zZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHNpZGVcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgd2hpY2ggc2lkZSBvZiB0aGUgc2NyZWVuIHRoZSBTcGxpdHRlclNpZGUgZWxlbWVudCBpcyBsb2NhdGVkLiBQb3NzaWJsZSB2YWx1ZXMgYXJlIGBcImxlZnRcImAgYW5kIGBcInJpZ2h0XCJgLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHNpZGU6IFByb3BUeXBlcy5vbmVPZihbJ2xlZnQnLCAncmlnaHQnXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIHN3aXBlVGFyZ2V0V2lkdGhcbiAgICogQHR5cGUgbnVtYmVyXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSB3aWR0aCBvZiBzd2lwZWFibGUgYXJlYSBjYWxjdWxhdGVkIGZyb20gdGhlIGVkZ2UgKGluIHBpeGVscykuIFVzZSB0aGlzIHRvIGVuYWJsZSBzd2lwZSBvbmx5IHdoZW4gdGhlIGZpbmdlciB0b3VjaCBvbiB0aGUgc2NyZWVuIGVkZ2UuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc3dpcGVUYXJnZXRXaWR0aDogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgd2lkdGhcbiAgICogQHR5cGUgIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TcGVjaWZpZXMgdGhlIHdpZHRoIG9mIHRoZSBtZW51LiBDYW4gYmUgc3BlY2lmaWVkIGluIGVpdGhlciBwaXhlbHMgb3IgYXMgYSBwZXJjZW50YWdlLCBlLmcuIGBcIjkwJVwiYCBvciBgXCIyMDBweFwiYC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICB3aWR0aDogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dU3BlY2lmeSB0aGUgYW5pbWF0aW9uLiBVc2Ugb25lIG9mIGBvdmVybGF5YCwgYHB1c2hgLCBgcmV2ZWFsYCwgb3IgYGRlZmF1bHRgLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGFuaW1hdGlvbjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uT3B0aW9uc1xuICAgKiBAdHlwZSBvYmplY3RcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIGFuaW1hdGlvbidzIGR1cmF0aW9uLCBkZWxheSBhbmQgdGltaW5nLiBFLmcuICBge2R1cmF0aW9uOiAwLjIsIGRlbGF5OiAwLjQsIHRpbWluZzogJ2Vhc2UtaW4nfWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgb3BlblRocmVzaG9sZFxuICAgKiBAdHlwZSBvYmplY3RcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBTcGVjaWZ5IGhvdyBtdWNoIHRoZSBtZW51IG5lZWRzIHRvIGJlIHN3aXBlZCBiZWZvcmUgb3BlbmluZy4gQSB2YWx1ZSBiZXR3ZWVuIGAwYCBhbmQgYDFgLiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb3BlblRocmVzaG9sZDogUHJvcFR5cGVzLm51bWJlcixcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVPcGVuXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gQ2FsbGVkIGJlZm9yZSB0aGUgbWVudSBvcGVucy4gIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUHJlT3BlbjogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlQ2xvc2VcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBDYWxsZWQgYmVmb3JlIHRoZSBtZW51IGNsb3Nlcy4gIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUHJlQ2xvc2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvbk1vZGVDaGFuZ2VcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBDYWxsZWQgYWZ0ZXIgdGhlIGNvbXBvbmVudCdzIG1vZGUgY2hhbmdlcy4gWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Nb2RlQ2hhbmdlOiBQcm9wVHlwZXMuZnVuY1xufTtcblxuZXhwb3J0IGRlZmF1bHQgU3BsaXR0ZXJTaWRlO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXN3aXRjaCc7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuaW1wb3J0IG9uZVRpbWVQcm9wIGZyb20gJy4uL29uZVRpbWVQcm9wJztcbmltcG9ydCBJTlBVVF9QUk9QUyBmcm9tICcuLi9pbnB1dFByb3BzJztcblxuY29uc3QgbmFtZU1hcCA9IHtcbiAgLi4uSU5QVVRfUFJPUFNcbn07XG5cbmNvbnN0IHdpdGhEZWZhdWx0Q2hlY2tlZCA9IGNvbXBvbmVudCA9PiBvbmVUaW1lUHJvcChjb21wb25lbnQsICdkZWZhdWx0Q2hlY2tlZCcsICdjaGVja2VkJyk7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy1zd2l0Y2hcbiAqIEBjYXRlZ29yeSBmb3JtXG4gKiBAdHV0b3JpYWwgcmVhY3QvUmVmZXJlbmNlL3N3aXRjaFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dICAgU3dpdGNoIGNvbXBvbmVudC4gVGhlIHN3aXRjaCBjYW4gYmUgdG9nZ2xlZCBib3RoIGJ5IGRyYWdnaW5nIGFuZCB0YXBwaW5nLlxuICogICAgIFdpbGwgYXV0b21hdGljYWxseSBkaXNwbGF5cyBhIE1hdGVyaWFsIERlc2lnbiBzd2l0Y2ggb24gQW5kcm9pZCBkZXZpY2VzLlxuIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqIEBleGFtcGxlXG4gKiA8U3dpdGNoIGNoZWNrZWQ9e3RoaXMuc3RhdGUuY2hlY2tlZH0gb25DaGFuZ2U9e3RoaXMub25DaGFuZ2V9IC8+XG4gKi9cbmNvbnN0IFN3aXRjaCA9IHdpdGhEZWZhdWx0Q2hlY2tlZChvbnNDdXN0b21FbGVtZW50KCdvbnMtc3dpdGNoJywge2RlcHJlY2F0ZWQ6IG5hbWVNYXB9KSk7XG5cblN3aXRjaC5wcm9wVHlwZXMgPSB7XG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSBjaGVja2JveC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgb25DaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dIENhbGxlZCB3aGVuIHRoZSB2YWx1ZSBvZiB0aGUgc3dpdGNoIGNoYW5nZXMgKGNoZWNrZWQvdW5jaGVja2VkKSBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkNoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGNoZWNrZWRcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gV2hldGhlciB0aGUgc3dpdGNoIGlzIGNoZWNrZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgY2hlY2tlZDogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGRlZmF1bHRDaGVja2VkXG4gICAqIEB0eXBlIGJvb2xlYW5cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dRGVmaW5lZCB0aGUgc3RhdGUgb2YgdGhlIHN3aXRjaCBhdCBmaXJzdCByZW5kZXIgZm9yIHVuY29udHJvbGxlZCBpbnB1dHMuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZGVmYXVsdENoZWNrZWQ6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXSBJZiBzZXQsIHRoZSBzd2l0Y2ggaXMgZGlzYWJsZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgZGlzYWJsZWQ6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBpbnB1dElkXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl0gU3BlY2lmeSB0aGUgYGlkYCBhdHRyaWJ1dGUgb2YgdGhlIGlubmVyIGA8aW5wdXQ+YCBlbGVtZW50LiBUaGlzIGlzIHVzZWZ1bCB3aGVuIHVzaW5nIGA8bGFiZWwgZm9yPVwiLi4uXCI+YCBlbGVtZW50cy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBpbnB1dElkOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG5leHBvcnQgZGVmYXVsdCBTd2l0Y2g7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtdGFiJztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy10YWJcbiAqIEBjYXRlZ29yeSB0YWJiYXJcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvdGFiYmFyXG4gKiBAZGVzY3JpcHRpb25cbiAqIFtlbl0gUmVwcmVzZW50cyBhIHRhYiBpbnNpZGUgdGFiIGJhci5cbiBbL2VuXVxuICogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuICogPFRhcD5cbiAqICAgSG9tZVxuICogPC9UYXA+XG4gKi9cbmNvbnN0IFRhYiA9IG9uc0N1c3RvbUVsZW1lbnQoJ29ucy10YWInKTtcblxuVGFiLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIGljb25cbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBpY29uIG5hbWUgZm9yIHRoZSB0YWIuIENhbiBzcGVjaWZ5IHRoZSBzYW1lIGljb24gbmFtZSBhcyA8b25zLWljb24+LlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGljb246IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFjdGl2ZUljb25cbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBuYW1lIG9mIHRoZSBpY29uIHdoZW4gdGhlIHRhYiBpcyBhY3RpdmUuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYWN0aXZlSWNvbjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgbGFiZWxcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBsYWJlbCBvZiB0aGUgdGFiIGl0ZW0uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgbGFiZWw6IFByb3BUeXBlcy5zdHJpbmcsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGJhZGdlXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1EaXNwbGF5IGEgbm90aWZpY2F0aW9uIGJhZGdlIG9uIHRvcCBvZiB0aGUgdGFiLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGJhZGdlOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG5leHBvcnQgZGVmYXVsdCBUYWI7XG4iLCJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXRhYmJhcic7XG5cbmltcG9ydCBvbnNDdXN0b21FbGVtZW50IGZyb20gJy4uL29uc0N1c3RvbUVsZW1lbnQnO1xuXG5jb25zdCBkZXByZWNhdGVkID0ge1xuICBpbmRleDogJ2FjdGl2ZUluZGV4J1xufTtcbmNvbnN0IEVsZW1lbnQgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtdGFiYmFyJywge2RlcHJlY2F0ZWR9KTtcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXRhYmJhclxuICogQGNhdGVnb3J5IHRhYmJhclxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS90YWJiYXJcbiAqIEBkZXNjcmlwdGlvblxuICogW2VuXSBDb21wb25lbnQgdG8gZGlzcGxheSBhIHRhYmJhciBvbiBlaXRoZXIgdGhlIHRvcCBvciB0aGUgYm90dG9tIG9mIGEgcGFnZS5cbiAqIFRvIGRlZmluZSB0aGUgdGFicyBhbmQgdGhlIGNvbnRlbnQgdGhlIHByb3BlcnR5IHJlbmRlclRhYnMgbmVlZCB0byBiZSBpbXBsZW1lbnRlZCwgdGhhdCByZXR1cm5zIGFuIGFycmF5IG9mIHRhYnMgYW5kIHRoZWlyIGNvbnRlbnQuIFNlZSB0aGUgZXhhbXBsZSBmb3Igc3BlY2lmaWNzLiBbL2VuXSogW2phXVsvamFdXG4gKiBAZXhhbXBsZVxuXG4gIDxQYWdlPlxuICAgIDxUYWJiYXJcbiAgICAgIG9uUHJlQ2hhbmdlPXsoe2luZGV4fSkgPT4gdGhpcy5zZXRTdGF0ZShpbmRleCl9XG4gICAgICBvblBvc3RDaGFuZ2U9eygpID0+IGNvbnNvbGUubG9nKCdwb3N0Q2hhbmdlJyl9XG4gICAgICBvblJlYWN0aXZlPXsoKSA9PiBjb25zb2xlLmxvZygncG9zdENoYW5nZScpfVxuICAgICAgcG9zaXRpb249J2JvdHRvbSdcbiAgICAgIGluZGV4PXt0aGlzLnN0YXRlLmluZGV4fVxuICAgICAgcmVuZGVyVGFicz17KGFjdGl2ZUluZGV4LCB0YWJiYXIpID0+IFtcbiAgICAgICAge1xuICAgICAgICAgIGNvbnRlbnQ6IDxUYWJQYWdlIHRpdGxlPVwiSG9tZVwiIGFjdGl2ZT17YWN0aXZlSW5kZXggPT09IDB9IHRhYmJhcj17dGFiYmFyfSAvPixcbiAgICAgICAgICB0YWI6IDxUYWIgbGFiZWw9XCJIb21lXCIgaWNvbj1cIm1kLWhvbWVcIiAvPlxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgY29udGVudDogPFRhYlBhZ2UgdGl0bGU9XCJTZXR0aW5nc1wiIGFjdGl2ZT17YWN0aXZlSW5kZXggPT09IDF9IHRhYmJhcj17dGFiYmFyfSAvPixcbiAgICAgICAgICB0YWI6IDxUYWIgbGFiZWw9XCJTZXR0aW5nc1wiIGljb249XCJtZC1zZXR0aW5nc1wiIC8+XG4gICAgICAgIH1dXG4gICAgICB9XG4gICAgLz5cbiAgPC9QYWdlPlxuICovXG5jb25zdCBUYWJiYXIgPSBSZWFjdC5mb3J3YXJkUmVmKChwcm9wcywgcmVmKSA9PiB7XG4gIGNvbnN0IHt2aXNpYmxlLCBoaWRlVGFicywgcmVuZGVyVGFicywgLi4ucmVzdH0gPSBwcm9wcztcblxuICBjb25zdCB0YWJzID0gcmVuZGVyVGFicyhwcm9wcy5hY3RpdmVJbmRleCwgcmVmKTtcblxuICAvLyB2aXNpYmxlIGlzIGRlcHJlY2F0ZWQgaW4gZmF2b3VyIG9mIGhpZGVUYWJzLCBidXQgaWYgdmlzaWJsZSBpcyBkZWZpbmVkIGFuZFxuICAvLyBoaWRlVGFicyBpcyBub3QsIHdlIHVzZSBpdHMgbmVnYXRpb24gYXMgdGhlIHZhbHVlIG9mIGhpZGVUYWJzXG4gIGxldCByZWFsbHlIaWRlVGFicztcbiAgaWYgKGhpZGVUYWJzID09PSB1bmRlZmluZWQgJiYgdmlzaWJsZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgcmVhbGx5SGlkZVRhYnMgPSAhdmlzaWJsZTtcbiAgfSBlbHNlIHtcbiAgICByZWFsbHlIaWRlVGFicyA9IGhpZGVUYWJzO1xuICB9XG5cbiAgcmV0dXJuIChcbiAgICA8RWxlbWVudFxuICAgICAgaGlkZVRhYnM9e3JlYWxseUhpZGVUYWJzfVxuICAgICAgey4uLnJlc3R9XG5cbiAgICAgIHJlZj17cmVmfVxuICAgID5cbiAgICAgIDxkaXYgY2xhc3NOYW1lPSd0YWJiYXJfX2NvbnRlbnQnPlxuICAgICAgICA8ZGl2PlxuICAgICAgICAgIHt0YWJzLm1hcCh0YWIgPT4gdGFiLmNvbnRlbnQpfVxuICAgICAgICA8L2Rpdj5cbiAgICAgICAgPGRpdj48L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICAgPGRpdiBjbGFzc05hbWU9J3RhYmJhcic+XG4gICAgICAgIHt0YWJzLm1hcCh0YWIgPT4gdGFiLnRhYil9XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSd0YWJiYXJfX2JvcmRlcic+PC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICA8L0VsZW1lbnQ+XG4gICk7XG59KTtcblxuVGFiYmFyLnByb3BUeXBlcyA9IHtcbiAgLyoqXG4gICAqIEBuYW1lIGFjdGl2ZUluZGV4XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgaW5kZXggb2YgdGhlIHRhYiB0byBoaWdobGlnaHQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYWN0aXZlSW5kZXg6IFByb3BUeXBlcy5udW1iZXIsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGluZGV4XG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1ERVBSRUNBVEVEISBVc2UgYGFjdGl2ZUluZGV4YCBpbnN0ZWFkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGluZGV4OiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSByZW5kZXJUYWJzXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUZ1bmN0aW9uIHRoYXQgcmV0dXJucyBhbiBhcnJheSBvZiBvYmplY3RzIHdpdGggdGhlIGtleXMgYGNvbnRlbnRgIGFuZCBgdGFiYC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICByZW5kZXJUYWJzOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBwb3NpdGlvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGFiYmFyJ3MgcG9zaXRpb24uIEF2YWlsYWJsZSB2YWx1ZXMgYXJlIGBcImJvdHRvbVwiYCBhbmQgYFwidG9wXCJgLiBVc2UgYFwiYXV0b1wiYCB0byBjaG9vc2UgcG9zaXRpb24gZGVwZW5kaW5nIG9uIHBsYXRmb3JtIChpT1MgYm90dG9tLCBBbmRyb2lkIHRvcCkuIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHBvc2l0aW9uOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBzd2lwZWFibGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1FbmFibGUgc3dpcGUgaW50ZXJhY3Rpb24uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc3dpcGVhYmxlOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaWdub3JlRWRnZVdpZHRoXG4gICAqIEB0eXBlIG51bWJlclxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1EaXN0YW5jZSBpbiBwaXhlbHMgZnJvbSBib3RoIGVkZ2VzLiBTd2lwaW5nIG9uIHRoZXNlIGFyZWFzIHdpbGwgcHJpb3JpdGl6ZSBwYXJlbnQgY29tcG9uZW50cyBzdWNoIGFzIGBTcGxpdHRlcmAgb3IgYE5hdmlnYXRvcmAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaWdub3JlRWRnZVdpZHRoOiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBhbmltYXRpb25cbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRoaXMgYXR0cmlidXRlIGlzIHNldCB0byBgXCJub25lXCJgIHRoZSB0cmFuc2l0aW9ucyB3aWxsIG5vdCBiZSBhbmltYXRlZC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBhbmltYXRpb246IFByb3BUeXBlcy5vbmVPZihbJ25vbmUnLCAnc2xpZGUnXSksXG5cbiAgLyoqXG4gICAqIEBuYW1lIGFuaW1hdGlvbk9wdGlvbnNcbiAgICogQHR5cGUgb2JqZWN0XG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1TcGVjaWZ5IHRoZSBhbmltYXRpb24ncyBkdXJhdGlvbiwgZGVsYXkgYW5kIHRpbWluZy4gRS5nLiBge2R1cmF0aW9uOiAwLjIsIGRlbGF5OiAwLjQsIHRpbWluZzogJ2Vhc2UtaW4nfWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgdGFiQm9yZGVyXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dSWYgdHJ1ZSwgdGhlIHRhYnMgc2hvdyBhIGR5bmFtaWMgYm90dG9tIGJvcmRlci4gT25seSB3b3JrcyBmb3IgaU9TIHNpbmNlIHRoZSBib3JkZXIgaXMgYWx3YXlzIHZpc2libGUgaW4gTWF0ZXJpYWwgRGVzaWduLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHRhYkJvcmRlcjogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlQ2hhbmdlXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUNhbGxlZCBqdXN0IGJlZm9yZSB0aGUgdGFiIGlzIGNoYW5nZWQuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVDaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBvblBvc3RDaGFuZ2VcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgdGhlIHRhYiBpcyBjaGFuZ2VkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uUG9zdENoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUmVhY3RpdmVcbiAgICogQHR5cGUgZnVuY3Rpb25cbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGlmIHRoZSBhbHJlYWR5IG9wZW4gdGFiIGlzIHRhcHBlZCBhZ2Fpbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblJlYWN0aXZlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Td2lwZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1Ib29rIGNhbGxlZCB3aGVuZXZlciB0aGUgdXNlciBzbGlkZXMgdGhlIHRhYmJhci4gSXQgZ2V0cyBhIGRlY2ltYWwgaW5kZXggYW5kIGFuIGFuaW1hdGlvbk9wdGlvbnMgb2JqZWN0IGFzIGFyZ3VtZW50cy5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblN3aXBlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgdmlzaWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRydWUsIHRoZSB0YWJiYXIgaXMgbm90IHNob3duIG9uIHRoZSBzY3JlZW4uIE90aGVyd2lzZSwgdGhlIHRhYmJhciBpcyBzaG93bi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBoaWRlVGFiczogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIHZpc2libGVcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1ERVBSRUNBVEVEISBVc2UgYGhpZGVUYWJzYCBpbnN0ZWFkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHZpc2libGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dVGhlIGFwcGVhcmFuY2Ugb2YgdGhlIHRhYmJhci5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZ1xufTtcblxuZXhwb3J0IGRlZmF1bHQgVGFiYmFyO1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXRvYXN0JztcblxuaW1wb3J0IG9uc0N1c3RvbUVsZW1lbnQgZnJvbSAnLi4vb25zQ3VzdG9tRWxlbWVudCc7XG5pbXBvcnQgYmFzZURpYWxvZyBmcm9tICcuLi9iYXNlRGlhbG9nJztcblxuY29uc3QgcHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgdmlzaWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgSW5kaWNhdGVzIHdoZXRoZXIgdGhlIHRvYXN0IG9wZW4gYW5kIHNob3duLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgdmlzaWJsZTogUHJvcFR5cGVzLmJvb2wsXG5cbiAgLyoqXG4gICAqIEBuYW1lIGlzT3BlblxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgREVQUkVDQVRFRCEgVXNlIGB2aXNpYmxlYCBpbnN0ZWFkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaXNPcGVuOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uXG4gICAqIEB0eXBlIHN0cmluZ1xuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQW5pbWF0aW9uIG5hbWUuIEF2YWlsYWJsZSBhbmltYXRpb25zIGFyZSBgXCJkZWZhdWx0XCJgLCBgXCJhc2NlbmRcImAgKEFuZHJvaWQpLCBgXCJsaWZ0XCJgIChpT1MpLCBgXCJmYWxsXCJgLCBgXCJmYWRlXCJgIG9yIGBcIm5vbmVcImAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBtb2RpZmllclxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVRoZSBhcHBlYXJhbmNlIG9mIHRoZSB0b2FzdC5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgYW5pbWF0aW9uT3B0aW9uc1xuICAgKiBAdHlwZSBvYmplY3RcbiAgICogQHJlcXVpcmVkIGZhbHNlXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVNwZWNpZnkgdGhlIGFuaW1hdGlvbidzIGR1cmF0aW9uLCBkZWxheSBhbmQgdGltaW5nLiBFLmcuICBge2R1cmF0aW9uOiAwLjIsIGRlbGF5OiAwLjQsIHRpbWluZzogJ2Vhc2UtaW4nfWAuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgYW5pbWF0aW9uT3B0aW9uczogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvKipcbiAgICogQG5hbWUgb25QcmVTaG93XG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIENhbGxlZCBqdXN0IGJlZm9yZSB0aGUgdG9hc3QgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVTaG93OiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0U2hvd1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dXG4gICAqICBDYWxsZWQganVzdCBhZnRlciB0aGUgdG9hc3QgaXMgZGlzcGxheWVkLlxuICAgKiAgWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25Qb3N0U2hvdzogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLyoqXG4gICAqIEBuYW1lIG9uUHJlSGlkZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYmVmb3JlIHRoZSB0b2FzdCBpcyBoaWRkZW4uWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgb25QcmVIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25Qb3N0SGlkZVxuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAcmVxdWlyZWQgZmFsc2VcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ2FsbGVkIGp1c3QgYWZ0ZXIgdGhlIHRvYXN0IGlzIGhpZGRlbi5bL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvblBvc3RIaWRlOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvKipcbiAgICogQG5hbWUgb25EZXZpY2VCYWNrQnV0dG9uXG4gICAqIEB0eXBlIGZ1bmN0aW9uXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1cbiAgICogIEN1c3RvbSBoYW5kbGVyIGZvciBkZXZpY2UgYmFjayBidXR0b24uXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBvbkRldmljZUJhY2tCdXR0b246IFByb3BUeXBlcy5mdW5jXG59O1xuXG5jb25zdCBkZXByZWNhdGVkID0ge1xuICBpc09wZW46ICd2aXNpYmxlJ1xufTtcblxuY29uc3Qgbm90QXR0cmlidXRlcyA9IFsnb25EZXZpY2VCYWNrQnV0dG9uJ107XG5cbi8qKlxuICogQG9yaWdpbmFsIG9ucy10b2FzdFxuICogQGNhdGVnb3J5IGRpYWxvZ1xuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS90b2FzdFxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dXG4gKiAgVGhlIFRvYXN0IG9yIFNuYWNrYmFyIGNvbXBvbmVudCBpcyB1c2VmdWwgZm9yIGRpc3BsYXlpbmcgZGlzbWlzc2FibGUgaW5mb3JtYXRpb24gb3Igc2ltcGxlIGFjdGlvbnMgYXQgKG5vcm1hbGx5KSB0aGUgYm90dG9tIG9mIHRoZSBwYWdlLlxuICpcbiAqICBUaGlzIGNvbXBvbmVudCBkb2VzIG5vdCBibG9jayB1c2VyIGlucHV0LCBhbGxvd2luZyB0aGUgYXBwIHRvIGNvbnRpbnVlIGl0cyBmbG93LiBGdXJ0aGVybW9yZSwgaXQgY2FuIGJlIGF1dG9tYXRpY2FsbHkgaGlkZGVuIGFmdGVyIGEgdGltZW91dC5cbiAqIFsvZW5dXG4gKiBbamFdWy9qYV1cbiAqL1xuY29uc3QgVG9hc3QgPSBvbnNDdXN0b21FbGVtZW50KGJhc2VEaWFsb2coJ29ucy10b2FzdCcpLCB7cHJvcFR5cGVzLCBkZXByZWNhdGVkLCBub3RBdHRyaWJ1dGVzfSk7XG5Ub2FzdC5wcm9wVHlwZXMgPSBwcm9wVHlwZXM7XG5cbmV4cG9ydCBkZWZhdWx0IFRvYXN0O1xuIiwiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCAnb25zZW51aS9lc20vZWxlbWVudHMvb25zLXRvb2xiYXInO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuY29uc3Qgbm90QXR0cmlidXRlcyA9IFsndmlzaWJsZSddO1xuXG4vKipcbiAqIEBvcmlnaW5hbCBvbnMtdG9vbGJhclxuICogQGNhdGVnb3J5IHBhZ2VcbiAqIEB0dXRvcmlhbCByZWFjdC9SZWZlcmVuY2UvdG9vbGJhclxuICogQGRlc2NyaXB0aW9uXG4gKiBbZW5dVG9vbGJhciBjb21wb25lbnQgdGhhdCBjYW4gYmUgdXNlZCB3aXRoIG5hdmlnYXRpb24uIExlZnQsIGNlbnRlciBhbmQgcmlnaHQgY29udGFpbmVyIGNhbiBiZSBzcGVjaWZpZWQgYnkgY2xhc3MgbmFtZXMuIFRoaXMgY29tcG9uZW50IHdpbGwgYXV0b21hdGljYWxseSBkaXNwbGF5cyBhcyBhIE1hdGVyaWFsIERlc2lnbiB0b29sYmFyIHdoZW4gcnVubmluZyBvbiBBbmRyb2lkIGRldmljZXMuWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqXG48UGFnZSByZW5kZXJUb29sYmFyPXsoKSA9PlxuICA8VG9vbGJhcj5cbiAgICA8ZGl2IGNsYXNzTmFtZT1cImxlZnRcIj5cbiAgICAgIDxCYWNrQnV0dG9uPlxuICAgICAgICAgIEJhY2tcbiAgICAgIDwvQmFja0J1dHRvbj5cbiAgICA8L2Rpdj5cbiAgICA8ZGl2IGNsYXNzTmFtZT1cImNlbnRlclwiPlxuICAgICAgVGl0bGVcbiAgICA8L2Rpdj5cbiAgICA8ZGl2IGNsYXNzTmFtZT1cInJpZ2h0XCI+XG4gICAgICA8VG9vbGJhckJ1dHRvbj5cbiAgICAgICAgPEljb24gaWNvbj1cIm1kLW1lbnVcIiAvPlxuICAgICAgPC9Ub29sYmFyQnV0dG9uPlxuICAgIDwvZGl2PlxuICA8L1Rvb2xiYXI+IH1cbi8+XG4gKi9cbmNvbnN0IFRvb2xiYXIgPSBvbnNDdXN0b21FbGVtZW50KCdvbnMtdG9vbGJhcicsIHtub3RBdHRyaWJ1dGVzfSk7XG5cblRvb2xiYXIucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgU3BlY2lmeSBtb2RpZmllciBuYW1lIHRvIHNwZWNpZnkgY3VzdG9tIHN0eWxlcy4gT3B0aW9uYWwuXG4gICAqICBbL2VuXVxuICAgKiAgW2phXVsvamFdXG4gICAqL1xuICBtb2RpZmllcjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgdmlzaWJsZVxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXUlmIHRydWUsIHRoZSB0b29sYmFyIGlzIHNob3duIG9uIHRoZSBzY3JlZW4uIE90aGVyd2lzZSwgdGhlIHRvb2xiYXIgaXMgbm90IHNob3duLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIHZpc2libGU6IFByb3BUeXBlcy5ib29sLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBzdGF0aWNcbiAgICogQHR5cGUgYm9vbFxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogICBbZW5dU3RhdGljIHRvb2xiYXJzIGFyZSBub3QgYW5pbWF0ZWQgYnkgYG9ucy1uYXZpZ2F0b3JgIHdoZW4gcHVzaGluZyBvciBwb3BwaW5nIHBhZ2VzLiBUaGlzIGNhbiBiZSB1c2VmdWwgdG8gaW1wcm92ZSBwZXJmb3JtYW5jZSBpbiBzb21lIHNpdHVhdGlvbnMuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgc3RhdGljOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaW5saW5lXG4gICAqIEB0eXBlIGJvb2xcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICAgW2VuXURpc3BsYXkgdGhlIHRvb2xiYXIgYXMgYW4gaW5saW5lIGVsZW1lbnQuWy9lbl1cbiAgICogICBbamFd44OE44O844Or44OQ44O844KS44Kk44Oz44Op44Kk44Oz44Gr572u44GN44G+44GZ44CC44K544Kv44Ot44O844Or6aCY5Z+f5YaF44Gr44Gd44Gu44G+44G+6KGo56S644GV44KM44G+44GZ44CCWy9qYV1cbiAgICovXG4gIGlubGluZTogUHJvcFR5cGVzLmJvb2xcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFRvb2xiYXI7XG4iLCJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0ICdvbnNlbnVpL2VzbS9lbGVtZW50cy9vbnMtdG9vbGJhci1idXR0b24nO1xuXG5pbXBvcnQgb25zQ3VzdG9tRWxlbWVudCBmcm9tICcuLi9vbnNDdXN0b21FbGVtZW50JztcblxuLyoqXG4gKiBAb3JpZ2luYWwgb25zLXRvb2xiYXItYnV0dG9uXG4gKiBAY2F0ZWdvcnkgcGFnZVxuICogQHR1dG9yaWFsIHJlYWN0L1JlZmVyZW5jZS9wYWdlXG4gKiBAZGVzY3JpcHRpb25cbiAqICAgW2VuXVxuICogICBCdXR0b24gY29tcG9uZW50IGZvciB0aGUgVG9vbGJhci4gVXNpbmcgdGhpcyBjb21wb25lbnQgZ2l2ZXMgYSBuaWNlIGRlZmF1bHQgc3R5bGUuXG4gKlxuICpcbiAqICAgWy9lbl1cbiAqIFtqYV1bL2phXVxuICogQGV4YW1wbGVcbiAqIDxQYWdlXG4gICAgIHJlbmRlclRvb2xiYXIgPSB7ICgpID0+XG4gICAgICA8VG9vbGJhcj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J2xlZnQnPjxCYWNrQnV0dG9uPkJhY2s8L0JhY2tCdXR0b24+PC9kaXY+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdjZW50ZXInPklucHV0PC9kaXY+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdyaWdodCc+XG4gICAgICAgICAgPFRvb2xiYXJCdXR0b24gb25DbGljaz17dGhpcy5hZGR9ID5BZGQ8L1Rvb2xiYXJCdXR0b24+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9Ub29sYmFyPlxuICAgICB9PlxuICAgICAgUGFnZSBDb250ZW50XG4gICAgPC9QYWdlPlxuICovXG5jb25zdCBUb29sYmFyQnV0dG9uID0gb25zQ3VzdG9tRWxlbWVudCgnb25zLXRvb2xiYXItYnV0dG9uJyk7XG5cblRvb2xiYXJCdXR0b24ucHJvcFR5cGVzID0ge1xuICAvKipcbiAgICogQG5hbWUgbW9kaWZpZXJcbiAgICogQHR5cGUgc3RyaW5nXG4gICAqIEByZXF1aXJlZCBmYWxzZVxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGUgYXBwZWFyYW5jZSBvZiB0aGUgYnV0dG9uLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG1vZGlmaWVyOiBQcm9wVHlwZXMuc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBAbmFtZSBkaXNhYmxlZFxuICAgKiBAdHlwZSBib29sXG4gICAqIEBkZXNjcmlwdGlvblxuICAgKiAgW2VuXVxuICAgKiAgSW5kaWNhdGVzIHdoZXRoZXIgdGhlIGJ1dHRvbiBpcyBkaXNhYmxlZC5cbiAgICogIFsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIGRpc2FibGVkOiBQcm9wVHlwZXMuYm9vbCxcblxuICAvKipcbiAgICogQG5hbWUgaWNvblxuICAgKiBAdHlwZSBzdHJpbmdcbiAgICogQGRlc2NyaXB0aW9uXG4gICAqICBbZW5dQ3JlYXRlcyBhbiBgSWNvbmAgY29tcG9uZW50IHdpdGggdGhpcyBzdHJpbmcuWy9lbl1cbiAgICogIFtqYV1bL2phXVxuICAgKi9cbiAgaWNvbjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICogQG5hbWUgb25DbGlja1xuICAgKiBAdHlwZSBmdW5jdGlvblxuICAgKiBAZGVzY3JpcHRpb25cbiAgICogIFtlbl1UaGlzIGZ1bmN0aW9uIHdpbGwgYmUgY2FsbGVkIHdoZW4gdGhlIGJ1dHRvbiBpcyBjbGlja2VkLlsvZW5dXG4gICAqICBbamFdWy9qYV1cbiAgICovXG4gIG9uQ2xpY2s6IFByb3BUeXBlcy5mdW5jXG59O1xuXG5leHBvcnQgZGVmYXVsdCBUb29sYmFyQnV0dG9uO1xuIiwiLypcbiAqIHJvdXRlU3RhY2sgOiBbdXNlclJvdXRlLCB1c2VyUm91dGUyLCAuLi5dXG4gKiBwcm9jZXNzU3RhY2s6IFtcbiAqIHsgdHlwZTogcHVzaCB8IHBvcCB8IHJlc2V0LCByb3V0ZTogdXNlclJvdXRlIH0sXG4gKiB7IHR5cGU6IHB1c2ggfCBwb3AgfCByZXNldCwgcm91dGU6IHVzZXJSb3V0ZTIgfSxcbiAqIC4uLlxuICogXVxuICovXG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgaW5pdDogKHJvdXRlcykgPT4ge1xuICAgIHJldHVybiB7XG4gICAgICByb3V0ZVN0YWNrOiBbLi4ucm91dGVzXSxcbiAgICAgIHByb2Nlc3NTdGFjazogW11cbiAgICB9O1xuICB9LFxuXG4gIHJlcGxhY2U6ICh7cm91dGVDb25maWcsIHJvdXRlLCBvcHRpb25zLCBrZXl9KSA9PiB7XG4gICAgY29uc3QgY29uZmlnID0gey4uLnJvdXRlQ29uZmlnfTtcbiAgICBjb25zdCByb3V0ZVN0YWNrID0gWy4uLmNvbmZpZy5yb3V0ZVN0YWNrXTtcbiAgICBsZXQgcHJvY2Vzc1N0YWNrID0gWy4uLmNvbmZpZy5wcm9jZXNzU3RhY2tdO1xuXG4gICAgaWYgKGtleSA9PSBudWxsIHx8IHByb2Nlc3NTdGFjay5maWx0ZXIoKGVsKSA9PiBlbC5rZXkgPT09IGtleSkubGVuZ3RoID09PSAwKSB7XG4gICAgICBjb25zdCBwcm9jZXNzID0ge1xuICAgICAgICB0eXBlOiAncmVwbGFjZScsXG4gICAgICAgIHJvdXRlLFxuICAgICAgICBvcHRpb25zLFxuICAgICAgICBrZXlcbiAgICAgIH07XG4gICAgICBwcm9jZXNzU3RhY2sgPSBbXG4gICAgICAgIC4uLnByb2Nlc3NTdGFjayxcbiAgICAgICAgcHJvY2Vzc1xuICAgICAgXTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgcm91dGVTdGFjayxcbiAgICAgIHByb2Nlc3NTdGFja1xuICAgIH07XG4gIH0sXG5cbiAgcmVzZXQ6ICh7cm91dGVDb25maWcsIHJvdXRlLCBvcHRpb25zLCBrZXl9KSA9PiB7XG4gICAgY29uc3QgY29uZmlnID0gey4uLnJvdXRlQ29uZmlnfTtcbiAgICBjb25zdCByb3V0ZVN0YWNrID0gWy4uLmNvbmZpZy5yb3V0ZVN0YWNrXTtcbiAgICBsZXQgcHJvY2Vzc1N0YWNrID0gWy4uLmNvbmZpZy5wcm9jZXNzU3RhY2tdO1xuXG4gICAgaWYgKGtleSA9PSBudWxsIHx8IHByb2Nlc3NTdGFjay5maWx0ZXIoKGVsKSA9PiBlbC5rZXkgPT09IGtleSkubGVuZ3RoID09PSAwKSB7XG4gICAgICBjb25zdCBwcm9jZXNzID0ge1xuICAgICAgICB0eXBlOiAncmVzZXQnLFxuICAgICAgICByb3V0ZSxcbiAgICAgICAgb3B0aW9ucyxcbiAgICAgICAga2V5XG4gICAgICB9O1xuXG4gICAgICBwcm9jZXNzU3RhY2sgPSBbXG4gICAgICAgIC4uLnByb2Nlc3NTdGFjayxcbiAgICAgICAgcHJvY2Vzc1xuICAgICAgXTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgcm91dGVTdGFjayxcbiAgICAgIHByb2Nlc3NTdGFja1xuICAgIH07XG4gIH0sXG5cbiAgcHVzaDogKHtyb3V0ZUNvbmZpZywgcm91dGUsIG9wdGlvbnMsIGtleX0pID0+IHtcbiAgICBjb25zdCBjb25maWcgPSB7Li4ucm91dGVDb25maWd9O1xuICAgIGNvbnN0IHJvdXRlU3RhY2sgPSBbLi4uY29uZmlnLnJvdXRlU3RhY2tdO1xuICAgIGxldCBwcm9jZXNzU3RhY2sgPSBbLi4uY29uZmlnLnByb2Nlc3NTdGFja107XG5cbiAgICBpZiAoa2V5ID09IG51bGwgfHwgY29uZmlnLnByb2Nlc3NTdGFjay5maWx0ZXIoKGVsKSA9PiBlbC5rZXkgPT09IGtleSkubGVuZ3RoID09PSAwKSB7XG4gICAgICBjb25zdCBwcm9jZXNzID0ge1xuICAgICAgICB0eXBlOiAncHVzaCcsXG4gICAgICAgIHJvdXRlLFxuICAgICAgICBvcHRpb25zLFxuICAgICAgICBrZXlcbiAgICAgIH07XG5cbiAgICAgIHByb2Nlc3NTdGFjayA9IFtcbiAgICAgICAgLi4ucHJvY2Vzc1N0YWNrLFxuICAgICAgICBwcm9jZXNzXG4gICAgICBdO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICByb3V0ZVN0YWNrLFxuICAgICAgcHJvY2Vzc1N0YWNrXG4gICAgfTtcbiAgfSxcblxuICBwb3A6ICh7cm91dGVDb25maWcsIG9wdGlvbnMsIGtleX0pID0+IHtcbiAgICBjb25zdCBjb25maWcgPSB7Li4ucm91dGVDb25maWd9O1xuICAgIGNvbnN0IHJvdXRlU3RhY2sgPSBbLi4uY29uZmlnLnJvdXRlU3RhY2tdO1xuICAgIGxldCBwcm9jZXNzU3RhY2sgPSBbLi4uY29uZmlnLnByb2Nlc3NTdGFja107XG5cbiAgICAvKipcbiAgICAgKiBTYWZlZ2F1cmQgdG8gZW5zdXJlIHRoYXQgbm90XG4gICAgICogdG9vIG1hbnkgcGFnZXMgYXJlIHBvcHBlZCBmcm9tXG4gICAgICogdGhlIHN0YWNrLlxuICAgICAqL1xuICAgIGNvbnN0IHBvcHMgPSBwcm9jZXNzU3RhY2tcbiAgICAgIC5maWx0ZXIoeCA9PiB4LnR5cGUgPT09ICdwb3AnKVxuICAgICAgLmxlbmd0aDtcblxuICAgIGlmIChwb3BzICsgMSA+PSByb3V0ZVN0YWNrLmxlbmd0aCkge1xuICAgICAgY29uc29sZS53YXJuKCdQYWdlIHN0YWNrIGlzIGFscmVhZHkgZW1wdHknKTtcbiAgICAgIHJldHVybiBjb25maWc7XG4gICAgfVxuXG4gICAgY29uc3QgcHJvY2VzcyA9IHtcbiAgICAgIHR5cGU6ICdwb3AnLFxuICAgICAga2V5LFxuICAgICAgb3B0aW9uc1xuICAgIH07XG5cbiAgICBwcm9jZXNzU3RhY2sgPSBbXG4gICAgICAuLi5wcm9jZXNzU3RhY2ssXG4gICAgICBwcm9jZXNzXG4gICAgXTtcblxuICAgIHJldHVybiB7XG4gICAgICByb3V0ZVN0YWNrLFxuICAgICAgcHJvY2Vzc1N0YWNrXG4gICAgfTtcbiAgfSxcblxuICBwb3N0UHVzaDogKHJvdXRlQ29uZmlnKSA9PiB7XG4gICAgY29uc3QgY29uZmlnID0gey4uLnJvdXRlQ29uZmlnfTtcbiAgICBsZXQgcm91dGVTdGFjayA9IFsuLi5jb25maWcucm91dGVTdGFja107XG4gICAgY29uc3QgcHJvY2Vzc1N0YWNrID0gWy4uLmNvbmZpZy5wcm9jZXNzU3RhY2tdO1xuXG4gICAgY29uc3QgbmV4dCA9IHByb2Nlc3NTdGFjay5zaGlmdCgpO1xuICAgIGNvbnN0IHR5cGUgPSBuZXh0LnR5cGU7XG4gICAgbGV0IHJvdXRlID0gbmV4dC5yb3V0ZTtcblxuICAgIGlmICh0eXBlID09PSAncHVzaCcpIHtcbiAgICAgIGlmIChyb3V0ZSAhPT0gbnVsbCkge1xuICAgICAgICByb3V0ZVN0YWNrID0gW1xuICAgICAgICAgIC4uLnJvdXRlU3RhY2ssXG4gICAgICAgICAgcm91dGVcbiAgICAgICAgXTtcbiAgICAgIH1cbiAgICB9IGVsc2UgaWYgKHR5cGUgPT09ICdyZXNldCcpIHtcbiAgICAgIGlmICghQXJyYXkuaXNBcnJheShyb3V0ZSkpIHJvdXRlID0gW3JvdXRlXTtcbiAgICAgIHJvdXRlU3RhY2sgPSByb3V0ZTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT09ICdyZXBsYWNlJykge1xuICAgICAgcm91dGVTdGFjay5wb3AoKTtcbiAgICAgIHJvdXRlU3RhY2sucHVzaChyb3V0ZSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHtcbiAgICAgIHJvdXRlU3RhY2ssXG4gICAgICBwcm9jZXNzU3RhY2tcbiAgICB9O1xuICB9LFxuXG4gIHBvc3RQb3A6IChyb3V0ZUNvbmZpZykgPT4ge1xuICAgIGNvbnN0IGNvbmZpZyA9IHsuLi5yb3V0ZUNvbmZpZ307XG4gICAgbGV0IHJvdXRlU3RhY2sgPSBbLi4uY29uZmlnLnJvdXRlU3RhY2tdO1xuICAgIGxldCBwcm9jZXNzU3RhY2sgPSBbLi4uY29uZmlnLnByb2Nlc3NTdGFja107XG4gICAgcm91dGVTdGFjayA9IHJvdXRlU3RhY2suc2xpY2UoMCwgcm91dGVTdGFjay5sZW5ndGggLSAxKTtcbiAgICBwcm9jZXNzU3RhY2sgPSBwcm9jZXNzU3RhY2suc2xpY2UoMSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgcm91dGVTdGFjayxcbiAgICAgIHByb2Nlc3NTdGFja1xuICAgIH07XG4gIH1cbn07XG4iXSwibmFtZXMiOlsia2ViYWJpemUiLCJjYW1lbFN0cmluZyIsInJlcGxhY2UiLCJ0b0xvd2VyQ2FzZSIsImFkZERlcHJlY2F0ZWQiLCJwcm9wcyIsImRlcHJlY2F0ZWQiLCJwcm9wc0NvcHkiLCJuYW1lTWFwIiwiX29iamVjdFNwcmVhZCIsImNsYXNzTmFtZSIsIk9iamVjdCIsImVudHJpZXMiLCJvbGROYW1lIiwibmV3TmFtZSIsInVuZGVmaW5lZCIsInVzZUN1c3RvbUVsZW1lbnRMaXN0ZW5lciIsInJlZiIsInByb3AiLCJoYW5kbGVyIiwiZXZlbnQiLCJzbGljZSIsInVzZUVmZmVjdCIsImN1cnJlbnQiLCJhZGRFdmVudExpc3RlbmVyIiwiY2xlYW51cCIsInJlbW92ZUV2ZW50TGlzdGVuZXIiLCJ1c2VDdXN0b21FbGVtZW50Iiwib3B0aW9ucyIsIm5vdEF0dHJpYnV0ZXMiLCJwcm9wZXJ0aWVzIiwidmFsdWUiLCJqc05hbWUiLCJpbmNsdWRlcyIsInRlc3QiLCJKU09OIiwic3RyaW5naWZ5Iiwib25zQ3VzdG9tRWxlbWVudCIsIldyYXBwZWRDb21wb25lbnQiLCJSZWFjdCIsImZvcndhcmRSZWYiLCJfcmVmIiwidXNlUmVmIiwic3R5bGUiLCJjaGlsZHJlbiIsInJlc3QiLCJfZXhjbHVkZWQiLCJQb3J0YWwiLCJjb250YWluZXIiLCJkb2N1bWVudCIsImNyZWF0ZUVsZW1lbnQiLCJib2R5IiwiYXBwZW5kQ2hpbGQiLCJyZW1vdmVDaGlsZCIsIlJlYWN0RE9NIiwiY3JlYXRlUG9ydGFsIiwiQ29tcG9uZW50IiwiYmFzZURpYWxvZyIsIkRpYWxvZ0NvbXBvbmVudCIsInZpc2libGUiLCJwcm9wVHlwZXMiLCJ0aXRsZSIsIlByb3BUeXBlcyIsInN0cmluZyIsIm9uRGlhbG9nQ2FuY2VsIiwiZnVuYyIsImJvb2wiLCJjYW5jZWxhYmxlIiwiZGlzYWJsZWQiLCJvbkNhbmNlbCIsImlzT3BlbiIsImlzQ2FuY2VsYWJsZSIsImlzRGlzYWJsZWQiLCJhbmltYXRpb24iLCJtb2RpZmllciIsIm1hc2tDb2xvciIsImFuaW1hdGlvbk9wdGlvbnMiLCJvYmplY3QiLCJvblByZVNob3ciLCJvblBvc3RTaG93Iiwib25QcmVIaWRlIiwib25Qb3N0SGlkZSIsIm9uRGV2aWNlQmFja0J1dHRvbiIsIkFjdGlvblNoZWV0IiwiaWNvbiIsIm9uQ2xpY2siLCJBY3Rpb25TaGVldEJ1dHRvbiIsIkFsZXJ0RGlhbG9nIiwiQWxlcnREaWFsb2dCdXR0b24iLCJCYWNrQnV0dG9uIiwic2hhcGUiLCJjYWxsYmFjayIsIkJvdHRvbVRvb2xiYXIiLCJyaXBwbGUiLCJCdXR0b24iLCJDYXJkIiwiaW5kZXgiLCJFbGVtZW50IiwiQ2Fyb3VzZWwiLCJpdGVtV2lkdGgiLCJpdGVtSGVpZ2h0IiwieCIsInJlYWxJdGVtV2lkdGgiLCJyZWFsSXRlbUhlaWdodCIsImRpcmVjdGlvbiIsIm9uZU9mIiwiZnVsbHNjcmVlbiIsIm92ZXJzY3JvbGxhYmxlIiwiY2VudGVyZWQiLCJhdXRvU2Nyb2xsIiwiYXV0b1Njcm9sbFJhdGlvIiwibnVtYmVyIiwic3dpcGVhYmxlIiwiYWN0aXZlSW5kZXgiLCJhdXRvUmVmcmVzaCIsIm9uUHJlQ2hhbmdlIiwib25Qb3N0Q2hhbmdlIiwib25SZWZyZXNoIiwib25PdmVyc2Nyb2xsIiwib25Td2lwZSIsIkNhcm91c2VsSXRlbSIsIm9uZVRpbWVQcm9wIiwiZGVmYXVsdFByb3AiLCJPbmVUaW1lUHJvcCIsImNyZWF0ZVJlZiIsImlubmVyUmVmIiwiSU5QVVRfUFJPUFMiLCJhdXRvQ2FwaXRhbGl6ZSIsImF1dG9Db21wbGV0ZSIsImF1dG9Db3JyZWN0IiwiYXV0b0ZvY3VzIiwiaW5wdXRNb2RlIiwibWF4TGVuZ3RoIiwibWluTGVuZ3RoIiwicmVhZE9ubHkiLCJzcGVsbENoZWNrIiwid2l0aERlZmF1bHRDaGVja2VkIiwiY29tcG9uZW50IiwiQ2hlY2tib3giLCJvbkNoYW5nZSIsIm9uSW5wdXQiLCJvbmVPZlR5cGUiLCJpbnN0YW5jZU9mIiwiRGF0ZSIsImNoZWNrZWQiLCJkZWZhdWx0Q2hlY2tlZCIsImlucHV0SWQiLCJDb2wiLCJ2ZXJ0aWNhbEFsaWduIiwid2lkdGgiLCJEaWFsb2ciLCJGYWIiLCJwb3NpdGlvbiIsIm9uRHJhZyIsIm9uRHJhZ0xlZnQiLCJvbkRyYWdSaWdodCIsIm9uRHJhZ1VwIiwib25EcmFnRG93biIsIm9uSG9sZCIsIm9uUmVsZWFzZSIsIm9uU3dpcGVMZWZ0Iiwib25Td2lwZVJpZ2h0Iiwib25Td2lwZVVwIiwib25Td2lwZURvd24iLCJvblRhcCIsIm9uRG91YmxlVGFwIiwib25QaW5jaCIsIm9uUGluY2hJbiIsIm9uUGluY2hPdXQiLCJvblRvdWNoIiwib25UcmFuc2Zvcm0iLCJvblJvdGF0ZSIsIkdlc3R1cmVEZXRlY3RvciIsInBhcnNlSWNvbiIsImtleXMiLCJmaWx0ZXIiLCJhIiwiaW5uZXJTdHJpbmciLCJtYXAiLCJrZXkiLCJqb2luIiwicGFyc2VTaXplIiwic2l6ZSIsIkljb24iLCJvYmplY3RPZiIsInJvdGF0ZSIsImZpeGVkV2lkdGgiLCJzcGluIiwid2l0aERlZmF1bHRWYWx1ZSIsIklucHV0IiwiZGVmYXVsdFZhbHVlIiwicGxhY2Vob2xkZXIiLCJ0eXBlIiwiTGlzdCIsInJlbmRlckhlYWRlciIsInJlbmRlckZvb3RlciIsInJlbmRlclJvdyIsImRhdGFTb3VyY2UiLCJyb3dzIiwiZGF0YSIsImFycmF5IiwiZGVmYXVsdFByb3BzIiwiTGF6eUxpc3QiLCJmb3J3YXJkZWRSZWYiLCJ1c2VTdGF0ZSIsInNldENoaWxkcmVuIiwic2V0VXBkYXRlVG9wIiwiY2FsY3VsYXRlSXRlbUhlaWdodCIsImxlbmd0aCIsImRlbGVnYXRlIiwiX3JlbmRlciIsInN0YXJ0IiwibGltaXQiLCJ1cGRhdGVUb3AiLCJlbCIsImkiLCJwdXNoIiwiY291bnRJdGVtcyIsImlzUmVxdWlyZWQiLCJMaXN0SGVhZGVyIiwidGFwcGFibGUiLCJ0YXBCYWNrZ3JvdW5kQ29sb3IiLCJsb2NrT25EcmFnIiwiZXhwYW5kYWJsZSIsImV4cGFuZGVkIiwib25FeHBhbmQiLCJMaXN0SXRlbSIsIkxpc3RUaXRsZSIsIk5hdmlnYXRvckNsYXNzIiwiYXJncyIsInBhZ2VzIiwic3RhdGUiLCJfcHJlUHVzaCIsImJpbmQiLCJfcG9zdFB1c2giLCJfcHJlUG9wIiwiX3Bvc3RQb3AiLCJvYmoiLCJQcm9taXNlIiwicmVzb2x2ZSIsImZvcmNlVXBkYXRlIiwicm91dGUiLCJyZXNldFBhZ2VTdGFjayIsInJvdXRlcyIsImlzUnVubmluZyIsInJlamVjdCIsImhpZGVQYWdlcyIsInBhZ2VFbGVtZW50cyIsImRpc3BsYXkiLCJwb3AiLCJyb3V0ZXNCZWZvcmVQb3AiLCJyb3V0ZXNBZnRlclBvcCIsImNvbmNhdCIsInVwZGF0ZSIsInRoZW4iLCJfcG9wUGFnZSIsImxhc3RSb3V0ZSIsIm5ld1BhZ2UiLCJyZW5kZXJQYWdlIiwiX3B1c2hQYWdlIiwiZXJyb3IiLCJfaXNSdW5uaW5nIiwicHVzaFBhZ2UiLCJwb3MiLCJzcGxpY2UiLCJ0b3BQYWdlIiwidXBkYXRlQmFja0J1dHRvbiIsImZsdXNoU3luYyIsInBvcFBhZ2UiLCJjYWxsUGFyZW50SGFuZGxlciIsInRhcmdldCIsInBvcHBpbmdSb3V0ZSIsIm9uUHJlUG9wIiwicG9wcGVkUm91dGUiLCJvblBvc3RQb3AiLCJwdXNoaW5nUm91dGUiLCJvblByZVB1c2giLCJwdXNoZWRSb3V0ZSIsIm9uUG9zdFB1c2giLCJub2RlIiwic3dpcGVNYXgiLCJzd2lwZVBvcCIsIl9vbkRldmljZUJhY2tCdXR0b24iLCJpbml0aWFsUm91dGUiLCJpbml0aWFsUm91dGVTdGFjayIsIkVycm9yIiwiTmF2aWdhdG9yIiwiTk9PUCIsIk1vZGFsIiwiUGFnZSIsInJlbmRlclRvb2xiYXIiLCJyZW5kZXJCb3R0b21Ub29sYmFyIiwicmVuZGVyTW9kYWwiLCJyZW5kZXJGaXhlZCIsImNvbnRlbnRTdHlsZSIsInpJbmRleCIsIm9uSW5pdCIsIm9uU2hvdyIsIm9uSGlkZSIsIm9uSW5maW5pdGVTY3JvbGwiLCJFbGVtIiwiUG9wb3ZlciIsImdldFRhcmdldCIsImlzRWxlbWVudCIsIkhUTUxEb2N1bWVudCIsInNob3ciLCJoaWRlIiwiUHJvZ3Jlc3NCYXIiLCJzZWNvbmRhcnlWYWx1ZSIsImluZGV0ZXJtaW5hdGUiLCJQcm9ncmVzc0NpcmN1bGFyIiwib25Mb2FkIiwiUHVsbEhvb2siLCJvbkNoYW5nZVN0YXRlIiwib25BY3Rpb24iLCJvblB1bGwiLCJoZWlnaHQiLCJ0aHJlc2hvbGRIZWlnaHQiLCJmaXhlZENvbnRlbnQiLCJSYWRpbyIsIm5hbWUiLCJSYW5nZSIsIlJpcHBsZSIsImNvbG9yIiwiYmFja2dyb3VuZCIsImNlbnRlciIsIlJvdXRlck5hdmlnYXRvckNsYXNzIiwiY2FuY2VsVXBkYXRlIiwiaW50ZXJuYWxTdGFjayIsImNiIiwic2V0U3RhdGUiLCJyb3V0ZUNvbmZpZyIsInJvdXRlU3RhY2siLCJwcmV2UHJvcHMiLCJwcm9jZXNzU3RhY2siLCJBcnJheSIsImlzQXJyYXkiLCJyZXBsYWNlUGFnZSIsInBhZ2VzVG9SZW5kZXIiLCJSb3V0ZXJOYXZpZ2F0b3IiLCJhcnJheU9mIiwiUm93IiwiU2VhcmNoSW5wdXQiLCJTZWdtZW50IiwidGFiYmFySWQiLCJTZWxlY3QiLCJtdWx0aXBsZSIsImF1dG9mb2N1cyIsInJlcXVpcmVkIiwiZm9ybSIsIlNwZWVkRGlhbCIsIlNwZWVkRGlhbEl0ZW0iLCJTcGxpdHRlciIsIlNwbGl0dGVyQ29udGVudCIsIm9uT3BlbiIsIm9uQ2xvc2UiLCJTcGxpdHRlclNpZGUiLCJyZWFsV2lkdGgiLCJjb2xsYXBzZSIsIm9uUG9zdE9wZW4iLCJvblBvc3RDbG9zZSIsInNpZGUiLCJzd2lwZVRhcmdldFdpZHRoIiwib3BlblRocmVzaG9sZCIsIm9uUHJlT3BlbiIsIm9uUHJlQ2xvc2UiLCJvbk1vZGVDaGFuZ2UiLCJTd2l0Y2giLCJUYWIiLCJhY3RpdmVJY29uIiwibGFiZWwiLCJiYWRnZSIsIlRhYmJhciIsImhpZGVUYWJzIiwicmVuZGVyVGFicyIsInRhYnMiLCJyZWFsbHlIaWRlVGFicyIsInRhYiIsImNvbnRlbnQiLCJpZ25vcmVFZGdlV2lkdGgiLCJ0YWJCb3JkZXIiLCJvblJlYWN0aXZlIiwiVG9hc3QiLCJUb29sYmFyIiwiaW5saW5lIiwiVG9vbGJhckJ1dHRvbiIsImluaXQiLCJjb25maWciLCJwcm9jZXNzIiwicmVzZXQiLCJwb3BzIiwiY29uc29sZSIsIndhcm4iLCJwb3N0UHVzaCIsIm5leHQiLCJzaGlmdCIsInBvc3RQb3AiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztFQUNBLElBQU1BLFFBQVEsR0FBRyxTQUFYQSxRQUFXLENBQUFDLFdBQVcsRUFBQTtJQUFBLE9BQzFCQSxXQUFXLENBQUNDLE9BQVosQ0FBb0Isb0JBQXBCLEVBQTBDLE9BQTFDLENBQW1EQyxDQUFBQSxXQUFuRCxFQUQwQixDQUFBO0VBQUEsQ0FBNUIsQ0FBQTs7RUFHQSxJQUFNQyxhQUFhLEdBQUcsU0FBaEJBLGFBQWdCLENBQUNDLEtBQUQsRUFBUUMsVUFBUixFQUF1QjtJQUMzQyxJQUFNQyxTQUFTLEdBQVFGLGNBQUFBLENBQUFBLEVBQUFBLEVBQUFBLEtBQVIsQ0FBZixDQUFBOztFQUVBLEVBQUEsSUFBTUcsT0FBTyxHQUFBQyxjQUFBLENBQUE7RUFDWEMsSUFBQUEsU0FBUyxFQUFFLE9BQUE7RUFEQSxHQUFBLEVBRVJKLFVBRlEsQ0FBYixDQUFBOztFQUtBLEVBQUEsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsZUFBQSxHQUFpQ0ssTUFBTSxDQUFDQyxPQUFQLENBQWVKLE9BQWYsQ0FBakMsRUFBMEQsRUFBQSxHQUFBLGVBQUEsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQUE7RUFBckQsSUFBQSxJQUFBLGtCQUFBLEdBQUEsY0FBQSxDQUFBLGVBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLENBQUE7RUFBQSxRQUFPSyxPQUFQLEdBQUEsa0JBQUEsQ0FBQSxDQUFBLENBQUE7RUFBQSxRQUFnQkMsT0FBaEIsR0FBQSxrQkFBQSxDQUFBLENBQUEsQ0FBQSxDQUFBOztFQUNILElBQUEsSUFBSVAsU0FBUyxDQUFDTyxPQUFELENBQVQsS0FBdUJDLFNBQXZCLElBQW9DUixTQUFTLENBQUNNLE9BQUQsQ0FBVCxLQUF1QkUsU0FBL0QsRUFBMEU7RUFDeEVSLE1BQUFBLFNBQVMsQ0FBQ08sT0FBRCxDQUFULEdBQXFCUCxTQUFTLENBQUNNLE9BQUQsQ0FBOUIsQ0FBQTtRQUNBLE9BQU9OLFNBQVMsQ0FBQ00sT0FBRCxDQUFoQixDQUFBO0VBQ0QsS0FBQTtFQUNGLEdBQUE7O0VBRUQsRUFBQSxPQUFPTixTQUFQLENBQUE7RUFDRCxDQWhCRCxDQUFBOztFQWtCQSxTQUFTUyx3QkFBVCxDQUFrQ0MsR0FBbEMsRUFBdUNDLElBQXZDLEVBQTZDQyxPQUE3QyxFQUFzRDtJQUNwRCxJQUFNQyxLQUFLLEdBQUdGLElBQUksQ0FBQ0csS0FBTCxDQUFXLENBQVgsQ0FBY2xCLENBQUFBLFdBQWQsRUFBZCxDQUFBO0VBQ0FtQixFQUFBQSxlQUFTLENBQUMsWUFBTTtFQUNkLElBQUEsSUFBTUMsT0FBTyxHQUFHTixHQUFHLENBQUNNLE9BQXBCLENBQUE7RUFDQUEsSUFBQUEsT0FBTyxDQUFDQyxnQkFBUixDQUF5QkosS0FBekIsRUFBZ0NELE9BQWhDLENBQUEsQ0FBQTtNQUVBLE9BQU8sU0FBU00sT0FBVCxHQUFtQjtFQUN4QkYsTUFBQUEsT0FBTyxDQUFDRyxtQkFBUixDQUE0Qk4sS0FBNUIsRUFBbUNELE9BQW5DLENBQUEsQ0FBQTtPQURGLENBQUE7RUFHRCxHQVBRLEVBT04sQ0FBQ0YsR0FBRCxFQUFNRSxPQUFOLENBUE0sQ0FBVCxDQUFBO0VBUUQsQ0FBQTs7RUFFRCxTQUFTUSxnQkFBVCxDQUEwQnRCLEtBQTFCLEVBQW9EO0lBQUEsSUFBbkJ1QixPQUFtQix1RUFBVCxFQUFTLENBQUE7RUFBQSxFQUFBLElBQUxYLEdBQUssR0FBQSxTQUFBLENBQUEsTUFBQSxHQUFBLENBQUEsR0FBQSxTQUFBLENBQUEsQ0FBQSxDQUFBLEdBQUEsU0FBQSxDQUFBO0VBQ2xELEVBQUEsSUFBTVksYUFBYSxHQUFHRCxPQUFPLENBQUNDLGFBQVIsSUFBeUIsRUFBL0MsQ0FBQTtFQUNBLEVBQUEsSUFBTXZCLFVBQVUsR0FBR3NCLE9BQU8sQ0FBQ3RCLFVBQVIsSUFBc0IsRUFBekMsQ0FBQTtJQUVBLElBQU13QixVQUFVLEdBQUcsRUFBbkIsQ0FBQTs7RUFKa0QsRUFBQSxJQUFBLEtBQUEsR0FBQSxTQUFBLEtBQUEsR0FBQTtFQUs3QyxJQUFBLElBQUEsbUJBQUEsR0FBQSxjQUFBLENBQUEsZ0JBQUEsQ0FBQSxHQUFBLENBQUEsRUFBQSxDQUFBLENBQUE7RUFBQSxRQUFPWixJQUFQLEdBQUEsbUJBQUEsQ0FBQSxDQUFBLENBQUE7RUFBQSxRQUFhYSxLQUFiLEdBQUEsbUJBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7RUFDSCxJQUFBLElBQU1DLE1BQU0sR0FBR2hDLFFBQVEsQ0FBQ2tCLElBQUQsQ0FBdkIsQ0FBQTs7RUFFQSxJQUFBLElBQUlXLGFBQWEsQ0FBQ0ksUUFBZCxDQUF1QmYsSUFBdkIsQ0FBSixFQUFrQztFQUNoQ0ksTUFBQUEsZUFBUyxDQUFDLFlBQU07RUFDZEwsUUFBQUEsR0FBRyxDQUFDTSxPQUFKLENBQVlMLElBQVosSUFBb0JhLEtBQXBCLENBQUE7RUFDRCxPQUZRLENBQVQsQ0FBQTtFQUdELEtBSkQsTUFJTyxJQUFJLFVBQUEsQ0FBV0csSUFBWCxDQUFnQmhCLElBQWhCLENBQUosRUFBMkI7RUFDaENGLE1BQUFBLHdCQUF3QixDQUFDQyxHQUFELEVBQU1DLElBQU4sRUFBWWEsS0FBWixDQUF4QixDQUFBO0VBQ0QsS0FGTSxNQUVBLElBQUksT0FBT0EsS0FBUCxLQUFpQixTQUFyQixFQUFnQztRQUNyQ0QsVUFBVSxDQUFDRSxNQUFELENBQVYsR0FBcUJELEtBQUssR0FBRyxFQUFILEdBQVEsSUFBbEMsQ0FBQTtPQURLLE1BRUEsSUFBSSxPQUFBLENBQU9BLEtBQVAsQ0FBQSxLQUFpQixRQUFqQixJQUE2QkEsS0FBSyxLQUFLLElBQTNDLEVBQWlEO1FBQ3RERCxVQUFVLENBQUNFLE1BQUQsQ0FBVixHQUFxQkcsSUFBSSxDQUFDQyxTQUFMLENBQWVMLEtBQWYsQ0FBckIsQ0FBQTtFQUNELEtBRk0sTUFFQTtFQUNMRCxNQUFBQSxVQUFVLENBQUNFLE1BQUQsQ0FBVixHQUFxQkQsS0FBckIsQ0FBQTtFQUNELEtBQUE7RUFwQitDLEdBQUEsQ0FBQTs7SUFLbEQsS0FBNEJwQixJQUFBQSxHQUFBQSxHQUFBQSxDQUFBQSxFQUFBQSxnQkFBQUEsR0FBQUEsTUFBTSxDQUFDQyxPQUFQLENBQWVSLGFBQWEsQ0FBQ0MsS0FBRCxFQUFRQyxVQUFSLENBQTVCLENBQTVCLEVBQThFLEdBQUEsR0FBQSxnQkFBQSxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBQTtFQUFBLElBQUEsS0FBQSxFQUFBLENBQUE7RUFnQjdFLEdBQUE7O0lBRUQsT0FBTztFQUFDd0IsSUFBQUEsVUFBVSxFQUFWQSxVQUFBQTtLQUFSLENBQUE7RUFDRCxDQUFBOztFQUVjLFNBQVNPLGdCQUFULENBQTBCQyxnQkFBMUIsRUFBNENWLE9BQTVDLEVBQXFEO0lBQ2xFLG9CQUFPVyx5QkFBSyxDQUFDQyxVQUFOLENBQWlCLFVBQUNuQyxLQUFELEVBQVFvQyxJQUFSLEVBQWlCO0VBQ3ZDLElBQUEsSUFBTXhCLEdBQUcsR0FBR3dCLElBQUksSUFBSUMsWUFBTSxFQUExQixDQUFBOztFQUVBLElBQUEsSUFBT0MsS0FBUCxHQUFtQ3RDLEtBQW5DLENBQU9zQyxLQUFQO0VBQUEsUUFBY0MsUUFBZCxHQUFtQ3ZDLEtBQW5DLENBQWN1QyxRQUFkO1VBQTJCQyxJQUEzQiw0QkFBbUN4QyxLQUFuQyxFQUFBeUMsV0FBQSxDQUFBLENBQUE7O0VBQ0EsSUFBQSxJQUFBLGlCQUFBLEdBQXFCbkIsZ0JBQWdCLENBQUNrQixJQUFELEVBQU9qQixPQUFQLEVBQWdCWCxHQUFoQixDQUFyQztVQUFPYSxVQUFQLHFCQUFPQSxVQUFQLENBQUE7O0VBRUEsSUFBQSxvQkFDRVMsd0NBQUMsZ0JBQUQsRUFBQSxRQUFBLENBQUE7RUFDRSxNQUFBLEdBQUcsRUFBRXRCLEdBRFA7RUFFRSxNQUFBLEtBQUssRUFBRTBCLEtBQUFBO09BQ0hiLEVBQUFBLFVBSE4sQ0FLR2MsRUFBQUEsUUFMSCxDQURGLENBQUE7RUFTRCxHQWZNLENBQVAsQ0FBQTtFQWdCRDs7OztNQzFFS0c7Ozs7O0VBQ0osRUFBQSxTQUFBLE1BQUEsQ0FBWTFDLEtBQVosRUFBbUI7RUFBQSxJQUFBLElBQUEsS0FBQSxDQUFBOztFQUFBLElBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxNQUFBLENBQUEsQ0FBQTs7RUFDakIsSUFBQSxLQUFBLEdBQUEsTUFBQSxDQUFBLElBQUEsQ0FBQSxJQUFBLEVBQU1BLEtBQU4sQ0FBQSxDQUFBO0VBQ0EsSUFBQSxLQUFBLENBQUsyQyxTQUFMLEdBQWlCQyxRQUFRLENBQUNDLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBakIsQ0FBQTtFQUZpQixJQUFBLE9BQUEsS0FBQSxDQUFBO0VBR2xCLEdBQUE7Ozs7YUFFRCxTQUFvQixpQkFBQSxHQUFBO0VBQ2xCRCxNQUFBQSxRQUFRLENBQUNFLElBQVQsQ0FBY0MsV0FBZCxDQUEwQixLQUFLSixTQUEvQixDQUFBLENBQUE7RUFDRCxLQUFBOzs7YUFFRCxTQUF1QixvQkFBQSxHQUFBO0VBQ3JCQyxNQUFBQSxRQUFRLENBQUNFLElBQVQsQ0FBY0UsV0FBZCxDQUEwQixLQUFLTCxTQUEvQixDQUFBLENBQUE7RUFDRCxLQUFBOzs7YUFFRCxTQUFTLE1BQUEsR0FBQTtRQUNQLG9CQUFPTSw0QkFBUSxDQUFDQyxZQUFULENBQ0wsSUFBQSxDQUFLbEQsS0FBTCxDQUFXdUMsUUFETixFQUVMLElBQUtJLENBQUFBLFNBRkEsQ0FBUCxDQUFBO0VBSUQsS0FBQTs7OztFQW5Ca0JULENBQUFBLENBQUFBLHlCQUFLLENBQUNpQjs7RUFzQjNCLElBQU1DLFVBQVUsR0FBRyxTQUFiQSxVQUFhLENBQUFDLGVBQWUsRUFBQTtJQUFBLG9CQUNoQ25CLHlCQUFLLENBQUNDLFVBQU4sQ0FBaUIsVUFBQ25DLEtBQUQsRUFBUVksR0FBUixFQUFnQjtFQUMvQjtFQUNBO0VBQ0EsSUFBQSxJQUFPMEMsT0FBUCxHQUEyQnRELEtBQTNCLENBQU9zRCxPQUFQO1VBQW1CZCxJQUFuQiw0QkFBMkJ4QyxLQUEzQixFQUFBeUMsV0FBQSxDQUFBLENBQUE7O0VBRUEsSUFBQSxvQkFDRVAsd0NBQUMsTUFBRCxFQUFBLElBQUEsZUFDRUEseUJBQUMsQ0FBQSxhQUFBLENBQUEsZUFBRCxlQUNNTSxJQUROLEVBQUE7RUFFRSxNQUFBLE9BQU8sRUFBRWMsT0FGWDtFQUlFLE1BQUEsR0FBRyxFQUFFMUMsR0FBQUE7RUFKUCxLQUFBLENBQUEsRUFNR1osS0FBSyxDQUFDdUMsUUFOVCxDQURGLENBREYsQ0FBQTtFQVlELEdBakJELENBRGdDLENBQUE7RUFBQSxDQUFsQzs7RUNuQkEsSUFBTWdCLFdBQVMsR0FBRztFQUNoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFQyxLQUFLLEVBQUVDLDZCQUFTLENBQUNDLE1BWEQ7O0VBYWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VDLGNBQWMsRUFBRUYsNkJBQVMsQ0FBQ0csSUF2QlY7O0VBeUJoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRU4sT0FBTyxFQUFFRyw2QkFBUyxDQUFDSSxJQWxDSDs7RUFvQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsVUFBVSxFQUFFTCw2QkFBUyxDQUFDSSxJQS9DTjs7RUFpRGhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VFLFFBQVEsRUFBRU4sNkJBQVMsQ0FBQ0ksSUEzREo7O0VBNkRoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFRyxRQUFRLEVBQUVQLDZCQUFTLENBQUNHLElBdkVKOztFQXlFaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VLLE1BQU0sRUFBRVIsNkJBQVMsQ0FBQ0ksSUFsRkY7O0VBb0ZoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSyxZQUFZLEVBQUVULDZCQUFTLENBQUNJLElBOUZSOztFQWdHaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRU0sVUFBVSxFQUFFViw2QkFBUyxDQUFDSSxJQTFHTjs7RUE0R2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VPLFNBQVMsRUFBRVgsNkJBQVMsQ0FBQ0MsTUF0SEw7O0VBd0hoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VXLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFoSUo7O0VBa0loQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VZLFNBQVMsRUFBRWIsNkJBQVMsQ0FBQ0MsTUExSUw7O0VBNEloQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VhLGdCQUFnQixFQUFFZCw2QkFBUyxDQUFDZSxNQXBKWjs7RUFzSmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VDLFNBQVMsRUFBRWhCLDZCQUFTLENBQUNHLElBaEtMOztFQWtLaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsVUFBVSxFQUFFakIsNkJBQVMsQ0FBQ0csSUE1S047O0VBOEtoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VlLFNBQVMsRUFBRWxCLDZCQUFTLENBQUNHLElBdExMOztFQXdMaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFZ0IsVUFBVSxFQUFFbkIsNkJBQVMsQ0FBQ0csSUFoTU47O0VBa01oQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaUIsa0JBQWtCLEVBQUVwQiw2QkFBUyxDQUFDRyxJQUFBQTtFQTVNZCxDQUFsQixDQUFBO0VBK01BLElBQU0zRCxZQUFVLEdBQUc7RUFDakIrRCxFQUFBQSxRQUFRLEVBQUUsZ0JBRE87RUFFakJDLEVBQUFBLE1BQU0sRUFBRSxTQUZTO0VBR2pCRSxFQUFBQSxVQUFVLEVBQUUsVUFISztFQUlqQkQsRUFBQUEsWUFBWSxFQUFFLFlBQUE7RUFKRyxDQUFuQixDQUFBO0VBT0EsSUFBTTFDLGVBQWEsR0FBRyxDQUFDLG9CQUFELENBQXRCLENBQUE7RUFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ01zRCxNQUFBQSxXQUFXLEdBQUc5QyxnQkFBZ0IsQ0FBQ29CLFVBQVUsQ0FBQyxrQkFBRCxDQUFYLEVBQWlDO0VBQUNHLEVBQUFBLFNBQVMsRUFBVEEsV0FBRDtFQUFZdEQsRUFBQUEsVUFBVSxFQUFWQSxZQUFaO0VBQXdCdUIsRUFBQUEsYUFBYSxFQUFiQSxlQUFBQTtFQUF4QixDQUFqQyxFQUFwQztFQUNBc0QsV0FBVyxDQUFDdkIsU0FBWixHQUF3QkEsV0FBeEI7O0VDdE9BLElBQU1BLFdBQVMsR0FBRztFQUNoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFUSjs7RUFXaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFCLElBQUksRUFBRXRCLDZCQUFTLENBQUNDLE1BbEJBOztFQW9CaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXNCLE9BQU8sRUFBRXZCLDZCQUFTLENBQUNHLElBQUFBO0VBM0JILENBQWxCLENBQUE7RUE4QkE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNcUIsaUJBQWlCLEdBQUdqRCxnQkFBZ0IsQ0FBQyx5QkFBRCxFQUE0QjtFQUFDdUIsRUFBQUEsU0FBUyxFQUFUQSxXQUFBQTtFQUFELENBQTVCLEVBQTFDO0VBQ0EwQixpQkFBaUIsQ0FBQzFCLFNBQWxCLEdBQThCQSxXQUE5Qjs7RUN0Q0EsSUFBTXRELFlBQVUsR0FBRztFQUNqQitELEVBQUFBLFFBQVEsRUFBRSxnQkFETztFQUVqQkMsRUFBQUEsTUFBTSxFQUFFLFNBRlM7RUFHakJFLEVBQUFBLFVBQVUsRUFBRSxVQUhLO0VBSWpCRCxFQUFBQSxZQUFZLEVBQUUsWUFBQTtFQUpHLENBQW5CLENBQUE7RUFPQSxJQUFNMUMsZUFBYSxHQUFHLENBQUMsb0JBQUQsQ0FBdEIsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNNMEQsTUFBQUEsV0FBVyxHQUFHbEQsZ0JBQWdCLENBQUNvQixVQUFVLENBQUMsa0JBQUQsQ0FBWCxFQUFpQztFQUFDbkQsRUFBQUEsVUFBVSxFQUFWQSxZQUFEO0VBQWF1QixFQUFBQSxhQUFhLEVBQWJBLGVBQUFBO0VBQWIsQ0FBakMsRUFBcEM7RUFFQTBELFdBQVcsQ0FBQzNCLFNBQVosR0FBd0I7RUFDdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VELE9BQU8sRUFBRUcsNkJBQVMsQ0FBQ0ksSUFWRzs7RUFZdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUUsUUFBUSxFQUFFTiw2QkFBUyxDQUFDSSxJQXRCRTs7RUF3QnRCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsVUFBVSxFQUFFTCw2QkFBUyxDQUFDSSxJQW5DQTs7RUFxQ3RCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VGLGNBQWMsRUFBRUYsNkJBQVMsQ0FBQ0csSUEvQ0o7O0VBaUR0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSSxRQUFRLEVBQUVQLDZCQUFTLENBQUNHLElBM0RFOztFQTZEdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VLLE1BQU0sRUFBRVIsNkJBQVMsQ0FBQ0ksSUF0RUk7O0VBd0V0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSyxZQUFZLEVBQUVULDZCQUFTLENBQUNJLElBbEZGOztFQW9GdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRU0sVUFBVSxFQUFFViw2QkFBUyxDQUFDSSxJQTlGQTs7RUFnR3RCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VPLFNBQVMsRUFBRVgsNkJBQVMsQ0FBQ0MsTUExR0M7O0VBNEd0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VXLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFwSEU7O0VBc0h0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VZLFNBQVMsRUFBRWIsNkJBQVMsQ0FBQ0MsTUE5SEM7O0VBZ0l0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VhLGdCQUFnQixFQUFFZCw2QkFBUyxDQUFDZSxNQXhJTjs7RUEwSXRCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VDLFNBQVMsRUFBRWhCLDZCQUFTLENBQUNHLElBcEpDOztFQXNKdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsVUFBVSxFQUFFakIsNkJBQVMsQ0FBQ0csSUFoS0E7O0VBa0t0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VlLFNBQVMsRUFBRWxCLDZCQUFTLENBQUNHLElBMUtDOztFQTRLdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFZ0IsVUFBVSxFQUFFbkIsNkJBQVMsQ0FBQ0csSUFwTEE7O0VBc0x0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaUIsa0JBQWtCLEVBQUVwQiw2QkFBUyxDQUFDRyxJQUFBQTtFQWhNUixDQUF4Qjs7RUNyQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNdUIsaUJBQWlCLEdBQUduRCxnQkFBZ0IsQ0FBQyx5QkFBRCxFQUExQztFQUVBbUQsaUJBQWlCLENBQUM1QixTQUFsQixHQUE4QjtFQUM1QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFUUTs7RUFXNUI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VLLFFBQVEsRUFBRU4sNkJBQVMsQ0FBQ0ksSUFwQlE7O0VBc0I1QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFbUIsT0FBTyxFQUFFdkIsNkJBQVMsQ0FBQ0csSUFBQUE7RUE3QlMsQ0FBOUI7O0VDVkEsSUFBTXBDLGVBQWEsR0FBRyxDQUFDLFNBQUQsQ0FBdEIsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTTRELFVBQVUsR0FBR3BELGdCQUFnQixDQUFDLGlCQUFELEVBQW9CO0VBQUNSLEVBQUFBLGFBQWEsRUFBYkEsZUFBQUE7RUFBRCxDQUFwQixFQUFuQztFQUVBNEQsVUFBVSxDQUFDN0IsU0FBWCxHQUF1QjtFQUNyQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFUQzs7RUFXckI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXNCLE9BQU8sRUFBRXZCLDZCQUFTLENBQUNHLElBbEJFOztFQW9CckI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRXJDLEVBQUFBLE9BQU8sRUFBRWtDLDZCQUFTLENBQUM0QixLQUFWLENBQWdCO01BQ3ZCakIsU0FBUyxFQUFFWCw2QkFBUyxDQUFDQyxNQURFO01BRXZCYSxnQkFBZ0IsRUFBRWQsNkJBQVMsQ0FBQ2UsTUFGTDtNQUd2QmMsUUFBUSxFQUFFN0IsNkJBQVMsQ0FBQ0csSUFBQUE7S0FIYixDQUFBO0VBM0JZLENBQXZCOztFQ3JCQSxJQUFNTCxXQUFTLEdBQUc7RUFDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQUFBQTtFQVJKLENBQWxCLENBQUE7RUFXQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTTZCLGFBQWEsR0FBR3ZELGdCQUFnQixDQUFDLG9CQUFELEVBQXVCO0VBQUN1QixFQUFBQSxTQUFTLEVBQVRBLFdBQUFBO0VBQUQsQ0FBdkIsRUFBdEM7RUFDQWdDLGFBQWEsQ0FBQ2hDLFNBQWQsR0FBMEJBLFdBQTFCOztFQ3JCQSxJQUFNQSxXQUFTLEdBQUc7RUFDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVEo7O0VBV2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBcEJKOztFQXNCaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UyQixNQUFNLEVBQUUvQiw2QkFBUyxDQUFDSSxJQS9CRjs7RUFpQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VtQixPQUFPLEVBQUV2Qiw2QkFBUyxDQUFDRyxJQUFBQTtFQXhDSCxDQUFsQixDQUFBO0VBMkNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU02QixNQUFNLEdBQUd6RCxnQkFBZ0IsQ0FBQyxZQUFELEVBQWU7RUFBQ3VCLEVBQUFBLFNBQVMsRUFBVEEsV0FBQUE7RUFBRCxDQUFmLEVBQS9CO0VBQ0FrQyxNQUFNLENBQUNsQyxTQUFQLEdBQW1CQSxXQUFuQjs7RUN6REE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTW1DLElBQUksR0FBRzFELGdCQUFnQixDQUFDLFVBQUQsRUFBN0I7RUFFQTBELElBQUksQ0FBQ25DLFNBQUwsR0FBaUI7RUFDZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQUFBQTtFQVZMLENBQWpCOzs7RUNkQSxJQUFNekQsWUFBVSxHQUFHO0VBQ2pCMEYsRUFBQUEsS0FBSyxFQUFFLGFBQUE7RUFEVSxDQUFuQixDQUFBO0VBSUEsSUFBTUMsU0FBTyxHQUFHNUQsZ0JBQWdCLENBQUMsY0FBRCxFQUFpQjtFQUFDL0IsRUFBQUEsVUFBVSxFQUFWQSxZQUFBQTtFQUFELENBQWpCLENBQWhDLENBQUE7RUFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtBQUNBO0VBQ0E7O0FBQ000RixNQUFBQSxRQUFRLGdCQUFHM0QseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRWSxHQUFSLEVBQWdCO0VBQ2hELEVBQUEsSUFBT2tGLFNBQVAsR0FBeUM5RixLQUF6QyxDQUFPOEYsU0FBUDtFQUFBLE1BQWtCQyxVQUFsQixHQUF5Qy9GLEtBQXpDLENBQWtCK0YsVUFBbEI7RUFBQSxNQUFpQ3ZELElBQWpDLEdBQUEsd0JBQUEsQ0FBeUN4QyxLQUF6QyxFQUFBeUMsV0FBQSxDQUFBLENBRGdEO0VBSWhEOzs7RUFDQSxFQUFBLElBQU1WLFNBQVMsR0FBRyxTQUFaQSxTQUFZLENBQUFpRSxDQUFDLEVBQUE7RUFBQSxJQUFBLE9BQUksT0FBT0EsQ0FBUCxLQUFhLFFBQWIsR0FBMkJBLEVBQUFBLENBQUFBLE1BQUFBLENBQUFBLENBQTNCLFVBQW1DQSxDQUF2QyxDQUFBO0tBQW5CLENBQUE7O0VBQ0EsRUFBQSxJQUFNQyxhQUFhLEdBQUdsRSxTQUFTLENBQUMrRCxTQUFELENBQS9CLENBQUE7RUFDQSxFQUFBLElBQU1JLGNBQWMsR0FBR25FLFNBQVMsQ0FBQ2dFLFVBQUQsQ0FBaEMsQ0FBQTtFQUVBLEVBQUEsb0JBQ0U3RCx3Q0FBQzBELFNBQUQsRUFBQSxRQUFBLENBQUE7RUFDRSxJQUFBLFNBQVMsRUFBRUssYUFEYjtFQUVFLElBQUEsVUFBVSxFQUFFQyxjQUZkO0VBR0UsSUFBQSxHQUFHLEVBQUV0RixHQUFBQTtFQUhQLEdBQUEsRUFJTTRCLElBSk4sQ0FBQSxFQU1HeEMsS0FBSyxDQUFDdUMsUUFOVCxDQURGLENBQUE7RUFVRCxDQW5CZ0IsRUFBakI7RUFxQkFzRCxRQUFRLENBQUN0QyxTQUFULEdBQXFCO0VBRW5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTRDLFNBQVMsRUFBRTFDLDZCQUFTLENBQUMyQyxLQUFWLENBQWdCLENBQUMsWUFBRCxFQUFlLFVBQWYsQ0FBaEIsQ0FWUTs7RUFZbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsVUFBVSxFQUFFNUMsNkJBQVMsQ0FBQ0ksSUFuQkg7O0VBcUJuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeUMsY0FBYyxFQUFFN0MsNkJBQVMsQ0FBQ0ksSUE1QlA7O0VBOEJuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMEMsUUFBUSxFQUFFOUMsNkJBQVMsQ0FBQ0ksSUFyQ0Q7O0VBdUNuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaUMsU0FBUyxFQUFFckMsNkJBQVMsQ0FBQ0MsTUE5Q0Y7O0VBZ0RuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFcUMsVUFBVSxFQUFFdEMsNkJBQVMsQ0FBQ0MsTUF2REg7O0VBeURuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFOEMsVUFBVSxFQUFFL0MsNkJBQVMsQ0FBQ0ksSUFoRUg7O0VBa0VuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFNEMsZUFBZSxFQUFFaEQsNkJBQVMsQ0FBQ2lELE1BekVSOztFQTJFbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsU0FBUyxFQUFFbEQsNkJBQVMsQ0FBQ0ksSUFsRkY7O0VBb0ZuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFRSxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBM0ZEOztFQTZGbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStDLFdBQVcsRUFBRW5ELDZCQUFTLENBQUNpRCxNQXBHSjs7RUFzR25CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VmLEtBQUssRUFBRWxDLDZCQUFTLENBQUNpRCxNQTdHRTs7RUErR25CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VHLFdBQVcsRUFBRXBELDZCQUFTLENBQUNJLElBdEhKOztFQXdIbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWlELFdBQVcsRUFBRXJELDZCQUFTLENBQUNHLElBL0hKOztFQWlJbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW1ELFlBQVksRUFBRXRELDZCQUFTLENBQUNHLElBeElMOztFQTBJbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW9ELFNBQVMsRUFBRXZELDZCQUFTLENBQUNHLElBakpGOztFQW1KbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFELFlBQVksRUFBRXhELDZCQUFTLENBQUNHLElBMUpMOztFQTRKbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFUSxTQUFTLEVBQUVYLDZCQUFTLENBQUNDLE1BcEtGOztFQXNLbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYSxnQkFBZ0IsRUFBRWQsNkJBQVMsQ0FBQ2UsTUE5S1Q7O0VBZ0xuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMEMsT0FBTyxFQUFFekQsNkJBQVMsQ0FBQ0csSUFBQUE7RUF2TEEsQ0FBckI7O0VDMURBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNdUQsWUFBWSxHQUFHbkYsZ0JBQWdCLENBQUMsbUJBQUQsRUFBckM7RUFFQW1GLFlBQVksQ0FBQzVELFNBQWIsR0FBeUI7RUFDdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFBQUE7RUFWRyxDQUF6Qjs7O0VDdEJBO0VBQ0E7RUFDQTtFQUNBOztFQUNBLElBQU0wRCxXQUFXLEdBQUcsU0FBZEEsV0FBYyxDQUFDbkYsZ0JBQUQsRUFBbUJvRixXQUFuQixFQUFnQ3hHLElBQWhDLEVBQXlDO0VBQUEsRUFBQSxJQUNyRHlHLFdBRHFELGdCQUFBLFVBQUEsZ0JBQUEsRUFBQTtFQUFBLElBQUEsU0FBQSxDQUFBLFdBQUEsRUFBQSxnQkFBQSxDQUFBLENBQUE7O0VBQUEsSUFBQSxJQUFBLE1BQUEsR0FBQSxZQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0VBRXpELElBQUEsU0FBQSxXQUFBLENBQVl0SCxLQUFaLEVBQW1CO0VBQUEsTUFBQSxJQUFBLEtBQUEsQ0FBQTs7RUFBQSxNQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsV0FBQSxDQUFBLENBQUE7O0VBQ2pCLE1BQUEsS0FBQSxHQUFBLE1BQUEsQ0FBQSxJQUFBLENBQUEsSUFBQSxFQUFNQSxLQUFOLENBQUEsQ0FBQTtFQUNBLE1BQUEsS0FBQSxDQUFLWSxHQUFMLGdCQUFXc0IseUJBQUssQ0FBQ3FGLFNBQU4sRUFBWCxDQUFBO0VBRmlCLE1BQUEsT0FBQSxLQUFBLENBQUE7RUFHbEIsS0FBQTs7RUFMd0QsSUFBQSxZQUFBLENBQUEsV0FBQSxFQUFBLENBQUE7RUFBQSxNQUFBLEdBQUEsRUFBQSxtQkFBQTtFQUFBLE1BQUEsS0FBQSxFQU96RCxTQUFvQixpQkFBQSxHQUFBO0VBQ2xCLFFBQUEsSUFBTTdGLEtBQUssR0FBRyxJQUFBLENBQUsxQixLQUFMLENBQVdxSCxXQUFYLENBQWQsQ0FBQTs7RUFDQSxRQUFBLElBQUkzRixLQUFKLEVBQVc7RUFDVCxVQUFBLElBQUEsQ0FBS2QsR0FBTCxDQUFTTSxPQUFULENBQWlCTCxJQUFqQixJQUF5QmEsS0FBekIsQ0FBQTtFQUNELFNBQUE7RUFDRixPQUFBO0VBWndELEtBQUEsRUFBQTtFQUFBLE1BQUEsR0FBQSxFQUFBLFFBQUE7RUFBQSxNQUFBLEtBQUEsRUFjekQsU0FBUyxNQUFBLEdBQUE7RUFDUCxRQUFBLElBQUEsV0FBQSxHQUE0QixLQUFLMUIsS0FBakM7Y0FBT3dILFFBQVAsZUFBT0EsUUFBUDtFQUFBLFlBQW9CaEYsSUFBcEIsR0FBQSx3QkFBQSxDQUFBLFdBQUEsRUFBQUMsV0FBQSxDQUFBLENBQUE7O1VBQ0EsT0FBT0QsSUFBSSxDQUFDNkUsV0FBRCxDQUFYLENBQUE7O0VBRUEsUUFBQSxJQUFJRyxRQUFRLElBQUlBLFFBQVEsS0FBSyxJQUFBLENBQUs1RyxHQUFsQyxFQUF1QztZQUNyQyxJQUFLQSxDQUFBQSxHQUFMLEdBQVc0RyxRQUFYLENBQUE7RUFDRCxTQUFBOztFQUVELFFBQUEsb0JBQ0V0Rix3Q0FBQyxnQkFBRCxFQUFBLFFBQUEsQ0FBQTtFQUNFLFVBQUEsR0FBRyxFQUFFLElBQUt0QixDQUFBQSxHQUFBQTtFQURaLFNBQUEsRUFFTTRCLElBRk4sQ0FJRyxFQUFBLElBQUEsQ0FBS3hDLEtBQUwsQ0FBV3VDLFFBSmQsQ0FERixDQUFBO0VBUUQsT0FBQTtFQTlCd0QsS0FBQSxDQUFBLENBQUEsQ0FBQTs7RUFBQSxJQUFBLE9BQUEsV0FBQSxDQUFBO0tBQ2pDTCxDQUFBQSx5QkFBSyxDQUFDaUIsU0FEMkIsQ0FBQSxDQUFBOztFQWlDM0QsRUFBQSxvQkFBT2pCLHlCQUFLLENBQUNDLFVBQU4sQ0FBaUIsVUFBQ25DLEtBQUQsRUFBUVksR0FBUixFQUFBO0VBQUEsSUFBQSxvQkFDdEJzQix3Q0FBQyxXQUFELEVBQUEsUUFBQSxDQUFBO0VBQWEsTUFBQSxRQUFRLEVBQUV0QixHQUFBQTtFQUF2QixLQUFBLEVBQWdDWixLQUFoQyxDQUFBLEVBQXdDQSxLQUFLLENBQUN1QyxRQUE5QyxDQURzQixDQUFBO0VBQUEsR0FBakIsQ0FBUCxDQUFBO0VBR0QsQ0FwQ0Q7O0VDUEEsSUFBTWtGLFdBQVcsR0FBRztFQUNsQkMsRUFBQUEsY0FBYyxFQUFFLGdCQURFO0VBRWxCQyxFQUFBQSxZQUFZLEVBQUUsY0FGSTtFQUdsQkMsRUFBQUEsV0FBVyxFQUFFLGFBSEs7RUFJbEJDLEVBQUFBLFNBQVMsRUFBRSxXQUpPO0VBS2xCQyxFQUFBQSxTQUFTLEVBQUUsV0FMTztFQU1sQkMsRUFBQUEsU0FBUyxFQUFFLFdBTk87RUFPbEJDLEVBQUFBLFNBQVMsRUFBRSxXQVBPO0VBUWxCQyxFQUFBQSxRQUFRLEVBQUUsVUFSUTtFQVNsQkMsRUFBQUEsVUFBVSxFQUFFLFlBQUE7RUFUTSxDQUFwQjs7RUNPQSxJQUFNL0gsU0FBTyxHQUNSc0gsY0FBQUEsQ0FBQUEsRUFBQUEsRUFBQUEsV0FEUSxDQUFiLENBQUE7O0VBSUEsSUFBTVUsb0JBQWtCLEdBQUcsU0FBckJBLGtCQUFxQixDQUFBQyxTQUFTLEVBQUE7RUFBQSxFQUFBLE9BQUloQixXQUFXLENBQUNnQixTQUFELEVBQVksZ0JBQVosRUFBOEIsU0FBOUIsQ0FBZixDQUFBO0VBQUEsQ0FBcEMsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOzs7QUFDQSxNQUFNQyxRQUFRLEdBQUdGLG9CQUFrQixDQUFDbkcsZ0JBQWdCLENBQUMsY0FBRCxFQUFpQjtFQUFDL0IsRUFBQUEsVUFBVSxFQUFFRSxTQUFBQTtFQUFiLENBQWpCLENBQWpCLEVBQW5DO0VBRUFrSSxRQUFRLENBQUM5RSxTQUFULEdBQXFCO0VBQ25CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQVREOztFQVduQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUssUUFBUSxFQUFFTiw2QkFBUyxDQUFDSSxJQXBCRDs7RUFzQm5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V5RSxRQUFRLEVBQUU3RSw2QkFBUyxDQUFDRyxJQTdCRDs7RUErQm5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UyRSxPQUFPLEVBQUU5RSw2QkFBUyxDQUFDRyxJQXRDQTs7RUF3Q25CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0VsQyxFQUFBQSxLQUFLLEVBQUUrQiw2QkFBUyxDQUFDK0UsU0FBVixDQUFvQixDQUN6Qi9FLDZCQUFTLENBQUNDLE1BRGUsRUFFekJELDZCQUFTLENBQUNnRixVQUFWLENBQXFCQyxJQUFyQixDQUZ5QixDQUFwQixDQS9DWTs7RUFvRG5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VDLE9BQU8sRUFBRWxGLDZCQUFTLENBQUNJLElBM0RBOztFQTZEbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStFLGNBQWMsRUFBRW5GLDZCQUFTLENBQUNJLElBcEVQOztFQXNFbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWdGLE9BQU8sRUFBRXBGLDZCQUFTLENBQUNDLE1BQUFBO0VBN0VBLENBQXJCOztFQzFCQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTW9GLEdBQUcsR0FBRzlHLGdCQUFnQixDQUFDLFNBQUQsRUFBNUI7RUFFQThHLEdBQUcsQ0FBQ3ZGLFNBQUosR0FBZ0I7RUFFZDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFd0YsRUFBQUEsYUFBYSxFQUFFdEYsNkJBQVMsQ0FBQzJDLEtBQVYsQ0FBZ0IsQ0FBQyxLQUFELEVBQVEsUUFBUixFQUFrQixRQUFsQixDQUFoQixDQVREOztFQVdkO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0U0QyxFQUFBQSxLQUFLLEVBQUV2Riw2QkFBUyxDQUFDK0UsU0FBVixDQUFvQixDQUFDL0UsNkJBQVMsQ0FBQ2lELE1BQVgsRUFBbUJqRCw2QkFBUyxDQUFDQyxNQUE3QixDQUFwQixDQUFBO0VBbEJPLENBQWhCOztFQ2hCQSxJQUFNekQsWUFBVSxHQUFHO0VBQ2pCK0QsRUFBQUEsUUFBUSxFQUFFLGdCQURPO0VBRWpCQyxFQUFBQSxNQUFNLEVBQUUsU0FGUztFQUdqQkUsRUFBQUEsVUFBVSxFQUFFLFVBSEs7RUFJakJELEVBQUFBLFlBQVksRUFBRSxZQUFBO0VBSkcsQ0FBbkIsQ0FBQTtFQU9BLElBQU0xQyxlQUFhLEdBQUcsQ0FBQyxvQkFBRCxDQUF0QixDQUFBO0VBRUE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7QUFDQTtFQUNBOztBQUNNeUgsTUFBQUEsTUFBTSxHQUFHakgsZ0JBQWdCLENBQUNvQixVQUFVLENBQUMsWUFBRCxDQUFYLEVBQTJCO0VBQUNuRCxFQUFBQSxVQUFVLEVBQVZBLFlBQUQ7RUFBYXVCLEVBQUFBLGFBQWEsRUFBYkEsZUFBQUE7RUFBYixDQUEzQixFQUEvQjtFQUVBeUgsTUFBTSxDQUFDMUYsU0FBUCxHQUFtQjtFQUNqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUQsT0FBTyxFQUFFRyw2QkFBUyxDQUFDSSxJQVZGOztFQVlqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFRSxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBdEJIOztFQXdCakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFQyxVQUFVLEVBQUVMLDZCQUFTLENBQUNJLElBbkNMOztFQXFDakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUYsY0FBYyxFQUFFRiw2QkFBUyxDQUFDRyxJQS9DVDs7RUFpRGpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VJLFFBQVEsRUFBRVAsNkJBQVMsQ0FBQ0csSUEzREg7O0VBNkRqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUssTUFBTSxFQUFFUiw2QkFBUyxDQUFDSSxJQXRFRDs7RUF3RWpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VLLFlBQVksRUFBRVQsNkJBQVMsQ0FBQ0ksSUFsRlA7O0VBb0ZqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFTSxVQUFVLEVBQUVWLDZCQUFTLENBQUNJLElBOUZMOztFQWdHakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRU8sU0FBUyxFQUFFWCw2QkFBUyxDQUFDQyxNQTFHSjs7RUE0R2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVcsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQXBISDs7RUFzSGpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVksU0FBUyxFQUFFYiw2QkFBUyxDQUFDQyxNQTlISjs7RUFnSWpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWEsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BeElYOztFQTBJakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsU0FBUyxFQUFFaEIsNkJBQVMsQ0FBQ0csSUFwSko7O0VBc0pqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxVQUFVLEVBQUVqQiw2QkFBUyxDQUFDRyxJQWhLTDs7RUFrS2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWUsU0FBUyxFQUFFbEIsNkJBQVMsQ0FBQ0csSUExS0o7O0VBNEtqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnQixVQUFVLEVBQUVuQiw2QkFBUyxDQUFDRyxJQXBMTDs7RUFzTGpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpQixrQkFBa0IsRUFBRXBCLDZCQUFTLENBQUNHLElBQUFBO0VBaE1iLENBQW5COztFQzlCQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU1zRixHQUFHLEdBQUdsSCxnQkFBZ0IsQ0FBQyxTQUFELEVBQTVCO0VBRUFrSCxHQUFHLENBQUMzRixTQUFKLEdBQWdCO0VBQ2Q7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVE47O0VBV2Q7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRThCLE1BQU0sRUFBRS9CLDZCQUFTLENBQUNJLElBbEJKOztFQW9CZDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzRixRQUFRLEVBQUUxRiw2QkFBUyxDQUFDQyxNQTVCTjs7RUE4QmQ7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUssUUFBUSxFQUFFTiw2QkFBUyxDQUFDSSxJQXJDTjs7RUF1Q2Q7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW1CLE9BQU8sRUFBRXZCLDZCQUFTLENBQUNHLElBQUFBO0VBOUNMLENBQWhCOztFQ3RCQSxJQUFNTCxXQUFTLEdBQUc7RUFFaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTZGLE1BQU0sRUFBRTNGLDZCQUFTLENBQUNHLElBVEY7O0VBV2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V5RixVQUFVLEVBQUU1Riw2QkFBUyxDQUFDRyxJQWxCTjs7RUFvQmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UwRixXQUFXLEVBQUU3Riw2QkFBUyxDQUFDRyxJQTNCUDs7RUE2QmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UyRixRQUFRLEVBQUU5Riw2QkFBUyxDQUFDRyxJQXBDSjs7RUFzQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0U0RixVQUFVLEVBQUUvRiw2QkFBUyxDQUFDRyxJQTdDTjs7RUErQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0U2RixNQUFNLEVBQUVoRyw2QkFBUyxDQUFDRyxJQXRERjs7RUF3RGhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0U4RixTQUFTLEVBQUVqRyw2QkFBUyxDQUFDRyxJQS9ETDs7RUFpRWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzRCxPQUFPLEVBQUV6RCw2QkFBUyxDQUFDRyxJQXhFSDs7RUEwRWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UrRixXQUFXLEVBQUVsRyw2QkFBUyxDQUFDRyxJQWpGUDs7RUFtRmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnRyxZQUFZLEVBQUVuRyw2QkFBUyxDQUFDRyxJQTFGUjs7RUE0RmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpRyxTQUFTLEVBQUVwRyw2QkFBUyxDQUFDRyxJQW5HTDs7RUFxR2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VrRyxXQUFXLEVBQUVyRyw2QkFBUyxDQUFDRyxJQTVHUDs7RUE4R2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VtRyxLQUFLLEVBQUV0Ryw2QkFBUyxDQUFDRyxJQXJIRDs7RUF1SGhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VvRyxXQUFXLEVBQUV2Ryw2QkFBUyxDQUFDRyxJQTlIUDs7RUFnSWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VxRyxPQUFPLEVBQUV4Ryw2QkFBUyxDQUFDRyxJQXZJSDs7RUF5SWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzRyxTQUFTLEVBQUV6Ryw2QkFBUyxDQUFDRyxJQWhKTDs7RUFrSmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V1RyxVQUFVLEVBQUUxRyw2QkFBUyxDQUFDRyxJQXpKTjs7RUEySmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V3RyxPQUFPLEVBQUUzRyw2QkFBUyxDQUFDRyxJQWxLSDs7RUFvS2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V5RyxXQUFXLEVBQUU1Ryw2QkFBUyxDQUFDRyxJQTNLUDs7RUE2S2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UwRyxRQUFRLEVBQUU3Ryw2QkFBUyxDQUFDRyxJQUFBQTtFQXBMSixDQUFsQixDQUFBO0VBdUxBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU0yRyxlQUFlLEdBQUd2SSxnQkFBZ0IsQ0FBQyxzQkFBRCxFQUF5QjtFQUFDdUIsRUFBQUEsU0FBUyxFQUFUQSxXQUFBQTtFQUFELENBQXpCLEVBQXhDO0VBQ0FnSCxlQUFlLENBQUNoSCxTQUFoQixHQUE0QkEsV0FBNUI7Ozs7RUMxTUEsSUFBTWlILFNBQVMsR0FBRyxTQUFaQSxTQUFZLENBQUF6RixJQUFJLEVBQUk7RUFDeEIsRUFBQSxJQUFJQSxJQUFKLEVBQVU7RUFDUixJQUFBLElBQUssT0FBT0EsSUFBUixLQUFrQixRQUF0QixFQUFnQztFQUM5QixNQUFBLE9BQU9BLElBQVAsQ0FBQTtFQUNELEtBRkQsTUFFTztRQUNMLElBQU0wRixJQUFJLEdBQUduSyxNQUFNLENBQUNtSyxJQUFQLENBQVkxRixJQUFaLENBQWtCMkYsQ0FBQUEsTUFBbEIsQ0FBeUIsVUFBQ0MsQ0FBRCxFQUFBO1VBQUEsT0FBT0EsQ0FBQyxLQUFLLFNBQWIsQ0FBQTtFQUFBLE9BQXpCLENBQWIsQ0FBQTtFQUNBLE1BQUEsSUFBTUMsV0FBVyxHQUFHSCxJQUFJLENBQUNJLEdBQUwsQ0FBUyxVQUFDQyxHQUFELEVBQUE7VUFBQSxPQUFTQSxHQUFHLEdBQUcsR0FBTixHQUFZL0YsSUFBSSxDQUFDK0YsR0FBRCxDQUFoQixHQUF3QixFQUFqQyxDQUFBO0VBQUEsT0FBVCxDQUFwQixDQUFBO1FBQ0EsT0FBTy9GLElBQUksQ0FBSixTQUFBLENBQUEsR0FBZSxJQUFmLEdBQXNCNkYsV0FBVyxDQUFDRyxJQUFaLENBQWlCLEdBQWpCLENBQTdCLENBQUE7RUFDRCxLQUFBO0VBQ0YsR0FBQTtFQUNGLENBVkQsQ0FBQTs7RUFZQSxJQUFNQyxTQUFTLEdBQUcsU0FBWkEsU0FBWSxDQUFBQyxJQUFJLEVBQUk7RUFDeEIsRUFBQSxJQUFJQSxJQUFKLEVBQVU7RUFDUixJQUFBLElBQUssT0FBT0EsSUFBUixLQUFrQixRQUF0QixFQUFnQztFQUM5QixNQUFBLE9BQUEsRUFBQSxDQUFBLE1BQUEsQ0FBVUEsSUFBVixFQUFBLElBQUEsQ0FBQSxDQUFBO0VBQ0QsS0FGRCxNQUVPO1FBQ0wsSUFBTVIsSUFBSSxHQUFHbkssTUFBTSxDQUFDbUssSUFBUCxDQUFZUSxJQUFaLENBQWtCUCxDQUFBQSxNQUFsQixDQUF5QixVQUFDQyxDQUFELEVBQUE7VUFBQSxPQUFPQSxDQUFDLEtBQUssU0FBYixDQUFBO0VBQUEsT0FBekIsQ0FBYixDQUFBO0VBQ0EsTUFBQSxJQUFNQyxXQUFXLEdBQUdILElBQUksQ0FBQ0ksR0FBTCxDQUFTLFVBQUNDLEdBQUQsRUFBQTtVQUFBLE9BQVNBLEdBQUcsR0FBRyxHQUFOLEdBQVlHLElBQUksQ0FBQ0gsR0FBRCxDQUFoQixHQUF3QixJQUFqQyxDQUFBO0VBQUEsT0FBVCxDQUFwQixDQUFBO1FBQ0EsT0FBT0csSUFBSSxDQUFKLFNBQUEsQ0FBQSxHQUFlLE1BQWYsR0FBd0JMLFdBQVcsQ0FBQ0csSUFBWixDQUFpQixHQUFqQixDQUEvQixDQUFBO0VBQ0QsS0FBQTtFQUNGLEdBQUE7RUFDRixDQVZELENBQUE7O0VBWUEsSUFBTW5GLFNBQU8sR0FBRzVELGdCQUFnQixDQUFDLFVBQUQsQ0FBaEMsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDTWtKLE1BQUFBLElBQUksZ0JBQUdoSix5QkFBSyxDQUFDQyxVQUFOLENBQWlCLFVBQUNuQyxLQUFELEVBQVFZLEdBQVIsRUFBZ0I7RUFDNUMsRUFBQSxJQUFPbUUsSUFBUCxHQUE4Qi9FLEtBQTlCLENBQU8rRSxJQUFQO0VBQUEsTUFBYWtHLElBQWIsR0FBOEJqTCxLQUE5QixDQUFhaUwsSUFBYjtRQUFzQnpJLElBQXRCLDRCQUE4QnhDLEtBQTlCLEVBQUF5QyxXQUFBLENBQUEsQ0FBQTs7RUFFQSxFQUFBLG9CQUNFUCx3Q0FBQzBELFNBQUQsRUFBQSxRQUFBLENBQUE7RUFDRSxJQUFBLElBQUksRUFBRTRFLFNBQVMsQ0FBQ3pGLElBQUQsQ0FEakI7TUFFRSxJQUFJLEVBQUVpRyxTQUFTLENBQUNDLElBQUQsQ0FBQTtFQUZqQixHQUFBLEVBR016SSxJQUhOLEVBQUE7RUFJRSxJQUFBLEdBQUcsRUFBRTVCLEdBQUFBO0tBRUpaLENBQUFBLEVBQUFBLEtBQUssQ0FBQ3VDLFFBTlQsQ0FERixDQUFBO0VBVUQsQ0FiWSxFQUFiO0VBZUEySSxJQUFJLENBQUMzSCxTQUFMLEdBQWlCO0VBQ2Y7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVEw7O0VBV2Y7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRXFCLEVBQUFBLElBQUksRUFBRXRCLDZCQUFTLENBQUMrRSxTQUFWLENBQW9CLENBQ3hCL0UsNkJBQVMsQ0FBQ0MsTUFEYyxFQUV4QkQsNkJBQVMsQ0FBQzBILFFBQVYsQ0FBbUIxSCw2QkFBUyxDQUFDQyxNQUE3QixDQUZ3QixDQUFwQixDQWxCUzs7RUF1QmY7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRXVILEVBQUFBLElBQUksRUFBRXhILDZCQUFTLENBQUMrRSxTQUFWLENBQW9CLENBQ3hCL0UsNkJBQVMsQ0FBQ2lELE1BRGMsRUFFeEJqRCw2QkFBUyxDQUFDMEgsUUFBVixDQUFtQjFILDZCQUFTLENBQUNpRCxNQUE3QixDQUZ3QixDQUFwQixDQTlCUzs7RUFtQ2Y7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRTBFLEVBQUFBLE1BQU0sRUFBRTNILDZCQUFTLENBQUMyQyxLQUFWLENBQWdCLENBQUMsQ0FBRCxFQUFJLEVBQUosRUFBUSxHQUFSLEVBQWEsR0FBYixDQUFoQixDQTFDTzs7RUE0Q2Y7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWlGLFVBQVUsRUFBRTVILDZCQUFTLENBQUNJLElBbkRQOztFQXFEZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeUgsSUFBSSxFQUFFN0gsNkJBQVMsQ0FBQ0ksSUFBQUE7RUE1REQsQ0FBakI7O0VDMURBLElBQU0xRCxTQUFPLEdBQ1JzSCxjQUFBQSxDQUFBQSxFQUFBQSxFQUFBQSxXQURRLENBQWIsQ0FBQTs7RUFJQSxJQUFNOEQsa0JBQWdCLEdBQUcsU0FBbkJBLGdCQUFtQixDQUFBbkQsU0FBUyxFQUFBO0VBQUEsRUFBQSxPQUFJaEIsV0FBVyxDQUFDZ0IsU0FBRCxFQUFZLGNBQVosRUFBNEIsT0FBNUIsQ0FBZixDQUFBO0VBQUEsQ0FBbEMsQ0FBQTs7RUFFQSxJQUFNNUcsZUFBYSxHQUFHLENBQ3BCLE9BRG9CO0VBQUEsQ0FBdEIsQ0FBQTtFQUlBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU1nSyxLQUFLLEdBQUdELGtCQUFnQixDQUFDdkosZ0JBQWdCLENBQUMsV0FBRCxFQUFjO0VBQUMvQixFQUFBQSxVQUFVLEVBQUVFLFNBQWI7RUFBc0JxQixFQUFBQSxhQUFhLEVBQWJBLGVBQUFBO0VBQXRCLENBQWQsQ0FBakIsRUFBOUI7RUFFQWdLLEtBQUssQ0FBQ2pJLFNBQU4sR0FBa0I7RUFDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVEo7O0VBV2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VLLFFBQVEsRUFBRU4sNkJBQVMsQ0FBQ0ksSUFsQko7O0VBb0JoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFb0UsUUFBUSxFQUFFeEUsNkJBQVMsQ0FBQ0ksSUEzQko7O0VBNkJoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeUUsUUFBUSxFQUFFN0UsNkJBQVMsQ0FBQ0csSUFwQ0o7O0VBc0NoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMkUsT0FBTyxFQUFFOUUsNkJBQVMsQ0FBQ0csSUE3Q0g7O0VBK0NoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFbEMsRUFBQUEsS0FBSyxFQUFFK0IsNkJBQVMsQ0FBQytFLFNBQVYsQ0FBb0IsQ0FDekIvRSw2QkFBUyxDQUFDQyxNQURlLEVBRXpCRCw2QkFBUyxDQUFDZ0YsVUFBVixDQUFxQkMsSUFBckIsQ0FGeUIsQ0FBcEIsQ0F0RFM7O0VBMkRoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFK0MsRUFBQUEsWUFBWSxFQUFFaEksNkJBQVMsQ0FBQytFLFNBQVYsQ0FBb0IsQ0FDaEMvRSw2QkFBUyxDQUFDQyxNQURzQixFQUVoQ0QsNkJBQVMsQ0FBQ2dGLFVBQVYsQ0FBcUJDLElBQXJCLENBRmdDLENBQXBCLENBbEVFOztFQXVFaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWdELFdBQVcsRUFBRWpJLDZCQUFTLENBQUNDLE1BOUVQOztFQWdGaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaUksSUFBSSxFQUFFbEksNkJBQVMsQ0FBQ0MsTUEzRkE7O0VBNkZoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFbUYsT0FBTyxFQUFFcEYsNkJBQVMsQ0FBQ0MsTUFwR0g7O0VBc0doQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFLEVBQUEsT0FBQSxFQUFPRCw2QkFBUyxDQUFDSSxJQUFBQTtFQTdHRCxDQUFsQjs7O0VDN0JBLElBQU0rQixTQUFPLEdBQUc1RCxnQkFBZ0IsQ0FBQyxVQUFELENBQWhDLENBQUE7RUFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ000SixNQUFBQSxJQUFJLGdCQUFHMUoseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRWSxHQUFSLEVBQWdCO0VBQzVDLEVBQUEsSUFBT2lMLFlBQVAsR0FBcUU3TCxLQUFyRSxDQUFPNkwsWUFBUDtFQUFBLE1BQXFCQyxZQUFyQixHQUFxRTlMLEtBQXJFLENBQXFCOEwsWUFBckI7RUFBQSxNQUFtQ0MsU0FBbkMsR0FBcUUvTCxLQUFyRSxDQUFtQytMLFNBQW5DO0VBQUEsTUFBOENDLFVBQTlDLEdBQXFFaE0sS0FBckUsQ0FBOENnTSxVQUE5QztRQUE2RHhKLElBQTdELDRCQUFxRXhDLEtBQXJFLEVBQUF5QyxXQUFBLENBQUEsQ0FBQTs7SUFFQSxJQUFNd0osSUFBSSxHQUFHRCxVQUFVLENBQUNuQixHQUFYLENBQWUsVUFBQ3FCLElBQUQsRUFBT3ZHLEtBQVAsRUFBQTtFQUFBLElBQUEsT0FBaUJvRyxTQUFTLENBQUNHLElBQUQsRUFBT3ZHLEtBQVAsQ0FBMUIsQ0FBQTtFQUFBLEdBQWYsQ0FBYixDQUFBO0lBRUEsb0JBQ0V6RCx5QkFBQSxDQUFBLGFBQUEsQ0FBQzBELFNBQUQsRUFBQSxRQUFBLENBQUEsRUFBQSxFQUNNcEQsSUFETixFQUFBO0VBRUUsSUFBQSxHQUFHLEVBQUU1QixHQUFBQTtLQUVKaUwsQ0FBQUEsRUFBQUEsWUFBWSxFQUpmLEVBS0dJLElBTEgsRUFNR2pNLEtBQUssQ0FBQ3VDLFFBTlQsRUFPR3VKLFlBQVksRUFQZixDQURGLENBQUE7RUFXRCxDQWhCWSxFQUFiO0VBa0JBRixJQUFJLENBQUNySSxTQUFMLEdBQWlCO0VBQ2Y7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFWTDs7RUFZZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXNJLFVBQVUsRUFBRXZJLDZCQUFTLENBQUMwSSxLQXJCUDs7RUF1QmY7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUosU0FBUyxFQUFFdEksNkJBQVMsQ0FBQ0csSUFqQ047O0VBbUNmO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaUksWUFBWSxFQUFFcEksNkJBQVMsQ0FBQ0csSUE1Q1Q7O0VBOENmO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFa0ksWUFBWSxFQUFFckksNkJBQVMsQ0FBQ0csSUFBQUE7RUF2RFQsQ0FBakIsQ0FBQTtFQTBEQWdJLElBQUksQ0FBQ1EsWUFBTCxHQUFvQjtFQUNsQkosRUFBQUEsVUFBVSxFQUFFLEVBRE07RUFFbEJELEVBQUFBLFNBQVMsRUFBRSxTQUFBLFNBQUEsR0FBQTtFQUFBLElBQUEsT0FBTSxJQUFOLENBQUE7S0FGTztFQUdsQkYsRUFBQUEsWUFBWSxFQUFFLFNBQUEsWUFBQSxHQUFBO0VBQUEsSUFBQSxPQUFNLElBQU4sQ0FBQTtLQUhJO0VBSWxCQyxFQUFBQSxZQUFZLEVBQUUsU0FBQSxZQUFBLEdBQUE7RUFBQSxJQUFBLE9BQU0sSUFBTixDQUFBO0VBQUEsR0FBQTtFQUpJLENBQXBCOzs7RUNuR0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7QUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNNTyxNQUFBQSxRQUFRLGdCQUFHbksseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRc00sWUFBUixFQUF5QjtFQUN6RCxFQUFBLElBQU0xTCxHQUFHLEdBQUcwTCxZQUFZLElBQUlqSyxZQUFNLEVBQWxDLENBQUE7O0lBQ0EsSUFBZ0NrSyxTQUFBQSxHQUFBQSxjQUFRLENBQUMsRUFBRCxDQUF4QztFQUFBLE1BQUEsVUFBQSxHQUFBLGNBQUEsQ0FBQSxTQUFBLEVBQUEsQ0FBQSxDQUFBO0VBQUEsTUFBT2hLLFFBQVAsR0FBQSxVQUFBLENBQUEsQ0FBQSxDQUFBO0VBQUEsTUFBaUJpSyxXQUFqQixHQUFBLFVBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7RUFDQSxFQUFBLElBQUEsVUFBQSxHQUF5QkQsY0FBUSxFQUFqQztFQUFBLE1BQUEsVUFBQSxHQUFBLGNBQUEsQ0FBQSxVQUFBLEVBQUEsQ0FBQSxDQUFBO0VBQUEsTUFBU0UsWUFBVCxHQUFBLFVBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7RUFFQSxFQUFBLElBQU9DLG9CQUFQLEdBQTBEMU0sS0FBMUQsQ0FBTzBNLG1CQUFQO0VBQUEsTUFBNEJYLFNBQTVCLEdBQTBEL0wsS0FBMUQsQ0FBNEIrTCxTQUE1QjtFQUFBLE1BQXVDWSxNQUF2QyxHQUEwRDNNLEtBQTFELENBQXVDMk0sTUFBdkM7UUFBa0RuSyxJQUFsRCw0QkFBMER4QyxLQUExRCxFQUFBeUMsV0FBQSxDQUFBLENBQUE7O0VBRUF4QixFQUFBQSxlQUFTLENBQUMsWUFBTTtFQUNkTCxJQUFBQSxHQUFHLENBQUNNLE9BQUosQ0FBWTBMLFFBQVosR0FBdUI7UUFDckJGLG1CQUFtQixFQUFFLFNBQVMvRyxtQkFBQUEsQ0FBQUEsS0FBVCxFQUFnQjtVQUNuQyxPQUFPK0csb0JBQW1CLENBQUMvRyxLQUFELENBQTFCLENBQUE7U0FGbUI7RUFJckJrSCxNQUFBQSxPQUFPLEVBQUUsU0FBU0MsT0FBQUEsQ0FBQUEsS0FBVCxFQUFnQkMsS0FBaEIsRUFBdUJDLFNBQXZCLEVBQWtDO1VBQ3pDLElBQU1DLEVBQUUsR0FBRyxFQUFYLENBQUE7O1VBQ0EsS0FBSyxJQUFJQyxDQUFDLEdBQUdKLEtBQWIsRUFBb0JJLENBQUMsR0FBR0gsS0FBeEIsRUFBK0JHLENBQUMsRUFBaEMsRUFBb0M7RUFDbENELFVBQUFBLEVBQUUsQ0FBQ0UsSUFBSCxDQUFRcEIsU0FBUyxDQUFDbUIsQ0FBRCxDQUFqQixDQUFBLENBQUE7RUFDRCxTQUFBOztVQUNEVixXQUFXLENBQUNTLEVBQUQsQ0FBWCxDQUFBO0VBQ0FSLFFBQUFBLFlBQVksQ0FBQ08sU0FBRCxDQUFaLENBTnlDO1NBSnRCO0VBWXJCSSxNQUFBQSxVQUFVLEVBQUUsU0FBVyxVQUFBLEdBQUE7RUFDckIsUUFBQSxPQUFPVCxNQUFQLENBQUE7RUFDRCxPQUFBO09BZEgsQ0FBQTtLQURPLEVBaUJOLENBQUNELG9CQUFELEVBQXNCWCxTQUF0QixFQUFpQ1ksTUFBakMsQ0FqQk0sQ0FBVCxDQUFBO0lBbUJBLG9CQUNFeksseUJBQUEsQ0FBQSxhQUFBLENBQUMsSUFBRCxFQUFBLFFBQUEsQ0FBQSxFQUFBLEVBQ01NLElBRE4sRUFBQTtFQUVFLElBQUEsS0FBSyxFQUFFO0VBQUMyRyxNQUFBQSxRQUFRLEVBQUUsVUFBQTtFQUFYLEtBQUE7S0FFUCxDQUFBLGVBQUFqSCx5QkFBQSxDQUFBLGFBQUEsQ0FBQSxpQkFBQSxFQUFBO0VBQWlCLElBQUEsR0FBRyxFQUFFdEIsR0FBQUE7S0FKeEIsQ0FBQSxFQUtHMkIsUUFMSCxDQURGLENBQUE7RUFTRCxDQW5DZ0IsRUFBakI7RUFxQ0E4SixRQUFRLENBQUM5SSxTQUFULEdBQXFCO0VBQ25CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQVREOztFQVduQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFaUosRUFBQUEsTUFBTSxFQUFFbEosNkJBQVMsQ0FBQ2lELE1BQVYsQ0FBaUIyRyxVQWxCTjs7RUFvQm5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0V0QixFQUFBQSxTQUFTLEVBQUV0SSw2QkFBUyxDQUFDRyxJQUFWLENBQWV5SixVQTNCUDs7RUE2Qm5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0VYLEVBQUFBLG1CQUFtQixFQUFFakosNkJBQVMsQ0FBQ0csSUFBVixDQUFleUosVUFBQUE7RUFwQ2pCLENBQXJCOztFQzdFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTUMsVUFBVSxHQUFHdEwsZ0JBQWdCLENBQUMsaUJBQUQsRUFBbkM7RUFFQXNMLFVBQVUsQ0FBQy9KLFNBQVgsR0FBdUI7RUFDckI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFBQUE7RUFWQyxDQUF2Qjs7RUNwQkEsSUFBTUgsV0FBUyxHQUFHO0VBQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQVRKOztFQVdoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTZKLFFBQVEsRUFBRTlKLDZCQUFTLENBQUNJLElBcEJKOztFQXNCaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UySixrQkFBa0IsRUFBRS9KLDZCQUFTLENBQUNDLE1BL0JkOztFQWlDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStKLFVBQVUsRUFBRWhLLDZCQUFTLENBQUNJLElBeENOOztFQTBDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTZKLFVBQVUsRUFBRWpLLDZCQUFTLENBQUNJLElBakROOztFQW1EaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRThKLFFBQVEsRUFBRWxLLDZCQUFTLENBQUNJLElBMURKOztFQTREaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStKLFFBQVEsRUFBRW5LLDZCQUFTLENBQUNHLElBbkVKOztFQXFFaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVEsU0FBUyxFQUFFWCw2QkFBUyxDQUFDQyxNQUFBQTtFQTVFTCxDQUFsQixDQUFBO0VBK0VBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTW1LLFFBQVEsR0FBRzdMLGdCQUFnQixDQUFDLGVBQUQsRUFBa0I7RUFBQ3VCLEVBQUFBLFNBQVMsRUFBVEEsV0FBQUE7RUFBRCxDQUFsQixFQUFqQztFQUNBc0ssUUFBUSxDQUFDdEssU0FBVCxHQUFxQkEsV0FBckI7O0VDakdBLElBQU1BLFdBQVMsR0FBRztFQUNoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQUFBQTtFQVZKLENBQWxCLENBQUE7RUFhQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNb0ssU0FBUyxHQUFHOUwsZ0JBQWdCLENBQUMsZ0JBQUQsRUFBbUI7RUFBQ3VCLEVBQUFBLFNBQVMsRUFBVEEsV0FBQUE7RUFBRCxDQUFuQixFQUFsQztFQUNBdUssU0FBUyxDQUFDdkssU0FBVixHQUFzQkEsV0FBdEI7OztFQy9CQSxJQUFNcUMsU0FBTyxHQUFHNUQsZ0JBQWdCLENBQUMsZUFBRCxDQUFoQyxDQUFBOztNQUVNK0w7Ozs7O0lBQ0osU0FBcUIsY0FBQSxHQUFBO0VBQUEsSUFBQSxJQUFBLEtBQUEsQ0FBQTs7RUFBQSxJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsY0FBQSxDQUFBLENBQUE7O0VBQUEsSUFBQSxLQUFBLElBQUEsSUFBQSxHQUFBLFNBQUEsQ0FBQSxNQUFBLEVBQU5DLElBQU0sR0FBQSxJQUFBLEtBQUEsQ0FBQSxJQUFBLENBQUEsRUFBQSxJQUFBLEdBQUEsQ0FBQSxFQUFBLElBQUEsR0FBQSxJQUFBLEVBQUEsSUFBQSxFQUFBLEVBQUE7UUFBTkEsSUFBTSxDQUFBLElBQUEsQ0FBQSxHQUFBLFNBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQTtFQUFBLEtBQUE7O0VBQ25CLElBQUEsS0FBQSxHQUFBLE1BQUEsQ0FBQSxJQUFBLENBQUEsS0FBQSxDQUFBLE1BQUEsRUFBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBU0EsSUFBVCxDQUFBLENBQUEsQ0FBQTtFQUNBLElBQUEsS0FBQSxDQUFLcE4sR0FBTCxnQkFBV3NCLHlCQUFLLENBQUNxRixTQUFOLEVBQVgsQ0FBQTtNQUNBLEtBQUswRyxDQUFBQSxLQUFMLEdBQWEsRUFBYixDQUFBO01BQ0EsS0FBS0MsQ0FBQUEsS0FBTCxHQUFhLEVBQWIsQ0FBQTtFQUNBLElBQUEsS0FBQSxDQUFLQyxRQUFMLEdBQWdCLEtBQUEsQ0FBS0EsUUFBTCxDQUFjQyxJQUFkLENBQWhCLHNCQUFBLENBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTtFQUNBLElBQUEsS0FBQSxDQUFLQyxTQUFMLEdBQWlCLEtBQUEsQ0FBS0EsU0FBTCxDQUFlRCxJQUFmLENBQWpCLHNCQUFBLENBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTtFQUNBLElBQUEsS0FBQSxDQUFLRSxPQUFMLEdBQWUsS0FBQSxDQUFLQSxPQUFMLENBQWFGLElBQWIsQ0FBZixzQkFBQSxDQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7RUFDQSxJQUFBLEtBQUEsQ0FBS0csUUFBTCxHQUFnQixLQUFBLENBQUtBLFFBQUwsQ0FBY0gsSUFBZCxDQUFoQixzQkFBQSxDQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7RUFSbUIsSUFBQSxPQUFBLEtBQUEsQ0FBQTtFQVNwQixHQUFBOzs7O2FBRUQsU0FBT0gsTUFBQUEsQ0FBQUEsS0FBUCxFQUFjTyxHQUFkLEVBQW1CO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O0VBQ2pCLE1BQUEsSUFBQSxDQUFLUCxLQUFMLEdBQWFBLEtBQUssSUFBSSxFQUF0QixDQUFBO0VBQ0EsTUFBQSxPQUFPLElBQUlRLE9BQUosQ0FBWSxVQUFDQyxPQUFELEVBQWE7VUFDOUIsTUFBSSxDQUFDQyxXQUFMLENBQWlCRCxPQUFqQixDQUFBLENBQUE7RUFDRCxPQUZNLENBQVAsQ0FBQTtFQUdELEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OztFQUNFLElBQUEsS0FBQSxFQUFBLFNBQUEsU0FBQSxDQUFVRSxLQUFWLEVBQStCO1FBQUEsSUFBZHJOLE9BQWMsdUVBQUosRUFBSSxDQUFBO1FBQzdCLE9BQU8sSUFBQSxDQUFLc04sY0FBTCxDQUFvQixDQUFDRCxLQUFELENBQXBCLEVBQTZCck4sT0FBN0IsQ0FBUCxDQUFBO0VBQ0QsS0FBQTtFQUVEO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOzs7O0VBQ0UsSUFBQSxLQUFBLEVBQUEsU0FBQSxjQUFBLENBQWV1TixNQUFmLEVBQXFDO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O1FBQUEsSUFBZHZOLE9BQWMsdUVBQUosRUFBSSxDQUFBOztRQUNuQyxJQUFJLElBQUEsQ0FBS3dOLFNBQUwsRUFBSixFQUFzQjtFQUNwQixRQUFBLE9BQU9OLE9BQU8sQ0FBQ08sTUFBUixDQUFlLHlDQUFmLENBQVAsQ0FBQTtFQUNELE9BQUE7O0VBRUQsTUFBQSxJQUFNQyxTQUFTLEdBQUcsU0FBWkEsU0FBWSxHQUFNO1VBQ3RCLElBQU1DLFlBQVksR0FBRyxNQUFJLENBQUN0TyxHQUFMLENBQVNNLE9BQVQsQ0FBaUIrTSxLQUF0QyxDQUFBOztFQUNBLFFBQUEsS0FBSyxJQUFJZixDQUFDLEdBQUdnQyxZQUFZLENBQUN2QyxNQUFiLEdBQXNCLENBQW5DLEVBQXNDTyxDQUFDLElBQUksQ0FBM0MsRUFBOENBLENBQUMsRUFBL0MsRUFBbUQ7WUFDakRnQyxZQUFZLENBQUNoQyxDQUFELENBQVosQ0FBZ0I1SyxLQUFoQixDQUFzQjZNLE9BQXRCLEdBQWdDLE1BQWhDLENBQUE7RUFDRCxTQUFBO1NBSkgsQ0FBQTs7UUFPQSxJQUFJNU4sT0FBTyxDQUFDNk4sR0FBWixFQUFpQjtFQUNmLFFBQUEsSUFBQSxDQUFLQyxlQUFMLEdBQXVCLElBQUEsQ0FBS1AsTUFBTCxDQUFZOU4sS0FBWixFQUF2QixDQUFBO1VBQ0EsSUFBS3NPLENBQUFBLGNBQUwsR0FBc0JSLE1BQXRCLENBQUE7RUFDQSxRQUFBLElBQUEsQ0FBS0EsTUFBTCxHQUFjQSxNQUFNLENBQUNTLE1BQVAsQ0FBYyxDQUFDLElBQUtULENBQUFBLE1BQUwsQ0FBWSxJQUFBLENBQUtBLE1BQUwsQ0FBWW5DLE1BQVosR0FBcUIsQ0FBakMsQ0FBRCxDQUFkLENBQWQsQ0FBQTs7RUFFQSxRQUFBLElBQU02QyxPQUFNLEdBQUcsU0FBVEEsT0FBUyxHQUFNO1lBQ25CLE1BQUksQ0FBQ3ZCLEtBQUwsQ0FBV21CLEdBQVgsRUFBQSxDQUFBOztZQUNBLE1BQUksQ0FBQ04sTUFBTCxHQUFjQSxNQUFkLENBQUE7RUFDQSxVQUFBLE9BQU8sSUFBSUwsT0FBSixDQUFZLFVBQUNDLE9BQUQsRUFBQTtFQUFBLFlBQUEsT0FBYSxNQUFJLENBQUNDLFdBQUwsQ0FBaUJELE9BQWpCLENBQWIsQ0FBQTtFQUFBLFdBQVosQ0FBUCxDQUFBO1dBSEYsQ0FBQTs7RUFNQSxRQUFBLE9BQU8sS0FBS2MsTUFBTCxDQUFZLEtBQUt2QixLQUFqQixDQUFBLENBQ0p3QixJQURJLENBQ0MsWUFBQTtZQUFBLE9BQU0sTUFBSSxDQUFDN08sR0FBTCxDQUFTTSxPQUFULENBQWlCd08sUUFBakIsQ0FBMEJuTyxPQUExQixFQUFtQ2lPLE9BQW5DLENBQU4sQ0FBQTtXQURELENBQUEsQ0FFSkMsSUFGSSxDQUVDLFlBQUE7RUFBQSxVQUFBLE9BQU1SLFNBQVMsRUFBZixDQUFBO0VBQUEsU0FGRCxDQUFQLENBQUE7RUFHRCxPQUFBOztRQUVELElBQU1VLFNBQVMsR0FBR2IsTUFBTSxDQUFDQSxNQUFNLENBQUNuQyxNQUFQLEdBQWdCLENBQWpCLENBQXhCLENBQUE7UUFDQSxJQUFNaUQsT0FBTyxHQUFHLElBQUEsQ0FBSzVQLEtBQUwsQ0FBVzZQLFVBQVgsQ0FBc0JGLFNBQXRCLEVBQWlDLElBQWpDLENBQWhCLENBQUE7RUFDQSxNQUFBLElBQUEsQ0FBS2IsTUFBTCxDQUFZM0IsSUFBWixDQUFpQndDLFNBQWpCLENBQUEsQ0FBQTs7RUFFQSxNQUFBLElBQU1ILE1BQU0sR0FBRyxTQUFUQSxNQUFTLEdBQU07RUFDbkIsUUFBQSxNQUFJLENBQUN2QixLQUFMLENBQVdkLElBQVgsQ0FBZ0J5QyxPQUFoQixDQUFBLENBQUE7O0VBQ0EsUUFBQSxPQUFPLElBQUluQixPQUFKLENBQVksVUFBQ0MsT0FBRCxFQUFBO0VBQUEsVUFBQSxPQUFhLE1BQUksQ0FBQ0MsV0FBTCxDQUFpQkQsT0FBakIsQ0FBYixDQUFBO0VBQUEsU0FBWixDQUFQLENBQUE7U0FGRixDQUFBOztFQUtBLE1BQUEsT0FBTyxJQUFLOU4sQ0FBQUEsR0FBTCxDQUFTTSxPQUFULENBQWlCNE8sU0FBakIsQ0FBMkJ2TyxPQUEzQixFQUFvQ2lPLE1BQXBDLENBQTRDQyxDQUFBQSxJQUE1QyxDQUFpRCxZQUFNO1VBQzVELE1BQUksQ0FBQ1gsTUFBTCxHQUFjQSxNQUFkLENBQUE7VUFDQSxNQUFJLENBQUNiLEtBQUwsR0FBYWEsTUFBTSxDQUFDakUsR0FBUCxDQUFXLFVBQUErRCxLQUFLLEVBQUE7WUFBQSxPQUFJLE1BQUksQ0FBQzVPLEtBQUwsQ0FBVzZQLFVBQVgsQ0FBc0JqQixLQUF0QixFQUE2QixNQUE3QixDQUFKLENBQUE7RUFBQSxTQUFoQixDQUFiLENBQUE7VUFDQSxPQUFPLE1BQUksQ0FBQ1ksTUFBTCxDQUFZLE1BQUksQ0FBQ3ZCLEtBQWpCLENBQXdCd0IsQ0FBQUEsSUFBeEIsQ0FBNkIsWUFBQTtFQUFBLFVBQUEsT0FBTVIsU0FBUyxFQUFmLENBQUE7RUFBQSxTQUE3QixDQUFQLENBQUE7RUFDRCxPQUpNLENBQVAsQ0FBQTtFQUtELEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OztFQUNFLElBQUEsS0FBQSxFQUFBLFNBQUEsUUFBQSxDQUFTTCxLQUFULEVBQThCO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O1FBQUEsSUFBZHJOLE9BQWMsdUVBQUosRUFBSSxDQUFBOztRQUM1QixJQUFJLElBQUEsQ0FBS3dOLFNBQUwsRUFBSixFQUFzQjtFQUNwQixRQUFBLE9BQU9OLE9BQU8sQ0FBQ08sTUFBUixDQUFlLHlDQUFmLENBQVAsQ0FBQTtFQUNELE9BQUE7O0VBRUQsTUFBQSxPQUFPLElBQUlQLE9BQUosQ0FBWSxVQUFDQyxPQUFELEVBQWE7RUFDOUIsUUFBQSxJQUFNYyxNQUFNLEdBQUcsU0FBVEEsTUFBUyxHQUFNO0VBQ25CLFVBQUEsT0FBTyxJQUFJZixPQUFKLENBQVksVUFBQ0MsT0FBRCxFQUFhO0VBQzlCLFlBQUEsTUFBSSxDQUFDVCxLQUFMLENBQVdkLElBQVgsQ0FBZ0IsTUFBSSxDQUFDbk4sS0FBTCxDQUFXNlAsVUFBWCxDQUFzQmpCLEtBQXRCLEVBQTZCLE1BQTdCLENBQWhCLENBQUEsQ0FBQTs7Y0FDQSxNQUFJLENBQUNELFdBQUwsQ0FBaUJELE9BQWpCLENBQUEsQ0FBQTtFQUNELFdBSE0sQ0FBUCxDQUFBO1dBREYsQ0FBQTs7RUFPQSxRQUFBLE1BQUksQ0FBQ0ksTUFBTCxDQUFZM0IsSUFBWixDQUFpQnlCLEtBQWpCLENBQUEsQ0FBQTs7RUFDQSxRQUFBLE1BQUksQ0FBQ2hPLEdBQUwsQ0FBU00sT0FBVCxDQUNHNE8sU0FESCxDQUVJdk8sT0FGSixFQUdJaU8sTUFISixFQUtHQyxJQUxILENBS1FmLE9BTFIsQ0FNUyxDQUFBLE9BQUEsQ0FBQSxDQUFBLFVBQUNxQixLQUFELEVBQVc7WUFDaEIsTUFBSSxDQUFDakIsTUFBTCxDQUFZTSxHQUFaLEVBQUEsQ0FBQTs7WUFDQSxNQUFJLENBQUNuQixLQUFMLENBQVdtQixHQUFYLEVBQUEsQ0FBQTs7RUFDQSxVQUFBLE1BQU1XLEtBQU4sQ0FBQTtXQVRKLENBQUEsQ0FBQTtFQVdELE9BcEJNLENBQVAsQ0FBQTtFQXFCRCxLQUFBOzs7YUFFRCxTQUFZLFNBQUEsR0FBQTtFQUNWLE1BQUEsT0FBTyxJQUFLblAsQ0FBQUEsR0FBTCxDQUFTTSxPQUFULENBQWlCOE8sVUFBeEIsQ0FBQTtFQUNELEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OztFQUNFLElBQUEsS0FBQSxFQUFBLFNBQUEsV0FBQSxDQUFZcEIsS0FBWixFQUFpQztFQUFBLE1BQUEsSUFBQSxNQUFBLEdBQUEsSUFBQSxDQUFBOztRQUFBLElBQWRyTixPQUFjLHVFQUFKLEVBQUksQ0FBQTs7UUFDL0IsSUFBSSxJQUFBLENBQUt3TixTQUFMLEVBQUosRUFBc0I7RUFDcEIsUUFBQSxPQUFPTixPQUFPLENBQUNPLE1BQVIsQ0FBZSx5Q0FBZixDQUFQLENBQUE7RUFDRCxPQUFBOztRQUVELE9BQU8sSUFBQSxDQUFLaUIsUUFBTCxDQUFjckIsS0FBZCxFQUFxQnJOLE9BQXJCLENBQUEsQ0FBOEJrTyxJQUE5QixDQUFtQyxZQUFNO1VBQzlDLElBQU1TLEdBQUcsR0FBRyxNQUFJLENBQUNqQyxLQUFMLENBQVd0QixNQUFYLEdBQW9CLENBQWhDLENBQUE7O0VBQ0EsUUFBQSxNQUFJLENBQUNzQixLQUFMLENBQVdrQyxNQUFYLENBQWtCRCxHQUFsQixFQUF1QixDQUF2QixDQUFBLENBQUE7O0VBQ0EsUUFBQSxNQUFJLENBQUNwQixNQUFMLENBQVlxQixNQUFaLENBQW1CRCxHQUFuQixFQUF3QixDQUF4QixDQUFBLENBQUE7O0VBQ0EsUUFBQSxNQUFJLENBQUN0UCxHQUFMLENBQVNNLE9BQVQsQ0FBaUJrUCxPQUFqQixDQUF5QkMsZ0JBQXpCLENBQTBDLE1BQUksQ0FBQ3BDLEtBQUwsQ0FBV3RCLE1BQVgsR0FBb0IsQ0FBOUQsQ0FBQSxDQUFBOztFQUNBLFFBQUEsTUFBSSxDQUFDZ0MsV0FBTCxFQUFBLENBQUE7RUFDRCxPQU5NLENBQVAsQ0FBQTtFQU9ELEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OzthQUNFLFNBQXNCLE9BQUEsR0FBQTtFQUFBLE1BQUEsSUFBQSxNQUFBLEdBQUEsSUFBQSxDQUFBOztRQUFBLElBQWRwTixPQUFjLHVFQUFKLEVBQUksQ0FBQTs7UUFDcEIsSUFBSSxJQUFBLENBQUt3TixTQUFMLEVBQUosRUFBc0I7RUFDcEIsUUFBQSxPQUFPTixPQUFPLENBQUNPLE1BQVIsQ0FBZSx5Q0FBZixDQUFQLENBQUE7RUFDRCxPQUFBOztFQUVELE1BQUEsSUFBQSxDQUFLSyxlQUFMLEdBQXVCLElBQUEsQ0FBS1AsTUFBTCxDQUFZOU4sS0FBWixFQUF2QixDQUFBO0VBQ0EsTUFBQSxJQUFBLENBQUtzTyxjQUFMLEdBQXNCLElBQUtELENBQUFBLGVBQUwsQ0FBcUJyTyxLQUFyQixDQUEyQixDQUEzQixFQUE4QixLQUFLcU8sZUFBTCxDQUFxQjFDLE1BQXJCLEdBQThCLENBQTVELENBQXRCLENBQUE7O0VBRUEsTUFBQSxJQUFNNkMsTUFBTSxHQUFHLFNBQVRBLE1BQVMsR0FBTTtFQUNuQixRQUFBLE9BQU8sSUFBSWYsT0FBSixDQUFZLFVBQUNDLE9BQUQsRUFBYTtZQUM5QixNQUFJLENBQUNULEtBQUwsQ0FBV21CLEdBQVgsRUFBQSxDQUFBOztZQUNBLE1BQUksQ0FBQ04sTUFBTCxDQUFZTSxHQUFaLEVBQUEsQ0FBQTs7WUFFQW5NLDRCQUFRLENBQUNxTixTQUFULENBQW1CLFlBQU07RUFBRTtjQUN6QixNQUFJLENBQUMzQixXQUFMLENBQWlCRCxPQUFqQixDQUFBLENBQUE7YUFERixDQUFBLENBQUE7RUFHRCxTQVBNLENBQVAsQ0FBQTtTQURGLENBQUE7O1FBV0EsT0FBTyxJQUFBLENBQUs5TixHQUFMLENBQVNNLE9BQVQsQ0FBaUJ3TyxRQUFqQixDQUEwQm5PLE9BQTFCLEVBQW1DaU8sTUFBbkMsQ0FBUCxDQUFBO0VBQ0QsS0FBQTs7O0VBRUQsSUFBQSxLQUFBLEVBQUEsU0FBQSxtQkFBQSxDQUFvQnpPLEtBQXBCLEVBQTJCO0VBQ3pCLE1BQUEsSUFBSSxLQUFLa04sS0FBTCxDQUFXdEIsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtFQUN6QixRQUFBLElBQUEsQ0FBSzRELE9BQUwsRUFBQSxDQUFBO0VBQ0QsT0FGRCxNQUVPO0VBQ0x4UCxRQUFBQSxLQUFLLENBQUN5UCxpQkFBTixFQUFBLENBQUE7RUFDRCxPQUFBO0VBQ0YsS0FBQTs7O0VBRUQsSUFBQSxLQUFBLEVBQUEsU0FBQSxPQUFBLENBQVF6UCxLQUFSLEVBQWU7UUFDYixJQUFJQSxLQUFLLENBQUMwUCxNQUFOLEtBQWlCLEtBQUs3UCxHQUFMLENBQVNNLE9BQTlCLEVBQXVDO0VBQ3JDLFFBQUEsT0FBQTtFQUNELE9BQUE7O1FBRURILEtBQUssQ0FBQytOLE1BQU4sR0FBZTtVQUNiNEIsWUFBWSxFQUFFLElBQUtyQixDQUFBQSxlQUFMLENBQXFCLElBQUEsQ0FBS0EsZUFBTCxDQUFxQjFDLE1BQXJCLEdBQThCLENBQW5ELENBREQ7RUFFYm1DLFFBQUFBLE1BQU0sRUFBRSxJQUFLTyxDQUFBQSxlQUFBQTtTQUZmLENBQUE7RUFLQSxNQUFBLElBQUEsQ0FBS3JQLEtBQUwsQ0FBVzJRLFFBQVgsQ0FBb0I1UCxLQUFwQixDQUFBLENBQUE7RUFDRCxLQUFBOzs7RUFFRCxJQUFBLEtBQUEsRUFBQSxTQUFBLFFBQUEsQ0FBU0EsS0FBVCxFQUFnQjtRQUNkLElBQUlBLEtBQUssQ0FBQzBQLE1BQU4sS0FBaUIsS0FBSzdQLEdBQUwsQ0FBU00sT0FBOUIsRUFBdUM7RUFDckMsUUFBQSxPQUFBO0VBQ0QsT0FBQTs7UUFFREgsS0FBSyxDQUFDK04sTUFBTixHQUFlO1VBQ2I4QixXQUFXLEVBQUUsSUFBS3ZCLENBQUFBLGVBQUwsQ0FBcUIsSUFBQSxDQUFLQSxlQUFMLENBQXFCMUMsTUFBckIsR0FBOEIsQ0FBbkQsQ0FEQTtFQUVibUMsUUFBQUEsTUFBTSxFQUFFLElBQUtRLENBQUFBLGNBQUFBO1NBRmYsQ0FBQTtFQUtBLE1BQUEsSUFBQSxDQUFLdFAsS0FBTCxDQUFXNlEsU0FBWCxDQUFxQjlQLEtBQXJCLENBQUEsQ0FBQTtFQUNELEtBQUE7OztFQUVELElBQUEsS0FBQSxFQUFBLFNBQUEsUUFBQSxDQUFTQSxLQUFULEVBQWdCO1FBQ2QsSUFBSUEsS0FBSyxDQUFDMFAsTUFBTixLQUFpQixLQUFLN1AsR0FBTCxDQUFTTSxPQUE5QixFQUF1QztFQUNyQyxRQUFBLE9BQUE7RUFDRCxPQUFBOztRQUVESCxLQUFLLENBQUMrTixNQUFOLEdBQWU7VUFDYmdDLFlBQVksRUFBRSxJQUFLaEMsQ0FBQUEsTUFBTCxDQUFZLElBQUEsQ0FBS0EsTUFBTCxDQUFZbkMsTUFBWixHQUFxQixDQUFqQyxDQUREO0VBRWJtQyxRQUFBQSxNQUFNLEVBQUUsSUFBQSxDQUFLQSxNQUFMLENBQVk5TixLQUFaLENBQWtCLENBQWxCLEVBQXFCLElBQUs4TixDQUFBQSxNQUFMLENBQVluQyxNQUFaLEdBQXFCLENBQTFDLENBQUE7U0FGVixDQUFBO0VBS0EsTUFBQSxJQUFBLENBQUszTSxLQUFMLENBQVcrUSxTQUFYLENBQXFCaFEsS0FBckIsQ0FBQSxDQUFBO0VBQ0QsS0FBQTs7O0VBRUQsSUFBQSxLQUFBLEVBQUEsU0FBQSxTQUFBLENBQVVBLEtBQVYsRUFBaUI7UUFDZixJQUFJQSxLQUFLLENBQUMwUCxNQUFOLEtBQWlCLEtBQUs3UCxHQUFMLENBQVNNLE9BQTlCLEVBQXVDO0VBQ3JDLFFBQUEsT0FBQTtFQUNELE9BQUE7O1FBRURILEtBQUssQ0FBQytOLE1BQU4sR0FBZTtVQUNia0MsV0FBVyxFQUFFLElBQUtsQyxDQUFBQSxNQUFMLENBQVksSUFBQSxDQUFLQSxNQUFMLENBQVluQyxNQUFaLEdBQXFCLENBQWpDLENBREE7RUFFYm1DLFFBQUFBLE1BQU0sRUFBRSxJQUFLQSxDQUFBQSxNQUFBQTtTQUZmLENBQUE7RUFLQSxNQUFBLElBQUEsQ0FBSzlPLEtBQUwsQ0FBV2lSLFVBQVgsQ0FBc0JsUSxLQUF0QixDQUFBLENBQUE7RUFDRCxLQUFBOzs7YUFFRCxTQUFvQixpQkFBQSxHQUFBO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O0VBQ2xCLE1BQUEsSUFBTW1RLElBQUksR0FBRyxJQUFLdFEsQ0FBQUEsR0FBTCxDQUFTTSxPQUF0QixDQUFBO1FBQ0FnUSxJQUFJLENBQUNYLE9BQUwsR0FBZSxJQUFBLENBQUtBLE9BQUwsQ0FBYW5DLElBQWIsQ0FBa0IsSUFBbEIsQ0FBZixDQUFBO0VBRUE4QyxNQUFBQSxJQUFJLENBQUMvUCxnQkFBTCxDQUFzQixTQUF0QixFQUFpQyxLQUFLZ04sUUFBdEMsQ0FBQSxDQUFBO0VBQ0ErQyxNQUFBQSxJQUFJLENBQUMvUCxnQkFBTCxDQUFzQixVQUF0QixFQUFrQyxLQUFLa04sU0FBdkMsQ0FBQSxDQUFBO0VBQ0E2QyxNQUFBQSxJQUFJLENBQUMvUCxnQkFBTCxDQUFzQixRQUF0QixFQUFnQyxLQUFLbU4sT0FBckMsQ0FBQSxDQUFBO0VBQ0E0QyxNQUFBQSxJQUFJLENBQUMvUCxnQkFBTCxDQUFzQixTQUF0QixFQUFpQyxLQUFLb04sUUFBdEMsQ0FBQSxDQUFBO0VBRUEyQyxNQUFBQSxJQUFJLENBQUNDLFFBQUwsR0FBZ0IsSUFBS25SLENBQUFBLEtBQUwsQ0FBV29SLFFBQTNCLENBQUE7RUFDQUYsTUFBQUEsSUFBSSxDQUFDck0sa0JBQUwsR0FBMEIsSUFBQSxDQUFLN0UsS0FBTCxDQUFXNkUsa0JBQVgsSUFBaUMsSUFBQSxDQUFLd00sbUJBQUwsQ0FBeUJqRCxJQUF6QixDQUE4QixJQUE5QixDQUEzRCxDQUFBOztRQUVBLElBQUksSUFBQSxDQUFLcE8sS0FBTCxDQUFXc1IsWUFBWCxJQUEyQixJQUFLdFIsQ0FBQUEsS0FBTCxDQUFXdVIsaUJBQTFDLEVBQTZEO0VBQzNELFFBQUEsTUFBTSxJQUFJQyxLQUFKLENBQVUsNERBQVYsQ0FBTixDQUFBO0VBQ0QsT0FBQTs7RUFFRCxNQUFBLElBQUksSUFBS3hSLENBQUFBLEtBQUwsQ0FBV3NSLFlBQWYsRUFBNkI7RUFDM0IsUUFBQSxJQUFBLENBQUt4QyxNQUFMLEdBQWMsQ0FBQyxLQUFLOU8sS0FBTCxDQUFXc1IsWUFBWixDQUFkLENBQUE7RUFDRCxPQUZELE1BRU8sSUFBSSxJQUFBLENBQUt0UixLQUFMLENBQVd1UixpQkFBZixFQUFrQztFQUN2QyxRQUFBLElBQUEsQ0FBS3pDLE1BQUwsR0FBYyxJQUFLOU8sQ0FBQUEsS0FBTCxDQUFXdVIsaUJBQXpCLENBQUE7RUFDRCxPQUZNLE1BRUE7VUFDTCxJQUFLekMsQ0FBQUEsTUFBTCxHQUFjLEVBQWQsQ0FBQTtFQUNELE9BQUE7O1FBRUQsSUFBS2IsQ0FBQUEsS0FBTCxHQUFhLElBQUthLENBQUFBLE1BQUwsQ0FBWWpFLEdBQVosQ0FDWCxVQUFDK0QsS0FBRCxFQUFBO1VBQUEsT0FBVyxNQUFJLENBQUM1TyxLQUFMLENBQVc2UCxVQUFYLENBQXNCakIsS0FBdEIsRUFBNkIsTUFBN0IsQ0FBWCxDQUFBO0VBQUEsT0FEVyxDQUFiLENBQUE7RUFHQSxNQUFBLElBQUEsQ0FBS0QsV0FBTCxFQUFBLENBQUE7RUFDRCxLQUFBOzs7YUFFRCxTQUFxQixrQkFBQSxHQUFBO0VBQ25CLE1BQUEsSUFBSSxLQUFLM08sS0FBTCxDQUFXNkUsa0JBQVgsS0FBa0NuRSxTQUF0QyxFQUFpRDtVQUMvQyxJQUFLRSxDQUFBQSxHQUFMLENBQVNNLE9BQVQsQ0FBaUIyRCxrQkFBakIsR0FBc0MsSUFBQSxDQUFLN0UsS0FBTCxDQUFXNkUsa0JBQWpELENBQUE7RUFDRCxPQUFBO0VBQ0YsS0FBQTs7O2FBRUQsU0FBdUIsb0JBQUEsR0FBQTtFQUNyQixNQUFBLElBQU1xTSxJQUFJLEdBQUcsSUFBS3RRLENBQUFBLEdBQUwsQ0FBU00sT0FBdEIsQ0FBQTtRQUNBZ1EsSUFBSSxDQUFDN1AsbUJBQUwsQ0FBeUIsU0FBekIsRUFBb0MsSUFBS3JCLENBQUFBLEtBQUwsQ0FBVytRLFNBQS9DLENBQUEsQ0FBQTtRQUNBRyxJQUFJLENBQUM3UCxtQkFBTCxDQUF5QixVQUF6QixFQUFxQyxJQUFLckIsQ0FBQUEsS0FBTCxDQUFXaVIsVUFBaEQsQ0FBQSxDQUFBO1FBQ0FDLElBQUksQ0FBQzdQLG1CQUFMLENBQXlCLFFBQXpCLEVBQW1DLElBQUtyQixDQUFBQSxLQUFMLENBQVcyUSxRQUE5QyxDQUFBLENBQUE7UUFDQU8sSUFBSSxDQUFDN1AsbUJBQUwsQ0FBeUIsU0FBekIsRUFBb0MsSUFBS3JCLENBQUFBLEtBQUwsQ0FBVzZRLFNBQS9DLENBQUEsQ0FBQTtFQUNELEtBQUE7OzthQUVELFNBQVMsTUFBQSxHQUFBO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O0VBQ1AsTUFBQSxJQUFBLFdBQUEsR0FlSSxLQUFLN1EsS0FmVCxDQUFBO1lBQ0V3SCxRQURGLGVBQ0VBLFFBREYsQ0FBQTtZQUVFcUksVUFGRixlQUVFQSxVQUZGLENBQUE7d0JBS0UwQixpQkFMRixDQUFBO3dCQU1FRCxZQU5GLENBQUE7d0JBT0VQLFNBUEYsQ0FBQTt3QkFRRUUsVUFSRixDQUFBO3dCQVNFTixRQVRGLENBQUE7d0JBVUVFLFNBVkYsQ0FBQTt3QkFXRU8sUUFYRixDQUFBO3dCQVlFdk0sa0JBWkYsQ0FBQTtFQUFBLGNBY0tyQyxJQWRMLEdBQUEsd0JBQUEsQ0FBQSxXQUFBLEVBQUFDLFdBQUEsRUFBQTs7UUFpQkEsSUFBTXdMLEtBQUssR0FBRyxJQUFBLENBQUthLE1BQUwsR0FBYyxJQUFLQSxDQUFBQSxNQUFMLENBQVlqRSxHQUFaLENBQWdCLFVBQUMrRCxLQUFELEVBQUE7RUFBQSxRQUFBLE9BQVdpQixVQUFVLENBQUNqQixLQUFELEVBQVEsTUFBUixDQUFyQixDQUFBO1NBQWhCLENBQWQsR0FBb0UsSUFBbEYsQ0FBQTs7RUFFQSxNQUFBLElBQUlwSCxRQUFRLElBQUlBLFFBQVEsS0FBSyxJQUFBLENBQUs1RyxHQUFsQyxFQUF1QztVQUNyQyxJQUFLQSxDQUFBQSxHQUFMLEdBQVc0RyxRQUFYLENBQUE7RUFDRCxPQUFBOztFQUVELE1BQUEsb0JBQ0V0Rix3Q0FBQzBELFNBQUQsRUFBQSxRQUFBLENBQUE7RUFDRSxRQUFBLEdBQUcsRUFBRSxJQUFLaEYsQ0FBQUEsR0FBQUE7U0FDTjRCLEVBQUFBLElBRk4sQ0FJR3lMLEVBQUFBLEtBSkgsQ0FERixDQUFBO0VBUUQsS0FBQTs7OztFQTdVMEIvTCxDQUFBQSxDQUFBQSx5QkFBSyxDQUFDaUI7RUFnVm5DO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7O0FBQ01zTyxNQUFBQSxTQUFTLGdCQUFHdlAseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRWSxHQUFSLEVBQUE7RUFBQSxFQUFBLG9CQUNqQ3NCLHdDQUFDLGNBQUQsRUFBQSxRQUFBLENBQUE7RUFBZ0IsSUFBQSxRQUFRLEVBQUV0QixHQUFBQTtFQUExQixHQUFBLEVBQW1DWixLQUFuQyxDQUFBLEVBQTJDQSxLQUFLLENBQUN1QyxRQUFqRCxDQURpQyxDQUFBO0VBQUEsQ0FBakIsRUFBbEI7RUFJQWtQLFNBQVMsQ0FBQ2xPLFNBQVYsR0FBc0I7RUFDcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0VzTSxFQUFBQSxVQUFVLEVBQUVwTSw2QkFBUyxDQUFDRyxJQUFWLENBQWV5SixVQVZQOztFQVdwQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VrRSxpQkFBaUIsRUFBRTlOLDZCQUFTLENBQUMwSSxLQXRCVDs7RUF3QnBCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFbUYsWUFBWSxFQUFFN04sNkJBQVMsQ0FBQ2UsTUFwQ0o7O0VBc0NwQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V1TSxTQUFTLEVBQUV0Tiw2QkFBUyxDQUFDRyxJQTlDRDs7RUFnRHBCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFOLFVBQVUsRUFBRXhOLDZCQUFTLENBQUNHLElBeERGOztFQTBEcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStNLFFBQVEsRUFBRWxOLDZCQUFTLENBQUNHLElBakVBOztFQW1FcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaU4sU0FBUyxFQUFFcE4sNkJBQVMsQ0FBQ0csSUEzRUQ7O0VBNkVwQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFUSxTQUFTLEVBQUVYLDZCQUFTLENBQUNDLE1BdkZEOztFQXlGcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWEsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BaEdSOztFQWtHcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFbUMsRUFBQUEsU0FBUyxFQUFFbEQsNkJBQVMsQ0FBQytFLFNBQVYsQ0FBb0IsQ0FBQy9FLDZCQUFTLENBQUNJLElBQVgsRUFBaUJKLDZCQUFTLENBQUNDLE1BQTNCLENBQXBCLENBMUdTOztFQTRHcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFME4sUUFBUSxFQUFFM04sNkJBQVMsQ0FBQ0csSUFwSEE7O0VBcUhwQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpQixrQkFBa0IsRUFBRXBCLDZCQUFTLENBQUNHLElBQUFBO0VBN0hWLENBQXRCLENBQUE7O0VBZ0lBLElBQU04TixNQUFJLEdBQUcsU0FBUEEsSUFBTyxHQUFBO0VBQUEsRUFBQSxPQUFNLElBQU4sQ0FBQTtFQUFBLENBQWIsQ0FBQTs7RUFFQUQsU0FBUyxDQUFDckYsWUFBVixHQUF5QjtFQUN2QjZFLEVBQUFBLFVBQVUsRUFBRVMsTUFEVztFQUV2QlgsRUFBQUEsU0FBUyxFQUFFVyxNQUZZO0VBR3ZCZixFQUFBQSxRQUFRLEVBQUVlLE1BSGE7RUFJdkJiLEVBQUFBLFNBQVMsRUFBRWEsTUFBQUE7RUFKWSxDQUF6Qjs7RUM5ZUEsSUFBTXpSLFlBQVUsR0FBRztFQUNqQmdFLEVBQUFBLE1BQU0sRUFBRSxTQUFBO0VBRFMsQ0FBbkIsQ0FBQTtFQUlBLElBQU16QyxlQUFhLEdBQUcsQ0FBQyxvQkFBRCxDQUF0QixDQUFBO0VBRUE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7QUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ01tUSxNQUFBQSxLQUFLLEdBQUczUCxnQkFBZ0IsQ0FBQ29CLFVBQVUsQ0FBQyxXQUFELENBQVgsRUFBMEI7RUFBQ25ELEVBQUFBLFVBQVUsRUFBVkEsWUFBRDtFQUFhdUIsRUFBQUEsYUFBYSxFQUFiQSxlQUFBQTtFQUFiLENBQTFCLEVBQTlCO0VBRUFtUSxLQUFLLENBQUNwTyxTQUFOLEdBQWtCO0VBQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRWEsRUFBQUEsU0FBUyxFQUFFWCw2QkFBUyxDQUFDMkMsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxNQUFULEVBQWlCLE1BQWpCLENBQWhCLENBVEs7O0VBV2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFN0IsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BakJaOztFQW1CaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsU0FBUyxFQUFFaEIsNkJBQVMsQ0FBQ0csSUE3Qkw7O0VBK0JoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxVQUFVLEVBQUVqQiw2QkFBUyxDQUFDRyxJQXpDTjs7RUEyQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWUsU0FBUyxFQUFFbEIsNkJBQVMsQ0FBQ0csSUFuREw7O0VBcURoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnQixVQUFVLEVBQUVuQiw2QkFBUyxDQUFDRyxJQTdETjs7RUErRGhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFTixPQUFPLEVBQUVHLDZCQUFTLENBQUNJLElBckVIOztFQXVFaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VJLE1BQU0sRUFBRVIsNkJBQVMsQ0FBQ0ksSUE3RUY7O0VBK0VoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFZ0Isa0JBQWtCLEVBQUVwQiw2QkFBUyxDQUFDRyxJQUFBQTtFQXpGZCxDQUFsQjs7O0VDakNBLElBQU1wQyxlQUFhLEdBQUcsQ0FBQyxrQkFBRCxFQUFxQixvQkFBckIsQ0FBdEIsQ0FBQTtFQUNBLElBQU1vRSxTQUFPLEdBQUc1RCxnQkFBZ0IsQ0FBQyxVQUFELEVBQWE7RUFBQ1IsRUFBQUEsYUFBYSxFQUFiQSxlQUFBQTtFQUFELENBQWIsQ0FBaEMsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDTW9RLE1BQUFBLElBQUksZ0JBQUcxUCx5QkFBSyxDQUFDQyxVQUFOLENBQWlCLFVBQUNuQyxLQUFELEVBQVFZLEdBQVIsRUFBZ0I7RUFDNUMsRUFBQSxJQUNFaVIsYUFERixHQVFJN1IsS0FSSixDQUNFNlIsYUFERjtFQUFBLE1BRUVDLG1CQUZGLEdBUUk5UixLQVJKLENBRUU4UixtQkFGRjtFQUFBLE1BR0VDLFdBSEYsR0FRSS9SLEtBUkosQ0FHRStSLFdBSEY7RUFBQSxNQUlFQyxXQUpGLEdBUUloUyxLQVJKLENBSUVnUyxXQUpGO0VBQUEsTUFLRUMsWUFMRixHQVFJalMsS0FSSixDQUtFaVMsWUFMRjtFQUFBLE1BTUUxUCxRQU5GLEdBUUl2QyxLQVJKLENBTUV1QyxRQU5GO1FBT0tDLElBUEwsNEJBUUl4QyxLQVJKLEVBQUF5QyxXQUFBLENBQUEsQ0FBQTs7SUFVQSxvQkFDRVAseUJBQUEsQ0FBQSxhQUFBLENBQUMwRCxTQUFELEVBQUEsUUFBQSxDQUFBLEVBQUEsRUFDTXBELElBRE4sRUFBQTtFQUVFLElBQUEsR0FBRyxFQUFFNUIsR0FBQUE7RUFGUCxHQUFBLENBQUEsRUFJR2lSLGFBQWEsQ0FBQ2pSLEdBQUQsQ0FKaEIsZUFLRXNCLHlCQUFBLENBQUEsYUFBQSxDQUFBLEtBQUEsRUFBQTtFQUFLLElBQUEsU0FBUyxFQUFDLGtCQUFBO0VBQWYsR0FBQSxFQUFBLEdBQUEsQ0FMRixlQU1FQSx5QkFBQSxDQUFBLGFBQUEsQ0FBQSxLQUFBLEVBQUE7RUFBSyxJQUFBLFNBQVMsRUFBQyxlQUFmO0VBQStCLElBQUEsS0FBSyxFQUFFK1AsWUFBQUE7S0FDbkMxUCxFQUFBQSxRQURILENBTkYsZUFTRUwseUJBQUEsQ0FBQSxhQUFBLENBQUEsS0FBQSxFQUFBO0VBQUssSUFBQSxTQUFTLEVBQUMsYUFBZjtFQUE2QixJQUFBLEtBQUssRUFBRTtFQUFDZ1EsTUFBQUEsTUFBTSxFQUFFLEtBQUE7RUFBVCxLQUFBO0VBQXBDLEdBQUEsRUFDR0gsV0FBVyxDQUFDblIsR0FBRCxDQURkLENBVEYsRUFZR29SLFdBQVcsQ0FBQ3BSLEdBQUQsQ0FaZCxFQWFHa1IsbUJBQW1CLENBQUNsUixHQUFELENBYnRCLENBREYsQ0FBQTtFQWlCRCxDQTVCWSxFQUFiO0VBOEJBZ1IsSUFBSSxDQUFDck8sU0FBTCxHQUFpQjtFQUVmO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTBPLFlBQVksRUFBRXhPLDZCQUFTLENBQUNlLE1BVlQ7O0VBWWY7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VILFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFyQkw7O0VBdUJmO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFPLFdBQVcsRUFBRXRPLDZCQUFTLENBQUNHLElBL0JSOztFQWlDZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWlPLGFBQWEsRUFBRXBPLDZCQUFTLENBQUNHLElBMUNWOztFQTRDZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VrTyxtQkFBbUIsRUFBRXJPLDZCQUFTLENBQUNHLElBcERoQjs7RUFzRGY7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFb08sV0FBVyxFQUFFdk8sNkJBQVMsQ0FBQ0csSUE5RFI7O0VBZ0VmO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V1TyxNQUFNLEVBQUUxTyw2QkFBUyxDQUFDRyxJQTFFSDs7RUE0RWY7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXdPLE1BQU0sRUFBRTNPLDZCQUFTLENBQUNHLElBdEZIOztFQXdGZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeU8sTUFBTSxFQUFFNU8sNkJBQVMsQ0FBQ0csSUFsR0g7O0VBb0dmO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UwTyxnQkFBZ0IsRUFBRTdPLDZCQUFTLENBQUNHLElBOUdiOztFQWdIZjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaUIsa0JBQWtCLEVBQUVwQiw2QkFBUyxDQUFDRyxJQUFBQTtFQTFIZixDQUFqQixDQUFBOztFQTZIQSxJQUFNOE4sSUFBSSxHQUFHLFNBQVBBLElBQU8sR0FBQTtFQUFBLEVBQUEsT0FBTSxJQUFOLENBQUE7RUFBQSxDQUFiLENBQUE7O0VBRUFFLElBQUksQ0FBQ3hGLFlBQUwsR0FBb0I7RUFDbEJ5RixFQUFBQSxhQUFhLEVBQUVILElBREc7RUFFbEJJLEVBQUFBLG1CQUFtQixFQUFFSixJQUZIO0VBR2xCSyxFQUFBQSxXQUFXLEVBQUVMLElBSEs7RUFJbEJNLEVBQUFBLFdBQVcsRUFBRU4sSUFBQUE7RUFKSyxDQUFwQjs7O0VDcExBLElBQU16UixZQUFVLEdBQUc7RUFDakIrRCxFQUFBQSxRQUFRLEVBQUUsZ0JBRE87RUFFakJHLEVBQUFBLFVBQVUsRUFBRSxVQUZLO0VBR2pCRCxFQUFBQSxZQUFZLEVBQUUsWUFBQTtFQUhHLENBQW5CLENBQUE7RUFNQSxJQUFNMUMsZUFBYSxHQUFHLENBQUMsb0JBQUQsQ0FBdEIsQ0FBQTtFQUVBLElBQU0rUSxJQUFJLEdBQUd2USxnQkFBZ0IsQ0FBQ29CLFVBQVUsQ0FBQyxhQUFELENBQVgsRUFBNEI7RUFBQ25ELEVBQUFBLFVBQVUsRUFBVkEsWUFBRDtFQUFhdUIsRUFBQUEsYUFBYSxFQUFiQSxlQUFBQTtFQUFiLENBQTVCLENBQTdCLENBQUE7RUFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ01nUixNQUFBQSxPQUFPLGdCQUFHdFEseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRc00sWUFBUixFQUF5QjtFQUN4RCxFQUFBLElBQU9ySSxNQUFQLEdBQStDakUsS0FBL0MsQ0FBT2lFLE1BQVA7RUFBQSxNQUFld08sU0FBZixHQUErQ3pTLEtBQS9DLENBQWV5UyxTQUFmO0VBQUEsTUFBMEJsUSxRQUExQixHQUErQ3ZDLEtBQS9DLENBQTBCdUMsUUFBMUI7UUFBdUNDLElBQXZDLDRCQUErQ3hDLEtBQS9DLEVBQUF5QyxXQUFBLENBQUEsQ0FBQTs7RUFDQSxFQUFBLElBQU03QixHQUFHLEdBQUcwTCxZQUFZLElBQUlqSyxZQUFNLEVBQWxDLENBQUE7RUFFQXBCLEVBQUFBLGVBQVMsQ0FBQyxZQUFNO0VBQ2QsSUFBQSxJQUFJZ0QsTUFBTSxLQUFLckQsR0FBRyxDQUFDTSxPQUFKLENBQVlvQyxPQUEzQixFQUFvQztFQUNsQyxNQUFBLElBQUlXLE1BQUosRUFBWTtFQUNWLFFBQUEsSUFBSXdNLE1BQU0sR0FBR2dDLFNBQVMsRUFBdEIsQ0FEVTs7RUFJVixRQUFBLElBQU1DLFNBQVMsR0FBRyxTQUFaQSxTQUFZLENBQUExTSxDQUFDLEVBQUE7RUFBQSxVQUFBLE9BQUlBLENBQUMsWUFBWUosT0FBYixJQUF3QkksQ0FBQyxZQUFZMk0sWUFBekMsQ0FBQTtXQUFuQixDQUFBOztVQUNBLElBQUksQ0FBQ0QsU0FBUyxDQUFDakMsTUFBRCxDQUFWLElBQXNCQSxNQUFNLENBQUN2UCxPQUFqQyxFQUEwQztZQUN4Q3VQLE1BQU0sR0FBR0EsTUFBTSxDQUFDdlAsT0FBaEIsQ0FBQTtFQUNELFNBQUE7O0VBRUROLFFBQUFBLEdBQUcsQ0FBQ00sT0FBSixDQUFZMFIsSUFBWixDQUFpQjtFQUFDbkMsVUFBQUEsTUFBTSxFQUFOQSxNQUFBQTtXQUFsQixDQUFBLENBQUE7RUFDRCxPQVZELE1BVU87VUFDTDdQLEdBQUcsQ0FBQ00sT0FBSixDQUFZMlIsSUFBWixFQUFBLENBQUE7RUFDRCxPQUFBO0VBQ0YsS0FBQTtFQUNGLEdBaEJRLENBQVQsQ0FBQTtFQWtCQSxFQUFBLG9CQUNFM1Esd0NBQUMsSUFBRCxFQUFBLFFBQUEsQ0FBQTtFQUNFLElBQUEsR0FBRyxFQUFFdEIsR0FBQUE7S0FDRDRCLEVBQUFBLElBRk4sQ0FJR0QsRUFBQUEsUUFKSCxDQURGLENBQUE7RUFRRCxDQTlCZSxFQUFoQjtFQWdDQWlRLE9BQU8sQ0FBQ2pQLFNBQVIsR0FBb0I7RUFDbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRWtQLEVBQUFBLFNBQVMsRUFBRWhQLDZCQUFTLENBQUNHLElBQVYsQ0FBZXlKLFVBWFI7O0VBYWxCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UxSixjQUFjLEVBQUVGLDZCQUFTLENBQUNHLElBdkJSOztFQXlCbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUksUUFBUSxFQUFFUCw2QkFBUyxDQUFDRyxJQW5DRjs7RUFxQ2xCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0VLLEVBQUFBLE1BQU0sRUFBRVIsNkJBQVMsQ0FBQ0ksSUFBVixDQUFld0osVUEvQ0w7O0VBaURsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V2SixVQUFVLEVBQUVMLDZCQUFTLENBQUNJLElBNURKOztFQThEbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUssWUFBWSxFQUFFVCw2QkFBUyxDQUFDSSxJQXhFTjs7RUEwRWxCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VFLFFBQVEsRUFBRU4sNkJBQVMsQ0FBQ0ksSUFwRkY7O0VBc0ZsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFTSxVQUFVLEVBQUVWLDZCQUFTLENBQUNJLElBaEdKOztFQWtHbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRU8sU0FBUyxFQUFFWCw2QkFBUyxDQUFDQyxNQTVHSDs7RUE4R2xCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVcsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQXRIRjs7RUF3SGxCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVksU0FBUyxFQUFFYiw2QkFBUyxDQUFDQyxNQWhJSDs7RUFrSWxCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWEsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BMUlWOztFQTRJbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsU0FBUyxFQUFFaEIsNkJBQVMsQ0FBQ0csSUF0Skg7O0VBd0psQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxVQUFVLEVBQUVqQiw2QkFBUyxDQUFDRyxJQWxLSjs7RUFvS2xCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWUsU0FBUyxFQUFFbEIsNkJBQVMsQ0FBQ0csSUE1S0g7O0VBOEtsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnQixVQUFVLEVBQUVuQiw2QkFBUyxDQUFDRyxJQXRMSjs7RUF3TGxCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpQixrQkFBa0IsRUFBRXBCLDZCQUFTLENBQUNHLElBQUFBO0VBbE1aLENBQXBCOztFQzFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU1rUCxXQUFXLEdBQUc5USxnQkFBZ0IsQ0FBQyxrQkFBRCxFQUFwQztFQUVBOFEsV0FBVyxDQUFDdlAsU0FBWixHQUF3QjtFQUN0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFURTs7RUFXdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VoQyxLQUFLLEVBQUUrQiw2QkFBUyxDQUFDaUQsTUFwQks7O0VBc0J0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFNLGNBQWMsRUFBRXRQLDZCQUFTLENBQUNpRCxNQS9CSjs7RUFpQ3RCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzTSxhQUFhLEVBQUV2UCw2QkFBUyxDQUFDSSxJQUFBQTtFQXhDSCxDQUF4Qjs7RUNiQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTW9QLGdCQUFnQixHQUFHalIsZ0JBQWdCLENBQUMsdUJBQUQsRUFBekM7RUFFQWlSLGdCQUFnQixDQUFDMVAsU0FBakIsR0FBNkI7RUFDM0I7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVE87O0VBVzNCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFaEMsS0FBSyxFQUFFK0IsNkJBQVMsQ0FBQ2lELE1BcEJVOztFQXNCM0I7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VxTSxjQUFjLEVBQUV0UCw2QkFBUyxDQUFDaUQsTUEvQkM7O0VBaUMzQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFc00sYUFBYSxFQUFFdlAsNkJBQVMsQ0FBQ0ksSUFBQUE7RUF4Q0UsQ0FBN0I7O0VDZEEsSUFBTTVELFlBQVUsR0FBRztFQUNqQmlULEVBQUFBLE1BQU0sRUFBRSxVQURTO0VBRWpCNUssRUFBQUEsUUFBUSxFQUFFLGVBQUE7RUFGTyxDQUFuQixDQUFBO0VBS0EsSUFBTTlHLGVBQWEsR0FBRyxDQUFDLFVBQUQsQ0FBdEIsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0FBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNMlIsUUFBUSxHQUFHblIsZ0JBQWdCLENBQUMsZUFBRCxFQUFrQjtFQUFDL0IsRUFBQUEsVUFBVSxFQUFWQSxZQUFEO0VBQWF1QixFQUFBQSxhQUFhLEVBQWJBLGVBQUFBO0VBQWIsQ0FBbEIsRUFBakM7RUFFQTJSLFFBQVEsQ0FBQzVQLFNBQVQsR0FBcUI7RUFDbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFNlAsYUFBYSxFQUFFM1AsNkJBQVMsQ0FBQ0csSUFUTjs7RUFXbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMEUsUUFBUSxFQUFFN0UsNkJBQVMsQ0FBQ0csSUFuQkQ7O0VBcUJuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V5UCxRQUFRLEVBQUU1UCw2QkFBUyxDQUFDRyxJQTdCRDs7RUErQm5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXNQLE1BQU0sRUFBRXpQLDZCQUFTLENBQUNHLElBdkNDOztFQXlDbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMFAsTUFBTSxFQUFFN1AsNkJBQVMsQ0FBQ0csSUFqREM7O0VBbURuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFRyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBMUREOztFQTREbkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTBQLE1BQU0sRUFBRTlQLDZCQUFTLENBQUNpRCxNQW5FQzs7RUFxRW5CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0U4TSxlQUFlLEVBQUUvUCw2QkFBUyxDQUFDaUQsTUE1RVI7O0VBOEVuQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFK00sWUFBWSxFQUFFaFEsNkJBQVMsQ0FBQ0ksSUFBQUE7RUFyRkwsQ0FBckI7O0VDckNBLElBQU0xRCxTQUFPLEdBQ1JzSCxjQUFBQSxDQUFBQSxFQUFBQSxFQUFBQSxXQURRLENBQWIsQ0FBQTs7RUFJQSxJQUFNVSxvQkFBa0IsR0FBRyxTQUFyQkEsa0JBQXFCLENBQUFDLFNBQVMsRUFBQTtFQUFBLEVBQUEsT0FBSWhCLFdBQVcsQ0FBQ2dCLFNBQUQsRUFBWSxnQkFBWixFQUE4QixTQUE5QixDQUFmLENBQUE7RUFBQSxDQUFwQyxDQUFBO0VBRUE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7OztBQUNBLE1BQU1zTCxLQUFLLEdBQUd2TCxvQkFBa0IsQ0FBQ25HLGdCQUFnQixDQUFDLFdBQUQsRUFBYztFQUFDL0IsRUFBQUEsVUFBVSxFQUFFRSxTQUFBQTtFQUFiLENBQWQsQ0FBakIsRUFBaEM7RUFFQXVULEtBQUssQ0FBQ25RLFNBQU4sR0FBa0I7RUFDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW9RLElBQUksRUFBRWxRLDZCQUFTLENBQUNDLE1BUkE7O0VBVWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVcsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQWxCSjs7RUFvQmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBN0JKOztFQStCaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXlFLFFBQVEsRUFBRTdFLDZCQUFTLENBQUNHLElBdENKOztFQXdDaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRWxDLEVBQUFBLEtBQUssRUFBRStCLDZCQUFTLENBQUMrRSxTQUFWLENBQW9CLENBQ3pCL0UsNkJBQVMsQ0FBQ0MsTUFEZSxFQUV6QkQsNkJBQVMsQ0FBQ2dGLFVBQVYsQ0FBcUJDLElBQXJCLENBRnlCLENBQXBCLENBL0NTOztFQW9EaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsT0FBTyxFQUFFbEYsNkJBQVMsQ0FBQ0ksSUEzREg7O0VBNkRoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFK0UsY0FBYyxFQUFFbkYsNkJBQVMsQ0FBQ0ksSUFwRVY7O0VBc0VoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFZ0YsT0FBTyxFQUFFcEYsNkJBQVMsQ0FBQ0MsTUFBQUE7RUE3RUgsQ0FBbEI7O0VDeEJBLElBQU12RCxTQUFPLEdBQ1JzSCxjQUFBQSxDQUFBQSxFQUFBQSxFQUFBQSxXQURRLENBQWIsQ0FBQTs7RUFJQSxJQUFNOEQsa0JBQWdCLEdBQUcsU0FBbkJBLGdCQUFtQixDQUFBbkQsU0FBUyxFQUFBO0VBQUEsRUFBQSxPQUFJaEIsV0FBVyxDQUFDZ0IsU0FBRCxFQUFZLGNBQVosRUFBNEIsT0FBNUIsQ0FBZixDQUFBO0VBQUEsQ0FBbEMsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7O0FBQ0EsTUFBTXdMLEtBQUssR0FBR3JJLGtCQUFnQixDQUFDdkosZ0JBQWdCLENBQUMsV0FBRCxFQUFjO0VBQUMvQixFQUFBQSxVQUFVLEVBQUVFLFNBQUFBO0VBQWIsQ0FBZCxDQUFqQixFQUE5QjtFQUVBeVQsS0FBSyxDQUFDclEsU0FBTixHQUFrQjtFQUNoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFUSjs7RUFXaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTRFLFFBQVEsRUFBRTdFLDZCQUFTLENBQUNHLElBbEJKOztFQW9CaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTJFLE9BQU8sRUFBRTlFLDZCQUFTLENBQUNHLElBM0JIOztFQTZCaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VsQyxLQUFLLEVBQUUrQiw2QkFBUyxDQUFDaUQsTUF0Q0Q7O0VBd0NoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStFLFlBQVksRUFBRWhJLDZCQUFTLENBQUNpRCxNQWpEUjs7RUFtRGhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UzQyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBQUFBO0VBMURKLENBQWxCOztFQ3pCQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU1nUSxNQUFNLEdBQUc3UixnQkFBZ0IsQ0FBQyxZQUFELEVBQS9CO0VBRUE2UixNQUFNLENBQUN0USxTQUFQLEdBQW1CO0VBQ2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXVRLEtBQUssRUFBRXJRLDZCQUFTLENBQUNDLE1BVEE7O0VBV2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVcsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQW5CSDs7RUFxQmpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFRLFVBQVUsRUFBRXRRLDZCQUFTLENBQUNDLE1BN0JMOztFQStCakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFdUgsSUFBSSxFQUFFeEgsNkJBQVMsQ0FBQ0MsTUF2Q0M7O0VBeUNqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzUSxNQUFNLEVBQUV2USw2QkFBUyxDQUFDSSxJQWpERDs7RUFtRGpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFRSxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBQUFBO0VBNURILENBQW5COzs7RUNkQSxJQUFNK0IsU0FBTyxHQUFHNUQsZ0JBQWdCLENBQUMsZUFBRCxDQUFoQyxDQUFBOztNQUVNaVM7Ozs7O0lBQ0osU0FBcUIsb0JBQUEsR0FBQTtFQUFBLElBQUEsSUFBQSxLQUFBLENBQUE7O0VBQUEsSUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLG9CQUFBLENBQUEsQ0FBQTs7RUFBQSxJQUFBLEtBQUEsSUFBQSxJQUFBLEdBQUEsU0FBQSxDQUFBLE1BQUEsRUFBTmpHLElBQU0sR0FBQSxJQUFBLEtBQUEsQ0FBQSxJQUFBLENBQUEsRUFBQSxJQUFBLEdBQUEsQ0FBQSxFQUFBLElBQUEsR0FBQSxJQUFBLEVBQUEsSUFBQSxFQUFBLEVBQUE7UUFBTkEsSUFBTSxDQUFBLElBQUEsQ0FBQSxHQUFBLFNBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQTtFQUFBLEtBQUE7O0VBQ25CLElBQUEsS0FBQSxHQUFBLE1BQUEsQ0FBQSxJQUFBLENBQUEsS0FBQSxDQUFBLE1BQUEsRUFBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBU0EsSUFBVCxDQUFBLENBQUEsQ0FBQTtNQUVBLEtBQUtrRyxDQUFBQSxZQUFMLEdBQW9CLEtBQXBCLENBQUE7O01BRUEsSUFBTTVPLFFBQVEsR0FBRyxTQUFYQSxRQUFXLENBQUNxTyxJQUFELEVBQU81UyxLQUFQLEVBQWlCO0VBQ2hDLE1BQUEsSUFBSSxLQUFLZixDQUFBQSxLQUFMLENBQVcyVCxJQUFYLENBQUosRUFBc0I7RUFDcEIsUUFBQSxPQUFPLE1BQUszVCxLQUFMLENBQVcyVCxJQUFYLENBQUEsQ0FBaUI1UyxLQUFqQixDQUFQLENBQUE7RUFDRCxPQUFBO09BSEgsQ0FBQTs7RUFLQSxJQUFBLEtBQUEsQ0FBS2dRLFNBQUwsR0FBaUJ6TCxRQUFRLENBQUM4SSxJQUFULENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBb0IsV0FBcEIsQ0FBakIsQ0FBQTtFQUNBLElBQUEsS0FBQSxDQUFLNkMsVUFBTCxHQUFrQjNMLFFBQVEsQ0FBQzhJLElBQVQsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFvQixZQUFwQixDQUFsQixDQUFBO0VBQ0EsSUFBQSxLQUFBLENBQUt1QyxRQUFMLEdBQWdCckwsUUFBUSxDQUFDOEksSUFBVCxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQW9CLFVBQXBCLENBQWhCLENBQUE7RUFDQSxJQUFBLEtBQUEsQ0FBS3lDLFNBQUwsR0FBaUJ2TCxRQUFRLENBQUM4SSxJQUFULENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBb0IsV0FBcEIsQ0FBakIsQ0FBQTtFQUVBLElBQUEsS0FBQSxDQUFLeE4sR0FBTCxnQkFBV3NCLHlCQUFLLENBQUNxRixTQUFOLEVBQVgsQ0FBQTtFQUVBLElBQUEsS0FBQSxDQUFLMkcsS0FBTCxHQUFhO0VBQ1hpRyxNQUFBQSxhQUFhLEVBQUUsRUFBQTtPQURqQixDQUFBO0VBakJtQixJQUFBLE9BQUEsS0FBQSxDQUFBO0VBb0JwQixHQUFBOzs7O0VBRUQsSUFBQSxLQUFBLEVBQUEsU0FBQSxNQUFBLENBQU9DLEVBQVAsRUFBVztRQUNULElBQUksQ0FBQyxJQUFLRixDQUFBQSxZQUFWLEVBQXdCO0VBQ3RCLFFBQUEsSUFBQSxDQUFLRyxRQUFMLENBQWMsRUFBZCxFQUFrQkQsRUFBbEIsQ0FBQSxDQUFBO0VBQ0QsT0FBQTtFQUNGLEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OztFQUNFLElBQUEsS0FBQSxFQUFBLFNBQUEsY0FBQSxDQUFldEYsTUFBZixFQUFxQztFQUFBLE1BQUEsSUFBQSxNQUFBLEdBQUEsSUFBQSxDQUFBOztRQUFBLElBQWR2TixPQUFjLHVFQUFKLEVBQUksQ0FBQTs7UUFDbkMsSUFBSSxJQUFBLENBQUt3TixTQUFMLEVBQUosRUFBc0I7RUFDcEIsUUFBQSxPQUFBO0VBQ0QsT0FBQTs7RUFFRCxNQUFBLElBQU1TLE1BQU0sR0FBRyxTQUFUQSxNQUFTLEdBQU07RUFDbkIsUUFBQSxPQUFPLElBQUlmLE9BQUosQ0FBWSxVQUFBQyxPQUFPLEVBQUk7WUFDNUIsTUFBSSxDQUFDMkYsUUFBTCxDQUFjO0VBQUNGLFlBQUFBLGFBQWEsRUFBTSxFQUFBLENBQUEsTUFBQSxDQUFBLGtCQUFBLENBQUEsTUFBSSxDQUFDakcsS0FBTCxDQUFXaUcsYUFBakIsQ0FBQSxFQUFBLENBQWdDckYsTUFBTSxDQUFDQSxNQUFNLENBQUNuQyxNQUFQLEdBQWdCLENBQWpCLENBQXRDLENBQUEsQ0FBQTtFQUFkLFdBQWQsRUFBeUYrQixPQUF6RixDQUFBLENBQUE7RUFDRCxTQUZNLENBQVAsQ0FBQTtTQURGLENBQUE7O0VBTUEsTUFBQSxPQUFPLElBQUs5TixDQUFBQSxHQUFMLENBQVNNLE9BQVQsQ0FBaUI0TyxTQUFqQixDQUEyQnZPLE9BQTNCLEVBQW9DaU8sTUFBcEMsQ0FDSkMsQ0FBQUEsSUFESSxDQUNDLFlBQU07VUFDVixNQUFJLENBQUM0RSxRQUFMLENBQWM7RUFBQ0YsVUFBQUEsYUFBYSxxQkFBTXJGLE1BQU4sQ0FBQTtXQUE1QixDQUFBLENBQUE7RUFDRCxPQUhJLENBQVAsQ0FBQTtFQUlELEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OztFQUNFLElBQUEsS0FBQSxFQUFBLFNBQUEsUUFBQSxDQUFTRixLQUFULEVBQThCO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O1FBQUEsSUFBZHJOLE9BQWMsdUVBQUosRUFBSSxDQUFBOztRQUM1QixJQUFJLElBQUEsQ0FBS3dOLFNBQUwsRUFBSixFQUFzQjtFQUNwQixRQUFBLE9BQUE7RUFDRCxPQUFBOztFQUVELE1BQUEsSUFBTVMsTUFBTSxHQUFHLFNBQVRBLE1BQVMsR0FBTTtFQUNuQixRQUFBLE9BQU8sSUFBSWYsT0FBSixDQUFZLFVBQUFDLE9BQU8sRUFBSTtZQUM1QixNQUFJLENBQUMyRixRQUFMLENBQWM7RUFBQ0YsWUFBQUEsYUFBYSwrQkFBTSxNQUFJLENBQUNqRyxLQUFMLENBQVdpRyxhQUFqQixJQUFnQ3ZGLEtBQWhDLENBQUEsQ0FBQTtFQUFkLFdBQWQsRUFBcUVGLE9BQXJFLENBQUEsQ0FBQTtFQUNELFNBRk0sQ0FBUCxDQUFBO1NBREYsQ0FBQTs7UUFNQSxPQUFPLElBQUEsQ0FBSzlOLEdBQUwsQ0FBU00sT0FBVCxDQUFpQjRPLFNBQWpCLENBQTJCdk8sT0FBM0IsRUFBb0NpTyxNQUFwQyxDQUFQLENBQUE7RUFDRCxLQUFBOzs7YUFFRCxTQUFZLFNBQUEsR0FBQTtFQUNWLE1BQUEsT0FBTyxJQUFLNU8sQ0FBQUEsR0FBTCxDQUFTTSxPQUFULENBQWlCOE8sVUFBeEIsQ0FBQTtFQUNELEtBQUE7RUFFRDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7OztFQUNFLElBQUEsS0FBQSxFQUFBLFNBQUEsV0FBQSxDQUFZcEIsS0FBWixFQUFpQztFQUFBLE1BQUEsSUFBQSxNQUFBLEdBQUEsSUFBQSxDQUFBOztRQUFBLElBQWRyTixPQUFjLHVFQUFKLEVBQUksQ0FBQTs7UUFDL0IsSUFBSSxJQUFBLENBQUt3TixTQUFMLEVBQUosRUFBc0I7RUFDcEIsUUFBQSxPQUFBO0VBQ0QsT0FBQTs7RUFFRCxNQUFBLElBQU1TLE1BQU0sR0FBRyxTQUFUQSxNQUFTLEdBQU07RUFDbkIsUUFBQSxPQUFPLElBQUlmLE9BQUosQ0FBWSxVQUFBQyxPQUFPLEVBQUk7WUFDNUIsTUFBSSxDQUFDMkYsUUFBTCxDQUFjO0VBQUNGLFlBQUFBLGFBQWEsK0JBQU0sTUFBSSxDQUFDakcsS0FBTCxDQUFXaUcsYUFBakIsSUFBZ0N2RixLQUFoQyxDQUFBLENBQUE7RUFBZCxXQUFkLEVBQXFFRixPQUFyRSxDQUFBLENBQUE7RUFDRCxTQUZNLENBQVAsQ0FBQTtTQURGLENBQUE7O0VBTUEsTUFBQSxPQUFPLElBQUs5TixDQUFBQSxHQUFMLENBQVNNLE9BQVQsQ0FBaUI0TyxTQUFqQixDQUEyQnZPLE9BQTNCLEVBQW9DaU8sTUFBcEMsQ0FDSkMsQ0FBQUEsSUFESSxDQUNDLFlBQU07VUFDVixNQUFJLENBQUM0RSxRQUFMLENBQWM7RUFBQ0YsVUFBQUEsYUFBYSxFQUFNLEVBQUEsQ0FBQSxNQUFBLENBQUEsa0JBQUEsQ0FBQSxNQUFJLENBQUNqRyxLQUFMLENBQVdpRyxhQUFYLENBQXlCblQsS0FBekIsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBQyxDQUFuQyxDQUFOLElBQTZDNE4sS0FBN0MsQ0FBQSxDQUFBO1dBQTVCLENBQUEsQ0FBQTtFQUNELE9BSEksQ0FBUCxDQUFBO0VBSUQsS0FBQTtFQUVEO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOzs7O2FBQ0UsU0FBc0IsT0FBQSxHQUFBO0VBQUEsTUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O1FBQUEsSUFBZHJOLE9BQWMsdUVBQUosRUFBSSxDQUFBOztRQUNwQixJQUFJLElBQUEsQ0FBS3dOLFNBQUwsRUFBSixFQUFzQjtFQUNwQixRQUFBLE9BQUE7RUFDRCxPQUFBOztFQUVELE1BQUEsSUFBTVMsTUFBTSxHQUFHLFNBQVRBLE1BQVMsR0FBTTtFQUNuQixRQUFBLE9BQU8sSUFBSWYsT0FBSixDQUFZLFVBQUFDLE9BQU8sRUFBSTtZQUM1QnpMLDRCQUFRLENBQUNxTixTQUFULENBQW1CLFlBQU07RUFBRTtjQUN6QixNQUFJLENBQUMrRCxRQUFMLENBQWM7RUFBQ0YsY0FBQUEsYUFBYSxFQUFFLE1BQUksQ0FBQ2pHLEtBQUwsQ0FBV2lHLGFBQVgsQ0FBeUJuVCxLQUF6QixDQUErQixDQUEvQixFQUFrQyxDQUFDLENBQW5DLENBQUE7RUFBaEIsYUFBZCxFQUFzRTBOLE9BQXRFLENBQUEsQ0FBQTthQURGLENBQUEsQ0FBQTtFQUdELFNBSk0sQ0FBUCxDQUFBO1NBREYsQ0FBQTs7UUFRQSxPQUFPLElBQUEsQ0FBSzlOLEdBQUwsQ0FBU00sT0FBVCxDQUFpQndPLFFBQWpCLENBQTBCbk8sT0FBMUIsRUFBbUNpTyxNQUFuQyxDQUFQLENBQUE7RUFDRCxLQUFBOzs7RUFFRCxJQUFBLEtBQUEsRUFBQSxTQUFBLG1CQUFBLENBQW9Cek8sS0FBcEIsRUFBMkI7UUFDekIsSUFBSSxJQUFBLENBQUtmLEtBQUwsQ0FBV3NVLFdBQVgsQ0FBdUJDLFVBQXZCLENBQWtDNUgsTUFBbEMsR0FBMkMsQ0FBL0MsRUFBa0Q7RUFDaEQsUUFBQSxJQUFBLENBQUs0RCxPQUFMLEVBQUEsQ0FBQTtFQUNELE9BRkQsTUFFTztFQUNMeFAsUUFBQUEsS0FBSyxDQUFDeVAsaUJBQU4sRUFBQSxDQUFBO0VBQ0QsT0FBQTtFQUNGLEtBQUE7OzthQUVELFNBQW9CLGlCQUFBLEdBQUE7RUFDbEIsTUFBQSxJQUFNVSxJQUFJLEdBQUcsSUFBS3RRLENBQUFBLEdBQUwsQ0FBU00sT0FBdEIsQ0FBQTtRQUVBLElBQUtnVCxDQUFBQSxZQUFMLEdBQW9CLEtBQXBCLENBQUE7RUFFQWhELE1BQUFBLElBQUksQ0FBQy9QLGdCQUFMLENBQXNCLFNBQXRCLEVBQWlDLEtBQUs0UCxTQUF0QyxDQUFBLENBQUE7RUFDQUcsTUFBQUEsSUFBSSxDQUFDL1AsZ0JBQUwsQ0FBc0IsVUFBdEIsRUFBa0MsS0FBSzhQLFVBQXZDLENBQUEsQ0FBQTtFQUNBQyxNQUFBQSxJQUFJLENBQUMvUCxnQkFBTCxDQUFzQixRQUF0QixFQUFnQyxLQUFLd1AsUUFBckMsQ0FBQSxDQUFBO0VBQ0FPLE1BQUFBLElBQUksQ0FBQy9QLGdCQUFMLENBQXNCLFNBQXRCLEVBQWlDLEtBQUswUCxTQUF0QyxDQUFBLENBQUE7O0VBRUEsTUFBQSxJQUFJLENBQUMsSUFBQSxDQUFLN1EsS0FBTCxDQUFXc1UsV0FBaEIsRUFBNkI7RUFDM0IsUUFBQSxNQUFNLElBQUk5QyxLQUFKLENBQVUsNkRBQVYsQ0FBTixDQUFBO0VBQ0QsT0FBQTs7RUFFRE4sTUFBQUEsSUFBSSxDQUFDQyxRQUFMLEdBQWdCLElBQUtuUixDQUFBQSxLQUFMLENBQVdvUixRQUEzQixDQUFBO0VBQ0FGLE1BQUFBLElBQUksQ0FBQ3JNLGtCQUFMLEdBQTBCLElBQUEsQ0FBSzdFLEtBQUwsQ0FBVzZFLGtCQUFYLElBQWlDLElBQUEsQ0FBS3dNLG1CQUFMLENBQXlCakQsSUFBekIsQ0FBOEIsSUFBOUIsQ0FBM0QsQ0FBQTtFQUVBLE1BQUEsSUFBQSxDQUFLaUcsUUFBTCxDQUFjO0VBQUNGLFFBQUFBLGFBQWEsRUFBRSxJQUFBLENBQUtuVSxLQUFMLENBQVdzVSxXQUFYLENBQXVCQyxVQUFBQTtTQUFyRCxDQUFBLENBQUE7RUFDRCxLQUFBOzs7YUFFRCxTQUF1QixvQkFBQSxHQUFBO0VBQ3JCLE1BQUEsSUFBTXJELElBQUksR0FBRyxJQUFLdFEsQ0FBQUEsR0FBTCxDQUFTTSxPQUF0QixDQUFBO0VBQ0FnUSxNQUFBQSxJQUFJLENBQUM3UCxtQkFBTCxDQUF5QixTQUF6QixFQUFvQyxLQUFLMFAsU0FBekMsQ0FBQSxDQUFBO0VBQ0FHLE1BQUFBLElBQUksQ0FBQzdQLG1CQUFMLENBQXlCLFVBQXpCLEVBQXFDLEtBQUs0UCxVQUExQyxDQUFBLENBQUE7RUFDQUMsTUFBQUEsSUFBSSxDQUFDN1AsbUJBQUwsQ0FBeUIsUUFBekIsRUFBbUMsS0FBS3NQLFFBQXhDLENBQUEsQ0FBQTtFQUNBTyxNQUFBQSxJQUFJLENBQUM3UCxtQkFBTCxDQUF5QixTQUF6QixFQUFvQyxLQUFLd1AsU0FBekMsQ0FBQSxDQUFBO1FBQ0EsSUFBS3FELENBQUFBLFlBQUwsR0FBb0IsSUFBcEIsQ0FBQTtFQUNELEtBQUE7OztFQUVELElBQUEsS0FBQSxFQUFBLFNBQUEsa0JBQUEsQ0FBbUJNLFNBQW5CLEVBQThCO0VBQzVCLE1BQUEsSUFBSSxLQUFLeFUsS0FBTCxDQUFXNkUsa0JBQVgsS0FBa0NuRSxTQUF0QyxFQUFpRDtVQUMvQyxJQUFLRSxDQUFBQSxHQUFMLENBQVNNLE9BQVQsQ0FBaUIyRCxrQkFBakIsR0FBc0MsSUFBQSxDQUFLN0UsS0FBTCxDQUFXNkUsa0JBQWpELENBQUE7RUFDRCxPQUFBOztRQUVELElBQU00UCxZQUFZLHNCQUFPLElBQUt6VSxDQUFBQSxLQUFMLENBQVdzVSxXQUFYLENBQXVCRyxZQUE5QixDQUFsQixDQUFBO0VBRUE7RUFDSjtFQUNBOzs7RUFDSSxNQUFBLElBQUlELFNBQVMsQ0FBQ0YsV0FBVixDQUFzQkcsWUFBdEIsQ0FBbUM5SCxNQUFuQyxHQUE0QyxJQUFBLENBQUszTSxLQUFMLENBQVdzVSxXQUFYLENBQXVCRyxZQUF2QixDQUFvQzlILE1BQWhGLElBQ0Y2SCxTQUFTLENBQUNGLFdBQVYsQ0FBc0JDLFVBQXRCLENBQWlDNUgsTUFBakMsR0FBMEMsSUFBSzNNLENBQUFBLEtBQUwsQ0FBV3NVLFdBQVgsQ0FBdUJDLFVBQXZCLENBQWtDNUgsTUFEOUUsRUFDc0Y7RUFDcEYsUUFBQSxPQUFBO0VBQ0QsT0FBQTs7RUFFRCxNQUFBLElBQUk4SCxZQUFZLENBQUM5SCxNQUFiLEdBQXNCLENBQTFCLEVBQTZCO1VBQzNCLElBQStCOEgsY0FBQUEsR0FBQUEsWUFBWSxDQUFDLENBQUQsQ0FBM0M7Y0FBTzlJLElBQVAsa0JBQU9BLElBQVA7Y0FBYWlELEtBQWIsa0JBQWFBLEtBQWI7Y0FBb0JyTixPQUFwQixrQkFBb0JBLE9BQXBCLENBQUE7O0VBRUEsUUFBQSxRQUFRb0ssSUFBUjtFQUNFLFVBQUEsS0FBSyxNQUFMO0VBQ0UsWUFBQSxJQUFBLENBQUtzRSxRQUFMLENBQWNyQixLQUFkLEVBQXFCck4sT0FBckIsQ0FBQSxDQUFBO0VBQ0EsWUFBQSxNQUFBOztFQUNGLFVBQUEsS0FBSyxLQUFMO2NBQ0UsSUFBS2dQLENBQUFBLE9BQUwsQ0FBYWhQLE9BQWIsQ0FBQSxDQUFBO0VBQ0EsWUFBQSxNQUFBOztFQUNGLFVBQUEsS0FBSyxPQUFMO0VBQ0UsWUFBQSxJQUFJbVQsS0FBSyxDQUFDQyxPQUFOLENBQWMvRixLQUFkLENBQUosRUFBMEI7RUFDeEIsY0FBQSxJQUFBLENBQUtDLGNBQUwsQ0FBb0JELEtBQXBCLEVBQTJCck4sT0FBM0IsQ0FBQSxDQUFBO0VBQ0QsYUFGRCxNQUVPO0VBQ0wsY0FBQSxJQUFBLENBQUtzTixjQUFMLENBQW9CLENBQUNELEtBQUQsQ0FBcEIsRUFBNkJyTixPQUE3QixDQUFBLENBQUE7RUFDRCxhQUFBOztFQUNELFlBQUEsTUFBQTs7RUFDRixVQUFBLEtBQUssU0FBTDtFQUNFLFlBQUEsSUFBQSxDQUFLcVQsV0FBTCxDQUFpQmhHLEtBQWpCLEVBQXdCck4sT0FBeEIsQ0FBQSxDQUFBO0VBQ0EsWUFBQSxNQUFBOztFQUNGLFVBQUE7RUFDRSxZQUFBLE1BQU0sSUFBSWlRLEtBQUosQ0FBMEI3RixlQUFBQSxDQUFBQSxNQUFBQSxDQUFBQSxJQUExQixFQUFOLGtCQUFBLENBQUEsQ0FBQSxDQUFBO0VBbEJKLFNBQUE7RUFvQkQsT0FBQTtFQUNGLEtBQUE7OzthQUVELFNBQVMsTUFBQSxHQUFBO0VBQ1AsTUFBQSxJQUFBLFdBQUEsR0FhSSxLQUFLM0wsS0FiVCxDQUFBO1lBQ0V3SCxRQURGLGVBQ0VBLFFBREYsQ0FBQTtZQUVFcUksVUFGRixlQUVFQSxVQUZGLENBQUE7d0JBS0VrQixTQUxGLENBQUE7d0JBTUVFLFVBTkYsQ0FBQTt3QkFPRU4sUUFQRixDQUFBO3dCQVFFRSxTQVJGLENBQUE7d0JBU0VPLFFBVEYsQ0FBQTt3QkFVRXZNLGtCQVZGLENBQUE7RUFBQSxjQVlLckMsSUFaTCxHQUFBLHdCQUFBLENBQUEsV0FBQSxFQUFBQyxXQUFBLEVBQUE7O1FBZUEsSUFBTW9TLGFBQWEsR0FBRyxJQUFBLENBQUszRyxLQUFMLENBQVdpRyxhQUFYLENBQXlCdEosR0FBekIsQ0FBNkIsVUFBQStELEtBQUssRUFBQTtVQUFBLE9BQUlpQixVQUFVLENBQUNqQixLQUFELENBQWQsQ0FBQTtFQUFBLE9BQWxDLENBQXRCLENBQUE7O0VBRUEsTUFBQSxJQUFJcEgsUUFBUSxJQUFJQSxRQUFRLEtBQUssSUFBQSxDQUFLNUcsR0FBbEMsRUFBdUM7VUFDckMsSUFBS0EsQ0FBQUEsR0FBTCxHQUFXNEcsUUFBWCxDQUFBO0VBQ0QsT0FBQTs7UUFFRCxvQkFDRXRGLHlCQUFBLENBQUEsYUFBQSxDQUFDMEQsU0FBRCxFQUFBLFFBQUEsQ0FBQSxFQUFBLEVBQWFwRCxJQUFiLEVBQUE7RUFBbUIsUUFBQSxHQUFHLEVBQUUsSUFBSzVCLENBQUFBLEdBQUFBO0VBQTdCLE9BQUEsQ0FBQSxFQUNHaVUsYUFESCxDQURGLENBQUE7RUFLRCxLQUFBOzs7O0VBeFBnQzNTLENBQUFBLENBQUFBLHlCQUFLLENBQUNpQjtFQTJQekM7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7O0FBQ00yUixNQUFBQSxlQUFlLGdCQUFHNVMseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRWSxHQUFSLEVBQUE7RUFBQSxFQUFBLG9CQUN2Q3NCLHdDQUFDLG9CQUFELEVBQUEsUUFBQSxDQUFBO0VBQXNCLElBQUEsUUFBUSxFQUFFdEIsR0FBQUE7RUFBaEMsR0FBQSxFQUF5Q1osS0FBekMsQ0FBQSxFQUFpREEsS0FBSyxDQUFDdUMsUUFBdkQsQ0FEdUMsQ0FBQTtFQUFBLENBQWpCLEVBQXhCO0VBSUF1UyxlQUFlLENBQUN2UixTQUFoQixHQUE0QjtFQUMxQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRXNNLEVBQUFBLFVBQVUsRUFBRXBNLDZCQUFTLENBQUNHLElBQVYsQ0FBZXlKLFVBVkQ7O0VBVzFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNFaUgsRUFBQUEsV0FBVyxFQUFFN1EsNkJBQVMsQ0FBQzRCLEtBQVYsQ0FBZ0I7TUFDM0JrUCxVQUFVLEVBQUU5USw2QkFBUyxDQUFDc1IsT0FBVixDQUFrQnRSLDZCQUFTLENBQUNlLE1BQTVCLENBRGU7RUFFM0JpUSxJQUFBQSxZQUFZLEVBQUVoUiw2QkFBUyxDQUFDc1IsT0FBVixDQUFrQnRSLDZCQUFTLENBQUNlLE1BQTVCLENBQUE7RUFGYSxHQUFoQixDQTFCYTs7RUErQjFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V1TSxTQUFTLEVBQUV0Tiw2QkFBUyxDQUFDRyxJQXRDSzs7RUF3QzFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VxTixVQUFVLEVBQUV4Tiw2QkFBUyxDQUFDRyxJQS9DSTs7RUFpRDFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UrTSxRQUFRLEVBQUVsTiw2QkFBUyxDQUFDRyxJQXhETTs7RUEwRDFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpTixTQUFTLEVBQUVwTiw2QkFBUyxDQUFDRyxJQWpFSzs7RUFtRTFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFUSxTQUFTLEVBQUVYLDZCQUFTLENBQUNDLE1BNUVLOztFQThFMUI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWEsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BckZGOztFQXVGMUI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRW1DLEVBQUFBLFNBQVMsRUFBRWxELDZCQUFTLENBQUMrRSxTQUFWLENBQW9CLENBQUMvRSw2QkFBUyxDQUFDSSxJQUFYLEVBQWlCSiw2QkFBUyxDQUFDQyxNQUEzQixDQUFwQixDQWpHZTs7RUFtRzFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0UwTixRQUFRLEVBQUUzTiw2QkFBUyxDQUFDRyxJQTdHTTs7RUErRzFCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpQixrQkFBa0IsRUFBRXBCLDZCQUFTLENBQUNHLElBQUFBO0VBekhKLENBQTVCOztFQzNRQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTW9SLEdBQUcsR0FBR2hULGdCQUFnQixDQUFDLFNBQUQsRUFBNUI7RUFFQWdULEdBQUcsQ0FBQ3pSLFNBQUosR0FBZ0I7RUFFZDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFd0YsYUFBYSxFQUFFdEYsNkJBQVMsQ0FBQzJDLEtBQVYsQ0FBZ0IsQ0FBQyxLQUFELEVBQVEsUUFBUixFQUFrQixRQUFsQixDQUFoQixDQUFBO0VBVEQsQ0FBaEI7O0VDZkEsSUFBTWpHLFNBQU8sR0FDUnNILGNBQUFBLENBQUFBLEVBQUFBLEVBQUFBLFdBRFEsQ0FBYixDQUFBOztFQUlBLElBQU04RCxrQkFBZ0IsR0FBRyxTQUFuQkEsZ0JBQW1CLENBQUFuRCxTQUFTLEVBQUE7RUFBQSxFQUFBLE9BQUloQixXQUFXLENBQUNnQixTQUFELEVBQVksY0FBWixFQUE0QixPQUE1QixDQUFmLENBQUE7RUFBQSxDQUFsQyxDQUFBOztFQUVBLElBQU01RyxlQUFhLEdBQUcsQ0FDcEIsT0FEb0I7RUFBQSxDQUF0QixDQUFBO0VBS0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU15VCxXQUFXLEdBQUcxSixrQkFBZ0IsQ0FBQ3ZKLGdCQUFnQixDQUFDLGtCQUFELEVBQXFCO0VBQUMvQixFQUFBQSxVQUFVLEVBQUVFLFNBQWI7RUFBc0JxQixFQUFBQSxhQUFhLEVBQWJBLGVBQUFBO0VBQXRCLENBQXJCLENBQWpCLEVBQXBDO0VBRUF5VCxXQUFXLENBQUMxUixTQUFaLEdBQXdCO0VBQ3RCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWMsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQVRFOztFQVd0QjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBbEJFOztFQW9CdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW9FLFFBQVEsRUFBRXhFLDZCQUFTLENBQUNJLElBM0JFOztFQTZCdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXlFLFFBQVEsRUFBRTdFLDZCQUFTLENBQUNHLElBcENFOztFQXNDdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTJFLE9BQU8sRUFBRTlFLDZCQUFTLENBQUNHLElBN0NHOztFQStDdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRWxDLEVBQUFBLEtBQUssRUFBRStCLDZCQUFTLENBQUMrRSxTQUFWLENBQW9CLENBQ3pCL0UsNkJBQVMsQ0FBQ0MsTUFEZSxFQUV6QkQsNkJBQVMsQ0FBQ2dGLFVBQVYsQ0FBcUJDLElBQXJCLENBRnlCLENBQXBCLENBdERlOztFQTJEdEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRStDLEVBQUFBLFlBQVksRUFBRWhJLDZCQUFTLENBQUMrRSxTQUFWLENBQW9CLENBQ2hDL0UsNkJBQVMsQ0FBQ0MsTUFEc0IsRUFFaENELDZCQUFTLENBQUNnRixVQUFWLENBQXFCQyxJQUFyQixDQUZnQyxDQUFwQixDQWxFUTs7RUF1RXRCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnRCxXQUFXLEVBQUVqSSw2QkFBUyxDQUFDQyxNQTlFRDs7RUFnRnRCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VtRixPQUFPLEVBQUVwRiw2QkFBUyxDQUFDQyxNQUFBQTtFQXZGRyxDQUF4Qjs7RUNqQ0EsSUFBTXpELFlBQVUsR0FBRztFQUNqQjBGLEVBQUFBLEtBQUssRUFBRSxhQUFBO0VBRFUsQ0FBbkIsQ0FBQTtFQUlBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU11UCxPQUFPLEdBQUdsVCxnQkFBZ0IsQ0FBQyxhQUFELEVBQWdCO0VBQUMvQixFQUFBQSxVQUFVLEVBQVZBLFlBQUFBO0VBQUQsQ0FBaEIsRUFBaEM7RUFFQWlWLE9BQU8sQ0FBQzNSLFNBQVIsR0FBb0I7RUFDbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXFELFdBQVcsRUFBRW5ELDZCQUFTLENBQUNpRCxNQVJMOztFQVVsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFZixLQUFLLEVBQUVsQyw2QkFBUyxDQUFDaUQsTUFqQkM7O0VBbUJsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeU8sUUFBUSxFQUFFMVIsNkJBQVMsQ0FBQ0MsTUExQkY7O0VBNEJsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VXLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFwQ0Y7O0VBc0NsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFcUQsWUFBWSxFQUFFdEQsNkJBQVMsQ0FBQ0csSUE3Q047O0VBK0NsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFRyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBQUFBO0VBdERGLENBQXBCOztFQ25CQSxJQUFNMUQsU0FBTyxHQUNSc0gsY0FBQUEsQ0FBQUEsRUFBQUEsRUFBQUEsV0FEUSxDQUFiLENBQUE7O0VBSUEsSUFBTThELGdCQUFnQixHQUFHLFNBQW5CQSxnQkFBbUIsQ0FBQW5ELFNBQVMsRUFBQTtFQUFBLEVBQUEsT0FBSWhCLFdBQVcsQ0FBQ2dCLFNBQUQsRUFBWSxjQUFaLEVBQTRCLE9BQTVCLENBQWYsQ0FBQTtFQUFBLENBQWxDLENBQUE7O0VBQ0EsSUFBTXhDLFNBQU8sR0FBRzJGLGdCQUFnQixDQUFDdkosZ0JBQWdCLENBQUMsWUFBRCxFQUFlO0VBQUMvQixFQUFBQSxVQUFVLEVBQUVFLFNBQUFBO0VBQWIsQ0FBZixDQUFqQixDQUFoQyxDQUFBO0VBRUE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNNaVYsTUFBQUEsTUFBTSxnQkFBR2xULHlCQUFLLENBQUNDLFVBQU4sQ0FBaUIsVUFBQ25DLEtBQUQsRUFBUVksR0FBUixFQUFBO0lBQUEsb0JBQzlCc0IseUJBQUEsQ0FBQSxhQUFBLENBQUMwRCxTQUFELEVBQUEsUUFBQSxDQUFBLEVBQUEsRUFBYTVGLEtBQWIsRUFBQTtFQUFvQixJQUFBLEdBQUcsRUFBRVksR0FBQUE7RUFBekIsR0FBQSxDQUFBLGVBQ0VzQix5QkFDR2xDLENBQUFBLGFBQUFBLENBQUFBLFFBQUFBLEVBQUFBLElBQUFBLEVBQUFBLEtBQUssQ0FBQ3VDLFFBRFQsQ0FERixDQUQ4QixDQUFBO0VBQUEsQ0FBakIsRUFBZjtFQVFBNlMsTUFBTSxDQUFDN1IsU0FBUCxHQUFtQjtFQUNqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BUkg7O0VBVWpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VLLFFBQVEsRUFBRU4sNkJBQVMsQ0FBQ0ksSUFqQkg7O0VBbUJqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeUUsUUFBUSxFQUFFN0UsNkJBQVMsQ0FBQ0csSUExQkg7O0VBNEJqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFbEMsS0FBSyxFQUFFK0IsNkJBQVMsQ0FBQ0MsTUFuQ0E7O0VBcUNqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFK0gsWUFBWSxFQUFFaEksNkJBQVMsQ0FBQ0MsTUE1Q1A7O0VBOENqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMlIsUUFBUSxFQUFFNVIsNkJBQVMsQ0FBQ0ksSUFyREg7O0VBdURqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFeVIsU0FBUyxFQUFFN1IsNkJBQVMsQ0FBQ0ksSUE5REo7O0VBZ0VqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMFIsUUFBUSxFQUFFOVIsNkJBQVMsQ0FBQ0ksSUF2RUg7O0VBeUVqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFMlIsSUFBSSxFQUFFL1IsNkJBQVMsQ0FBQ0MsTUFoRkM7O0VBa0ZqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFdUgsSUFBSSxFQUFFeEgsNkJBQVMsQ0FBQ2lELE1BekZDOztFQTJGakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWlOLElBQUksRUFBRWxRLDZCQUFTLENBQUNDLE1BQUFBO0VBbEdDLENBQW5COztFQ3BDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNBLE1BQU0rUixTQUFTLEdBQUd6VCxnQkFBZ0IsQ0FBQyxnQkFBRCxFQUFsQztFQUVBeVQsU0FBUyxDQUFDbFMsU0FBVixHQUFzQjtFQUNwQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFUQTs7RUFXcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXlGLFFBQVEsRUFBRTFGLDZCQUFTLENBQUNDLE1BckJBOztFQXVCcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDRXlDLEVBQUFBLFNBQVMsRUFBRTFDLDZCQUFTLENBQUMyQyxLQUFWLENBQWdCLENBQUMsSUFBRCxFQUFPLE1BQVAsRUFBZSxNQUFmLEVBQXVCLE9BQXZCLENBQWhCLENBOUJTOztFQWdDcEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXJDLFFBQVEsRUFBRU4sNkJBQVMsQ0FBQ0ksSUFBQUE7RUF2Q0EsQ0FBdEI7O0VDdEJBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNNlIsYUFBYSxHQUFHMVQsZ0JBQWdCLENBQUMscUJBQUQsRUFBdEM7RUFFQTBULGFBQWEsQ0FBQ25TLFNBQWQsR0FBMEI7RUFDeEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVEk7O0VBV3hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzQixPQUFPLEVBQUV2Qiw2QkFBUyxDQUFDRyxJQUFBQTtFQWxCSyxDQUExQjs7RUNwQkEsSUFBTXBDLGVBQWEsR0FBRyxDQUFDLG9CQUFELENBQXRCLENBQUE7RUFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTW1VLFFBQVEsR0FBRzNULGdCQUFnQixDQUFDLGNBQUQsRUFBaUI7RUFBQ1IsRUFBQUEsYUFBYSxFQUFiQSxlQUFBQTtFQUFELENBQWpCLEVBQWpDO0VBRUFtVSxRQUFRLENBQUNwUyxTQUFULEdBQXFCO0VBQ25CO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzQixrQkFBa0IsRUFBRXBCLDZCQUFTLENBQUNHLElBQUFBO0VBWFgsQ0FBckI7O0VDdENBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTWdTLGVBQWUsR0FBRzVULGdCQUFnQixDQUFDLHNCQUFEOzs7RUM5QnhDLElBQU0vQixZQUFVLEdBQUc7RUFDakI0VixFQUFBQSxNQUFNLEVBQUUsWUFEUztFQUVqQkMsRUFBQUEsT0FBTyxFQUFFLGFBQUE7RUFGUSxDQUFuQixDQUFBO0VBSUEsSUFBTXRVLGVBQWEsR0FBRyxDQUFDLFFBQUQsQ0FBdEIsQ0FBQTtFQUVBLElBQU1vRSxTQUFPLEdBQUc1RCxnQkFBZ0IsQ0FBQyxtQkFBRCxFQUFzQjtFQUFDL0IsRUFBQUEsVUFBVSxFQUFWQSxZQUFEO0VBQWF1QixFQUFBQSxhQUFhLEVBQWJBLGVBQUFBO0VBQWIsQ0FBdEIsQ0FBaEMsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ011VSxNQUFBQSxZQUFZLGdCQUFHN1QseUJBQUssQ0FBQ0MsVUFBTixDQUFpQixVQUFDbkMsS0FBRCxFQUFRWSxHQUFSLEVBQWdCO0VBQ3BELEVBQUEsSUFBT29JLEtBQVAsR0FBeUJoSixLQUF6QixDQUFPZ0osS0FBUDtFQUFBLE1BQWlCeEcsSUFBakIsR0FBQSx3QkFBQSxDQUF5QnhDLEtBQXpCLEVBQUF5QyxXQUFBLENBQUEsQ0FEb0Q7OztJQUlwRCxJQUFNdVQsU0FBUyxHQUFHLE9BQU9oTixLQUFQLEtBQWlCLFFBQWpCLEdBQUEsRUFBQSxDQUFBLE1BQUEsQ0FBK0JBLEtBQS9CLEVBQUEsSUFBQSxDQUFBLEdBQTJDQSxLQUE3RCxDQUFBO0VBRUEsRUFBQSxvQkFDRTlHLHdDQUFDMEQsU0FBRCxFQUFBLFFBQUEsQ0FBQTtFQUNFLElBQUEsS0FBSyxFQUFFb1EsU0FEVDtFQUVFLElBQUEsR0FBRyxFQUFFcFYsR0FBQUE7RUFGUCxHQUFBLEVBR000QixJQUhOLENBQUEsRUFLR3hDLEtBQUssQ0FBQ3VDLFFBTFQsQ0FERixDQUFBO0VBU0QsQ0Fmb0IsRUFBckI7RUFpQkF3VCxZQUFZLENBQUN4UyxTQUFiLEdBQXlCO0VBQ3ZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0UwUyxFQUFBQSxRQUFRLEVBQUV4Uyw2QkFBUyxDQUFDK0UsU0FBVixDQUFvQixDQUFDL0UsNkJBQVMsQ0FBQ0ksSUFBWCxFQUFpQkosNkJBQVMsQ0FBQ0MsTUFBM0IsQ0FBcEIsQ0FYYTs7RUFhdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWlELFNBQVMsRUFBRWxELDZCQUFTLENBQUNJLElBcEJFOztFQXNCdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUksTUFBTSxFQUFFUiw2QkFBUyxDQUFDSSxJQTdCSzs7RUErQnZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VxUyxVQUFVLEVBQUV6Uyw2QkFBUyxDQUFDRyxJQXRDQzs7RUF3Q3ZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpUyxNQUFNLEVBQUVwUyw2QkFBUyxDQUFDRyxJQS9DSzs7RUFpRHZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V1UyxXQUFXLEVBQUUxUyw2QkFBUyxDQUFDRyxJQXhEQTs7RUEwRHZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VrUyxPQUFPLEVBQUVyUyw2QkFBUyxDQUFDRyxJQWpFSTs7RUFtRXZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V3UyxJQUFJLEVBQUUzUyw2QkFBUyxDQUFDMkMsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxPQUFULENBQWhCLENBMUVpQjs7RUE0RXZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpUSxnQkFBZ0IsRUFBRTVTLDZCQUFTLENBQUNpRCxNQW5GTDs7RUFxRnZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VzQyxLQUFLLEVBQUV2Riw2QkFBUyxDQUFDQyxNQTVGTTs7RUE4RnZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVUsU0FBUyxFQUFFWCw2QkFBUyxDQUFDQyxNQXRHRTs7RUF3R3ZCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWEsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BaEhMOztFQWtIdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFOFIsYUFBYSxFQUFFN1MsNkJBQVMsQ0FBQ2lELE1BMUhGOztFQTRIdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTZQLFNBQVMsRUFBRTlTLDZCQUFTLENBQUNHLElBbklFOztFQXFJdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTRTLFVBQVUsRUFBRS9TLDZCQUFTLENBQUNHLElBNUlDOztFQThJdkI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTZTLFlBQVksRUFBRWhULDZCQUFTLENBQUNHLElBQUFBO0VBckpELENBQXpCOztFQ3hEQSxJQUFNekQsT0FBTyxHQUNSc0gsY0FBQUEsQ0FBQUEsRUFBQUEsRUFBQUEsV0FEUSxDQUFiLENBQUE7O0VBSUEsSUFBTVUsa0JBQWtCLEdBQUcsU0FBckJBLGtCQUFxQixDQUFBQyxTQUFTLEVBQUE7RUFBQSxFQUFBLE9BQUloQixXQUFXLENBQUNnQixTQUFELEVBQVksZ0JBQVosRUFBOEIsU0FBOUIsQ0FBZixDQUFBO0VBQUEsQ0FBcEMsQ0FBQTtFQUVBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7O0FBQ0EsTUFBTXNPLE1BQU0sR0FBR3ZPLGtCQUFrQixDQUFDbkcsZ0JBQWdCLENBQUMsWUFBRCxFQUFlO0VBQUMvQixFQUFBQSxVQUFVLEVBQUVFLE9BQUFBO0VBQWIsQ0FBZixDQUFqQixFQUFqQztFQUVBdVcsTUFBTSxDQUFDblQsU0FBUCxHQUFtQjtFQUNqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VjLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFUSDs7RUFXakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTRFLFFBQVEsRUFBRTdFLDZCQUFTLENBQUNHLElBbEJIOztFQW9CakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStFLE9BQU8sRUFBRWxGLDZCQUFTLENBQUNJLElBM0JGOztFQTZCakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStFLGNBQWMsRUFBRW5GLDZCQUFTLENBQUNJLElBcENUOztFQXNDakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUUsUUFBUSxFQUFFTiw2QkFBUyxDQUFDSSxJQTdDSDs7RUErQ2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnRixPQUFPLEVBQUVwRiw2QkFBUyxDQUFDQyxNQUFBQTtFQXRERixDQUFuQjs7RUN0QkE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTWlULEdBQUcsR0FBRzNVLGdCQUFnQixDQUFDLFNBQUQsRUFBNUI7RUFFQTJVLEdBQUcsQ0FBQ3BULFNBQUosR0FBZ0I7RUFDZDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFd0IsSUFBSSxFQUFFdEIsNkJBQVMsQ0FBQ0MsTUFSRjs7RUFVZDtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFa1QsVUFBVSxFQUFFblQsNkJBQVMsQ0FBQ0MsTUFqQlI7O0VBbUJkO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VtVCxLQUFLLEVBQUVwVCw2QkFBUyxDQUFDQyxNQTFCSDs7RUE0QmQ7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW9ULEtBQUssRUFBRXJULDZCQUFTLENBQUNDLE1BQUFBO0VBbkNILENBQWhCOzs7RUNkQSxJQUFNekQsWUFBVSxHQUFHO0VBQ2pCMEYsRUFBQUEsS0FBSyxFQUFFLGFBQUE7RUFEVSxDQUFuQixDQUFBO0VBR0EsSUFBTUMsU0FBTyxHQUFHNUQsZ0JBQWdCLENBQUMsWUFBRCxFQUFlO0VBQUMvQixFQUFBQSxVQUFVLEVBQVZBLFlBQUFBO0VBQUQsQ0FBZixDQUFoQyxDQUFBO0VBRUE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtBQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDTThXLE1BQUFBLE1BQU0sZ0JBQUc3VSx5QkFBSyxDQUFDQyxVQUFOLENBQWlCLFVBQUNuQyxLQUFELEVBQVFZLEdBQVIsRUFBZ0I7RUFDOUMsRUFBQSxJQUFPMEMsT0FBUCxHQUFpRHRELEtBQWpELENBQU9zRCxPQUFQO0VBQUEsTUFBZ0IwVCxRQUFoQixHQUFpRGhYLEtBQWpELENBQWdCZ1gsUUFBaEI7RUFBQSxNQUEwQkMsVUFBMUIsR0FBaURqWCxLQUFqRCxDQUEwQmlYLFVBQTFCO1FBQXlDelUsSUFBekMsNEJBQWlEeEMsS0FBakQsRUFBQSxTQUFBLENBQUEsQ0FBQTs7SUFFQSxJQUFNa1gsSUFBSSxHQUFHRCxVQUFVLENBQUNqWCxLQUFLLENBQUM0RyxXQUFQLEVBQW9CaEcsR0FBcEIsQ0FBdkIsQ0FIOEM7RUFNOUM7O0VBQ0EsRUFBQSxJQUFJdVcsY0FBSixDQUFBOztFQUNBLEVBQUEsSUFBSUgsUUFBUSxLQUFLdFcsU0FBYixJQUEwQjRDLE9BQU8sS0FBSzVDLFNBQTFDLEVBQXFEO01BQ25EeVcsY0FBYyxHQUFHLENBQUM3VCxPQUFsQixDQUFBO0VBQ0QsR0FGRCxNQUVPO0VBQ0w2VCxJQUFBQSxjQUFjLEdBQUdILFFBQWpCLENBQUE7RUFDRCxHQUFBOztFQUVELEVBQUEsb0JBQ0U5VSx3Q0FBQzBELFNBQUQsRUFBQSxRQUFBLENBQUE7RUFDRSxJQUFBLFFBQVEsRUFBRXVSLGNBQUFBO0VBRFosR0FBQSxFQUVNM1UsSUFGTixFQUFBO0VBSUUsSUFBQSxHQUFHLEVBQUU1QixHQUFBQTtLQUVMLENBQUEsZUFBQXNCLHlCQUFBLENBQUEsYUFBQSxDQUFBLEtBQUEsRUFBQTtFQUFLLElBQUEsU0FBUyxFQUFDLGlCQUFBO0VBQWYsR0FBQSxlQUNFQSxxREFDR2dWLElBQUksQ0FBQ3JNLEdBQUwsQ0FBUyxVQUFBdU0sR0FBRyxFQUFBO01BQUEsT0FBSUEsR0FBRyxDQUFDQyxPQUFSLENBQUE7RUFBQSxHQUFaLENBREgsQ0FERixlQUlFblYseUJBQUEsQ0FBQSxhQUFBLENBQUEsS0FBQSxFQUFBLElBQUEsQ0FKRixDQU5GLGVBWUVBLHlCQUFBLENBQUEsYUFBQSxDQUFBLEtBQUEsRUFBQTtFQUFLLElBQUEsU0FBUyxFQUFDLFFBQUE7RUFBZixHQUFBLEVBQ0dnVixJQUFJLENBQUNyTSxHQUFMLENBQVMsVUFBQXVNLEdBQUcsRUFBQTtNQUFBLE9BQUlBLEdBQUcsQ0FBQ0EsR0FBUixDQUFBO0VBQUEsR0FBWixDQURILGVBRUVsVix5QkFBQSxDQUFBLGFBQUEsQ0FBQSxLQUFBLEVBQUE7RUFBSyxJQUFBLFNBQVMsRUFBQyxnQkFBQTtFQUFmLEdBQUEsQ0FGRixDQVpGLENBREYsQ0FBQTtFQW1CRCxDQWpDYyxFQUFmO0VBbUNBNlUsTUFBTSxDQUFDeFQsU0FBUCxHQUFtQjtFQUNqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFcUQsV0FBVyxFQUFFbkQsNkJBQVMsQ0FBQ2lELE1BUk47O0VBVWpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VmLEtBQUssRUFBRWxDLDZCQUFTLENBQUNpRCxNQWpCQTs7RUFtQmpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0V1USxFQUFBQSxVQUFVLEVBQUV4VCw2QkFBUyxDQUFDRyxJQUFWLENBQWV5SixVQTFCVjs7RUE0QmpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VsRSxRQUFRLEVBQUUxRiw2QkFBUyxDQUFDQyxNQW5DSDs7RUFxQ2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpRCxTQUFTLEVBQUVsRCw2QkFBUyxDQUFDSSxJQTVDSjs7RUE4Q2pCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0V5VCxlQUFlLEVBQUU3VCw2QkFBUyxDQUFDaUQsTUFyRFY7O0VBdURqQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFdEMsU0FBUyxFQUFFWCw2QkFBUyxDQUFDMkMsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxPQUFULENBQWhCLENBOURNOztFQWdFakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFN0IsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BeEVYOztFQTBFakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRStTLFNBQVMsRUFBRTlULDZCQUFTLENBQUNJLElBakZKOztFQW1GakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWlELFdBQVcsRUFBRXJELDZCQUFTLENBQUNHLElBMUZOOztFQTRGakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW1ELFlBQVksRUFBRXRELDZCQUFTLENBQUNHLElBbkdQOztFQXFHakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRTRULFVBQVUsRUFBRS9ULDZCQUFTLENBQUNHLElBNUdMOztFQThHakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXNELE9BQU8sRUFBRXpELDZCQUFTLENBQUNHLElBckhGOztFQXVIakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRW9ULFFBQVEsRUFBRXZULDZCQUFTLENBQUNJLElBOUhIOztFQWdJakI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVAsT0FBTyxFQUFFRyw2QkFBUyxDQUFDSSxJQXZJRjs7RUF5SWpCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VRLFFBQVEsRUFBRVosNkJBQVMsQ0FBQ0MsTUFBQUE7RUFoSkgsQ0FBbkI7O0VDckVBLElBQU1ILFNBQVMsR0FBRztFQUNoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUQsT0FBTyxFQUFFRyw2QkFBUyxDQUFDSSxJQVZIOztFQVloQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUksTUFBTSxFQUFFUiw2QkFBUyxDQUFDSSxJQXJCRjs7RUF1QmhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRU8sU0FBUyxFQUFFWCw2QkFBUyxDQUFDQyxNQS9CTDs7RUFpQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRVcsUUFBUSxFQUFFWiw2QkFBUyxDQUFDQyxNQXpDSjs7RUEyQ2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWEsZ0JBQWdCLEVBQUVkLDZCQUFTLENBQUNlLE1BbkRaOztFQXFEaEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRUMsU0FBUyxFQUFFaEIsNkJBQVMsQ0FBQ0csSUEvREw7O0VBaUVoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxVQUFVLEVBQUVqQiw2QkFBUyxDQUFDRyxJQTNFTjs7RUE2RWhCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWUsU0FBUyxFQUFFbEIsNkJBQVMsQ0FBQ0csSUFyRkw7O0VBdUZoQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VnQixVQUFVLEVBQUVuQiw2QkFBUyxDQUFDRyxJQS9GTjs7RUFpR2hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VpQixrQkFBa0IsRUFBRXBCLDZCQUFTLENBQUNHLElBQUFBO0VBM0dkLENBQWxCLENBQUE7RUE4R0EsSUFBTTNELFVBQVUsR0FBRztFQUNqQmdFLEVBQUFBLE1BQU0sRUFBRSxTQUFBO0VBRFMsQ0FBbkIsQ0FBQTtFQUlBLElBQU16QyxlQUFhLEdBQUcsQ0FBQyxvQkFBRCxDQUF0QixDQUFBO0VBRUE7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBOztBQUNNaVcsTUFBQUEsS0FBSyxHQUFHelYsZ0JBQWdCLENBQUNvQixVQUFVLENBQUMsV0FBRCxDQUFYLEVBQTBCO0VBQUNHLEVBQUFBLFNBQVMsRUFBVEEsU0FBRDtFQUFZdEQsRUFBQUEsVUFBVSxFQUFWQSxVQUFaO0VBQXdCdUIsRUFBQUEsYUFBYSxFQUFiQSxlQUFBQTtFQUF4QixDQUExQixFQUE5QjtFQUNBaVcsS0FBSyxDQUFDbFUsU0FBTixHQUFrQkEsU0FBbEI7O0VDbElBLElBQU0vQixhQUFhLEdBQUcsQ0FBQyxTQUFELENBQXRCLENBQUE7RUFFQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7O0FBQ0EsTUFBTWtXLE9BQU8sR0FBRzFWLGdCQUFnQixDQUFDLGFBQUQsRUFBZ0I7RUFBQ1IsRUFBQUEsYUFBYSxFQUFiQSxhQUFBQTtFQUFELENBQWhCLEVBQWhDO0VBRUFrVyxPQUFPLENBQUNuVSxTQUFSLEdBQW9CO0VBQ2xCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVkY7O0VBWWxCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0lBQ0VKLE9BQU8sRUFBRUcsNkJBQVMsQ0FBQ0ksSUFuQkQ7O0VBcUJsQjtFQUNGO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFLFFBQVFKLEVBQUFBLDZCQUFTLENBQUNJLElBNUJBOztFQThCbEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRThULE1BQU0sRUFBRWxVLDZCQUFTLENBQUNJLElBQUFBO0VBckNBLENBQXBCOztFQy9CQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTs7QUFDQSxNQUFNK1QsYUFBYSxHQUFHNVYsZ0JBQWdCLENBQUMsb0JBQUQsRUFBdEM7RUFFQTRWLGFBQWEsQ0FBQ3JVLFNBQWQsR0FBMEI7RUFDeEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFYyxRQUFRLEVBQUVaLDZCQUFTLENBQUNDLE1BVEk7O0VBV3hCO0VBQ0Y7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtJQUNFSyxRQUFRLEVBQUVOLDZCQUFTLENBQUNJLElBcEJJOztFQXNCeEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRWtCLElBQUksRUFBRXRCLDZCQUFTLENBQUNDLE1BN0JROztFQStCeEI7RUFDRjtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7SUFDRXNCLE9BQU8sRUFBRXZCLDZCQUFTLENBQUNHLElBQUFBO0VBdENLLENBQTFCOztFQ2hDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0E7RUFDQTtFQUNBO0FBRUEsbUJBQWU7SUFDYmlVLElBQUksRUFBRSxTQUFDL0ksSUFBQUEsQ0FBQUEsTUFBRCxFQUFZO01BQ2hCLE9BQU87UUFDTHlGLFVBQVUsRUFBQSxrQkFBQSxDQUFNekYsTUFBTixDQURMO0VBRUwyRixNQUFBQSxZQUFZLEVBQUUsRUFBQTtPQUZoQixDQUFBO0tBRlc7RUFRYjVVLEVBQUFBLE9BQU8sRUFBRSxTQUF3QyxPQUFBLENBQUEsSUFBQSxFQUFBO01BQUEsSUFBdEN5VSxXQUFzQyxRQUF0Q0EsV0FBc0M7VUFBekIxRixLQUF5QixRQUF6QkEsS0FBeUI7VUFBbEJyTixPQUFrQixRQUFsQkEsT0FBa0I7VUFBVHVKLEdBQVMsUUFBVEEsR0FBUyxDQUFBOztNQUMvQyxJQUFNZ04sTUFBTSxHQUFPeEQsY0FBQUEsQ0FBQUEsRUFBQUEsRUFBQUEsV0FBUCxDQUFaLENBQUE7O0VBQ0EsSUFBQSxJQUFNQyxVQUFVLEdBQUEsa0JBQUEsQ0FBT3VELE1BQU0sQ0FBQ3ZELFVBQWQsQ0FBaEIsQ0FBQTs7RUFDQSxJQUFBLElBQUlFLFlBQVksR0FBQSxrQkFBQSxDQUFPcUQsTUFBTSxDQUFDckQsWUFBZCxDQUFoQixDQUFBOztNQUVBLElBQUkzSixHQUFHLElBQUksSUFBUCxJQUFlMkosWUFBWSxDQUFDL0osTUFBYixDQUFvQixVQUFDdUMsRUFBRCxFQUFBO0VBQUEsTUFBQSxPQUFRQSxFQUFFLENBQUNuQyxHQUFILEtBQVdBLEdBQW5CLENBQUE7RUFBQSxLQUFwQixDQUE0QzZCLENBQUFBLE1BQTVDLEtBQXVELENBQTFFLEVBQTZFO0VBQzNFLE1BQUEsSUFBTW9MLE9BQU8sR0FBRztFQUNkcE0sUUFBQUEsSUFBSSxFQUFFLFNBRFE7RUFFZGlELFFBQUFBLEtBQUssRUFBTEEsS0FGYztFQUdkck4sUUFBQUEsT0FBTyxFQUFQQSxPQUhjO0VBSWR1SixRQUFBQSxHQUFHLEVBQUhBLEdBQUFBO1NBSkYsQ0FBQTtFQU1BMkosTUFBQUEsWUFBWSxHQUNQQSxFQUFBQSxDQUFBQSxNQUFBQSxDQUFBQSxrQkFBQUEsQ0FBQUEsWUFETyxDQUVWc0QsRUFBQUEsQ0FBQUEsT0FGVSxDQUFaLENBQUEsQ0FBQTtFQUlELEtBQUE7O01BRUQsT0FBTztFQUNMeEQsTUFBQUEsVUFBVSxFQUFWQSxVQURLO0VBRUxFLE1BQUFBLFlBQVksRUFBWkEsWUFBQUE7T0FGRixDQUFBO0tBMUJXO0VBZ0NidUQsRUFBQUEsS0FBSyxFQUFFLFNBQXdDLEtBQUEsQ0FBQSxLQUFBLEVBQUE7TUFBQSxJQUF0QzFELFdBQXNDLFNBQXRDQSxXQUFzQztVQUF6QjFGLEtBQXlCLFNBQXpCQSxLQUF5QjtVQUFsQnJOLE9BQWtCLFNBQWxCQSxPQUFrQjtVQUFUdUosR0FBUyxTQUFUQSxHQUFTLENBQUE7O01BQzdDLElBQU1nTixNQUFNLEdBQU94RCxjQUFBQSxDQUFBQSxFQUFBQSxFQUFBQSxXQUFQLENBQVosQ0FBQTs7RUFDQSxJQUFBLElBQU1DLFVBQVUsR0FBQSxrQkFBQSxDQUFPdUQsTUFBTSxDQUFDdkQsVUFBZCxDQUFoQixDQUFBOztFQUNBLElBQUEsSUFBSUUsWUFBWSxHQUFBLGtCQUFBLENBQU9xRCxNQUFNLENBQUNyRCxZQUFkLENBQWhCLENBQUE7O01BRUEsSUFBSTNKLEdBQUcsSUFBSSxJQUFQLElBQWUySixZQUFZLENBQUMvSixNQUFiLENBQW9CLFVBQUN1QyxFQUFELEVBQUE7RUFBQSxNQUFBLE9BQVFBLEVBQUUsQ0FBQ25DLEdBQUgsS0FBV0EsR0FBbkIsQ0FBQTtFQUFBLEtBQXBCLENBQTRDNkIsQ0FBQUEsTUFBNUMsS0FBdUQsQ0FBMUUsRUFBNkU7RUFDM0UsTUFBQSxJQUFNb0wsT0FBTyxHQUFHO0VBQ2RwTSxRQUFBQSxJQUFJLEVBQUUsT0FEUTtFQUVkaUQsUUFBQUEsS0FBSyxFQUFMQSxLQUZjO0VBR2RyTixRQUFBQSxPQUFPLEVBQVBBLE9BSGM7RUFJZHVKLFFBQUFBLEdBQUcsRUFBSEEsR0FBQUE7U0FKRixDQUFBO0VBT0EySixNQUFBQSxZQUFZLEdBQ1BBLEVBQUFBLENBQUFBLE1BQUFBLENBQUFBLGtCQUFBQSxDQUFBQSxZQURPLENBRVZzRCxFQUFBQSxDQUFBQSxPQUZVLENBQVosQ0FBQSxDQUFBO0VBSUQsS0FBQTs7TUFFRCxPQUFPO0VBQ0x4RCxNQUFBQSxVQUFVLEVBQVZBLFVBREs7RUFFTEUsTUFBQUEsWUFBWSxFQUFaQSxZQUFBQTtPQUZGLENBQUE7S0FuRFc7RUF5RGJ0SCxFQUFBQSxJQUFJLEVBQUUsU0FBd0MsSUFBQSxDQUFBLEtBQUEsRUFBQTtNQUFBLElBQXRDbUgsV0FBc0MsU0FBdENBLFdBQXNDO1VBQXpCMUYsS0FBeUIsU0FBekJBLEtBQXlCO1VBQWxCck4sT0FBa0IsU0FBbEJBLE9BQWtCO1VBQVR1SixHQUFTLFNBQVRBLEdBQVMsQ0FBQTs7TUFDNUMsSUFBTWdOLE1BQU0sR0FBT3hELGNBQUFBLENBQUFBLEVBQUFBLEVBQUFBLFdBQVAsQ0FBWixDQUFBOztFQUNBLElBQUEsSUFBTUMsVUFBVSxHQUFBLGtCQUFBLENBQU91RCxNQUFNLENBQUN2RCxVQUFkLENBQWhCLENBQUE7O0VBQ0EsSUFBQSxJQUFJRSxZQUFZLEdBQUEsa0JBQUEsQ0FBT3FELE1BQU0sQ0FBQ3JELFlBQWQsQ0FBaEIsQ0FBQTs7TUFFQSxJQUFJM0osR0FBRyxJQUFJLElBQVAsSUFBZWdOLE1BQU0sQ0FBQ3JELFlBQVAsQ0FBb0IvSixNQUFwQixDQUEyQixVQUFDdUMsRUFBRCxFQUFBO0VBQUEsTUFBQSxPQUFRQSxFQUFFLENBQUNuQyxHQUFILEtBQVdBLEdBQW5CLENBQUE7RUFBQSxLQUEzQixDQUFtRDZCLENBQUFBLE1BQW5ELEtBQThELENBQWpGLEVBQW9GO0VBQ2xGLE1BQUEsSUFBTW9MLE9BQU8sR0FBRztFQUNkcE0sUUFBQUEsSUFBSSxFQUFFLE1BRFE7RUFFZGlELFFBQUFBLEtBQUssRUFBTEEsS0FGYztFQUdkck4sUUFBQUEsT0FBTyxFQUFQQSxPQUhjO0VBSWR1SixRQUFBQSxHQUFHLEVBQUhBLEdBQUFBO1NBSkYsQ0FBQTtFQU9BMkosTUFBQUEsWUFBWSxHQUNQQSxFQUFBQSxDQUFBQSxNQUFBQSxDQUFBQSxrQkFBQUEsQ0FBQUEsWUFETyxDQUVWc0QsRUFBQUEsQ0FBQUEsT0FGVSxDQUFaLENBQUEsQ0FBQTtFQUlELEtBQUE7O01BRUQsT0FBTztFQUNMeEQsTUFBQUEsVUFBVSxFQUFWQSxVQURLO0VBRUxFLE1BQUFBLFlBQVksRUFBWkEsWUFBQUE7T0FGRixDQUFBO0tBNUVXO0VBa0ZickYsRUFBQUEsR0FBRyxFQUFFLFNBQWlDLEdBQUEsQ0FBQSxLQUFBLEVBQUE7TUFBQSxJQUEvQmtGLFdBQStCLFNBQS9CQSxXQUErQjtVQUFsQi9TLE9BQWtCLFNBQWxCQSxPQUFrQjtVQUFUdUosR0FBUyxTQUFUQSxHQUFTLENBQUE7O01BQ3BDLElBQU1nTixNQUFNLEdBQU94RCxjQUFBQSxDQUFBQSxFQUFBQSxFQUFBQSxXQUFQLENBQVosQ0FBQTs7RUFDQSxJQUFBLElBQU1DLFVBQVUsR0FBQSxrQkFBQSxDQUFPdUQsTUFBTSxDQUFDdkQsVUFBZCxDQUFoQixDQUFBOztFQUNBLElBQUEsSUFBSUUsWUFBWSxHQUFBLGtCQUFBLENBQU9xRCxNQUFNLENBQUNyRCxZQUFkLENBQWhCLENBQUE7RUFFQTtFQUNKO0VBQ0E7RUFDQTtFQUNBOzs7RUFDSSxJQUFBLElBQU13RCxJQUFJLEdBQUd4RCxZQUFZLENBQ3RCL0osTUFEVSxDQUNILFVBQUExRSxDQUFDLEVBQUE7RUFBQSxNQUFBLE9BQUlBLENBQUMsQ0FBQzJGLElBQUYsS0FBVyxLQUFmLENBQUE7RUFBQSxLQURFLEVBRVZnQixNQUZILENBQUE7O0VBSUEsSUFBQSxJQUFJc0wsSUFBSSxHQUFHLENBQVAsSUFBWTFELFVBQVUsQ0FBQzVILE1BQTNCLEVBQW1DO1FBQ2pDdUwsT0FBTyxDQUFDQyxJQUFSLENBQWEsNkJBQWIsQ0FBQSxDQUFBO0VBQ0EsTUFBQSxPQUFPTCxNQUFQLENBQUE7RUFDRCxLQUFBOztFQUVELElBQUEsSUFBTUMsT0FBTyxHQUFHO0VBQ2RwTSxNQUFBQSxJQUFJLEVBQUUsS0FEUTtFQUVkYixNQUFBQSxHQUFHLEVBQUhBLEdBRmM7RUFHZHZKLE1BQUFBLE9BQU8sRUFBUEEsT0FBQUE7T0FIRixDQUFBO0VBTUFrVCxJQUFBQSxZQUFZLEdBQ1BBLEVBQUFBLENBQUFBLE1BQUFBLENBQUFBLGtCQUFBQSxDQUFBQSxZQURPLENBRVZzRCxFQUFBQSxDQUFBQSxPQUZVLENBQVosQ0FBQSxDQUFBO01BS0EsT0FBTztFQUNMeEQsTUFBQUEsVUFBVSxFQUFWQSxVQURLO0VBRUxFLE1BQUFBLFlBQVksRUFBWkEsWUFBQUE7T0FGRixDQUFBO0tBaEhXO0lBc0hiMkQsUUFBUSxFQUFFLFNBQUM5RCxRQUFBQSxDQUFBQSxXQUFELEVBQWlCO01BQ3pCLElBQU13RCxNQUFNLEdBQU94RCxjQUFBQSxDQUFBQSxFQUFBQSxFQUFBQSxXQUFQLENBQVosQ0FBQTs7RUFDQSxJQUFBLElBQUlDLFVBQVUsR0FBQSxrQkFBQSxDQUFPdUQsTUFBTSxDQUFDdkQsVUFBZCxDQUFkLENBQUE7O0VBQ0EsSUFBQSxJQUFNRSxZQUFZLEdBQUEsa0JBQUEsQ0FBT3FELE1BQU0sQ0FBQ3JELFlBQWQsQ0FBbEIsQ0FBQTs7RUFFQSxJQUFBLElBQU00RCxJQUFJLEdBQUc1RCxZQUFZLENBQUM2RCxLQUFiLEVBQWIsQ0FBQTtFQUNBLElBQUEsSUFBTTNNLElBQUksR0FBRzBNLElBQUksQ0FBQzFNLElBQWxCLENBQUE7RUFDQSxJQUFBLElBQUlpRCxLQUFLLEdBQUd5SixJQUFJLENBQUN6SixLQUFqQixDQUFBOztNQUVBLElBQUlqRCxJQUFJLEtBQUssTUFBYixFQUFxQjtRQUNuQixJQUFJaUQsS0FBSyxLQUFLLElBQWQsRUFBb0I7RUFDbEIyRixRQUFBQSxVQUFVLEdBQ0xBLEVBQUFBLENBQUFBLE1BQUFBLENBQUFBLGtCQUFBQSxDQUFBQSxVQURLLENBRVIzRixFQUFBQSxDQUFBQSxLQUZRLENBQVYsQ0FBQSxDQUFBO0VBSUQsT0FBQTtFQUNGLEtBUEQsTUFPTyxJQUFJakQsSUFBSSxLQUFLLE9BQWIsRUFBc0I7RUFDM0IsTUFBQSxJQUFJLENBQUMrSSxLQUFLLENBQUNDLE9BQU4sQ0FBYy9GLEtBQWQsQ0FBTCxFQUEyQkEsS0FBSyxHQUFHLENBQUNBLEtBQUQsQ0FBUixDQUFBO0VBQzNCMkYsTUFBQUEsVUFBVSxHQUFHM0YsS0FBYixDQUFBO0VBQ0QsS0FITSxNQUdBLElBQUlqRCxJQUFJLEtBQUssU0FBYixFQUF3QjtFQUM3QjRJLE1BQUFBLFVBQVUsQ0FBQ25GLEdBQVgsRUFBQSxDQUFBO1FBQ0FtRixVQUFVLENBQUNwSCxJQUFYLENBQWdCeUIsS0FBaEIsQ0FBQSxDQUFBO0VBQ0QsS0FBQTs7TUFFRCxPQUFPO0VBQ0wyRixNQUFBQSxVQUFVLEVBQVZBLFVBREs7RUFFTEUsTUFBQUEsWUFBWSxFQUFaQSxZQUFBQTtPQUZGLENBQUE7S0E5SVc7SUFvSmI4RCxPQUFPLEVBQUUsU0FBQ2pFLE9BQUFBLENBQUFBLFdBQUQsRUFBaUI7TUFDeEIsSUFBTXdELE1BQU0sR0FBT3hELGNBQUFBLENBQUFBLEVBQUFBLEVBQUFBLFdBQVAsQ0FBWixDQUFBOztFQUNBLElBQUEsSUFBSUMsVUFBVSxHQUFBLGtCQUFBLENBQU91RCxNQUFNLENBQUN2RCxVQUFkLENBQWQsQ0FBQTs7RUFDQSxJQUFBLElBQUlFLFlBQVksR0FBQSxrQkFBQSxDQUFPcUQsTUFBTSxDQUFDckQsWUFBZCxDQUFoQixDQUFBOztFQUNBRixJQUFBQSxVQUFVLEdBQUdBLFVBQVUsQ0FBQ3ZULEtBQVgsQ0FBaUIsQ0FBakIsRUFBb0J1VCxVQUFVLENBQUM1SCxNQUFYLEdBQW9CLENBQXhDLENBQWIsQ0FBQTtFQUNBOEgsSUFBQUEsWUFBWSxHQUFHQSxZQUFZLENBQUN6VCxLQUFiLENBQW1CLENBQW5CLENBQWYsQ0FBQTtNQUVBLE9BQU87RUFDTHVULE1BQUFBLFVBQVUsRUFBVkEsVUFESztFQUVMRSxNQUFBQSxZQUFZLEVBQVpBLFlBQUFBO09BRkYsQ0FBQTtFQUlELEdBQUE7RUEvSlksQ0FBZjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzsifQ==
