'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; }

var _domHelpersQueryOffset = require('dom-helpers/query/offset');

var _domHelpersQueryOffset2 = _interopRequireDefault(_domHelpersQueryOffset);

var _domHelpersUtilRequestAnimationFrame = require('dom-helpers/util/requestAnimationFrame');

var _domHelpersUtilRequestAnimationFrame2 = _interopRequireDefault(_domHelpersUtilRequestAnimationFrame);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibMountable = require('react-prop-types/lib/mountable');

var _reactPropTypesLibMountable2 = _interopRequireDefault(_reactPropTypesLibMountable);

var _Affix = require('./Affix');

var _Affix2 = _interopRequireDefault(_Affix);

var _utilsAddEventListener = require('./utils/addEventListener');

var _utilsAddEventListener2 = _interopRequireDefault(_utilsAddEventListener);

var _utilsGetContainer = require('./utils/getContainer');

var _utilsGetContainer2 = _interopRequireDefault(_utilsGetContainer);

var _utilsGetDocumentHeight = require('./utils/getDocumentHeight');

var _utilsGetDocumentHeight2 = _interopRequireDefault(_utilsGetDocumentHeight);

var _utilsOwnerDocument = require('./utils/ownerDocument');

var _utilsOwnerDocument2 = _interopRequireDefault(_utilsOwnerDocument);

var _utilsOwnerWindow = require('./utils/ownerWindow');

var _utilsOwnerWindow2 = _interopRequireDefault(_utilsOwnerWindow);

/**
 * The `<AutoAffix/>` component wraps `<Affix/>` to automatically calculate
 * offsets in many common cases.
 */

var AutoAffix = (function (_React$Component) {
  function AutoAffix(props, context) {
    _classCallCheck(this, AutoAffix);

    _React$Component.call(this, props, context);

    this.state = {
      offsetTop: null,
      offsetBottom: null,
      width: null
    };
  }

  _inherits(AutoAffix, _React$Component);

  AutoAffix.prototype.componentDidMount = function componentDidMount() {
    var _this = this;

    this._isMounted = true;

    this._windowScrollListener = _utilsAddEventListener2['default'](_utilsOwnerWindow2['default'](this), 'scroll', function () {
      return _this.onWindowScroll();
    });
    this._documentClickListener = _utilsAddEventListener2['default'](_utilsOwnerDocument2['default'](this), 'click', function () {
      return _this.onDocumentClick();
    });

    this.onUpdate();
  };

  AutoAffix.prototype.componentWillReceiveProps = function componentWillReceiveProps() {
    this._needPositionUpdate = true;
  };

  AutoAffix.prototype.componentDidUpdate = function componentDidUpdate() {
    if (this._needPositionUpdate) {
      this._needPositionUpdate = false;
      this.onUpdate();
    }
  };

  AutoAffix.prototype.componentWillUnmount = function componentWillUnmount() {
    this._isMounted = false;

    if (this._windowScrollListener) {
      this._windowScrollListener.remove();
    }
    if (this._documentClickListener) {
      this._documentClickListener.remove();
    }
  };

  AutoAffix.prototype.onWindowScroll = function onWindowScroll() {
    this.onUpdate();
  };

  AutoAffix.prototype.onDocumentClick = function onDocumentClick() {
    var _this2 = this;

    _domHelpersUtilRequestAnimationFrame2['default'](function () {
      return _this2.onUpdate();
    });
  };

  AutoAffix.prototype.onUpdate = function onUpdate() {
    if (!this._isMounted) {
      return;
    }

    var _getOffset = _domHelpersQueryOffset2['default'](this.refs.positioner);

    var offsetTop = _getOffset.top;
    var width = _getOffset.width;

    var container = _utilsGetContainer2['default'](this.props.container);
    var offsetBottom = undefined;
    if (container) {
      var documentHeight = _utilsGetDocumentHeight2['default'](_utilsOwnerDocument2['default'](this));

      var _getOffset2 = _domHelpersQueryOffset2['default'](container);

      var _top = _getOffset2.top;
      var height = _getOffset2.height;

      offsetBottom = documentHeight - _top - height;
    } else {
      offsetBottom = null;
    }

    this.updateState(offsetTop, offsetBottom, width);
  };

  AutoAffix.prototype.updateState = function updateState(offsetTop, offsetBottom, width) {
    if (offsetTop === this.state.offsetTop && offsetBottom === this.state.offsetBottom && width === this.state.width) {
      return;
    }

    this.setState({ offsetTop: offsetTop, offsetBottom: offsetBottom, width: width });
  };

  AutoAffix.prototype.render = function render() {
    var _props = this.props;
    var container = _props.container;
    var autoWidth = _props.autoWidth;
    var viewportOffsetTop = _props.viewportOffsetTop;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['container', 'autoWidth', 'viewportOffsetTop', 'children']);

    var _state = this.state;
    var offsetTop = _state.offsetTop;
    var offsetBottom = _state.offsetBottom;
    var width = _state.width;

    var effectiveOffsetTop = Math.max(offsetTop, viewportOffsetTop || 0);

    var _props2 = this.props;
    var affixStyle = _props2.affixStyle;
    var bottomStyle = _props2.bottomStyle;

    if (autoWidth) {
      affixStyle = _extends({ width: width }, affixStyle);
      bottomStyle = _extends({ width: width }, bottomStyle);
    }

    return _react2['default'].createElement(
      'div',
      null,
      _react2['default'].createElement('div', { ref: 'positioner' }),
      _react2['default'].createElement(
        _Affix2['default'],
        _extends({
          offsetTop: effectiveOffsetTop,
          viewportOffsetTop: viewportOffsetTop,
          offsetBottom: offsetBottom,
          affixStyle: affixStyle,
          bottomStyle: bottomStyle
        }, props),
        children
      )
    );
  };

  return AutoAffix;
})(_react2['default'].Component);

AutoAffix.propTypes = _extends({}, _Affix2['default'].propTypes, {
  /**
   * The logical container node or component for determining offset from bottom
   * of viewport, or a function that returns it
   */
  container: _react2['default'].PropTypes.oneOfType([_reactPropTypesLibMountable2['default'], _react2['default'].PropTypes.func]),
  /**
   * Automatically set width when affixed
   */
  autoWidth: _react2['default'].PropTypes.bool
});

// This intentionally doesn't inherit default props from `<Affix>`, so that the
// auto-calculated offsets can apply.
AutoAffix.defaultProps = {
  autoWidth: true
};

exports['default'] = AutoAffix;
module.exports = exports['default'];