'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; }

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _domHelpersQueryHeight = require('dom-helpers/query/height');

var _domHelpersQueryHeight2 = _interopRequireDefault(_domHelpersQueryHeight);

var _domHelpersQueryOffset = require('dom-helpers/query/offset');

var _domHelpersQueryOffset2 = _interopRequireDefault(_domHelpersQueryOffset);

var _domHelpersQueryOffsetParent = require('dom-helpers/query/offsetParent');

var _domHelpersQueryOffsetParent2 = _interopRequireDefault(_domHelpersQueryOffsetParent);

var _domHelpersQueryScrollTop = require('dom-helpers/query/scrollTop');

var _domHelpersQueryScrollTop2 = _interopRequireDefault(_domHelpersQueryScrollTop);

var _domHelpersUtilRequestAnimationFrame = require('dom-helpers/util/requestAnimationFrame');

var _domHelpersUtilRequestAnimationFrame2 = _interopRequireDefault(_domHelpersUtilRequestAnimationFrame);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _utilsAddEventListener = require('./utils/addEventListener');

var _utilsAddEventListener2 = _interopRequireDefault(_utilsAddEventListener);

var _utilsGetDocumentHeight = require('./utils/getDocumentHeight');

var _utilsGetDocumentHeight2 = _interopRequireDefault(_utilsGetDocumentHeight);

var _utilsOwnerDocument = require('./utils/ownerDocument');

var _utilsOwnerDocument2 = _interopRequireDefault(_utilsOwnerDocument);

var _utilsOwnerWindow = require('./utils/ownerWindow');

var _utilsOwnerWindow2 = _interopRequireDefault(_utilsOwnerWindow);

/**
 * The `<Affix/>` component toggles `position: fixed;` on and off, emulating
 * the effect found with `position: sticky;`.
 */

var Affix = (function (_React$Component) {
  function Affix(props, context) {
    _classCallCheck(this, Affix);

    _React$Component.call(this, props, context);

    this.state = {
      affixed: 'top',
      position: null,
      top: null
    };

    this._needPositionUpdate = false;
  }

  _inherits(Affix, _React$Component);

  Affix.prototype.componentDidMount = function componentDidMount() {
    var _this = this;

    this._isMounted = true;

    this._windowScrollListener = _utilsAddEventListener2['default'](_utilsOwnerWindow2['default'](this), 'scroll', function () {
      return _this.onWindowScroll();
    });
    this._documentClickListener = _utilsAddEventListener2['default'](_utilsOwnerDocument2['default'](this), 'click', function () {
      return _this.onDocumentClick();
    });

    this.onUpdate();
  };

  Affix.prototype.componentWillReceiveProps = function componentWillReceiveProps() {
    this._needPositionUpdate = true;
  };

  Affix.prototype.componentDidUpdate = function componentDidUpdate() {
    if (this._needPositionUpdate) {
      this._needPositionUpdate = false;
      this.onUpdate();
    }
  };

  Affix.prototype.componentWillUnmount = function componentWillUnmount() {
    this._isMounted = false;

    if (this._windowScrollListener) {
      this._windowScrollListener.remove();
    }
    if (this._documentClickListener) {
      this._documentClickListener.remove();
    }
  };

  Affix.prototype.onWindowScroll = function onWindowScroll() {
    this.onUpdate();
  };

  Affix.prototype.onDocumentClick = function onDocumentClick() {
    var _this2 = this;

    _domHelpersUtilRequestAnimationFrame2['default'](function () {
      return _this2.onUpdate();
    });
  };

  Affix.prototype.onUpdate = function onUpdate() {
    var _this3 = this;

    if (!this._isMounted) {
      return;
    }

    var _props = this.props;
    var offsetTop = _props.offsetTop;
    var viewportOffsetTop = _props.viewportOffsetTop;

    var scrollTop = _domHelpersQueryScrollTop2['default'](_utilsOwnerWindow2['default'](this));
    var positionTopMin = scrollTop + (viewportOffsetTop || 0);

    if (positionTopMin <= offsetTop) {
      this.updateState('top', null, null);
      return;
    }

    if (positionTopMin > this.getPositionTopMax()) {
      if (this.state.affixed === 'bottom') {
        this.updateStateAtBottom();
      } else {
        // Setting position away from `fixed` can change the offset parent of
        // the affix, so we can't calculate the correct position until after
        // we've updated its position.
        this.setState({
          affixed: 'bottom',
          position: 'absolute',
          top: null
        }, function () {
          if (!_this3._isMounted) {
            return;
          }

          _this3.updateStateAtBottom();
        });
      }
      return;
    }

    this.updateState('affix', 'fixed', viewportOffsetTop);
  };

  Affix.prototype.getPositionTopMax = function getPositionTopMax() {
    var documentHeight = _utilsGetDocumentHeight2['default'](_utilsOwnerDocument2['default'](this));
    var height = _domHelpersQueryHeight2['default'](_reactDom2['default'].findDOMNode(this));

    return documentHeight - height - this.props.offsetBottom;
  };

  Affix.prototype.updateState = function updateState(affixed, position, top) {
    var _this4 = this;

    if (affixed === this.state.affixed && position === this.state.position && top === this.state.top) {
      return;
    }

    var upperName = affixed === 'affix' ? '' : affixed.charAt(0).toUpperCase() + affixed.substr(1);

    if (this.props['onAffix' + upperName]) {
      this.props['onAffix' + upperName]();
    }

    this.setState({ affixed: affixed, position: position, top: top }, function () {
      if (_this4.props['onAffixed' + upperName]) {
        _this4.props['onAffixed' + upperName]();
      }
    });
  };

  Affix.prototype.updateStateAtBottom = function updateStateAtBottom() {
    var positionTopMax = this.getPositionTopMax();
    var offsetParent = _domHelpersQueryOffsetParent2['default'](_reactDom2['default'].findDOMNode(this));
    var parentTop = _domHelpersQueryOffset2['default'](offsetParent).top;

    this.updateState('bottom', 'absolute', positionTopMax - parentTop);
  };

  Affix.prototype.render = function render() {
    var child = _react2['default'].Children.only(this.props.children);
    var _child$props = child.props;
    var className = _child$props.className;
    var style = _child$props.style;
    var _state = this.state;
    var affixed = _state.affixed;
    var position = _state.position;
    var top = _state.top;

    var positionStyle = { position: position, top: top };

    var affixClassName = undefined;
    var affixStyle = undefined;
    if (affixed === 'top') {
      affixClassName = this.props.topClassName;
      affixStyle = this.props.topStyle;
    } else if (affixed === 'bottom') {
      affixClassName = this.props.bottomClassName;
      affixStyle = this.props.bottomStyle;
    } else {
      affixClassName = this.props.affixClassName;
      affixStyle = this.props.affixStyle;
    }

    return _react2['default'].cloneElement(child, {
      className: _classnames2['default'](affixClassName, className),
      style: _extends({}, positionStyle, affixStyle, style)
    });
  };

  return Affix;
})(_react2['default'].Component);

Affix.propTypes = {
  /**
   * Pixels to offset from top of screen when calculating position
   */
  offsetTop: _react2['default'].PropTypes.number,
  /**
   * When affixed, pixels to offset from top of viewport
   */
  viewportOffsetTop: _react2['default'].PropTypes.number,
  /**
   * Pixels to offset from bottom of screen when calculating position
   */
  offsetBottom: _react2['default'].PropTypes.number,
  /**
   * CSS class or classes to apply when at top
   */
  topClassName: _react2['default'].PropTypes.string,
  /**
   * Style to apply when at top
   */
  topStyle: _react2['default'].PropTypes.object,
  /**
   * CSS class or classes to apply when affixed
   */
  affixClassName: _react2['default'].PropTypes.string,
  /**
   * Style to apply when affixed
   */
  affixStyle: _react2['default'].PropTypes.object,
  /**
   * CSS class or classes to apply when at bottom
   */
  bottomClassName: _react2['default'].PropTypes.string,
  /**
   * Style to apply when at bottom
   */
  bottomStyle: _react2['default'].PropTypes.object,

  onAffix: _react2['default'].PropTypes.func,
  onAffixed: _react2['default'].PropTypes.func,
  onAffixTop: _react2['default'].PropTypes.func,
  onAffixedTop: _react2['default'].PropTypes.func,
  onAffixBottom: _react2['default'].PropTypes.func,
  onAffixedBottom: _react2['default'].PropTypes.func
};

Affix.defaultProps = {
  offsetTop: 0,
  viewportOffsetTop: null,
  offsetBottom: 0
};

exports['default'] = Affix;
module.exports = exports['default'];