"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

exports.__esModule = true;
exports.Value = exports.SubEntries = exports.LabelButton = exports.Label = exports.Info = exports.Expander = exports.Entry = exports.DefaultRenderer = void 0;
exports.chunkArray = chunkArray;
exports.default = Explorer;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _utils = require("./utils");

const Entry = (0, _utils.styled)('div', {
  fontFamily: 'Menlo, monospace',
  fontSize: '1em',
  lineHeight: '1.7',
  outline: 'none',
  wordBreak: 'break-word'
});
exports.Entry = Entry;
const Label = (0, _utils.styled)('span', {
  color: 'white'
});
exports.Label = Label;
const LabelButton = (0, _utils.styled)('button', {
  cursor: 'pointer',
  color: 'white'
});
exports.LabelButton = LabelButton;
const Value = (0, _utils.styled)('span', (_props, theme) => ({
  color: theme.danger
}));
exports.Value = Value;
const SubEntries = (0, _utils.styled)('div', {
  marginLeft: '.1em',
  paddingLeft: '1em',
  borderLeft: '2px solid rgba(0,0,0,.15)'
});
exports.SubEntries = SubEntries;
const Info = (0, _utils.styled)('span', {
  color: 'grey',
  fontSize: '.7em'
});
exports.Info = Info;

const Expander = ({
  expanded,
  style = {}
}) => /*#__PURE__*/_react.default.createElement("span", {
  style: {
    display: 'inline-block',
    transition: 'all .1s ease',
    transform: "rotate(" + (expanded ? 90 : 0) + "deg) " + (style.transform || ''),
    ...style
  }
}, "\u25B6");

exports.Expander = Expander;

/**
 * Chunk elements in the array by size
 *
 * when the array cannot be chunked evenly by size, the last chunk will be
 * filled with the remaining elements
 *
 * @example
 * chunkArray(['a','b', 'c', 'd', 'e'], 2) // returns [['a','b'], ['c', 'd'], ['e']]
 */
function chunkArray(array, size) {
  if (size < 1) return [];
  let i = 0;
  const result = [];

  while (i < array.length) {
    result.push(array.slice(i, i + size));
    i = i + size;
  }

  return result;
}

const DefaultRenderer = ({
  HandleEntry,
  label,
  value,
  subEntries = [],
  subEntryPages = [],
  type,
  expanded = false,
  toggleExpanded,
  pageSize
}) => {
  const [expandedPages, setExpandedPages] = _react.default.useState([]);

  return /*#__PURE__*/_react.default.createElement(Entry, {
    key: label
  }, subEntryPages.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
    onClick: () => toggleExpanded()
  }, /*#__PURE__*/_react.default.createElement(Expander, {
    expanded: expanded
  }), " ", label, ' ', /*#__PURE__*/_react.default.createElement(Info, null, String(type).toLowerCase() === 'iterable' ? '(Iterable) ' : '', subEntries.length, " ", subEntries.length > 1 ? "items" : "item")), expanded ? subEntryPages.length === 1 ? /*#__PURE__*/_react.default.createElement(SubEntries, null, subEntries.map(entry => /*#__PURE__*/_react.default.createElement(HandleEntry, {
    key: entry.label,
    entry: entry
  }))) : /*#__PURE__*/_react.default.createElement(SubEntries, null, subEntryPages.map((entries, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, /*#__PURE__*/_react.default.createElement(Entry, null, /*#__PURE__*/_react.default.createElement(LabelButton, {
    onClick: () => setExpandedPages(old => old.includes(index) ? old.filter(d => d !== index) : [...old, index])
  }, /*#__PURE__*/_react.default.createElement(Expander, {
    expanded: expanded
  }), " [", index * pageSize, " ...", ' ', index * pageSize + pageSize - 1, "]"), expandedPages.includes(index) ? /*#__PURE__*/_react.default.createElement(SubEntries, null, entries.map(entry => /*#__PURE__*/_react.default.createElement(HandleEntry, {
    key: entry.label,
    entry: entry
  }))) : null)))) : null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Label, null, label, ":"), " ", /*#__PURE__*/_react.default.createElement(Value, null, (0, _utils.displayValue)(value))));
};

exports.DefaultRenderer = DefaultRenderer;

function isIterable(x) {
  return Symbol.iterator in x;
}

function Explorer({
  value,
  defaultExpanded,
  renderer = DefaultRenderer,
  pageSize = 100,
  ...rest
}) {
  const [expanded, setExpanded] = _react.default.useState(Boolean(defaultExpanded));

  const toggleExpanded = _react.default.useCallback(() => setExpanded(old => !old), []);

  let type = typeof value;
  let subEntries = [];

  const makeProperty = sub => {
    const subDefaultExpanded = defaultExpanded === true ? {
      [sub.label]: true
    } : defaultExpanded == null ? void 0 : defaultExpanded[sub.label];
    return { ...sub,
      defaultExpanded: subDefaultExpanded
    };
  };

  if (Array.isArray(value)) {
    type = 'array';
    subEntries = value.map((d, i) => makeProperty({
      label: i.toString(),
      value: d
    }));
  } else if (value !== null && typeof value === 'object' && isIterable(value) && typeof value[Symbol.iterator] === 'function') {
    type = 'Iterable';
    subEntries = Array.from(value, (val, i) => makeProperty({
      label: i.toString(),
      value: val
    }));
  } else if (typeof value === 'object' && value !== null) {
    type = 'object';
    subEntries = Object.entries(value).map(([key, val]) => makeProperty({
      label: key,
      value: val
    }));
  }

  const subEntryPages = chunkArray(subEntries, pageSize);
  return renderer({
    HandleEntry: ({
      entry
    }) => /*#__PURE__*/_react.default.createElement(Explorer, (0, _extends2.default)({
      value: value,
      renderer: renderer
    }, rest, entry)),
    type,
    subEntries,
    subEntryPages,
    value,
    expanded,
    toggleExpanded,
    pageSize,
    ...rest
  });
}