"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

exports.__esModule = true;
exports.ThemeProvider = ThemeProvider;
exports.defaultTheme = void 0;
exports.useTheme = useTheme;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

const defaultTheme = {
  background: '#0b1521',
  backgroundAlt: '#132337',
  foreground: 'white',
  gray: '#3f4e60',
  grayAlt: '#222e3e',
  inputBackgroundColor: '#fff',
  inputTextColor: '#000',
  success: '#00ab52',
  danger: '#ff0085',
  active: '#006bff',
  paused: '#8c49eb',
  warning: '#ffb200'
};
exports.defaultTheme = defaultTheme;

const ThemeContext = /*#__PURE__*/_react.default.createContext(defaultTheme);

function ThemeProvider({
  theme,
  ...rest
}) {
  return /*#__PURE__*/_react.default.createElement(ThemeContext.Provider, (0, _extends2.default)({
    value: theme
  }, rest));
}

function useTheme() {
  return _react.default.useContext(ThemeContext);
}