"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

exports.__esModule = true;
exports.displayValue = void 0;
exports.getQueryStatusColor = getQueryStatusColor;
exports.getQueryStatusLabel = getQueryStatusLabel;
exports.isServer = void 0;
exports.styled = styled;
exports.useIsMounted = useIsMounted;

var _react = _interopRequireDefault(require("react"));

var _theme = require("./theme");

var _useMediaQuery = _interopRequireDefault(require("./useMediaQuery"));

const isServer = typeof window === 'undefined';
exports.isServer = isServer;

function getQueryStatusColor({
  queryState,
  observerCount,
  isStale,
  theme
}) {
  return queryState.fetchStatus === 'fetching' ? theme.active : !observerCount ? theme.gray : queryState.fetchStatus === 'paused' ? theme.paused : isStale ? theme.warning : theme.success;
}

function getQueryStatusLabel(query) {
  return query.state.fetchStatus === 'fetching' ? 'fetching' : !query.getObserversCount() ? 'inactive' : query.state.fetchStatus === 'paused' ? 'paused' : query.isStale() ? 'stale' : 'fresh';
}

function styled(type, newStyles, queries = {}) {
  return /*#__PURE__*/_react.default.forwardRef(({
    style,
    ...rest
  }, ref) => {
    const theme = (0, _theme.useTheme)();
    const mediaStyles = Object.entries(queries).reduce((current, [key, value]) => {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      return (0, _useMediaQuery.default)(key) ? { ...current,
        ...(typeof value === 'function' ? value(rest, theme) : value)
      } : current;
    }, {});
    return /*#__PURE__*/_react.default.createElement(type, { ...rest,
      style: { ...(typeof newStyles === 'function' ? newStyles(rest, theme) : newStyles),
        ...style,
        ...mediaStyles
      },
      ref
    });
  });
}

function useIsMounted() {
  const mountedRef = _react.default.useRef(false);

  const isMounted = _react.default.useCallback(() => mountedRef.current, []);

  _react.default[isServer ? 'useEffect' : 'useLayoutEffect'](() => {
    mountedRef.current = true;
    return () => {
      mountedRef.current = false;
    };
  }, []);

  return isMounted;
}
/**
 * Displays a string regardless the type of the data
 * @param {unknown} value Value to be stringified
 */


const displayValue = value => {
  const name = Object.getOwnPropertyNames(Object(value));
  const newValue = typeof value === 'bigint' ? value.toString() + "n" : value;
  return JSON.stringify(newValue, name);
};

exports.displayValue = displayValue;