"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

exports.__esModule = true;
exports.PersistQueryClientProvider = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _persist = require("./persist");

var _reactjs = require("../reactjs");

var _isRestoring = require("../reactjs/isRestoring");

const PersistQueryClientProvider = ({
  client,
  children,
  persistOptions,
  onSuccess,
  ...props
}) => {
  const [isRestoring, setIsRestoring] = _react.default.useState(true);

  const refs = _react.default.useRef({
    persistOptions,
    onSuccess
  });

  _react.default.useEffect(() => {
    refs.current = {
      persistOptions,
      onSuccess
    };
  });

  _react.default.useEffect(() => {
    let isStale = false;
    setIsRestoring(true);
    const [unsubscribe, promise] = (0, _persist.persistQueryClient)({ ...refs.current.persistOptions,
      queryClient: client
    });
    promise.then(() => {
      if (!isStale) {
        refs.current.onSuccess == null ? void 0 : refs.current.onSuccess();
        setIsRestoring(false);
      }
    });
    return () => {
      isStale = true;
      unsubscribe();
    };
  }, [client]);

  return /*#__PURE__*/_react.default.createElement(_reactjs.QueryClientProvider, (0, _extends2.default)({
    client: client
  }, props), /*#__PURE__*/_react.default.createElement(_isRestoring.IsRestoringProvider, {
    value: isRestoring
  }, children));
};

exports.PersistQueryClientProvider = PersistQueryClientProvider;