"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

exports.__esModule = true;
exports.useQueryClient = exports.defaultContext = exports.QueryClientProvider = void 0;

var _react = _interopRequireDefault(require("react"));

const defaultContext = /*#__PURE__*/_react.default.createContext(undefined);

exports.defaultContext = defaultContext;

const QueryClientSharingContext = /*#__PURE__*/_react.default.createContext(false); // If we are given a context, we will use it.
// Otherwise, if contextSharing is on, we share the first and at least one
// instance of the context across the window
// to ensure that if React Query is used across
// different bundles or microfrontends they will
// all use the same **instance** of context, regardless
// of module scoping.


function getQueryClientContext(context, contextSharing) {
  if (context) {
    return context;
  }

  if (contextSharing && typeof window !== 'undefined') {
    if (!window.ReactQueryClientContext) {
      window.ReactQueryClientContext = defaultContext;
    }

    return window.ReactQueryClientContext;
  }

  return defaultContext;
}

const useQueryClient = ({
  context
} = {}) => {
  const queryClient = _react.default.useContext(getQueryClientContext(context, _react.default.useContext(QueryClientSharingContext)));

  if (!queryClient) {
    throw new Error('No QueryClient set, use QueryClientProvider to set one');
  }

  return queryClient;
};

exports.useQueryClient = useQueryClient;

const QueryClientProvider = ({
  client,
  children,
  context,
  contextSharing = false
}) => {
  _react.default.useEffect(() => {
    client.mount();
    return () => {
      client.unmount();
    };
  }, [client]);

  const Context = getQueryClientContext(context, contextSharing);
  return /*#__PURE__*/_react.default.createElement(QueryClientSharingContext.Provider, {
    value: !context && contextSharing
  }, /*#__PURE__*/_react.default.createElement(Context.Provider, {
    value: client
  }, children));
};

exports.QueryClientProvider = QueryClientProvider;