"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

exports.__esModule = true;
exports.useQueryErrorResetBoundary = exports.QueryErrorResetBoundary = void 0;

var _react = _interopRequireDefault(require("react"));

function createValue() {
  let isReset = false;
  return {
    clearReset: () => {
      isReset = false;
    },
    reset: () => {
      isReset = true;
    },
    isReset: () => {
      return isReset;
    }
  };
}

const QueryErrorResetBoundaryContext = /*#__PURE__*/_react.default.createContext(createValue()); // HOOK


const useQueryErrorResetBoundary = () => _react.default.useContext(QueryErrorResetBoundaryContext); // COMPONENT


exports.useQueryErrorResetBoundary = useQueryErrorResetBoundary;

const QueryErrorResetBoundary = ({
  children
}) => {
  const [value] = _react.default.useState(() => createValue());

  return /*#__PURE__*/_react.default.createElement(QueryErrorResetBoundaryContext.Provider, {
    value: value
  }, typeof children === 'function' ? children(value) : children);
};

exports.QueryErrorResetBoundary = QueryErrorResetBoundary;