/*
* work - Bar.js
* Copyright(c) 2015 xeodou <xeodou@gmail.com>
* MIT Licensed
*/

var React = require('react');
var PropTypes = React.PropTypes;
var emptyFunction = require('react/lib/emptyFunction');

var Bar = React.createClass({

  displayName: 'RangeSliderCursor',

  propTypes: {
    axis: PropTypes.oneOf(['X', 'Y']),
    offset: PropTypes.number,
    onClick: PropTypes.func,
    className: PropTypes.string
  },

  getDefaultProps: function () {
    return {
      axis: 'X',
      offset: 0,
      key: 0,
      className: null,
      onClick: emptyFunction
    };
  },

  renderBar: function (from, to, i) {
    var style = {
      position: 'absolute',
      backgroundColor: this.state.value.length > 0 ? this.state.value[i].color : null
    };
    style[this.state.minProp] = from;
    style[this.state.maxProp] = this.state.upperBound - to;
    return React.createElement('div', {
      key: 'bar' + i,
      ref: 'bar' + i,
      className: 'bar bar-' + i + (this.state.clicked === i ? ' active' : ''),
      style: style,
      onClick: this.handleBarClick.bind(this, i)
    });
  },

  render: function () {
    return (
      React.createElement('div', this.props)
    );
  }

});

module.exports = Bar;
