import React, { Component } from "react";
import ReactDOM from "react-dom";
import _ from "lodash";

import { createStore, applyMiddleware, combineReducers, compose } from "redux";
import { Provider, connect } from "react-redux";
// import { Form, Control, Errors, combineForms, actions } from 'react-redux-form'
import thunk from "redux-thunk";
import createLogger from "redux-logger";
// import RxForm from 'rxform';

// console.log(RxForm);

// const logger = createLogger();

import {
  Field,
  Fieldset,
  Errors,
  Control,
  Form,
  LocalForm,
  combineForms,
  actions,
  formReducer,
  modeled,
  controls
} from "react-redux-form";

const logger = createLogger({
  collapsed: true,
  level: 'info',
  logger: console,
});
const initialUserState = {
  firstName: '',
  lastName: '',
};

const initialAdminState = {
  firstName: '',
  lastName: '',
};

const store = createStore(combineForms({
  user: initialUserState,
  admin: initialAdminState,
}), applyMiddleware(thunk, logger));

class UserForm extends Component {

  componentWillUnmount() {
    console.log('resetting...');
    this.props.dispatch(actions.reset('user'));
  }

  render() {
    return (
      <Form model="user" onSubmit={v => console.log(v)}>
        <div className="field">
          <label>First name:</label>
          <Control.text model="user.firstName" debounce={300} />
        </div>

        <div className="field">
          <label>Last name:</label>
          <Control.text model="user.lastName" debounce={300} />
        </div>

        <span>I'm the User form</span>

      </Form>
    )
  }
}

const ConnectedUserForm = connect()(UserForm);

class AdminForm extends React.Component {
  componentWillUnmount() {
    this.props.dispatch(actions.reset('admin'));
  }

  render() {
    return (
      <Form model="admin" onSubmit={v => console.log(v)}>
        <div className="field">
          <label>First Name</label>
          <Control.text model="admin.firstName" debounce={300} />
        </div>

        <div className="field">
          <label>Last Name</label>
          <Control.text model="admin.lastName" debounce={300} />
        </div>

        <span>I'm the Admin form</span>
      </Form>
    )
  }
}

const ConnectedAdminForm = connect()(AdminForm);

class FormSwitcher extends React.Component {
  constructor() {
    super();

    this.state = {
      form: 'User',
    }
    this.toggle = this.toggle.bind(this);
    this.renderForm = this.renderForm.bind(this);
  }

  toggle(form) {
    this.setState({ form });
  }

  renderForm() {
    const options = {
      'User': <ConnectedUserForm />,
      'Admin': <ConnectedAdminForm />,
    }
    return options[this.state.form];
  }

  render() {
    return (
      <div>
        <div>{this.renderForm()}</div>
        {
          this.state.form === 'User'
          ? <button onClick={() => this.setState({ form: 'Admin' })}>Switch Form</button>
          : <button onClick={() => this.setState({ form: 'User' })}>Switch Form</button>
        }
      </div>
    )
  }
}

class App extends React.Component {
  render() {
    return (
      <LocalForm onSubmit={v => console.log(v)}>
        <Control.text model=".name" validators={{
          required: () => false
        }} />
        <Errors model=".name" messages={{
          required: 'this is required!'
        }} show="touched"/>
        <button>Submit</button>
      </LocalForm>
    );
  }
}

ReactDOM.render(<App />, document.getElementById('app'));
