import React, { Component } from "react";
import ReactDOM from "react-dom";
import _ from "lodash";

import { createStore, applyMiddleware, combineReducers, compose } from "redux";
import { Provider, connect } from "react-redux";
// import { Form, Control, Errors, combineForms, actions } from 'react-redux-form'
import thunk from "redux-thunk";
import createLogger from "redux-logger";
// import RxForm from 'rxform';

// console.log(RxForm);

const logger = createLogger();

import {
  Field,
  Fieldset,
  Errors,
  Control,
  Form,
  LocalForm,
  combineForms,
  actions,
  formReducer,
  modeled,
  controls
} from "react-redux-form";

// ========================================
// ========================================

const initialUserState = {
  firstName: '',
  lastName: ''
};

const store = createStore(
  combineForms({
    user: initialUserState
  }),
  applyMiddleware(thunk, logger)
);

class UserForm extends Component {
  render() {
    return (
      <Form model="user" onSubmit={this.handleSubmit}>
        <Errors model="user" show={true} />

        <div className="field">
          <label>First name:</label>
          <Control.text model="user.firstName" />
        </div>

        <div className="field">
          <label>Last name:</label>
          <Control.text model="user.lastName" />
        </div>

        <button type="submit">Submit (check console)</button>
      </Form>
    );
  }

  constructor(props) {
    super(props);
    this.handleSubmit = this.handleSubmit.bind(this);
  }

  handleSubmit(v) {
    console.log(v);
    const login$Q = () => {
      return new Promise((resolve, reject) => {
        setTimeout(() => reject('show this in errors field of user'), 500);
      });
    };
    const loginActionAsync = () => {
      return login$Q().catch(err => {
        console.log(err);
        return this.props.dispatch(
          actions.setErrors('user', { a: 'woo' }, { async: true })
        );
      });
    };
    const { dispatch } = this.props;
    dispatch(actions.submit('user', loginActionAsync()));
  }
}

const ConnectedUserForm = connect()(UserForm);

class App extends React.Component {
  render() {
    return (
      <Provider store={store}>
        <ConnectedUserForm />
      </Provider>
    );
  }
}

ReactDOM.render(<App />, document.getElementById('app'));
