import React, { Component, PropTypes } from 'react';
import ReactDOM from 'react-dom';
import {
  createStore,
  combineReducers,
  applyMiddleware
} from 'redux';
import { connect, Provider } from 'react-redux';
import {
  Form,
  Control,
  Errors,
  actions,
  combineForms,
} from 'react-redux-form';
import thunk from 'redux-thunk';
import createLogger from 'redux-logger';

const isEmpty_ = (val) => !val;

const store = createStore(combineForms({
  user: {
    username: '',
    items: []
  },
}), applyMiddleware(thunk, createLogger()));


const INITIAL_ITEM = {name: '', subitems: []};
const INITIAL_SUBITEM = {name: ''};
const isRequired = value => !isEmpty_(value);


class App extends Component {
  constructor(props) {
    super(props);
    
    this.onItemAdd = this.onItemAdd.bind(this);
    this.onSubItemAdd = this.onSubItemAdd.bind(this);
    this.onItemDelete = this.onItemDelete.bind(this);
    this.onSubmit = this.onSubmit.bind(this);
  }
  
  onItemDelete(itemIndex) {
    const { dispatch } = this.props;
    if (confirm("Delete?")) {
      dispatch(actions.remove('user.items', itemIndex));
    }
  }
  
  onItemAdd() {
    const { dispatch } = this.props;
    dispatch(actions.push('user.items', INITIAL_ITEM));
  }
  
  onSubmit(data) {
    console.error("################ handleSubmit(): %O ################", data);
  }
  
  onSubItemAdd(itemIndex) {
    const { dispatch } = this.props;
    dispatch(actions.push(`user.items[${itemIndex}].subitems`, INITIAL_SUBITEM));
  }
  
  render() {
    const { user } = this.props;
    
    return (
      <Form
        model="user"
        onSubmit={this.onSubmit}
      >
        <h2>User</h2>
        <label>Username:</label>
        
        <Control.text 
          model=".username" 
          validators={{isRequired}} />
          
        <Errors 
          show={true} 
          model=".username" 
          messages={{isRequired: "Please enter a name!"}}/>
        <br />
        
        <h3>Items</h3>
        {user.items.map((item, itemIndex) =>
          <div key={itemIndex} style={{backgroundColor: "#dddddd", margin: "10px"}}>
            <label>Name:</label>
            <Control.text 
              model={`user.items[${itemIndex}].name`}
              validators={{isRequired}} />
              
            <button 
              type="button"
              onClick={() => this.onItemDelete(itemIndex)}>Remove item</button>
              
            <Errors 
              show={true}
              model={`user.items[${itemIndex}].name`}
              messages={{isRequired: "Please enter a name!"}} />
            
            <div style={{backgroundColor: '#eee'}}>
              <h4>SubItems</h4>
              {item.subitems.map((subitem, subItemIndex) =>
                <div key={subItemIndex}>
                  <label>Name:</label>
                  
                  <Control.text 
                    model={`user.items[${itemIndex}].subitems[${subItemIndex}].name`}
                    validators={{isRequired}} />
                    
                  <Errors 
                    show={true}
                    model={`user.items[${itemIndex}].subitems[${subItemIndex}].name`}
                    messages={{isRequired: "Please enter a name!"}} />
                </div>
              )}
              <br />
              
              <button 
                type="button" 
                onClick={() => this.onSubItemAdd(itemIndex)}>Add subitem</button>
            </div>
          </div>
        )}
        
        <br />
        <button type="button" onClick={this.onItemAdd}>Add item</button>
        <br /><br /><br />
        <button type="submit">Submit!</button>
      </Form>
    );
  }
}

const mapStateToProps = state => ({
  user: state.user
});

const BoundApp = connect(mapStateToProps)(App);

ReactDOM.render(
  <Provider store={store}>
    <BoundApp />
  </Provider>
, document.querySelector('#app'));
