'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resetActionReducer;

var _actionTypes = require('../../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

var _updateField = require('../../utils/update-field');

var _updateField2 = _interopRequireDefault(_updateField);

var _mapValues = require('../../utils/map-values');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _initialFieldState = require('../../constants/initial-field-state');

var _initialFieldState2 = _interopRequireDefault(_initialFieldState);

var _icepick = require('icepick');

var _icepick2 = _interopRequireDefault(_icepick);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function resetActionReducer(state, action, localPath) {
  if (action.type !== _actionTypes2.default.RESET && action.type !== _actionTypes2.default.SET_INITIAL) {
    return state;
  }

  var resetFieldState = function resetFieldState(field) {
    if (field.$form) return (0, _mapValues2.default)(field, resetFieldState);

    return _icepick2.default.merge(_initialFieldState2.default, {
      value: field.initialValue,
      model: field.model
    });
  };

  return (0, _updateField2.default)(state, localPath, resetFieldState, resetFieldState);
}