'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setValidityActionReducer;

var _map = require('../../utils/map');

var _map2 = _interopRequireDefault(_map);

var _fieldActions = require('../../actions/field-actions');

var _fieldActions2 = _interopRequireDefault(_fieldActions);

var _actionTypes = require('../../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

var _isPlainObject = require('lodash/isPlainObject');

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

var _mapValues = require('../../utils/map-values');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _inverse = require('../../utils/inverse');

var _inverse2 = _interopRequireDefault(_inverse);

var _updateField2 = require('../../utils/update-field');

var _updateField3 = _interopRequireDefault(_updateField2);

var _toPath = require('../../utils/to-path');

var _toPath2 = _interopRequireDefault(_toPath);

var _isValid = require('../../form/is-valid');

var _isValid2 = _interopRequireDefault(_isValid);

var _isValidityValid = require('../../utils/is-validity-valid');

var _isValidityValid2 = _interopRequireDefault(_isValidityValid);

var _isValidityInvalid = require('../../utils/is-validity-invalid');

var _isValidityInvalid2 = _interopRequireDefault(_isValidityInvalid);

var _updateParentForms = require('../../utils/update-parent-forms');

var _updateParentForms2 = _interopRequireDefault(_updateParentForms);

var _get = require('../../utils/get');

var _get2 = _interopRequireDefault(_get);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function setValidityActionReducer(state, action, localPath) {
  var _updateField;

  if (action.type === _actionTypes2.default.SET_FIELDS_VALIDITY) {
    return (0, _map2.default)(action.fieldsValidity, function (fieldValidity, field) {
      return _fieldActions2.default.setValidity(field, fieldValidity, action.options);
    }).reduce(function (accState, subAction) {
      return setValidityActionReducer(accState, subAction, localPath.concat((0, _toPath2.default)(subAction.model)));
    }, state);
  }

  if (action.type === _actionTypes2.default.SET_VALIDATING) {
    return (0, _updateField3.default)(state, localPath, {
      validating: action.validating,
      validated: !action.validating
    });
  }

  if (action.type !== _actionTypes2.default.SET_VALIDITY && action.type !== _actionTypes2.default.SET_ERRORS) {
    return state;
  }

  var isErrors = action.type === _actionTypes2.default.SET_ERRORS;
  var validity = isErrors ? action.errors : action.validity;

  var inverseValidity = (0, _isPlainObject2.default)(validity) ? (0, _mapValues2.default)(validity, _inverse2.default) : !validity;

  var field = (0, _get2.default)(state, localPath);

  // If the field is a form, its validity is
  // also based on whether its fields are all valid.
  var areFieldsValid = field && field.$form ? (0, _isValid.fieldsValid)(field) : true;

  var newState = (0, _updateField3.default)(state, localPath, (_updateField = {}, _defineProperty(_updateField, isErrors ? 'errors' : 'validity', validity), _defineProperty(_updateField, isErrors ? 'validity' : 'errors', inverseValidity), _defineProperty(_updateField, 'validating', false), _defineProperty(_updateField, 'validated', true), _defineProperty(_updateField, 'valid', areFieldsValid && (isErrors ? !(0, _isValidityInvalid2.default)(validity) : (0, _isValidityValid2.default)(validity))), _updateField));

  return (0, _updateParentForms2.default)(newState, localPath, function (form) {
    return {
      valid: (0, _isValid2.default)(form)
    };
  });
}