'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelForm = undefined;

var _modelReducer = require('./model-reducer');

var _modelReducer2 = _interopRequireDefault(_modelReducer);

var _formReducer = require('./form-reducer');

var _formReducer2 = _interopRequireDefault(_formReducer);

var _redux = require('redux');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function modelFormReducer(model) {
  var initialState = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  var modelPath = model + '.model';

  return (0, _redux.combineReducers)({
    model: (0, _modelReducer2.default)(modelPath, initialState),
    form: (0, _formReducer2.default)(modelPath, initialState)
  });
}

function modelForm(model) {
  var initialState = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  return _defineProperty({}, model, modelFormReducer(model, initialState));
}

exports.modelForm = modelForm;
exports.default = modelFormReducer;