import React, { Component, PropTypes } from 'react';
import ReactDOM from 'react-dom';
import {
  createStore,
  combineReducers,
  applyMiddleware
} from 'redux';
import { connect, Provider } from 'react-redux';
import {
  Form,
  Control,
  actions,
  combineForms,
} from 'react-redux-form';
import thunk from 'redux-thunk';
import createLogger from 'redux-logger';



const store = createStore(combineForms({
  user: {
    anArray: []
  },
}), applyMiddleware(thunk, createLogger()));


// custom control that prints the dataArray and
// logs it to console
class CustomControl extends Component {
  render(){
    console.log('CustomControl value=', this.props.value)
    return <h3>{this.props.value.join(',')}</h3>
  }
}

let dataArray = []

class App extends Component {
  constructor() {
    super()

    // when the 'Reset Form' button is clicked
    // dispatch rrf/reset and clear dataArray
    this.onClickResetForm = () => {
      this.props.dispatch(
        actions.reset('user')
      )
      dataArray.length = 0
    }

    // when the 'Append' button is clicked
    // add 'item' to the dataArray array
    this.onClickAppend = () => {
      dataArray = [...dataArray, 'item']

      this.props.dispatch(
        actions.change('user.anArray', [...dataArray])
      )
    }
  }


  render() {
    return (
      <div>
      <Form
        model="user"
      >
        <label>Custom Control:</label>
        <Control
          component={CustomControl}
          model=".anArray"
          mapProps={{
            value: (props) => props.viewValue
          }}
        />
      </Form>

      <button onClick={this.onClickResetForm}>Reset Form</button>
      <button onClick={this.onClickAppend}>Append</button>
      </div>
    );
  }
}

App = connect()(App)

ReactDOM.render(
  <Provider store={store}>
    <App />
  </Provider>
, document.querySelector('#app'));
