'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = pendingActionReducer;

var _actionTypes = require('../../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

var _updateField = require('../../utils/update-field');

var _updateField2 = _interopRequireDefault(_updateField);

var _updateParentForms = require('../../utils/update-parent-forms');

var _updateParentForms2 = _interopRequireDefault(_updateParentForms);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function pendingActionReducer(state, action, localPath) {
  if (action.type !== _actionTypes2.default.SET_PENDING) {
    return state;
  }

  var newState = (0, _updateField2.default)(state, localPath, {
    pending: action.pending,
    submitted: false,
    submitFailed: false,
    retouched: false
  });

  return (0, _updateParentForms2.default)(newState, localPath, {
    pending: action.pending
  });
}