'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isNative = require('./is-native');

var _isNative2 = _interopRequireDefault(_isNative);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var currentFocusedModel = '';

function handleFocus(fieldValue, node) {
  if (!fieldValue || _isNative2.default) return;

  if (fieldValue.focus) {
    if (currentFocusedModel !== fieldValue.model) {
      if (document && document.activeElement !== node && node.focus) {
        currentFocusedModel = fieldValue.model;
        node.focus();
      }
    }
  }
}

handleFocus.clearCache = function () {
  return currentFocusedModel = '';
}; // eslint-disable-line no-return-assign

exports.default = handleFocus;