'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormStateKey = exports.pathStartsWith = exports.getModelPath = exports.invertValidity = exports.invertValidators = exports.getFieldFromState = exports.getForm = exports.isInvalid = exports.isValid = exports.getValidity = exports.getValue = exports.getEventValue = exports.isTouched = exports.isPristine = exports.isMulti = exports.isFocused = undefined;

var _endsWith = require('lodash/endsWith');

var _endsWith2 = _interopRequireDefault(_endsWith);

var _mapValues = require('../utils/map-values');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _isPlainObject = require('lodash/isPlainObject');

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

var _every = require('lodash/every');

var _every2 = _interopRequireDefault(_every);

var _some = require('lodash/some');

var _some2 = _interopRequireDefault(_some);

var _get2 = require('../utils/get');

var _get3 = _interopRequireDefault(_get2);

var _toPath = require('../utils/to-path');

var _toPath2 = _interopRequireDefault(_toPath);

var _pathStartsWith = require('../utils/path-starts-with');

var _pathStartsWith2 = _interopRequireDefault(_pathStartsWith);

var _memoize = require('lodash/memoize');

var _memoize2 = _interopRequireDefault(_memoize);

var _formReducer = require('../reducers/form-reducer');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function isMulti(model) {
  return (0, _endsWith2.default)(model, '[]');
}

function isFocused(field) {
  return field && field.focus;
}

function isPristine(field) {
  return field ? field.pristine : _formReducer.initialFieldState.pristine;
}

function isTouched(field) {
  return field ? field.touched : _formReducer.initialFieldState.touched;
}

function isEvent(event) {
  return !!(event && event.stopPropagation && event.preventDefault);
}

function getEventValue(event) {
  var target = event.target;


  if (!target) {
    if (!event.nativeEvent) {
      return undefined;
    }

    return event.nativeEvent.text;
  }

  if (target.type === 'file') {
    return [].concat(_toConsumableArray(target.files)) || target.dataTransfer && [].concat(_toConsumableArray(target.dataTransfer.files));
  }

  if (target.multiple) {
    return [].concat(_toConsumableArray(target.selectedOptions)).map(function (option) {
      return option.value;
    });
  }

  return target.value;
}

function getValue(value) {
  return isEvent(value) ? getEventValue(value) : value;
}

function getFormStateKey(state, model) {
  var currentPath = arguments.length <= 2 || arguments[2] === undefined ? '' : arguments[2];

  var deepCandidateKeys = [];
  var result = null;

  Object.keys(state).some(function (key) {
    var subState = state[key];

    if (subState && subState.model) {
      if ((0, _pathStartsWith2.default)(model, subState.model)) {
        result = currentPath ? [currentPath, key].join('.') : key;

        return true;
      }

      return false;
    }

    if ((0, _isPlainObject2.default)(subState)) {
      deepCandidateKeys.push(key);
    }

    return false;
  });

  if (result) return result;

  deepCandidateKeys.some(function (key) {
    result = getFormStateKey(state[key], model, currentPath ? [currentPath, key].join('.') : key);

    return !!result;
  });

  if (result) return result;

  return null;
}

var formStateKeyCaches = {};

function getFormStateKeyCached(state, model) {
  if (!formStateKeyCaches.hasOwnProperty(model)) {
    formStateKeyCaches[model] = new _memoize2.default.Cache();
  }

  var cache = formStateKeyCaches[model];
  if (cache.has(model)) {
    return cache.get(model);
  }

  var formStateKey = getFormStateKey(state, model);
  cache.set(model, formStateKey);
  return formStateKey;
}

function getForm(state, model) {
  var formStateKey = getFormStateKeyCached(state, model);

  return (0, _get3.default)(state, formStateKey);
}

function getFieldFromState(state, model) {
  var form = getForm(state, model);

  if (!form) return null;

  var formPath = (0, _toPath2.default)(form.model);
  var fieldPath = (0, _toPath2.default)(model).slice(formPath.length);

  return (0, _formReducer.getField)(form, fieldPath.length ? [fieldPath.join('.')] : []);
}

function getValidity(validators, value) {
  var modelValue = getValue(value);

  if (typeof validators === 'function') {
    return validators(modelValue);
  }

  return (0, _mapValues2.default)(validators, function (validator) {
    return getValidity(validator, modelValue);
  });
}

function invertValidators(validators) {
  if (typeof validators === 'function') {
    return function (val) {
      return !validators(val);
    };
  }

  return (0, _mapValues2.default)(validators, invertValidators);
}

function invertValidity(validity) {
  if ((0, _isPlainObject2.default)(validity)) {
    return (0, _mapValues2.default)(validity, invertValidity);
  }

  return !validity;
}

function isValid(validity) {
  if ((0, _isPlainObject2.default)(validity)) {
    return (0, _every2.default)(validity, isValid);
  }

  return !!validity;
}

function isInvalid(errors) {
  if ((0, _isPlainObject2.default)(errors)) {
    return (0, _some2.default)(errors, isInvalid);
  }

  return !!errors;
}

function getModelPath(model) {
  var field = arguments.length <= 1 || arguments[1] === undefined ? '' : arguments[1];

  return field.length ? model + '.' + field : model;
}

exports.isFocused = isFocused;
exports.isMulti = isMulti;
exports.isPristine = isPristine;
exports.isTouched = isTouched;
exports.getEventValue = getEventValue;
exports.getValue = getValue;
exports.getValidity = getValidity;
exports.isValid = isValid;
exports.isInvalid = isInvalid;
exports.getForm = getForm;
exports.getFieldFromState = getFieldFromState;
exports.invertValidators = invertValidators;
exports.invertValidity = invertValidity;
exports.getModelPath = getModelPath;
exports.pathStartsWith = _pathStartsWith2.default;
exports.getFormStateKey = getFormStateKey;