'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sequenceEventActions = undefined;

var _identity = require('lodash/identity');

var _identity2 = _interopRequireDefault(_identity);

var _capitalize = require('../utils/capitalize');

var _capitalize2 = _interopRequireDefault(_capitalize);

var _mapValues = require('../utils/map-values');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _compose = require('redux/lib/compose');

var _compose2 = _interopRequireDefault(_compose);

var _merge = require('../utils/merge');

var _merge2 = _interopRequireDefault(_merge);

var _icepick = require('icepick');

var _icepick2 = _interopRequireDefault(_icepick);

var _shallowEqual = require('react-redux/lib/utils/shallowEqual');

var _shallowEqual2 = _interopRequireDefault(_shallowEqual);

var _index = require('./index');

var _actions2 = require('../actions');

var _actions3 = _interopRequireDefault(_actions2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var asyncSetValidity = _actions3.default.asyncSetValidity;
var blur = _actions3.default.blur;
var focus = _actions3.default.focus;
var setErrors = _actions3.default.setErrors;


function persistEventWithCallback(callback) {
  return function (event) {
    if (event && event.persist) {
      event.persist();
    }

    callback(event);
    return event;
  };
}

var modelValueUpdaterMap = {
  checkbox: function checkbox(props, eventValue) {
    var model = props.model;
    var modelValue = props.modelValue;


    if ((0, _index.isMulti)(model)) {
      var valueWithItem = modelValue || [];
      var valueWithoutItem = (valueWithItem || []).filter(function (item) {
        return item !== eventValue;
      });
      var value = valueWithoutItem.length === valueWithItem.length ? _icepick2.default.push(valueWithItem, eventValue) : valueWithoutItem;

      return value;
    }

    return !modelValue;
  },
  default: function _default(props, eventValue) {
    return eventValue;
  }
};

function isReadOnlyValue(controlProps) {
  return ~['radio', 'checkbox'].indexOf(controlProps.type);
}

function deprecateUpdateOn(updateOn) {
  console.warn('Using the updateOn prop as a function will be deprecated in v1.0. ' + 'Please use the changeAction prop instead.');

  return updateOn;
}

function sequenceEventActions(props) {
  var dispatch = props.dispatch;
  var model = props.model;
  var _props$updateOn = props.updateOn;
  var updateOn = _props$updateOn === undefined ? 'change' : _props$updateOn;
  var _props$parser = props.parser;
  var parser = _props$parser === undefined ? _identity2.default : _props$parser;
  var _props$changeAction = props.changeAction;
  var changeAction = _props$changeAction === undefined ? _identity2.default : _props$changeAction;
  var _props$controlProps = props.controlProps;
  var controlProps = _props$controlProps === undefined ? {} : _props$controlProps;
  var fieldValue = props.fieldValue;
  var _controlProps$onChang = controlProps.onChange;
  var onChange = _controlProps$onChang === undefined ? _identity2.default : _controlProps$onChang;
  var _controlProps$onBlur = controlProps.onBlur;
  var onBlur = _controlProps$onBlur === undefined ? _identity2.default : _controlProps$onBlur;
  var _controlProps$onFocus = controlProps.onFocus;
  var onFocus = _controlProps$onFocus === undefined ? _identity2.default : _controlProps$onFocus;


  var controlOnChange = persistEventWithCallback(onChange);
  var controlOnBlur = persistEventWithCallback(onBlur);
  var controlOnFocus = persistEventWithCallback(onFocus);

  var updateOnEventHandler = typeof updateOn === 'function' ? 'onChange' : 'on' + (0, _capitalize2.default)(updateOn);
  var validateOn = 'on' + (0, _capitalize2.default)(props.validateOn);
  var asyncValidateOn = 'on' + (0, _capitalize2.default)(props.asyncValidateOn);

  var updaterFn = typeof updateOn === 'function' ? deprecateUpdateOn(updateOn) : _identity2.default;

  var eventActions = {
    onFocus: [],
    onBlur: [],
    onChange: [],
    onLoad: [], // pseudo-event
    onSubmit: [] };

  var controlChangeMethod = function controlChangeMethod() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return changeAction.apply(undefined, [model].concat(args));
  };
  var modelValueUpdater = modelValueUpdaterMap[controlProps.type] || modelValueUpdaterMap.default;

  if (controlProps.defaultValue) {
    eventActions.onLoad.push(function () {
      return dispatch(_actions3.default.change(model, controlProps.defaultValue));
    });
  }

  var changeActionCreator = void 0;

  switch (updateOnEventHandler) {
    case 'onBlur':
      changeActionCreator = function changeActionCreator(modelValue) {
        return _actions3.default.batch(model, [blur(model), controlChangeMethod(modelValue)]);
      };
      eventActions.onFocus.push(function () {
        return dispatch(focus(model));
      });
      break;
    case 'onFocus':
      changeActionCreator = function changeActionCreator(modelValue) {
        return _actions3.default.batch(model, [focus(model), controlChangeMethod(modelValue)]);
      };
      eventActions.onBlur.push(function () {
        return dispatch(blur(model));
      });
      break;
    default:
      changeActionCreator = function changeActionCreator(modelValue) {
        return controlChangeMethod(modelValue);
      };
      eventActions.onBlur.push(function () {
        return dispatch(blur(model));
      });
      eventActions.onFocus.push(function () {
        return dispatch(focus(model));
      });
      break;
  }

  if (props.validators || props.errors) {
    var dispatchValidate = function dispatchValidate(value) {
      var fieldValidity = (0, _index.getValidity)(props.validators, value);
      var fieldErrors = (0, _index.getValidity)(props.errors, value);

      var errors = props.validators ? (0, _merge2.default)((0, _index.invertValidity)(fieldValidity), fieldErrors) : fieldErrors;

      if (fieldValue && !(0, _shallowEqual2.default)(errors, fieldValue.errors)) {
        dispatch(setErrors(model, errors));
      }

      return value;
    };

    eventActions[validateOn].push(dispatchValidate);
    eventActions.onLoad.push(dispatchValidate);
  }

  if (props.asyncValidators) {
    var dispatchAsyncValidate = function dispatchAsyncValidate(value) {
      (0, _mapValues2.default)(props.asyncValidators, function (validator, key) {
        return dispatch(asyncSetValidity(model, function (_, done) {
          var outerDone = function outerDone(valid) {
            var validity = _icepick2.default.merge(fieldValue.validity, _defineProperty({}, key, valid));

            done(validity);
          };

          validator((0, _index.getValue)(value), outerDone);
        }));
      });

      return value;
    };

    eventActions[asyncValidateOn].push(dispatchAsyncValidate);
  }

  var dispatchChange = function dispatchChange(event) {
    var modelValue = isReadOnlyValue(controlProps) ? modelValueUpdater(props, controlProps.value) : event;

    dispatch(changeActionCreator(modelValue));

    return modelValue;
  };

  eventActions.onSubmit.push(updaterFn(dispatchChange));

  if (!isReadOnlyValue(controlProps)) {
    eventActions[updateOnEventHandler].push((0, _compose2.default)(updaterFn(dispatchChange), function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return modelValueUpdater.apply(undefined, [props].concat(args));
    }, parser, _index.getValue, controlOnChange));
  } else {
    eventActions[updateOnEventHandler].push(updaterFn(dispatchChange));
    eventActions[updateOnEventHandler].push(controlOnChange);
  }
  eventActions.onBlur.push(controlOnBlur);
  eventActions.onFocus.push(controlOnFocus);

  return (0, _mapValues2.default)(eventActions, function (_actions) {
    return _compose2.default.apply(undefined, _toConsumableArray(_actions));
  });
}

exports.sequenceEventActions = sequenceEventActions;