import React from 'react';
import ReactDOM from 'react-dom';
import { Control, Form, combineForms } from 'react-redux-form/immutable';
import Immutable from 'immutable';
import { Radio } from 'react-bootstrap';

import { createStore } from 'redux';
import { Provider } from 'react-redux';

const store = createStore(combineForms({
  search: Immutable.fromJS({ sex: 'male' }),
}));

class MyForm extends React.PureComponent {

  handleSubmit(vals) {
    console.log(vals);
  }
  render() {
    return (
      <Provider store={store}>
        <Form
          model="search"
          onSubmit={(vals) => this.handleSubmit(vals)}
        >
          <Control.radio model=".sex" value="male" component={Radio} inline>
            Male
          </Control.radio>
          <Control.radio model=".sex" value="female" component={Radio} inline>
            Female
          </Control.radio>
        </Form>
      </Provider>
    );
  }
}

ReactDOM.render(<MyForm />, document.querySelector('#app'))
