'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actionTypes = require('../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createBatchReducer(reducer, initialState) {
  return function () {
    var state = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];
    var action = arguments[1];

    if (action.type === _actionTypes2.default.BATCH) {
      return action.actions.reduce(reducer, state);
    }

    return reducer(state, action);
  };
}

exports.default = createBatchReducer;