'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setPristineActionReducer;

var _actionTypes = require('../../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

var _updateField = require('../../utils/update-field');

var _updateField2 = _interopRequireDefault(_updateField);

var _isPristine = require('../../form/is-pristine');

var _isPristine2 = _interopRequireDefault(_isPristine);

var _updateParentForms = require('../../utils/update-parent-forms');

var _updateParentForms2 = _interopRequireDefault(_updateParentForms);

var _updateSubFields = require('../../utils/update-sub-fields');

var _updateSubFields2 = _interopRequireDefault(_updateSubFields);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function setPristineActionReducer(state, action, localPath) {
  if (action.type !== _actionTypes2.default.SET_PRISTINE) {
    return state;
  }

  var updatedField = (0, _updateField2.default)(state, localPath, {
    pristine: true
  });

  var updatedSubFields = (0, _updateSubFields2.default)(updatedField, localPath, {
    pristine: true
  });

  return (0, _updateParentForms2.default)(updatedSubFields, localPath, function (form) {
    return {
      pristine: (0, _isPristine2.default)(form)
    };
  });
}