'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = submitFailedActionReducer;

var _actionTypes = require('../../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

var _updateField = require('../../utils/update-field');

var _updateField2 = _interopRequireDefault(_updateField);

var _updateSubFields = require('../../utils/update-sub-fields');

var _updateSubFields2 = _interopRequireDefault(_updateSubFields);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function submitFailedActionReducer(state, action, localPath) {
  if (action.type !== _actionTypes2.default.SET_SUBMIT_FAILED) {
    return state;
  }

  var updatedField = (0, _updateField2.default)(state, localPath, function (fieldState) {
    return {
      pending: false,
      submitted: fieldState.submitted && !action.submitFailed,
      submitFailed: !!action.submitFailed,
      touched: true,
      retouched: false
    };
  });

  var updatedSubFields = (0, _updateSubFields2.default)(updatedField, localPath, {
    pending: false,
    submitted: !action.submitFailed,
    submitFailed: !!action.submitFailed,
    touched: true,
    retouched: false
  });

  return updatedSubFields;
}