'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = submittedActionReducer;

var _actionTypes = require('../../action-types');

var _actionTypes2 = _interopRequireDefault(_actionTypes);

var _updateField = require('../../utils/update-field');

var _updateField2 = _interopRequireDefault(_updateField);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function submittedActionReducer(state, action, localPath) {
  if (action.type !== _actionTypes2.default.SET_SUBMITTED) {
    return state;
  }

  var submitted = !!action.submitted;

  return (0, _updateField2.default)(state, localPath, function (fieldState) {
    return {
      pending: false,
      submitted: submitted,
      submitFailed: submitted ? false : fieldState.submitFailed,
      touched: true,
      retouched: false
    };
  }, function (subFieldState, updatedFieldState) {
    return {
      submitted: submitted,
      submitFailed: submitted ? false : updatedFieldState.submitFailed,
      retouched: false
    };
  });
}