'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialFieldState = undefined;
exports.getField = getField;
exports.default = createFormReducer;

var _get2 = require('../utils/get');

var _get3 = _interopRequireDefault(_get2);

var _icepick = require('icepick');

var _icepick2 = _interopRequireDefault(_icepick);

var _arraysEqual = require('../utils/arrays-equal');

var _arraysEqual2 = _interopRequireDefault(_arraysEqual);

var _isPlainObject = require('lodash/isPlainObject');

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

var _isArray = require('lodash/isArray');

var _isArray2 = _interopRequireDefault(_isArray);

var _mapValues = require('../utils/map-values');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _toPath = require('../utils/to-path');

var _toPath2 = _interopRequireDefault(_toPath);

var _composeReducers = require('../utils/compose-reducers');

var _composeReducers2 = _interopRequireDefault(_composeReducers);

var _batchEnhancer = require('../enhancers/batch-enhancer');

var _batchEnhancer2 = _interopRequireDefault(_batchEnhancer);

var _changeActionReducer = require('./form/change-action-reducer');

var _changeActionReducer2 = _interopRequireDefault(_changeActionReducer);

var _setValidityActionReducer = require('./form/set-validity-action-reducer');

var _setValidityActionReducer2 = _interopRequireDefault(_setValidityActionReducer);

var _focusActionReducer = require('./form/focus-action-reducer');

var _focusActionReducer2 = _interopRequireDefault(_focusActionReducer);

var _setPristineActionReducer = require('./form/set-pristine-action-reducer');

var _setPristineActionReducer2 = _interopRequireDefault(_setPristineActionReducer);

var _setDirtyActionReducer = require('./form/set-dirty-action-reducer');

var _setDirtyActionReducer2 = _interopRequireDefault(_setDirtyActionReducer);

var _blurTouchActionReducer = require('./form/blur-touch-action-reducer');

var _blurTouchActionReducer2 = _interopRequireDefault(_blurTouchActionReducer);

var _untouchActionReducer = require('./form/untouch-action-reducer');

var _untouchActionReducer2 = _interopRequireDefault(_untouchActionReducer);

var _pendingActionReducer = require('./form/pending-action-reducer');

var _pendingActionReducer2 = _interopRequireDefault(_pendingActionReducer);

var _submittedActionReducer = require('./form/submitted-action-reducer');

var _submittedActionReducer2 = _interopRequireDefault(_submittedActionReducer);

var _submitFailedActionReducer = require('./form/submit-failed-action-reducer');

var _submitFailedActionReducer2 = _interopRequireDefault(_submitFailedActionReducer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var initialFieldState = exports.initialFieldState = {
  focus: false,
  pending: false,
  pristine: true,
  submitted: false,
  submitFailed: false,
  retouched: false,
  touched: false,
  validating: false,
  validated: false,
  viewValue: null,
  validity: {},
  errors: {}
};

function getField(state, path) {
  if (process.env.NODE_ENV !== 'production') {
    if (!(0, _isPlainObject2.default)(state)) {
      throw new Error('Could not retrieve field \'' + path + '\' ' + 'from an invalid/empty form state.');
    }
  }

  return (0, _get3.default)(state, path, initialFieldState);
}

function createInitialState(model, state) {
  var initialState = void 0;

  if ((0, _isArray2.default)(state) || (0, _isPlainObject2.default)(state)) {
    initialState = (0, _mapValues2.default)(state, function (subState) {
      return createInitialState(model, subState);
    });
  } else {
    return _icepick2.default.merge(initialFieldState, {
      initialValue: state,
      value: state,
      model: model
    });
  }

  var initialForm = _icepick2.default.merge(initialFieldState, {
    initialValue: state,
    value: state,
    model: model
  });

  return _icepick2.default.set(initialState, '$form', initialForm);
}

function wrapFormReducer(plugin, modelPath, initialState) {
  return function () {
    var state = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];
    var action = arguments[1];

    if (!action.model) return state;

    var path = (0, _toPath2.default)(action.model);

    if (modelPath.length && !(0, _arraysEqual2.default)(path.slice(0, modelPath.length), modelPath)) {
      return state;
    }

    var localPath = path.slice(modelPath.length);

    return plugin(state, action, localPath);
  };
}

var defaultPlugins = [_focusActionReducer2.default, _blurTouchActionReducer2.default, _untouchActionReducer2.default, _setPristineActionReducer2.default, _setDirtyActionReducer2.default, _changeActionReducer2.default, _setValidityActionReducer2.default, _pendingActionReducer2.default, _submittedActionReducer2.default, _submitFailedActionReducer2.default];

function createFormReducer(model) {
  var initialState = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
  var plugins = arguments.length <= 2 || arguments[2] === undefined ? [] : arguments[2];

  var modelPath = (0, _toPath2.default)(model);
  var initialFormState = createInitialState(model, initialState);

  var wrappedPlugins = plugins.concat(defaultPlugins).map(function (plugin) {
    return wrapFormReducer(plugin, modelPath, initialFormState);
  });

  return (0, _batchEnhancer2.default)(_composeReducers2.default.apply(undefined, _toConsumableArray(wrappedPlugins)));
}