function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Context from './Context';

var ContextProvider = Context.Provider;

var Provider = function (_Component) {
  _inherits(Provider, _Component);

  function Provider(props) {
    _classCallCheck(this, Provider);

    var _this = _possibleConstructorReturn(this, _Component.call(this, props));

    _this.state = {
      state: props.store.getState(),
      store: props.store
    };
    _this.unsubscribe = null;
    return _this;
  }

  Provider.prototype.componentDidMount = function componentDidMount() {
    this.isUnmounted = false;
    var state = this.state.store.getState();
    this.unsubscribe = this.state.store.subscribe(this.triggerUpdateOnStoreStateChange.bind(this));

    if (state !== this.state.state) {
      this.setState({ state: state });
    }
  };

  Provider.prototype.componentWillUnmount = function componentWillUnmount() {
    this.isUnmounted = true;
    if (this.unsubscribe) this.unsubscribe();
  };

  Provider.prototype.componentDidUpdate = function componentDidUpdate(lastProps) {
    if (lastProps.store !== this.props.store) {
      if (this.unsubscribe) this.unsubscribe();
      this.unsubscribe = this.props.store.subscribe(this.triggerUpdateOnStoreStateChange.bind(this));
      this.setState({
        state: this.props.store.getState(),
        store: this.props.store
      });
    }
  };

  Provider.prototype.triggerUpdateOnStoreStateChange = function triggerUpdateOnStoreStateChange() {
    if (this.isUnmounted) {
      return;
    }

    this.setState(function (prevState) {
      var newState = prevState.store.getState();
      if (prevState.state === newState) {
        return null;
      }
      return {
        state: newState
      };
    });
  };

  Provider.prototype.render = function render() {
    var Context = this.props.context || ContextProvider;
    return React.createElement(
      Context,
      { value: this.state },
      this.props.children
    );
  };

  return Provider;
}(Component);

Provider.propTypes = {
  store: PropTypes.shape({
    subscribe: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired,
    getState: PropTypes.func.isRequired
  }),
  context: PropTypes.object,
  children: PropTypes.any
};

export default Provider;