var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import hoistStatics from 'hoist-non-react-statics';
import invariant from 'invariant';
import React, { Component, PureComponent } from 'react';
import propTypes from 'prop-types';
import { isValidElementType } from 'react-is';

import Context from './Context';

var ReduxConsumer = Context.Consumer;

export default function connectAdvanced(
/*
  selectorFactory is a func that is responsible for returning the selector function used to
  compute new props from state, props, and dispatch. For example:
     export default connectAdvanced((dispatch, options) => (state, props) => ({
      thing: state.things[props.thingId],
      saveThing: fields => dispatch(actionCreators.saveThing(props.thingId, fields)),
    }))(YourComponent)
   Access to dispatch is provided to the factory so selectorFactories can bind actionCreators
  outside of their selector as an optimization. Options passed to connectAdvanced are passed to
  the selectorFactory, along with displayName and WrappedComponent, as the second argument.
   Note that selectorFactory is responsible for all caching/memoization of inbound and outbound
  props. Do not use connectAdvanced directly without memoizing results between calls to your
  selector, otherwise the Connect component will re-render on every state or props change.
*/
selectorFactory) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$getDisplayName = _ref.getDisplayName,
      getDisplayName = _ref$getDisplayName === undefined ? function (name) {
    return 'ConnectAdvanced(' + name + ')';
  } : _ref$getDisplayName,
      _ref$methodName = _ref.methodName,
      methodName = _ref$methodName === undefined ? 'connectAdvanced' : _ref$methodName,
      _ref$renderCountProp = _ref.renderCountProp,
      renderCountProp = _ref$renderCountProp === undefined ? undefined : _ref$renderCountProp,
      _ref$shouldHandleStat = _ref.shouldHandleStateChanges,
      shouldHandleStateChanges = _ref$shouldHandleStat === undefined ? true : _ref$shouldHandleStat,
      _ref$storeKey = _ref.storeKey,
      storeKey = _ref$storeKey === undefined ? 'store' : _ref$storeKey,
      _ref$withRef = _ref.withRef,
      withRef = _ref$withRef === undefined ? false : _ref$withRef,
      _ref$consumer = _ref.consumer,
      consumer = _ref$consumer === undefined ? ReduxConsumer : _ref$consumer,
      connectOptions = _objectWithoutProperties(_ref, ['getDisplayName', 'methodName', 'renderCountProp', 'shouldHandleStateChanges', 'storeKey', 'withRef', 'consumer']);

  invariant(renderCountProp === undefined, 'renderCountProp is removed. render counting is built into the latest React dev tools profiling extension');

  invariant(storeKey === 'store', 'storeKey has been removed and does not do anything. To use a custom redux store for a single component, ' + 'create a custom React context with React.createContext() and pass the Provider to react-redux\'s provider ' + 'and the Consumer to this component as in <Provider context={context.Provider}><' + 'ConnectedComponent consumer={context.Consumer} /></Provider>');

  var Consumer = consumer;

  return function wrapWithConnect(WrappedComponent) {
    invariant(isValidElementType(WrappedComponent), 'You must pass a component to the function returned by ' + (methodName + '. Instead received ' + JSON.stringify(WrappedComponent)));
    invariant(!withRef || withRef === 'forwardRef', 'withRef must be set to the text "forwardRef." Reference uses React.forwardRef and you may now access ref ' + ('directly instead of using getWrappedInstance() in component ' + wrappedComponentName));

    var wrappedComponentName = WrappedComponent.displayName || WrappedComponent.name || 'Component';

    var displayName = getDisplayName(wrappedComponentName);

    var PureWrapper = void 0;

    if (withRef) {
      var PureWrapperRef = function (_Component) {
        _inherits(PureWrapperRef, _Component);

        function PureWrapperRef() {
          _classCallCheck(this, PureWrapperRef);

          return _possibleConstructorReturn(this, _Component.apply(this, arguments));
        }

        PureWrapperRef.prototype.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
          return nextProps.derivedProps !== this.props.derivedProps;
        };

        PureWrapperRef.prototype.render = function render() {
          var _props = this.props,
              forwardRef = _props.forwardRef,
              derivedProps = _props.derivedProps;

          return React.createElement(WrappedComponent, _extends({}, derivedProps, { ref: forwardRef }));
        };

        return PureWrapperRef;
      }(Component);

      PureWrapperRef.propTypes = {
        derivedProps: propTypes.object,
        forwardRef: propTypes.oneOfType([propTypes.func, propTypes.object])
      };
      PureWrapper = PureWrapperRef;
    } else {
      var PureWrapperNoRef = function (_Component2) {
        _inherits(PureWrapperNoRef, _Component2);

        function PureWrapperNoRef() {
          _classCallCheck(this, PureWrapperNoRef);

          return _possibleConstructorReturn(this, _Component2.apply(this, arguments));
        }

        PureWrapperNoRef.prototype.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
          return nextProps.derivedProps !== this.props.derivedProps;
        };

        PureWrapperNoRef.prototype.render = function render() {
          return React.createElement(WrappedComponent, this.props.derivedProps);
        };

        return PureWrapperNoRef;
      }(Component);

      PureWrapperNoRef.propTypes = {
        derivedProps: propTypes.object
      };
      PureWrapper = PureWrapperNoRef;
    }

    var selectorFactoryOptions = _extends({}, connectOptions, {
      getDisplayName: getDisplayName,
      methodName: methodName,
      renderCountProp: renderCountProp,
      shouldHandleStateChanges: shouldHandleStateChanges,
      storeKey: storeKey,
      withRef: withRef,
      displayName: displayName,
      wrappedComponentName: wrappedComponentName,
      WrappedComponent: WrappedComponent
    });

    var OuterBase = connectOptions.pure ? PureComponent : Component;

    var Connect = function (_OuterBase) {
      _inherits(Connect, _OuterBase);

      function Connect(props) {
        _classCallCheck(this, Connect);

        var _this3 = _possibleConstructorReturn(this, _OuterBase.call(this, props));

        invariant(withRef ? !props.props[storeKey] : !props[storeKey], 'Passing redux store in props has been removed and does not do anything. ' + 'To use a custom redux store for a single component, ' + 'create a custom React context with React.createContext() and pass the Provider to react-redux\'s provider ' + 'and the Consumer to this component\'s connect as in <Provider context={context.Provider}></Provider>' + (' and connect(mapState, mapDispatch, undefined, { consumer=context.consumer })(' + wrappedComponentName + ')'));
        _this3.generatedDerivedProps = _this3.makeDerivedPropsGenerator();
        _this3.renderWrappedComponent = _this3.renderWrappedComponent.bind(_this3);
        return _this3;
      }

      Connect.prototype.makeDerivedPropsGenerator = function makeDerivedPropsGenerator() {
        var lastProps = void 0;
        var lastState = void 0;
        var lastDerivedProps = void 0;
        var lastStore = void 0;
        var sourceSelector = void 0;
        return function (state, props, store) {
          if (connectOptions.pure && lastProps === props && lastState === state) {
            return lastDerivedProps;
          }
          if (store !== lastStore) {
            lastStore = store;
            sourceSelector = selectorFactory(store.dispatch, selectorFactoryOptions);
          }
          lastProps = props;
          lastState = state;
          var nextProps = sourceSelector(state, props);
          if (lastDerivedProps === nextProps) {
            return lastDerivedProps;
          }
          lastDerivedProps = nextProps;
          return lastDerivedProps;
        };
      };

      Connect.prototype.renderWrappedComponentWithRef = function renderWrappedComponentWithRef(value) {
        invariant(value, 'Could not find "store" in the context of ' + ('"' + displayName + '". Either wrap the root component in a <Provider>, ') + 'or pass a custom React context provider to <Provider> and the corresponding ' + ('React context consumer to ' + displayName + ' in connect options.'));
        var state = value.state,
            store = value.store;
        var _props2 = this.props,
            forwardRef = _props2.forwardRef,
            props = _props2.props;

        var derivedProps = this.generatedDerivedProps(state, props, store);
        if (connectOptions.pure) {
          return React.createElement(PureWrapper, { derivedProps: derivedProps, forwardRef: forwardRef });
        }

        return React.createElement(WrappedComponent, _extends({}, derivedProps, { ref: forwardRef }));
      };

      Connect.prototype.renderWrappedComponent = function renderWrappedComponent(value) {
        invariant(value, 'Could not find "store" in the context of ' + ('"' + displayName + '". Either wrap the root component in a <Provider>, ') + 'or pass a custom React context provider to <Provider> and the corresponding ' + ('React context consumer to ' + displayName + ' in connect options.'));
        var state = value.state,
            store = value.store;

        var derivedProps = this.generatedDerivedProps(state, this.props, store);
        if (connectOptions.pure) {
          return React.createElement(PureWrapper, { derivedProps: derivedProps });
        }

        return React.createElement(WrappedComponent, derivedProps);
      };

      Connect.prototype.render = function render() {
        if (this.props.unstable_observedBits) {
          return React.createElement(
            Consumer,
            { unstable_observedBits: this.props.unstable_observedBits },
            this.renderWrappedComponent
          );
        }
        return React.createElement(
          Consumer,
          null,
          this.renderWrappedComponent
        );
      };

      return Connect;
    }(OuterBase);

    Connect.WrappedComponent = WrappedComponent;
    Connect.displayName = displayName;
    if (withRef) {
      Connect.prototype.renderWrappedComponent = Connect.prototype.renderWrappedComponentWithRef;
      Connect.propTypes = {
        props: propTypes.object,
        forwardRef: propTypes.oneOfType([propTypes.func, propTypes.object])
      };
    }

    if (!withRef) {
      return hoistStatics(Connect, WrappedComponent);
    }

    function forwardRef(props, ref) {
      return React.createElement(Connect, { props: props, forwardRef: ref });
    }

    var forwarded = React.forwardRef(forwardRef);
    forwarded.displayName = displayName;
    forwarded.WrappedComponent = WrappedComponent;
    return hoistStatics(forwarded, WrappedComponent);
  };
}