/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule generateForceIndex
 * 
 * @typechecks
 */

'use strict';

var _index = 1;

/**
 * Generate a new force index used to write GraphQL data in the store. A new
 * force index can be used to overwrite previous ranges.
 *
 * @internal
 */
function generateForceIndex() {
  return _index++;
}

module.exports = generateForceIndex;