/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule GraphQL_DEPRECATED
 * @typechecks
 */

'use strict';

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _Object$freeze = require('babel-runtime/core-js/object/freeze')['default'];

var RelayNodeInterface = require('./RelayNodeInterface');

var EMPTY_OBJECT = {};
var EMPTY_ARRAY = [];

if (process.env.NODE_ENV !== 'production') {
  _Object$freeze(EMPTY_OBJECT);
  _Object$freeze(EMPTY_ARRAY);
}

var BATCH_CALL_VARIABLE = 'BatchCallVariable';
var CALL = 'Call';
var CALL_VALUE = 'CallValue';
var CALL_VARIABLE = 'CallVariable';
var FIELD = 'Field';
var FRAGMENT = 'Fragment';
var MUTATION = 'Mutation';
var QUERY = 'Query';
var SUBSCRIPTION = 'Subscription';

/**
 * Represents a GraphQL node.
 *
 * A node may contain zero or more fields and/or query fragments.
 *
 * Note that we don't actually export this class (rather, we export subclasses
 * corresponding to fields, fragments, queries and mutations); we do, however,
 * use `GraphQLNode` as a type throughout Dlite.
 */

var GraphQLNode = function GraphQLNode(fields, fragments) {
  _classCallCheck(this, GraphQLNode);

  this.fields = fields || EMPTY_ARRAY;
  this.fragments = fragments && fragments.length > 0 ? fragments.filter(isTruthy) : EMPTY_ARRAY;

  this.children = this.fields.concat(this.fragments);
}

/**
 * Represents a GraphQL call such as `size(50, 50)` or `(size: 32)`.
 */
;

var GraphQLCallvNode = function GraphQLCallvNode(name, value, metadata) {
  _classCallCheck(this, GraphQLCallvNode);

  this.kind = CALL;
  this.value = map(value, castArg) || null;
  this.name = name;
  this.metadata = metadata || EMPTY_OBJECT;
}

/**
 * Represents a value passed to a GraphQL call (for example, the value 5 passed
 * in a call like `first(5)`).
 */
;

var GraphQLCallValue = function GraphQLCallValue(value) {
  _classCallCheck(this, GraphQLCallValue);

  this.kind = CALL_VALUE;
  this.callValue = value;
}

/**
 * Represents a GraphQL call variable for use with the GraphQL Batch API.
 *
 * For example, given a source query identified by "q0", we would make a batch
 * call variable "<ref_q0>" as follows:
 *
 *     new GraphQL.BatchCallVariable('q0', '$.*.actor.id');
 *
 * The batch API allows streaming responses to the client, re-using information
 * from previous queries via ref_params; the query identifier ("q0" in the
 * example above) combined with a JSONPath to the node to be extended
 * ("$.*.actor.id") allow us to define a supplementary query that retrieves
 * additional information (example: https://fburl.com/65122329) for that node.
 *
 * @see https://our.intern.facebook.com/intern/dex/graphql-batch-api
 */
;

var GraphQLBatchCallVariable = function GraphQLBatchCallVariable(sourceQueryID, jsonPath) {
  _classCallCheck(this, GraphQLBatchCallVariable);

  this.kind = BATCH_CALL_VARIABLE;
  this.sourceQueryID = sourceQueryID;
  this.jsonPath = jsonPath;
}

/**
 * Represents a variable used in a GraphQL call.
 *
 * For example:
 *
 *     new GraphQL.CallVariable('foo') // variable: <foo>
 */
;

var GraphQLCallVariable = function GraphQLCallVariable(variableName) {
  _classCallCheck(this, GraphQLCallVariable);

  this.kind = CALL_VARIABLE;
  this.callVariableName = variableName;
}

/**
 * Represents a field in a GraphQL query.
 *
 * A field may be simple or arbitrarily complex, including calls, and containing
 * subfields, nested fragments.
 */
;

var GraphQLFieldNode = (function (_GraphQLNode) {
  _inherits(GraphQLFieldNode, _GraphQLNode);

  function GraphQLFieldNode(fieldName, fields, fragments, calls, alias, condition, metadata, directives) {
    _classCallCheck(this, GraphQLFieldNode);

    _GraphQLNode.call(this, fields, fragments);

    this.kind = FIELD;
    this.fieldName = fieldName;
    this.calls = calls || EMPTY_ARRAY;
    this.alias = alias || null;
    this.condition = condition || null;

    metadata = metadata || EMPTY_OBJECT;
    this.__metadata__ = metadata;
    this.metadata = {
      edgesID: metadata.edgesID,
      inferredRootCallName: metadata.rootCall,
      inferredPrimaryKey: metadata.pk,
      isConnection: !!metadata.connection,
      isFindable: !!metadata.connection && !metadata.nonFindable,
      isGenerated: !!metadata.generated,
      isPlural: !!metadata.plural,
      isRequisite: !!metadata.requisite,
      isUnionOrInterface: !!metadata.dynamic,
      parentType: metadata.parentType
    };
    this.directives = directives || null;
  }

  /**
   * Represents a query fragment in a GraphQL query.
   *
   * A fragment may contain zero or more fields and/or additional fragments.
   */
  return GraphQLFieldNode;
})(GraphQLNode);

var GraphQLQueryFragment = (function (_GraphQLNode2) {
  _inherits(GraphQLQueryFragment, _GraphQLNode2);

  function GraphQLQueryFragment(name, type, fields, fragments, metadata, directives) {
    _classCallCheck(this, GraphQLQueryFragment);

    _GraphQLNode2.call(this, fields, fragments);
    this.kind = FRAGMENT;
    this.name = name;
    this.type = type;
    this.metadata = this.__metadata__ = metadata || EMPTY_OBJECT;
    this.directives = directives || null;
  }

  /**
   * Represents a root GraphQL query such as `viewer() { ... }` or `me() { ... }`.
   *
   * Queries may contain zero or more fields, and/or subfragments.
   */
  return GraphQLQueryFragment;
})(GraphQLNode);

var GraphQLQuery = (function (_GraphQLNode3) {
  _inherits(GraphQLQuery, _GraphQLNode3);

  function GraphQLQuery(fieldName, value, fields, fragments, metadata, queryName, directives) {
    _classCallCheck(this, GraphQLQuery);

    _GraphQLNode3.call(this, fields, fragments);
    this.__metadata__ = metadata || EMPTY_OBJECT;
    var identifyingArgName = this.__metadata__.identifyingArgName;
    if (identifyingArgName == null && RelayNodeInterface.isNodeRootCall(fieldName)) {
      identifyingArgName = RelayNodeInterface.ID;
    }
    this.kind = QUERY;
    this.metadata = _extends({}, this.__metadata__);
    if (identifyingArgName !== undefined) {
      this.metadata.identifyingArgName = identifyingArgName;
    }
    this.directives = directives || null;
    this.name = queryName;
    this.fieldName = fieldName;
    this.isDeferred = !!this.__metadata__.isDeferred;

    this.calls = [];
    // In the future, the constructor for a `GraphQLQuery` will accept an
    // arbitrary number of `arguments` for the root field and pass them all
    // through to `this.calls`. In the meantime we synthesize an identifying
    // argument, if an `identifyingArgName` exists.
    if (identifyingArgName != null) {
      this.calls.push(new GraphQLCallvNode(identifyingArgName, value));
    }
  }

  /**
   * Base class from which GraphQLMutation and GraphQLSubscription extend.
   */
  return GraphQLQuery;
})(GraphQLNode);

var GraphQLOperation = (function (_GraphQLNode4) {
  _inherits(GraphQLOperation, _GraphQLNode4);

  function GraphQLOperation(name, responseType, call, fields, fragments, metadata) {
    _classCallCheck(this, GraphQLOperation);

    _GraphQLNode4.call(this, fields, fragments);
    this.name = name;
    this.responseType = responseType;
    this.calls = [call];
    this.metadata = metadata || EMPTY_OBJECT;
  }

  /**
   * Represents a GraphQL mutation.
   */
  return GraphQLOperation;
})(GraphQLNode);

var GraphQLMutation = (function (_GraphQLOperation) {
  _inherits(GraphQLMutation, _GraphQLOperation);

  function GraphQLMutation() {
    _classCallCheck(this, GraphQLMutation);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _GraphQLOperation.call.apply(_GraphQLOperation, [this].concat(args));
    this.kind = MUTATION;
  }

  /**
   * Represents a GraphQL subscription.
   */
  return GraphQLMutation;
})(GraphQLOperation);

var GraphQLSubscription = (function (_GraphQLOperation2) {
  _inherits(GraphQLSubscription, _GraphQLOperation2);

  function GraphQLSubscription() {
    _classCallCheck(this, GraphQLSubscription);

    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    _GraphQLOperation2.call.apply(_GraphQLOperation2, [this].concat(args));
    this.kind = SUBSCRIPTION;
  }

  return GraphQLSubscription;
})(GraphQLOperation);

function isTruthy(thing) {
  return !!thing;
}

/**
 * Map a singular/array value with the supplied function.
 */
function map(value, fn) {
  if (value == null) {
    return value;
  } else if (Array.isArray(value)) {
    return value.map(fn);
  } else {
    return fn(value);
  }
}

function castArg(arg) {
  if (arg instanceof GraphQLCallValue || arg instanceof GraphQLCallVariable || arg instanceof GraphQLBatchCallVariable) {
    return arg;
  } else if (arg == null) {
    return new GraphQLCallVariable('__null__');
  } else {
    return new GraphQLCallValue(arg);
  }
}

function isType(node, type) {
  return typeof node === 'object' && node !== null && node.kind === type;
}

function isCall(node) {
  return isType(node, CALL);
}

function isCallValue(node) {
  return isType(node, CALL_VALUE);
}

function isCallVariable(node) {
  return isType(node, CALL_VARIABLE);
}

function isBatchCallVariable(node) {
  return isType(node, BATCH_CALL_VARIABLE);
}

function isField(node) {
  return isType(node, FIELD);
}

function isFragment(node) {
  return isType(node, FRAGMENT);
}

function isQuery(node) {
  return isType(node, QUERY);
}

function isMutation(node) {
  return isType(node, MUTATION);
}

function isSubscription(node) {
  return isType(node, SUBSCRIPTION);
}

/**
 * This module exports the building blocks for creating a structured
 * representation (ie. an AST) of GraphQL queries in JavaScript.
 *
 * @see https://our.intern.facebook.com/intern/dex/introduction-to-graphql/
 * @internal
 */
var GraphQL_DEPRECATED = {
  BatchCallVariable: GraphQLBatchCallVariable,
  Callv: GraphQLCallvNode,
  CallValue: GraphQLCallValue,
  CallVariable: GraphQLCallVariable,
  Field: GraphQLFieldNode,
  Mutation: GraphQLMutation,
  Query: GraphQLQuery,
  QueryFragment: GraphQLQueryFragment,
  Subscription: GraphQLSubscription,
  isBatchCallVariable: isBatchCallVariable,
  isCall: isCall,
  isCallValue: isCallValue,
  isCallVariable: isCallVariable,
  isField: isField,
  isFragment: isFragment,
  isMutation: isMutation,
  isQuery: isQuery,
  isSubscription: isSubscription
};

module.exports = GraphQL_DEPRECATED;