## master

## 0.6.1 (January 8, 2016)

* Renamed `RelayStore#update` to `RelayStore#commitUpdate`. `RelayStore#commit`
  will be removed in v0.7.0. For an automated codemod that you can use to 
  update your Relay app, visit https://github.com/relayjs/relay-codemod
* Replaced `RelayTestUtils.unmockRelay();` with 
  `require('configureForRelayOSS');` in tests.
* Fragment names in printed queries are now less verbose.
* Fixed a bug that caused queries to be printed incorrectly.
* Eliminated concrete fragment hashes.
* Connections now handle repeated edges more gracefully.
* Created a new `RelayTaskQueue` class. Used it to back `RelayTaskScheduler`.
* Reduced memory by only storing paths to container root nodes.
* Renamed `RelayTaskScheduler#await` to `RelayTaskScheduler#enqueue`.
* Fixed a series of memory leaks with a new GC implementation.
* Tests now run with Jasmine 2.

## 0.6.0 (December 4, 2015)

* Bump the `babel-relay-plugin` version to v0.6.0 (now Babel 6 compatible).
* The keys in `rangeBehaviors` are now compared against the *sorted* filter
  arguments of a field. For the field `foo(first: 10, b:true, a:false)` the
  matching range behavior key will be `'a(false).b(true)'`.
* Relay will now throw an invariant if range behavior keys are unsorted.
* Fragments are now supported in mutation fat queries.
* Added `Relay.Store#applyUpdate` method to create a transaction optimistically
  without committing it. Returns a transaction object that you can use to
  `commit()` or `rollback()`.
* Added `RelayStoreData#clearCacheManager` method.
* Renamed `RelayQuery#getHash` to `RelayQuery#getConcreteFragmentHash`
* Removed `RelayQueryPath#toJSON` and `RelayQueryPath#fromJSON`

## 0.5.0 (November 11, 2015)

* Bump the `babel-relay-plugin` version to v0.4.1.
  * Added validation of arguments for connections with `edges` or `pageInfo`.
    * Connections without arguments in fat queries can add the new fragment
      directive `@relay(pattern: true)`.
  * Fixed validation of fields within inline fragments in connections.
  * Print queries using a plain-object representation (instead of `GraphQL`
    objects).
* `RelayQueryField#getStorageKey` will now produce the same key regardless of
  the order of a field's arguments.
* Range behavior keys in mutation configs are now guaranteed to be sorted.
* Added the `Relay.createQuery()` function which returns a
  `RelayQuery.Root` (that can be used with `Relay.Store` methods).
* Optimistic response keys now use GraphQL OSS syntax. (Usage of old, call-like
  syntax is now deprecated and will warn.)
* Fix a bug where optimistic queries could cause the error "Could not find a
  type name for record ...".

## 0.4.0 (October 13, 2015)

* Bump the `babel-relay-plugin` version to v0.3.0.
  * Fixed the metadata for fields on abstract types.
  * Directives are now validated against the schema.
  * Mutations field arguments are now validated.
  * Non-root `node(id: ...)` fields are now invalid.
  * Added support for `RelayQL` template tag.
  * Improvements to validation and error messages.
* The `__typename` of abstract types are now fetched and stored locally.
* Fixed `hasOptimisticUpdate` returning true after mutation succeeds (#86).
* Fixed printing mutations with generated `id` fields (#414).
* Fixed updating views when removing the last element in a plural field (#401).
* Fixed sending mutations via classes without invalid GraphQL characters (#448).
* Added a `__DEV__`-only warning when data is passed down via the wrong prop.

## 0.3.2 (September 18, 2015)

* Bump the `babel-relay-plugin` version to v0.2.5.
  * Queries now preserve directives.
  * Output is now generated by babel.
* Fix refragmenting diff queries (#305).
* Directives are now printed.

## 0.3.1 (September 11, 2015)

* Rebuild to replace faulty NPM package (no code changes).

## 0.3.0 (September 11, 2015)

* Fix query variable printing for non-null and list types (#203).
* Bumped React dependency to v0.14.0-rc.
* Switched to using `ReactDOM` rather than `React` for performing batched
  updates (via `unstable_batchedUpdates`).
* Updated the babel-relay-plugin to v0.2.3:
  * Added support for compiling queries containing introspection fields such as
    `__schema`, `__typename` and such.
  * Use of `field(before: ..., first: ...)` or `field(after: ..., last: ...)` is
    now an error.
* Various improvements to documentation, warnings and error messages.

## 0.2.1 (September 1, 2015)

* Support simplified route query definitions (previous API still supported).

## 0.2.0 (August 28, 2015)

* Upgraded jest to 0.5 and switched Relay to use iojs v2+ only.
* Changed `Relay.DefaultNetworkLayer` constructor to take an `init` object
  instead of `fetchTimeout` and `retryDelays`.
* Scalars other than strings are now allowed as cursors, so long as they
  serialize to strings.
* Added `npm run update-schema` to update the test schema.

## 0.1.1 (August 14, 2015)

* The 'main' entrypoint can now be used in non-ES6 projects (now built w/
  Babel).
* Instance methods of `Relay.DefaultNetworkLayer` are bound to the instance,
  facilitating reuse.
* Renamed `GraphQL_EXPERIMENTAL` to `GraphQL` (internal change).
* Update copyright headers.
* Remove invariant in `RelayQueryField.getCallType()` when argument is unknown.
* `GraphQLRange` returns diff calls with numeric values instead of strings.
* Example apps now include an ES6 polyfill.
* Moved React to peer dependencies; projects should depend on React directly.
* Variables in the default network layer are no longer double-JSON encoded.
* The default network layer now passed cookies along to the server.

## 0.1.0 (August 11, 2015)

* Initial public release.
