'use strict';

var _extends = require('babel-runtime/helpers/extends')['default'];

var Promise = require('fbjs/lib/Promise');

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule Relay
 * @typechecks
 * 
 */

'use strict';

var RelayDefaultNetworkLayer = require('./RelayDefaultNetworkLayer');
var RelayPublic = require('./RelayPublic');
var RelayStore = require('./RelayStore');
var warning = require('fbjs/lib/warning');

if (process.env.NODE_ENV !== 'production') {
  process.env.NODE_ENV !== 'production' ? warning(typeof Promise === 'function' && Array.prototype.find, 'Relay relies on polyfills for ES6 features in older browsers. ' + 'Babel provides a good one: https://babeljs.io/docs/usage/polyfill/') : undefined;
}

// By default, assume that GraphQL is served at `/graphql` on the same domain.
RelayStore.injectNetworkLayer(new RelayDefaultNetworkLayer('/graphql'));

module.exports = _extends({}, RelayPublic, {
  // Expose the default network layer to allow convenient re-configuration.
  DefaultNetworkLayer: RelayDefaultNetworkLayer
});